// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off
#include <QJSValue>
#include <QObject>
#include <QProperty>
#include <qqmlregistration.h>


#include <properties/BorderProperty.h>

#include "LinePropertyGroup.h"
#include "LinePropertyGroup.h"
#include "LinePropertyGroup.h"
#include "LinePropertyGroup.h"
// clang-format on

class QuickStyle;

/*!
 * \qmltype BorderPropertyGroup
 * \inqmlmodule org.kde.union.impl
 * \ingroup qtquick-properties
 *
 * \brief A group object exposing the properties of BorderProperty to QML.
 */
class BorderPropertyGroup : public QObject
{
    Q_OBJECT
    QML_ANONYMOUS

public:
    explicit BorderPropertyGroup(QuickStyle *style);

    void update(Union::Properties::BorderProperty *newState);
    Q_SIGNAL void updated();

    void refreshColors();

    /*!
     * \qmlproperty LinePropertyGroup BorderPropertyGroup::left
     *
     * Exposes BorderProperty::LineProperty to QML.
     */
    Q_PROPERTY(LinePropertyGroup *left READ left CONSTANT)
    LinePropertyGroup *left() const;

    /*!
     * \qmlproperty LinePropertyGroup BorderPropertyGroup::right
     *
     * Exposes BorderProperty::LineProperty to QML.
     */
    Q_PROPERTY(LinePropertyGroup *right READ right CONSTANT)
    LinePropertyGroup *right() const;

    /*!
     * \qmlproperty LinePropertyGroup BorderPropertyGroup::top
     *
     * Exposes BorderProperty::LineProperty to QML.
     */
    Q_PROPERTY(LinePropertyGroup *top READ top CONSTANT)
    LinePropertyGroup *top() const;

    /*!
     * \qmlproperty LinePropertyGroup BorderPropertyGroup::bottom
     *
     * Exposes BorderProperty::LineProperty to QML.
     */
    Q_PROPERTY(LinePropertyGroup *bottom READ bottom CONSTANT)
    LinePropertyGroup *bottom() const;

private:
    QuickStyle *m_style = nullptr;
    std::unique_ptr<LinePropertyGroup> m_left;
    std::unique_ptr<LinePropertyGroup> m_right;
    std::unique_ptr<LinePropertyGroup> m_top;
    std::unique_ptr<LinePropertyGroup> m_bottom;

    Union::Properties::BorderProperty *m_state = nullptr;
};