// ui/base/ime/mojom/text_input_state.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/ime/mojom/text_input_state.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/ime/mojom/text_input_state.mojom-params-data.h"
namespace ui {
namespace mojom {

namespace internal {


// static
bool ImeTextSpanInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ImeTextSpanInfo_Data* object =
      static_cast<const ImeTextSpanInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->span, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->span, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

ImeTextSpanInfo_Data::ImeTextSpanInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextInputState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextInputState_Data* object =
      static_cast<const TextInputState_Data*>(data);


  if (!::ui::mojom::internal::TextInputType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::ui::mojom::internal::TextInputMode_Data
        ::Validate(object->mode, validation_context))
    return false;


  if (!::ui::mojom::internal::TextInputAction_Data
        ::Validate(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selection, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->selection, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->composition, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->edit_context_control_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->edit_context_selection_bounds, validation_context))
    return false;


  if (!::ui::mojom::internal::VirtualKeyboardPolicy_Data
        ::Validate(object->vk_policy, validation_context))
    return false;


  if (!::ui::mojom::internal::VirtualKeyboardVisibilityRequest_Data
        ::Validate(object->last_vk_visibility_request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ime_text_spans_info, 17, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ime_text_spans_info, validation_context,
                                         &ime_text_spans_info_validate_params)) {
    return false;
  }

  return true;
}

TextInputState_Data::TextInputState_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ui