// ui/base/ime/mojom/ime_types.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_IME_MOJOM_IME_TYPES_MOJOM_BLINK_H_
#define UI_BASE_IME_MOJOM_IME_TYPES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/base/ime/mojom/ime_types.mojom-features.h"  // IWYU pragma: export
#include "ui/base/ime/mojom/ime_types.mojom-shared.h"  // IWYU pragma: export
#include "ui/base/ime/mojom/ime_types.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "ui/base/ime/mojom/ime_types_mojom_traits.h"
#include "ui/base/ime/mojom/text_edit_command_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace ui::mojom::blink {








class BLINK_PLATFORM_EXPORT ImeTextSpan {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImeTextSpan, T>::value>;
  using DataView = ImeTextSpanDataView;
  using Data_ = internal::ImeTextSpan_Data;

  template <typename... Args>
  static ImeTextSpanPtr New(Args&&... args) {
    return ImeTextSpanPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImeTextSpanPtr From(const U& u) {
    return mojo::TypeConverter<ImeTextSpanPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImeTextSpan>::Convert(*this);
  }


  ImeTextSpan();

  ImeTextSpan(
      ::ui::ImeTextSpan::Type type,
      uint32_t start_offset,
      uint32_t end_offset,
      uint32_t underline_color,
      ::ui::ImeTextSpan::Thickness thickness,
      ::ui::ImeTextSpan::UnderlineStyle underline_style,
      uint32_t text_color,
      uint32_t background_color,
      uint32_t suggestion_highlight_color,
      bool remove_on_finish_composing,
      bool interim_char_selection,
      ::blink::Vector<::blink::String> suggestions);


  ~ImeTextSpan();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImeTextSpanPtr>
  ImeTextSpanPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImeTextSpan::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ImeTextSpan::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ImeTextSpan::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImeTextSpan::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImeTextSpan::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImeTextSpan::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImeTextSpan_UnserializedMessageContext<
            UserType, ImeTextSpan::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ImeTextSpan::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ImeTextSpan::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImeTextSpan_UnserializedMessageContext<
            UserType, ImeTextSpan::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImeTextSpan::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ui::ImeTextSpan::Type type;
  
  uint32_t start_offset;
  
  uint32_t end_offset;
  
  uint32_t underline_color;
  
  ::ui::ImeTextSpan::Thickness thickness;
  
  ::ui::ImeTextSpan::UnderlineStyle underline_style;
  
  uint32_t text_color;
  
  uint32_t background_color;
  
  uint32_t suggestion_highlight_color;
  
  bool remove_on_finish_composing;
  
  bool interim_char_selection;
  
  ::blink::Vector<::blink::String> suggestions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImeTextSpan::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImeTextSpan::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImeTextSpan::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImeTextSpan::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ImeTextSpanPtr ImeTextSpan::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(start_offset),
      mojo::Clone(end_offset),
      mojo::Clone(underline_color),
      mojo::Clone(thickness),
      mojo::Clone(underline_style),
      mojo::Clone(text_color),
      mojo::Clone(background_color),
      mojo::Clone(suggestion_highlight_color),
      mojo::Clone(remove_on_finish_composing),
      mojo::Clone(interim_char_selection),
      mojo::Clone(suggestions)
  );
}

template <typename T, ImeTextSpan::EnableIfSame<T>*>
bool ImeTextSpan::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->start_offset, other_struct.start_offset))
    return false;
  if (!mojo::Equals(this->end_offset, other_struct.end_offset))
    return false;
  if (!mojo::Equals(this->underline_color, other_struct.underline_color))
    return false;
  if (!mojo::Equals(this->thickness, other_struct.thickness))
    return false;
  if (!mojo::Equals(this->underline_style, other_struct.underline_style))
    return false;
  if (!mojo::Equals(this->text_color, other_struct.text_color))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->suggestion_highlight_color, other_struct.suggestion_highlight_color))
    return false;
  if (!mojo::Equals(this->remove_on_finish_composing, other_struct.remove_on_finish_composing))
    return false;
  if (!mojo::Equals(this->interim_char_selection, other_struct.interim_char_selection))
    return false;
  if (!mojo::Equals(this->suggestions, other_struct.suggestions))
    return false;
  return true;
}

template <typename T, ImeTextSpan::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.start_offset < rhs.start_offset)
    return true;
  if (rhs.start_offset < lhs.start_offset)
    return false;
  if (lhs.end_offset < rhs.end_offset)
    return true;
  if (rhs.end_offset < lhs.end_offset)
    return false;
  if (lhs.underline_color < rhs.underline_color)
    return true;
  if (rhs.underline_color < lhs.underline_color)
    return false;
  if (lhs.thickness < rhs.thickness)
    return true;
  if (rhs.thickness < lhs.thickness)
    return false;
  if (lhs.underline_style < rhs.underline_style)
    return true;
  if (rhs.underline_style < lhs.underline_style)
    return false;
  if (lhs.text_color < rhs.text_color)
    return true;
  if (rhs.text_color < lhs.text_color)
    return false;
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.suggestion_highlight_color < rhs.suggestion_highlight_color)
    return true;
  if (rhs.suggestion_highlight_color < lhs.suggestion_highlight_color)
    return false;
  if (lhs.remove_on_finish_composing < rhs.remove_on_finish_composing)
    return true;
  if (rhs.remove_on_finish_composing < lhs.remove_on_finish_composing)
    return false;
  if (lhs.interim_char_selection < rhs.interim_char_selection)
    return true;
  if (rhs.interim_char_selection < lhs.interim_char_selection)
    return false;
  if (lhs.suggestions < rhs.suggestions)
    return true;
  if (rhs.suggestions < lhs.suggestions)
    return false;
  return false;
}


}  // ui::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::ui::mojom::blink::ImeTextSpan::DataView,
                                         ::ui::mojom::blink::ImeTextSpanPtr> {
  static bool IsNull(const ::ui::mojom::blink::ImeTextSpanPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::blink::ImeTextSpanPtr* output) { output->reset(); }

  static decltype(::ui::mojom::blink::ImeTextSpan::type) type(
      const ::ui::mojom::blink::ImeTextSpanPtr& input) {
    return input->type;
  }

  static decltype(::ui::mojom::blink::ImeTextSpan::start_offset) start_offset(
      const ::ui::mojom::blink::ImeTextSpanPtr& input) {
    return input->start_offset;
  }

  static decltype(::ui::mojom::blink::ImeTextSpan::end_offset) end_offset(
      const ::ui::mojom::blink::ImeTextSpanPtr& input) {
    return input->end_offset;
  }

  static decltype(::ui::mojom::blink::ImeTextSpan::underline_color) underline_color(
      const ::ui::mojom::blink::ImeTextSpanPtr& input) {
    return input->underline_color;
  }

  static decltype(::ui::mojom::blink::ImeTextSpan::thickness) thickness(
      const ::ui::mojom::blink::ImeTextSpanPtr& input) {
    return input->thickness;
  }

  static decltype(::ui::mojom::blink::ImeTextSpan::underline_style) underline_style(
      const ::ui::mojom::blink::ImeTextSpanPtr& input) {
    return input->underline_style;
  }

  static decltype(::ui::mojom::blink::ImeTextSpan::text_color) text_color(
      const ::ui::mojom::blink::ImeTextSpanPtr& input) {
    return input->text_color;
  }

  static decltype(::ui::mojom::blink::ImeTextSpan::background_color) background_color(
      const ::ui::mojom::blink::ImeTextSpanPtr& input) {
    return input->background_color;
  }

  static decltype(::ui::mojom::blink::ImeTextSpan::suggestion_highlight_color) suggestion_highlight_color(
      const ::ui::mojom::blink::ImeTextSpanPtr& input) {
    return input->suggestion_highlight_color;
  }

  static decltype(::ui::mojom::blink::ImeTextSpan::remove_on_finish_composing) remove_on_finish_composing(
      const ::ui::mojom::blink::ImeTextSpanPtr& input) {
    return input->remove_on_finish_composing;
  }

  static decltype(::ui::mojom::blink::ImeTextSpan::interim_char_selection) interim_char_selection(
      const ::ui::mojom::blink::ImeTextSpanPtr& input) {
    return input->interim_char_selection;
  }

  static const decltype(::ui::mojom::blink::ImeTextSpan::suggestions)& suggestions(
      const ::ui::mojom::blink::ImeTextSpanPtr& input) {
    return input->suggestions;
  }

  static bool Read(::ui::mojom::blink::ImeTextSpan::DataView input, ::ui::mojom::blink::ImeTextSpanPtr* output);
};

}  // namespace mojo

#endif  // UI_BASE_IME_MOJOM_IME_TYPES_MOJOM_BLINK_H_