// third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_WORKLET_SERVICE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_WORKLET_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-forward.h"
#include "services/network/public/mojom/url_loader_factory.mojom-forward.h"
#include "services/network/public/mojom/shared_storage.mojom.h"
#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-forward.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-forward.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-forward.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class SharedStorageEntriesListenerProxy;

template <typename ImplRefTraits>
class SharedStorageEntriesListenerStub;

class SharedStorageEntriesListenerRequestValidator;


class BLINK_COMMON_EXPORT SharedStorageEntriesListener
    : public SharedStorageEntriesListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SharedStorageEntriesListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SharedStorageEntriesListenerInterfaceBase;
  using Proxy_ = SharedStorageEntriesListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SharedStorageEntriesListenerStub<ImplRefTraits>;

  using RequestValidator_ = SharedStorageEntriesListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidReadEntriesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidReadEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SharedStorageEntriesListener() = default;

  virtual void DidReadEntries(bool success, const std::string& error_message, std::vector<SharedStorageKeyAndOrValuePtr> entries, bool has_more_entries, int32_t total_queued_to_send) = 0;
};

class SharedStorageWorkletServiceClientProxy;

template <typename ImplRefTraits>
class SharedStorageWorkletServiceClientStub;

class SharedStorageWorkletServiceClientRequestValidator;
class SharedStorageWorkletServiceClientResponseValidator;


class BLINK_COMMON_EXPORT SharedStorageWorkletServiceClient
    : public SharedStorageWorkletServiceClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SharedStorageWorkletServiceClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SharedStorageWorkletServiceClientInterfaceBase;
  using Proxy_ = SharedStorageWorkletServiceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SharedStorageWorkletServiceClientStub<ImplRefTraits>;

  using RequestValidator_ = SharedStorageWorkletServiceClientRequestValidator;
  using ResponseValidator_ = SharedStorageWorkletServiceClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSharedStorageUpdateMinVersion = 0,
    kSharedStorageBatchUpdateMinVersion = 0,
    kSharedStorageGetMinVersion = 0,
    kSharedStorageKeysMinVersion = 0,
    kSharedStorageEntriesMinVersion = 0,
    kSharedStorageLengthMinVersion = 0,
    kSharedStorageRemainingBudgetMinVersion = 0,
    kGetInterestGroupsMinVersion = 0,
    kDidAddMessageToConsoleMinVersion = 0,
    kRecordUseCountersMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SharedStorageUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageBatchUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageGet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageKeys_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageLength_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageRemainingBudget_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetInterestGroups_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidAddMessageToConsole_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordUseCounters_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SharedStorageWorkletServiceClient() = default;

  using SharedStorageUpdateCallback = base::OnceCallback<void(const std::string&)>;
  using SharedStorageUpdateMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void SharedStorageUpdate(::network::mojom::SharedStorageModifierMethodWithOptionsPtr method_with_options, SharedStorageUpdateCallback callback) = 0;

  using SharedStorageBatchUpdateCallback = base::OnceCallback<void(const std::string&)>;
  using SharedStorageBatchUpdateMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void SharedStorageBatchUpdate(::std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::std::string>& with_lock, SharedStorageBatchUpdateCallback callback) = 0;

  using SharedStorageGetCallback = base::OnceCallback<void(::blink::mojom::SharedStorageGetStatus, const std::string&, const ::std::u16string&)>;
  using SharedStorageGetMojoCallback = base::OnceCallback<void(::blink::mojom::SharedStorageGetStatus, const std::string&, const ::std::u16string&)>;

  virtual void SharedStorageGet(const ::std::u16string& key, SharedStorageGetCallback callback) = 0;

  virtual void SharedStorageKeys(::mojo::PendingRemote<SharedStorageEntriesListener> listener) = 0;

  virtual void SharedStorageEntries(::mojo::PendingRemote<SharedStorageEntriesListener> listener, bool values_only) = 0;

  using SharedStorageLengthCallback = base::OnceCallback<void(bool, const std::string&, uint32_t)>;
  using SharedStorageLengthMojoCallback = base::OnceCallback<void(bool, const std::string&, uint32_t)>;

  virtual void SharedStorageLength(SharedStorageLengthCallback callback) = 0;

  using SharedStorageRemainingBudgetCallback = base::OnceCallback<void(bool, const std::string&, double)>;
  using SharedStorageRemainingBudgetMojoCallback = base::OnceCallback<void(bool, const std::string&, double)>;

  virtual void SharedStorageRemainingBudget(SharedStorageRemainingBudgetCallback callback) = 0;

  using GetInterestGroupsCallback = base::OnceCallback<void(GetInterestGroupsResultPtr)>;
  using GetInterestGroupsMojoCallback = base::OnceCallback<void(GetInterestGroupsResultPtr)>;

  virtual void GetInterestGroups(GetInterestGroupsCallback callback) = 0;

  virtual void DidAddMessageToConsole(::blink::mojom::ConsoleMessageLevel log_level, const std::string& message) = 0;

  virtual void RecordUseCounters(const std::vector<::blink::mojom::WebFeature>& features) = 0;
};

class SharedStorageWorkletServiceProxy;

template <typename ImplRefTraits>
class SharedStorageWorkletServiceStub;

class SharedStorageWorkletServiceRequestValidator;
class SharedStorageWorkletServiceResponseValidator;


class BLINK_COMMON_EXPORT SharedStorageWorkletService
    : public SharedStorageWorkletServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SharedStorageWorkletService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SharedStorageWorkletServiceInterfaceBase;
  using Proxy_ = SharedStorageWorkletServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SharedStorageWorkletServiceStub<ImplRefTraits>;

  using RequestValidator_ = SharedStorageWorkletServiceRequestValidator;
  using ResponseValidator_ = SharedStorageWorkletServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitializeMinVersion = 0,
    kAddModuleMinVersion = 0,
    kRunURLSelectionOperationMinVersion = 0,
    kRunOperationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Initialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddModule_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunURLSelectionOperation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunOperation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SharedStorageWorkletService() = default;

  virtual void Initialize(::mojo::PendingAssociatedRemote<SharedStorageWorkletServiceClient> client, SharedStorageWorkletPermissionsPolicyStatePtr permissions_policy_state, const std::optional<::std::u16string>& embedder_context) = 0;

  using AddModuleCallback = base::OnceCallback<void(bool, const std::string&)>;
  using AddModuleMojoCallback = base::OnceCallback<void(bool, const std::string&)>;

  virtual void AddModule(::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, const ::GURL& script_source_url, AddModuleCallback callback) = 0;

  using RunURLSelectionOperationCallback = base::OnceCallback<void(bool, const std::string&, uint32_t)>;
  using RunURLSelectionOperationMojoCallback = base::OnceCallback<void(bool, const std::string&, uint32_t)>;

  virtual void RunURLSelectionOperation(const std::string& name, const std::vector<::GURL>& urls, ::blink::CloneableMessage serialized_data, PrivateAggregationOperationDetailsPtr pa_operation_details, RunURLSelectionOperationCallback callback) = 0;

  using RunOperationCallback = base::OnceCallback<void(bool, const std::string&)>;
  using RunOperationMojoCallback = base::OnceCallback<void(bool, const std::string&)>;

  virtual void RunOperation(const std::string& name, ::blink::CloneableMessage serialized_data, PrivateAggregationOperationDetailsPtr pa_operation_details, RunOperationCallback callback) = 0;
};



class BLINK_COMMON_EXPORT SharedStorageEntriesListenerProxy
    : public SharedStorageEntriesListener {
 public:
  using InterfaceType = SharedStorageEntriesListener;

  explicit SharedStorageEntriesListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidReadEntries(bool success, const std::string& error_message, std::vector<SharedStorageKeyAndOrValuePtr> entries, bool has_more_entries, int32_t total_queued_to_send) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT SharedStorageWorkletServiceClientProxy
    : public SharedStorageWorkletServiceClient {
 public:
  using InterfaceType = SharedStorageWorkletServiceClient;

  explicit SharedStorageWorkletServiceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SharedStorageUpdate(::network::mojom::SharedStorageModifierMethodWithOptionsPtr method_with_options, SharedStorageUpdateCallback callback) final;
  
  void SharedStorageBatchUpdate(::std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::std::string>& with_lock, SharedStorageBatchUpdateCallback callback) final;
  
  void SharedStorageGet(const ::std::u16string& key, SharedStorageGetCallback callback) final;
  
  void SharedStorageKeys(::mojo::PendingRemote<SharedStorageEntriesListener> listener) final;
  
  void SharedStorageEntries(::mojo::PendingRemote<SharedStorageEntriesListener> listener, bool values_only) final;
  
  void SharedStorageLength(SharedStorageLengthCallback callback) final;
  
  void SharedStorageRemainingBudget(SharedStorageRemainingBudgetCallback callback) final;
  
  void GetInterestGroups(GetInterestGroupsCallback callback) final;
  
  void DidAddMessageToConsole(::blink::mojom::ConsoleMessageLevel log_level, const std::string& message) final;
  
  void RecordUseCounters(const std::vector<::blink::mojom::WebFeature>& features) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT SharedStorageWorkletServiceProxy
    : public SharedStorageWorkletService {
 public:
  using InterfaceType = SharedStorageWorkletService;

  explicit SharedStorageWorkletServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Initialize(::mojo::PendingAssociatedRemote<SharedStorageWorkletServiceClient> client, SharedStorageWorkletPermissionsPolicyStatePtr permissions_policy_state, const std::optional<::std::u16string>& embedder_context) final;
  
  void AddModule(::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, const ::GURL& script_source_url, AddModuleCallback callback) final;
  
  void RunURLSelectionOperation(const std::string& name, const std::vector<::GURL>& urls, ::blink::CloneableMessage serialized_data, PrivateAggregationOperationDetailsPtr pa_operation_details, RunURLSelectionOperationCallback callback) final;
  
  void RunOperation(const std::string& name, ::blink::CloneableMessage serialized_data, PrivateAggregationOperationDetailsPtr pa_operation_details, RunOperationCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT SharedStorageEntriesListenerStubDispatch {
 public:
  static bool Accept(SharedStorageEntriesListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SharedStorageEntriesListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SharedStorageEntriesListener>>
class SharedStorageEntriesListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SharedStorageEntriesListenerStub() = default;
  ~SharedStorageEntriesListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageEntriesListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageEntriesListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SharedStorageWorkletServiceClientStubDispatch {
 public:
  static bool Accept(SharedStorageWorkletServiceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SharedStorageWorkletServiceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SharedStorageWorkletServiceClient>>
class SharedStorageWorkletServiceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SharedStorageWorkletServiceClientStub() = default;
  ~SharedStorageWorkletServiceClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageWorkletServiceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageWorkletServiceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SharedStorageWorkletServiceStubDispatch {
 public:
  static bool Accept(SharedStorageWorkletService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SharedStorageWorkletService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SharedStorageWorkletService>>
class SharedStorageWorkletServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SharedStorageWorkletServiceStub() = default;
  ~SharedStorageWorkletServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageWorkletServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageWorkletServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SharedStorageEntriesListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT SharedStorageWorkletServiceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT SharedStorageWorkletServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT SharedStorageWorkletServiceClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT SharedStorageWorkletServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_COMMON_EXPORT SharedStorageWorkletPermissionsPolicyState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageWorkletPermissionsPolicyState, T>::value>;
  using DataView = SharedStorageWorkletPermissionsPolicyStateDataView;
  using Data_ = internal::SharedStorageWorkletPermissionsPolicyState_Data;

  template <typename... Args>
  static SharedStorageWorkletPermissionsPolicyStatePtr New(Args&&... args) {
    return SharedStorageWorkletPermissionsPolicyStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageWorkletPermissionsPolicyStatePtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageWorkletPermissionsPolicyStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageWorkletPermissionsPolicyState>::Convert(*this);
  }


  SharedStorageWorkletPermissionsPolicyState();

  SharedStorageWorkletPermissionsPolicyState(
      bool private_aggregation_allowed,
      bool join_ad_interest_group_allowed,
      bool run_ad_auction_allowed);


  ~SharedStorageWorkletPermissionsPolicyState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageWorkletPermissionsPolicyStatePtr>
  SharedStorageWorkletPermissionsPolicyStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageWorkletPermissionsPolicyState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageWorkletPermissionsPolicyState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageWorkletPermissionsPolicyState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageWorkletPermissionsPolicyState_UnserializedMessageContext<
            UserType, SharedStorageWorkletPermissionsPolicyState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageWorkletPermissionsPolicyState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageWorkletPermissionsPolicyState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageWorkletPermissionsPolicyState_UnserializedMessageContext<
            UserType, SharedStorageWorkletPermissionsPolicyState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageWorkletPermissionsPolicyState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool private_aggregation_allowed;
  
  bool join_ad_interest_group_allowed;
  
  bool run_ad_auction_allowed;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_COMMON_EXPORT GetInterestGroupsResult {
 public:
  using DataView = GetInterestGroupsResultDataView;
  using Data_ = internal::GetInterestGroupsResult_Data;
  using Tag = Data_::GetInterestGroupsResult_Tag;

  template <typename... Args>
  static GetInterestGroupsResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |error_message|.
  static GetInterestGroupsResultPtr NewErrorMessage(
      const std::string& value);
  // Construct an instance holding |groups|.
  static GetInterestGroupsResultPtr NewGroups(
      std::vector<::blink::mojom::StorageInterestGroupPtr> value);

  template <typename U>
  static GetInterestGroupsResultPtr From(const U& u) {
    return mojo::TypeConverter<GetInterestGroupsResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetInterestGroupsResult>::Convert(*this);
  }
  ~GetInterestGroupsResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GetInterestGroupsResult(const GetInterestGroupsResult& other) = delete;
  GetInterestGroupsResult& operator=(const GetInterestGroupsResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GetInterestGroupsResultPtr>
  GetInterestGroupsResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetInterestGroupsResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetInterestGroupsResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_error_message() const { return tag_ == Tag::kErrorMessage; }
  const std::string& get_error_message() const {
    CHECK(tag_ == Tag::kErrorMessage);
    return data_.error_message;
  }
  std::string& get_error_message() {
    CHECK(tag_ == Tag::kErrorMessage);
    return data_.error_message;
  }
  void set_error_message(const std::string& error_message);

  bool is_groups() const { return tag_ == Tag::kGroups; }
  const std::vector<::blink::mojom::StorageInterestGroupPtr>& get_groups() const {
    CHECK(tag_ == Tag::kGroups);
    return data_.groups;
  }
  std::vector<::blink::mojom::StorageInterestGroupPtr>& get_groups() {
    CHECK(tag_ == Tag::kGroups);
    return data_.groups;
  }
  void set_groups(std::vector<::blink::mojom::StorageInterestGroupPtr> groups);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetInterestGroupsResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GetInterestGroupsResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGroups)>,
        std::vector<::blink::mojom::StorageInterestGroupPtr> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::string error_message;
    std::vector<::blink::mojom::StorageInterestGroupPtr> groups;
  };

  GetInterestGroupsResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
      const std::string& value);
  GetInterestGroupsResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kGroups)>,
      std::vector<::blink::mojom::StorageInterestGroupPtr> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class BLINK_COMMON_EXPORT SharedStorageKeyAndOrValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageKeyAndOrValue, T>::value>;
  using DataView = SharedStorageKeyAndOrValueDataView;
  using Data_ = internal::SharedStorageKeyAndOrValue_Data;

  template <typename... Args>
  static SharedStorageKeyAndOrValuePtr New(Args&&... args) {
    return SharedStorageKeyAndOrValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageKeyAndOrValuePtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageKeyAndOrValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageKeyAndOrValue>::Convert(*this);
  }


  SharedStorageKeyAndOrValue();

  SharedStorageKeyAndOrValue(
      const ::std::u16string& key,
      const ::std::u16string& value);


  ~SharedStorageKeyAndOrValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageKeyAndOrValuePtr>
  SharedStorageKeyAndOrValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageKeyAndOrValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageKeyAndOrValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageKeyAndOrValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageKeyAndOrValue::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageKeyAndOrValue::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageKeyAndOrValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageKeyAndOrValue_UnserializedMessageContext<
            UserType, SharedStorageKeyAndOrValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageKeyAndOrValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageKeyAndOrValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageKeyAndOrValue_UnserializedMessageContext<
            UserType, SharedStorageKeyAndOrValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageKeyAndOrValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string key;
  
  ::std::u16string value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageKeyAndOrValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageKeyAndOrValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageKeyAndOrValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageKeyAndOrValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PrivateAggregationOperationDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrivateAggregationOperationDetails, T>::value>;
  using DataView = PrivateAggregationOperationDetailsDataView;
  using Data_ = internal::PrivateAggregationOperationDetails_Data;

  template <typename... Args>
  static PrivateAggregationOperationDetailsPtr New(Args&&... args) {
    return PrivateAggregationOperationDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrivateAggregationOperationDetailsPtr From(const U& u) {
    return mojo::TypeConverter<PrivateAggregationOperationDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrivateAggregationOperationDetails>::Convert(*this);
  }


  PrivateAggregationOperationDetails();

  PrivateAggregationOperationDetails(
      ::mojo::PendingRemote<::blink::mojom::PrivateAggregationHost> pa_host,
      uint32_t filtering_id_max_bytes);

PrivateAggregationOperationDetails(const PrivateAggregationOperationDetails&) = delete;
PrivateAggregationOperationDetails& operator=(const PrivateAggregationOperationDetails&) = delete;

  ~PrivateAggregationOperationDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrivateAggregationOperationDetailsPtr>
  PrivateAggregationOperationDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrivateAggregationOperationDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrivateAggregationOperationDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrivateAggregationOperationDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrivateAggregationOperationDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrivateAggregationOperationDetails_UnserializedMessageContext<
            UserType, PrivateAggregationOperationDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrivateAggregationOperationDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrivateAggregationOperationDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrivateAggregationOperationDetails_UnserializedMessageContext<
            UserType, PrivateAggregationOperationDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrivateAggregationOperationDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::blink::mojom::PrivateAggregationHost> pa_host;
  
  uint32_t filtering_id_max_bytes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrivateAggregationOperationDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrivateAggregationOperationDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrivateAggregationOperationDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrivateAggregationOperationDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
GetInterestGroupsResultPtr GetInterestGroupsResult::Clone() const {
  switch (tag_) {
    case Tag::kErrorMessage:
      return NewErrorMessage(
          mojo::Clone(data_.error_message));
    case Tag::kGroups:
      return NewGroups(
          mojo::Clone(data_.groups));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GetInterestGroupsResult>::value>::type*>
bool GetInterestGroupsResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kErrorMessage:
      return mojo::Equals(data_.error_message, other.data_.error_message);
    case Tag::kGroups:
      return mojo::Equals(data_.groups, other.data_.groups);
  }

  return false;
}
template <typename StructPtrType>
SharedStorageWorkletPermissionsPolicyStatePtr SharedStorageWorkletPermissionsPolicyState::Clone() const {
  return New(
      mojo::Clone(private_aggregation_allowed),
      mojo::Clone(join_ad_interest_group_allowed),
      mojo::Clone(run_ad_auction_allowed)
  );
}

template <typename T, SharedStorageWorkletPermissionsPolicyState::EnableIfSame<T>*>
bool SharedStorageWorkletPermissionsPolicyState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->private_aggregation_allowed, other_struct.private_aggregation_allowed))
    return false;
  if (!mojo::Equals(this->join_ad_interest_group_allowed, other_struct.join_ad_interest_group_allowed))
    return false;
  if (!mojo::Equals(this->run_ad_auction_allowed, other_struct.run_ad_auction_allowed))
    return false;
  return true;
}

template <typename T, SharedStorageWorkletPermissionsPolicyState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.private_aggregation_allowed < rhs.private_aggregation_allowed)
    return true;
  if (rhs.private_aggregation_allowed < lhs.private_aggregation_allowed)
    return false;
  if (lhs.join_ad_interest_group_allowed < rhs.join_ad_interest_group_allowed)
    return true;
  if (rhs.join_ad_interest_group_allowed < lhs.join_ad_interest_group_allowed)
    return false;
  if (lhs.run_ad_auction_allowed < rhs.run_ad_auction_allowed)
    return true;
  if (rhs.run_ad_auction_allowed < lhs.run_ad_auction_allowed)
    return false;
  return false;
}
template <typename StructPtrType>
SharedStorageKeyAndOrValuePtr SharedStorageKeyAndOrValue::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(value)
  );
}

template <typename T, SharedStorageKeyAndOrValue::EnableIfSame<T>*>
bool SharedStorageKeyAndOrValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, SharedStorageKeyAndOrValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
PrivateAggregationOperationDetailsPtr PrivateAggregationOperationDetails::Clone() const {
  return New(
      mojo::Clone(pa_host),
      mojo::Clone(filtering_id_max_bytes)
  );
}

template <typename T, PrivateAggregationOperationDetails::EnableIfSame<T>*>
bool PrivateAggregationOperationDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pa_host, other_struct.pa_host))
    return false;
  if (!mojo::Equals(this->filtering_id_max_bytes, other_struct.filtering_id_max_bytes))
    return false;
  return true;
}

template <typename T, PrivateAggregationOperationDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pa_host < rhs.pa_host)
    return true;
  if (rhs.pa_host < lhs.pa_host)
    return false;
  if (lhs.filtering_id_max_bytes < rhs.filtering_id_max_bytes)
    return true;
  if (rhs.filtering_id_max_bytes < lhs.filtering_id_max_bytes)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SharedStorageWorkletPermissionsPolicyState::DataView,
                                         ::blink::mojom::SharedStorageWorkletPermissionsPolicyStatePtr> {
  static bool IsNull(const ::blink::mojom::SharedStorageWorkletPermissionsPolicyStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SharedStorageWorkletPermissionsPolicyStatePtr* output) { output->reset(); }

  static decltype(::blink::mojom::SharedStorageWorkletPermissionsPolicyState::private_aggregation_allowed) private_aggregation_allowed(
      const ::blink::mojom::SharedStorageWorkletPermissionsPolicyStatePtr& input) {
    return input->private_aggregation_allowed;
  }

  static decltype(::blink::mojom::SharedStorageWorkletPermissionsPolicyState::join_ad_interest_group_allowed) join_ad_interest_group_allowed(
      const ::blink::mojom::SharedStorageWorkletPermissionsPolicyStatePtr& input) {
    return input->join_ad_interest_group_allowed;
  }

  static decltype(::blink::mojom::SharedStorageWorkletPermissionsPolicyState::run_ad_auction_allowed) run_ad_auction_allowed(
      const ::blink::mojom::SharedStorageWorkletPermissionsPolicyStatePtr& input) {
    return input->run_ad_auction_allowed;
  }

  static bool Read(::blink::mojom::SharedStorageWorkletPermissionsPolicyState::DataView input, ::blink::mojom::SharedStorageWorkletPermissionsPolicyStatePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SharedStorageKeyAndOrValue::DataView,
                                         ::blink::mojom::SharedStorageKeyAndOrValuePtr> {
  static bool IsNull(const ::blink::mojom::SharedStorageKeyAndOrValuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SharedStorageKeyAndOrValuePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SharedStorageKeyAndOrValue::key)& key(
      const ::blink::mojom::SharedStorageKeyAndOrValuePtr& input) {
    return input->key;
  }

  static const decltype(::blink::mojom::SharedStorageKeyAndOrValue::value)& value(
      const ::blink::mojom::SharedStorageKeyAndOrValuePtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::SharedStorageKeyAndOrValue::DataView input, ::blink::mojom::SharedStorageKeyAndOrValuePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PrivateAggregationOperationDetails::DataView,
                                         ::blink::mojom::PrivateAggregationOperationDetailsPtr> {
  static bool IsNull(const ::blink::mojom::PrivateAggregationOperationDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PrivateAggregationOperationDetailsPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::PrivateAggregationOperationDetails::pa_host)& pa_host(
       ::blink::mojom::PrivateAggregationOperationDetailsPtr& input) {
    return input->pa_host;
  }

  static decltype(::blink::mojom::PrivateAggregationOperationDetails::filtering_id_max_bytes) filtering_id_max_bytes(
      const ::blink::mojom::PrivateAggregationOperationDetailsPtr& input) {
    return input->filtering_id_max_bytes;
  }

  static bool Read(::blink::mojom::PrivateAggregationOperationDetails::DataView input, ::blink::mojom::PrivateAggregationOperationDetailsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::GetInterestGroupsResult::DataView,
                                        ::blink::mojom::GetInterestGroupsResultPtr> {
  static bool IsNull(const ::blink::mojom::GetInterestGroupsResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::GetInterestGroupsResultPtr* output) { output->reset(); }

  static ::blink::mojom::GetInterestGroupsResult::Tag GetTag(const ::blink::mojom::GetInterestGroupsResultPtr& input) {
    return input->which();
  }

  static const std::string& error_message(const ::blink::mojom::GetInterestGroupsResultPtr& input) {
    return input->get_error_message();
  }

  static const std::vector<::blink::mojom::StorageInterestGroupPtr>& groups(const ::blink::mojom::GetInterestGroupsResultPtr& input) {
    return input->get_groups();
  }

  static bool Read(::blink::mojom::GetInterestGroupsResult::DataView input, ::blink::mojom::GetInterestGroupsResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_WORKLET_SERVICE_MOJOM_H_