// third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CREDENTIALMANAGEMENT_CREDENTIAL_MANAGER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CREDENTIALMANAGEMENT_CREDENTIAL_MANAGER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "url/mojom/scheme_host_port.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class CredentialManagerProxy;

template <typename ImplRefTraits>
class CredentialManagerStub;

class CredentialManagerRequestValidator;
class CredentialManagerResponseValidator;


class PLATFORM_EXPORT CredentialManager
    : public CredentialManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.CredentialManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CredentialManagerInterfaceBase;
  using Proxy_ = CredentialManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = CredentialManagerStub<ImplRefTraits>;

  using RequestValidator_ = CredentialManagerRequestValidator;
  using ResponseValidator_ = CredentialManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStoreMinVersion = 0,
    kPreventSilentAccessMinVersion = 0,
    kGetMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Store_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreventSilentAccess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Get_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CredentialManager() = default;

  using StoreCallback = base::OnceCallback<void()>;
  using StoreMojoCallback = base::OnceCallback<void()>;

  virtual void Store(CredentialInfoPtr credential, StoreCallback callback) = 0;

  using PreventSilentAccessCallback = base::OnceCallback<void()>;
  using PreventSilentAccessMojoCallback = base::OnceCallback<void()>;

  virtual void PreventSilentAccess(PreventSilentAccessCallback callback) = 0;

  using GetCallback = base::OnceCallback<void(CredentialManagerError, CredentialInfoPtr)>;
  using GetMojoCallback = base::OnceCallback<void(CredentialManagerError, CredentialInfoPtr)>;

  virtual void Get(CredentialMediationRequirement mediation, bool include_passwords, const ::blink::Vector<::blink::KURL>& federations, GetCallback callback) = 0;
};



class PLATFORM_EXPORT CredentialManagerProxy
    : public CredentialManager {
 public:
  using InterfaceType = CredentialManager;

  explicit CredentialManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Store(CredentialInfoPtr credential, StoreCallback callback) final;
  
  void PreventSilentAccess(PreventSilentAccessCallback callback) final;
  
  void Get(CredentialMediationRequirement mediation, bool include_passwords, const ::blink::Vector<::blink::KURL>& federations, GetCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT CredentialManagerStubDispatch {
 public:
  static bool Accept(CredentialManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CredentialManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CredentialManager>>
class CredentialManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CredentialManagerStub() = default;
  ~CredentialManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CredentialManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CredentialManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT CredentialManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT CredentialManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT CredentialInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CredentialInfo, T>::value>;
  using DataView = CredentialInfoDataView;
  using Data_ = internal::CredentialInfo_Data;

  template <typename... Args>
  static CredentialInfoPtr New(Args&&... args) {
    return CredentialInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CredentialInfoPtr From(const U& u) {
    return mojo::TypeConverter<CredentialInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CredentialInfo>::Convert(*this);
  }


  CredentialInfo();

  CredentialInfo(
      CredentialType type,
      const ::blink::String& id,
      const ::blink::String& name,
      const ::blink::KURL& icon,
      const ::blink::String& password,
      const ::url::SchemeHostPort& federation);


  ~CredentialInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CredentialInfoPtr>
  CredentialInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CredentialInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CredentialInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CredentialInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CredentialInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CredentialInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CredentialInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CredentialInfo_UnserializedMessageContext<
            UserType, CredentialInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CredentialInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CredentialInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CredentialInfo_UnserializedMessageContext<
            UserType, CredentialInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CredentialInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CredentialType type;
  
  ::blink::String id;
  
  ::blink::String name;
  
  ::blink::KURL icon;
  
  ::blink::String password;
  
  ::url::SchemeHostPort federation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CredentialInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CredentialInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CredentialInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CredentialInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CredentialInfoPtr CredentialInfo::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(id),
      mojo::Clone(name),
      mojo::Clone(icon),
      mojo::Clone(password),
      mojo::Clone(federation)
  );
}

template <typename T, CredentialInfo::EnableIfSame<T>*>
bool CredentialInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->icon, other_struct.icon))
    return false;
  if (!mojo::Equals(this->password, other_struct.password))
    return false;
  if (!mojo::Equals(this->federation, other_struct.federation))
    return false;
  return true;
}

template <typename T, CredentialInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.icon < rhs.icon)
    return true;
  if (rhs.icon < lhs.icon)
    return false;
  if (lhs.password < rhs.password)
    return true;
  if (rhs.password < lhs.password)
    return false;
  if (lhs.federation < rhs.federation)
    return true;
  if (rhs.federation < lhs.federation)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::CredentialInfo::DataView,
                                         ::blink::mojom::blink::CredentialInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::CredentialInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CredentialInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::CredentialInfo::type) type(
      const ::blink::mojom::blink::CredentialInfoPtr& input) {
    return input->type;
  }

  static const decltype(::blink::mojom::blink::CredentialInfo::id)& id(
      const ::blink::mojom::blink::CredentialInfoPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::blink::CredentialInfo::name)& name(
      const ::blink::mojom::blink::CredentialInfoPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::CredentialInfo::icon)& icon(
      const ::blink::mojom::blink::CredentialInfoPtr& input) {
    return input->icon;
  }

  static const decltype(::blink::mojom::blink::CredentialInfo::password)& password(
      const ::blink::mojom::blink::CredentialInfoPtr& input) {
    return input->password;
  }

  static const decltype(::blink::mojom::blink::CredentialInfo::federation)& federation(
      const ::blink::mojom::blink::CredentialInfoPtr& input) {
    return input->federation;
  }

  static bool Read(::blink::mojom::blink::CredentialInfo::DataView input, ::blink::mojom::blink::CredentialInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CREDENTIALMANAGEMENT_CREDENTIAL_MANAGER_MOJOM_BLINK_H_