// services/viz/public/mojom/compositing/shared_quad_state.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/token.mojom-forward.h"
#include "services/viz/public/mojom/compositing/offset_tag.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/rrect_f.mojom-forward.h"
#include "ui/gfx/mojom/transform.mojom.h"
#include "ui/gfx/mojom/mask_filter_info.mojom.h"
#include <string>
#include <vector>




#include "services/viz/public/cpp/compositing/shared_quad_state_mojom_traits.h"




namespace viz::mojom {








class  SharedQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedQuadState, T>::value>;
  using DataView = SharedQuadStateDataView;
  using Data_ = internal::SharedQuadState_Data;

  template <typename... Args>
  static SharedQuadStatePtr New(Args&&... args) {
    return SharedQuadStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<SharedQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedQuadState>::Convert(*this);
  }


  SharedQuadState();

  SharedQuadState(
      const ::gfx::Transform& quad_to_target_transform,
      const ::gfx::Rect& quad_layer_rect,
      const ::gfx::Rect& visible_quad_layer_rect,
      const std::optional<::gfx::MaskFilterInfo>& mask_filter_info,
      const std::optional<::gfx::Rect>& clip_rect,
      bool are_contents_opaque,
      float opacity,
      uint32_t blend_mode,
      int32_t sorting_context_id,
      uint32_t layer_id,
      bool is_fast_rounded_corner,
      const ::viz::OffsetTag& offset_tag);


  ~SharedQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedQuadStatePtr>
  SharedQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedQuadState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedQuadState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedQuadState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedQuadState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedQuadState_UnserializedMessageContext<
            UserType, SharedQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedQuadState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedQuadState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedQuadState_UnserializedMessageContext<
            UserType, SharedQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedQuadState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Transform quad_to_target_transform;
  
  ::gfx::Rect quad_layer_rect;
  
  ::gfx::Rect visible_quad_layer_rect;
  
  std::optional<::gfx::MaskFilterInfo> mask_filter_info;
  
  std::optional<::gfx::Rect> clip_rect;
  
  bool are_contents_opaque;
  
  float opacity;
  
  uint32_t blend_mode;
  
  int32_t sorting_context_id;
  
  uint32_t layer_id;
  
  bool is_fast_rounded_corner;
  
  ::viz::OffsetTag offset_tag;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SharedQuadStatePtr SharedQuadState::Clone() const {
  return New(
      mojo::Clone(quad_to_target_transform),
      mojo::Clone(quad_layer_rect),
      mojo::Clone(visible_quad_layer_rect),
      mojo::Clone(mask_filter_info),
      mojo::Clone(clip_rect),
      mojo::Clone(are_contents_opaque),
      mojo::Clone(opacity),
      mojo::Clone(blend_mode),
      mojo::Clone(sorting_context_id),
      mojo::Clone(layer_id),
      mojo::Clone(is_fast_rounded_corner),
      mojo::Clone(offset_tag)
  );
}

template <typename T, SharedQuadState::EnableIfSame<T>*>
bool SharedQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->quad_to_target_transform, other_struct.quad_to_target_transform))
    return false;
  if (!mojo::Equals(this->quad_layer_rect, other_struct.quad_layer_rect))
    return false;
  if (!mojo::Equals(this->visible_quad_layer_rect, other_struct.visible_quad_layer_rect))
    return false;
  if (!mojo::Equals(this->mask_filter_info, other_struct.mask_filter_info))
    return false;
  if (!mojo::Equals(this->clip_rect, other_struct.clip_rect))
    return false;
  if (!mojo::Equals(this->are_contents_opaque, other_struct.are_contents_opaque))
    return false;
  if (!mojo::Equals(this->opacity, other_struct.opacity))
    return false;
  if (!mojo::Equals(this->blend_mode, other_struct.blend_mode))
    return false;
  if (!mojo::Equals(this->sorting_context_id, other_struct.sorting_context_id))
    return false;
  if (!mojo::Equals(this->layer_id, other_struct.layer_id))
    return false;
  if (!mojo::Equals(this->is_fast_rounded_corner, other_struct.is_fast_rounded_corner))
    return false;
  if (!mojo::Equals(this->offset_tag, other_struct.offset_tag))
    return false;
  return true;
}

template <typename T, SharedQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.quad_to_target_transform < rhs.quad_to_target_transform)
    return true;
  if (rhs.quad_to_target_transform < lhs.quad_to_target_transform)
    return false;
  if (lhs.quad_layer_rect < rhs.quad_layer_rect)
    return true;
  if (rhs.quad_layer_rect < lhs.quad_layer_rect)
    return false;
  if (lhs.visible_quad_layer_rect < rhs.visible_quad_layer_rect)
    return true;
  if (rhs.visible_quad_layer_rect < lhs.visible_quad_layer_rect)
    return false;
  if (lhs.mask_filter_info < rhs.mask_filter_info)
    return true;
  if (rhs.mask_filter_info < lhs.mask_filter_info)
    return false;
  if (lhs.clip_rect < rhs.clip_rect)
    return true;
  if (rhs.clip_rect < lhs.clip_rect)
    return false;
  if (lhs.are_contents_opaque < rhs.are_contents_opaque)
    return true;
  if (rhs.are_contents_opaque < lhs.are_contents_opaque)
    return false;
  if (lhs.opacity < rhs.opacity)
    return true;
  if (rhs.opacity < lhs.opacity)
    return false;
  if (lhs.blend_mode < rhs.blend_mode)
    return true;
  if (rhs.blend_mode < lhs.blend_mode)
    return false;
  if (lhs.sorting_context_id < rhs.sorting_context_id)
    return true;
  if (rhs.sorting_context_id < lhs.sorting_context_id)
    return false;
  if (lhs.layer_id < rhs.layer_id)
    return true;
  if (rhs.layer_id < lhs.layer_id)
    return false;
  if (lhs.is_fast_rounded_corner < rhs.is_fast_rounded_corner)
    return true;
  if (rhs.is_fast_rounded_corner < lhs.is_fast_rounded_corner)
    return false;
  if (lhs.offset_tag < rhs.offset_tag)
    return true;
  if (rhs.offset_tag < lhs.offset_tag)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::SharedQuadState::DataView,
                                         ::viz::mojom::SharedQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::SharedQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::SharedQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::SharedQuadState::quad_to_target_transform)& quad_to_target_transform(
      const ::viz::mojom::SharedQuadStatePtr& input) {
    return input->quad_to_target_transform;
  }

  static const decltype(::viz::mojom::SharedQuadState::quad_layer_rect)& quad_layer_rect(
      const ::viz::mojom::SharedQuadStatePtr& input) {
    return input->quad_layer_rect;
  }

  static const decltype(::viz::mojom::SharedQuadState::visible_quad_layer_rect)& visible_quad_layer_rect(
      const ::viz::mojom::SharedQuadStatePtr& input) {
    return input->visible_quad_layer_rect;
  }

  static const decltype(::viz::mojom::SharedQuadState::mask_filter_info)& mask_filter_info(
      const ::viz::mojom::SharedQuadStatePtr& input) {
    return input->mask_filter_info;
  }

  static const decltype(::viz::mojom::SharedQuadState::clip_rect)& clip_rect(
      const ::viz::mojom::SharedQuadStatePtr& input) {
    return input->clip_rect;
  }

  static decltype(::viz::mojom::SharedQuadState::are_contents_opaque) are_contents_opaque(
      const ::viz::mojom::SharedQuadStatePtr& input) {
    return input->are_contents_opaque;
  }

  static decltype(::viz::mojom::SharedQuadState::opacity) opacity(
      const ::viz::mojom::SharedQuadStatePtr& input) {
    return input->opacity;
  }

  static decltype(::viz::mojom::SharedQuadState::blend_mode) blend_mode(
      const ::viz::mojom::SharedQuadStatePtr& input) {
    return input->blend_mode;
  }

  static decltype(::viz::mojom::SharedQuadState::sorting_context_id) sorting_context_id(
      const ::viz::mojom::SharedQuadStatePtr& input) {
    return input->sorting_context_id;
  }

  static decltype(::viz::mojom::SharedQuadState::layer_id) layer_id(
      const ::viz::mojom::SharedQuadStatePtr& input) {
    return input->layer_id;
  }

  static decltype(::viz::mojom::SharedQuadState::is_fast_rounded_corner) is_fast_rounded_corner(
      const ::viz::mojom::SharedQuadStatePtr& input) {
    return input->is_fast_rounded_corner;
  }

  static const decltype(::viz::mojom::SharedQuadState::offset_tag)& offset_tag(
      const ::viz::mojom::SharedQuadStatePtr& input) {
    return input->offset_tag;
  }

  static bool Read(::viz::mojom::SharedQuadState::DataView input, ::viz::mojom::SharedQuadStatePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_H_