// services/viz/public/mojom/compositing/compositor_frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/compositor_frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/compositor_frame.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/compositor_frame.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-test-utils.h"
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"


namespace viz::mojom {
CompositorFrame::CompositorFrame()
    : metadata(),
      resources(),
      passes() {}

CompositorFrame::CompositorFrame(
    ::viz::CompositorFrameMetadata metadata_in,
    std::vector<::viz::TransferableResource> resources_in,
    std::vector<::std::unique_ptr<::viz::CompositorRenderPass>> passes_in)
    : metadata(std::move(metadata_in)),
      resources(std::move(resources_in)),
      passes(std::move(passes_in)) {}

CompositorFrame::~CompositorFrame() = default;

void CompositorFrame::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::CompositorFrameMetadata>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resources"), this->resources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::viz::TransferableResource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "passes"), this->passes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::std::unique_ptr<::viz::CompositorRenderPass>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CompositorFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::CompositorFrame::DataView, ::viz::mojom::CompositorFramePtr>::Read(
    ::viz::mojom::CompositorFrame::DataView input,
    ::viz::mojom::CompositorFramePtr* output) {
  bool success = true;
  ::viz::mojom::CompositorFramePtr result(::viz::mojom::CompositorFrame::New());
  
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
      if (success && !input.ReadResources(&result->resources))
        success = false;
      if (success && !input.ReadPasses(&result->passes))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif