// services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BITMAP_IN_SHARED_MEMORY_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BITMAP_IN_SHARED_MEMORY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BitmapInSharedMemoryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BitmapInSharedMemoryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BitmapInSharedMemory_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::image_info(input)) in_image_info = Traits::image_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_info)::BaseType> image_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::ImageInfoDataView>(
      in_image_info,
      image_info_fragment);

    fragment->image_info.Set(
        image_info_fragment.is_null() ? nullptr : image_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_info in BitmapInSharedMemory struct");

    fragment->row_bytes = Traits::row_bytes(input);

    decltype(Traits::pixels(input)) in_pixels = Traits::pixels(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pixels)::BaseType> pixels_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::WritableSharedMemoryRegionDataView>(
      in_pixels,
      pixels_fragment);

    fragment->pixels.Set(
        pixels_fragment.is_null() ? nullptr : pixels_fragment.data());
  }

  static bool Deserialize(::viz::mojom::internal::BitmapInSharedMemory_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::BitmapInSharedMemoryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void BitmapInSharedMemoryDataView::GetImageInfoDataView(
    ::skia::mojom::ImageInfoDataView* output) {
  auto pointer = data_->image_info.Get();
  *output = ::skia::mojom::ImageInfoDataView(pointer, message_);
}
inline void BitmapInSharedMemoryDataView::GetPixelsDataView(
    ::mojo_base::mojom::WritableSharedMemoryRegionDataView* output) {
  auto pointer = data_->pixels.Get();
  *output = ::mojo_base::mojom::WritableSharedMemoryRegionDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BITMAP_IN_SHARED_MEMORY_MOJOM_SHARED_H_