// services/viz/privileged/mojom/gl/gpu_logging.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_LOGGING_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_LOGGING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/gl/gpu_logging.mojom-features.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/gl/gpu_logging.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/gl/gpu_logging.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace viz::mojom {

class GpuLoggingProxy;

template <typename ImplRefTraits>
class GpuLoggingStub;

class GpuLoggingRequestValidator;


class GpuLogging
    : public GpuLoggingInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.GpuLogging";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GpuLoggingInterfaceBase;
  using Proxy_ = GpuLoggingProxy;

  template <typename ImplRefTraits>
  using Stub_ = GpuLoggingStub<ImplRefTraits>;

  using RequestValidator_ = GpuLoggingRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRecordLogMessageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RecordLogMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GpuLogging() = default;

  virtual void RecordLogMessage(int32_t severity, const std::string& header, const std::string& message) = 0;
};



class  GpuLoggingProxy
    : public GpuLogging {
 public:
  using InterfaceType = GpuLogging;

  explicit GpuLoggingProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RecordLogMessage(int32_t severity, const std::string& header, const std::string& message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GpuLoggingStubDispatch {
 public:
  static bool Accept(GpuLogging* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GpuLogging* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GpuLogging>>
class GpuLoggingStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GpuLoggingStub() = default;
  ~GpuLoggingStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuLoggingStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuLoggingStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GpuLoggingRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // viz::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_LOGGING_MOJOM_H_