// services/video_capture/public/mojom/video_source.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/video_capture/public/mojom/video_source.mojom-features.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/video_source.mojom-shared.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/video_source.mojom-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/image_capture.mojom-forward.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "media/capture/mojom/video_effects_manager.mojom-forward.h"
#include "services/video_effects/public/mojom/video_effects_processor.mojom-forward.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace video_capture::mojom {

class PushVideoStreamSubscriptionProxy;

template <typename ImplRefTraits>
class PushVideoStreamSubscriptionStub;

class PushVideoStreamSubscriptionRequestValidator;
class PushVideoStreamSubscriptionResponseValidator;


class PushVideoStreamSubscription
    : public PushVideoStreamSubscriptionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "video_capture.mojom.PushVideoStreamSubscription";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PushVideoStreamSubscriptionInterfaceBase;
  using Proxy_ = PushVideoStreamSubscriptionProxy;

  template <typename ImplRefTraits>
  using Stub_ = PushVideoStreamSubscriptionStub<ImplRefTraits>;

  using RequestValidator_ = PushVideoStreamSubscriptionRequestValidator;
  using ResponseValidator_ = PushVideoStreamSubscriptionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kActivateMinVersion = 0,
    kSuspendMinVersion = 0,
    kResumeMinVersion = 0,
    kGetPhotoStateMinVersion = 0,
    kSetPhotoOptionsMinVersion = 0,
    kTakePhotoMinVersion = 0,
    kCloseMinVersion = 0,
    kProcessFeedbackMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Activate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Suspend_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Resume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPhotoState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPhotoOptions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TakePhoto_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ProcessFeedback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PushVideoStreamSubscription() = default;

  virtual void Activate() = 0;

  using SuspendCallback = base::OnceCallback<void()>;
  using SuspendMojoCallback = base::OnceCallback<void()>;

  virtual void Suspend(SuspendCallback callback) = 0;

  virtual void Resume() = 0;

  using GetPhotoStateCallback = base::OnceCallback<void(::media::mojom::PhotoStatePtr)>;
  using GetPhotoStateMojoCallback = base::OnceCallback<void(::media::mojom::PhotoStatePtr)>;

  virtual void GetPhotoState(GetPhotoStateCallback callback) = 0;

  using SetPhotoOptionsCallback = base::OnceCallback<void(bool)>;
  using SetPhotoOptionsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetPhotoOptions(::media::mojom::PhotoSettingsPtr settings, SetPhotoOptionsCallback callback) = 0;

  using TakePhotoCallback = base::OnceCallback<void(::media::mojom::BlobPtr)>;
  using TakePhotoMojoCallback = base::OnceCallback<void(::media::mojom::BlobPtr)>;

  virtual void TakePhoto(TakePhotoCallback callback) = 0;

  using CloseCallback = base::OnceCallback<void()>;
  using CloseMojoCallback = base::OnceCallback<void()>;

  virtual void Close(CloseCallback callback) = 0;

  virtual void ProcessFeedback(const ::media::VideoCaptureFeedback& feedback) = 0;
};

class VideoSourceProxy;

template <typename ImplRefTraits>
class VideoSourceStub;

class VideoSourceRequestValidator;
class VideoSourceResponseValidator;


class VideoSource
    : public VideoSourceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "video_capture.mojom.VideoSource";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoSourceInterfaceBase;
  using Proxy_ = VideoSourceProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoSourceStub<ImplRefTraits>;

  using RequestValidator_ = VideoSourceRequestValidator;
  using ResponseValidator_ = VideoSourceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreatePushSubscriptionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePushSubscription_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoSource() = default;

  using CreatePushSubscriptionCallback = base::OnceCallback<void(CreatePushSubscriptionResultCodePtr, const ::media::VideoCaptureParams&)>;
  using CreatePushSubscriptionMojoCallback = base::OnceCallback<void(CreatePushSubscriptionResultCodePtr, const ::media::VideoCaptureParams&)>;

  virtual void CreatePushSubscription(::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> subscriber, const ::media::VideoCaptureParams& requested_settings, bool force_reopen_with_new_settings, ::mojo::PendingReceiver<PushVideoStreamSubscription> subscription, CreatePushSubscriptionCallback callback) = 0;
};



class  PushVideoStreamSubscriptionProxy
    : public PushVideoStreamSubscription {
 public:
  using InterfaceType = PushVideoStreamSubscription;

  explicit PushVideoStreamSubscriptionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Activate() final;
  
  void Suspend(SuspendCallback callback) final;
  
  void Resume() final;
  
  void GetPhotoState(GetPhotoStateCallback callback) final;
  
  void SetPhotoOptions(::media::mojom::PhotoSettingsPtr settings, SetPhotoOptionsCallback callback) final;
  
  void TakePhoto(TakePhotoCallback callback) final;
  
  void Close(CloseCallback callback) final;
  
  void ProcessFeedback(const ::media::VideoCaptureFeedback& feedback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  VideoSourceProxy
    : public VideoSource {
 public:
  using InterfaceType = VideoSource;

  explicit VideoSourceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePushSubscription(::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> subscriber, const ::media::VideoCaptureParams& requested_settings, bool force_reopen_with_new_settings, ::mojo::PendingReceiver<PushVideoStreamSubscription> subscription, CreatePushSubscriptionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PushVideoStreamSubscriptionStubDispatch {
 public:
  static bool Accept(PushVideoStreamSubscription* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PushVideoStreamSubscription* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PushVideoStreamSubscription>>
class PushVideoStreamSubscriptionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PushVideoStreamSubscriptionStub() = default;
  ~PushVideoStreamSubscriptionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PushVideoStreamSubscriptionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PushVideoStreamSubscriptionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoSourceStubDispatch {
 public:
  static bool Accept(VideoSource* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoSource* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoSource>>
class VideoSourceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoSourceStub() = default;
  ~VideoSourceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoSourceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoSourceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PushVideoStreamSubscriptionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoSourceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PushVideoStreamSubscriptionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoSourceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  CreatePushSubscriptionResultCode {
 public:
  using DataView = CreatePushSubscriptionResultCodeDataView;
  using Data_ = internal::CreatePushSubscriptionResultCode_Data;
  using Tag = Data_::CreatePushSubscriptionResultCode_Tag;

  template <typename... Args>
  static CreatePushSubscriptionResultCodePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success_code|.
  static CreatePushSubscriptionResultCodePtr NewSuccessCode(
      CreatePushSubscriptionSuccessCode value);
  // Construct an instance holding |error_code|.
  static CreatePushSubscriptionResultCodePtr NewErrorCode(
      ::media::VideoCaptureError value);

  template <typename U>
  static CreatePushSubscriptionResultCodePtr From(const U& u) {
    return mojo::TypeConverter<CreatePushSubscriptionResultCodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreatePushSubscriptionResultCode>::Convert(*this);
  }
  ~CreatePushSubscriptionResultCode();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CreatePushSubscriptionResultCodePtr>
  CreatePushSubscriptionResultCodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreatePushSubscriptionResultCode>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreatePushSubscriptionResultCode>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success_code() const { return tag_ == Tag::kSuccessCode; }
  CreatePushSubscriptionSuccessCode get_success_code() const {
    CHECK(tag_ == Tag::kSuccessCode);
    return data_.success_code;
  }
  void set_success_code(CreatePushSubscriptionSuccessCode success_code);

  bool is_error_code() const { return tag_ == Tag::kErrorCode; }
  ::media::VideoCaptureError get_error_code() const {
    CHECK(tag_ == Tag::kErrorCode);
    return data_.error_code;
  }
  void set_error_code(::media::VideoCaptureError error_code);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreatePushSubscriptionResultCode::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CreatePushSubscriptionResultCode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccessCode)>,
        CreatePushSubscriptionSuccessCode value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
        ::media::VideoCaptureError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    CreatePushSubscriptionSuccessCode success_code;
    ::media::VideoCaptureError error_code;
  };

  CreatePushSubscriptionResultCode(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccessCode)>,
      CreatePushSubscriptionSuccessCode value);
  CreatePushSubscriptionResultCode(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
      ::media::VideoCaptureError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
CreatePushSubscriptionResultCodePtr CreatePushSubscriptionResultCode::Clone() const {
  switch (tag_) {
    case Tag::kSuccessCode:
      return NewSuccessCode(
          mojo::Clone(data_.success_code));
    case Tag::kErrorCode:
      return NewErrorCode(
          mojo::Clone(data_.error_code));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CreatePushSubscriptionResultCode>::value>::type*>
bool CreatePushSubscriptionResultCode::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccessCode:
      return mojo::Equals(data_.success_code, other.data_.success_code);
    case Tag::kErrorCode:
      return mojo::Equals(data_.error_code, other.data_.error_code);
  }

  return false;
}


}  // video_capture::mojom

namespace mojo {


template <>
struct  UnionTraits<::video_capture::mojom::CreatePushSubscriptionResultCode::DataView,
                                        ::video_capture::mojom::CreatePushSubscriptionResultCodePtr> {
  static bool IsNull(const ::video_capture::mojom::CreatePushSubscriptionResultCodePtr& input) { return !input; }
  static void SetToNull(::video_capture::mojom::CreatePushSubscriptionResultCodePtr* output) { output->reset(); }

  static ::video_capture::mojom::CreatePushSubscriptionResultCode::Tag GetTag(const ::video_capture::mojom::CreatePushSubscriptionResultCodePtr& input) {
    return input->which();
  }

  static  ::video_capture::mojom::CreatePushSubscriptionSuccessCode success_code(const ::video_capture::mojom::CreatePushSubscriptionResultCodePtr& input) {
    return input->get_success_code();
  }

  static  ::media::VideoCaptureError error_code(const ::video_capture::mojom::CreatePushSubscriptionResultCodePtr& input) {
    return input->get_error_code();
  }

  static bool Read(::video_capture::mojom::CreatePushSubscriptionResultCode::DataView input, ::video_capture::mojom::CreatePushSubscriptionResultCodePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_H_