// services/video_capture/public/mojom/producer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_PRODUCER_MOJOM_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_PRODUCER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/video_capture/public/mojom/producer.mojom-features.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/producer.mojom-shared.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/producer.mojom-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_buffer.mojom-forward.h"
#include "media/capture/mojom/video_capture_types.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace video_capture::mojom {

class ProducerProxy;

template <typename ImplRefTraits>
class ProducerStub;

class ProducerRequestValidator;
class ProducerResponseValidator;


class Producer
    : public ProducerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "video_capture.mojom.Producer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProducerInterfaceBase;
  using Proxy_ = ProducerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProducerStub<ImplRefTraits>;

  using RequestValidator_ = ProducerRequestValidator;
  using ResponseValidator_ = ProducerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnNewBufferMinVersion = 0,
    kOnBufferRetiredMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnNewBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBufferRetired_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Producer() = default;

  using OnNewBufferCallback = base::OnceCallback<void()>;
  using OnNewBufferMojoCallback = base::OnceCallback<void()>;

  virtual void OnNewBuffer(int32_t buffer_id, ::media::mojom::VideoBufferHandlePtr buffer_handle, OnNewBufferCallback callback) = 0;

  virtual void OnBufferRetired(int32_t buffer_id) = 0;
};



class  ProducerProxy
    : public Producer {
 public:
  using InterfaceType = Producer;

  explicit ProducerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnNewBuffer(int32_t buffer_id, ::media::mojom::VideoBufferHandlePtr buffer_handle, OnNewBufferCallback callback) final;
  
  void OnBufferRetired(int32_t buffer_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ProducerStubDispatch {
 public:
  static bool Accept(Producer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Producer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Producer>>
class ProducerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProducerStub() = default;
  ~ProducerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProducerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProducerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProducerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProducerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // video_capture::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_PRODUCER_MOJOM_H_