// services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_MEMORY_INSTRUMENTATION_MEMORY_INSTRUMENTATION_MOJOM_SHARED_H_
#define SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_MEMORY_INSTRUMENTATION_MEMORY_INSTRUMENTATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_string.mojom-shared.h"
#include "mojo/public/mojom/base/process_id.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::memory_instrumentation::mojom::DumpType>
    : public mojo::internal::EnumHashImpl<::memory_instrumentation::mojom::DumpType> {};

template <>
struct hash<::memory_instrumentation::mojom::LevelOfDetail>
    : public mojo::internal::EnumHashImpl<::memory_instrumentation::mojom::LevelOfDetail> {};

template <>
struct hash<::memory_instrumentation::mojom::Determinism>
    : public mojo::internal::EnumHashImpl<::memory_instrumentation::mojom::Determinism> {};

template <>
struct hash<::memory_instrumentation::mojom::ProcessType>
    : public mojo::internal::EnumHashImpl<::memory_instrumentation::mojom::ProcessType> {};

template <>
struct hash<::memory_instrumentation::mojom::MemoryMapOption>
    : public mojo::internal::EnumHashImpl<::memory_instrumentation::mojom::MemoryMapOption> {};

template <>
struct hash<::memory_instrumentation::mojom::MemDumpFlags>
    : public mojo::internal::EnumHashImpl<::memory_instrumentation::mojom::MemDumpFlags> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::DumpType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::memory_instrumentation::mojom::DumpType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::memory_instrumentation::mojom::DumpType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::LevelOfDetail, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::memory_instrumentation::mojom::LevelOfDetail, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::memory_instrumentation::mojom::LevelOfDetail>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::Determinism, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::memory_instrumentation::mojom::Determinism, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::memory_instrumentation::mojom::Determinism>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::ProcessType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::memory_instrumentation::mojom::ProcessType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::memory_instrumentation::mojom::ProcessType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::MemoryMapOption, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::memory_instrumentation::mojom::MemoryMapOption, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::memory_instrumentation::mojom::MemoryMapOption>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::MemDumpFlags, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::memory_instrumentation::mojom::MemDumpFlags, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::memory_instrumentation::mojom::MemDumpFlags>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::RequestArgsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::RequestArgsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::RequestArgs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->dump_guid = Traits::dump_guid(input);

    
    mojo::internal::Serialize<::memory_instrumentation::mojom::DumpType>(
      Traits::dump_type(input),
      &fragment->dump_type);

    
    mojo::internal::Serialize<::memory_instrumentation::mojom::LevelOfDetail>(
      Traits::level_of_detail(input),
      &fragment->level_of_detail);

    
    mojo::internal::Serialize<::memory_instrumentation::mojom::Determinism>(
      Traits::determinism(input),
      &fragment->determinism);
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::RequestArgs_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::RequestArgsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::RawAllocatorDumpEdgeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::RawAllocatorDumpEdgeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::RawAllocatorDumpEdge_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->source_id = Traits::source_id(input);

    fragment->target_id = Traits::target_id(input);

    fragment->importance = Traits::importance(input);

    fragment->overridable = Traits::overridable(input);
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::RawAllocatorDumpEdge_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::RawAllocatorDumpEdgeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::RawAllocatorDumpEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::RawAllocatorDumpEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::RawAllocatorDumpEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in RawAllocatorDumpEntry struct");

    decltype(Traits::units(input)) in_units = Traits::units(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->units)::BaseType> units_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_units,
      units_fragment);

    fragment->units.Set(
        units_fragment.is_null() ? nullptr : units_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->units.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null units in RawAllocatorDumpEntry struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<decltype(fragment->value)>
        value_fragment(fragment.message());
    value_fragment.Claim(&fragment->value);
    
    mojo::internal::Serialize<::memory_instrumentation::mojom::RawAllocatorDumpEntryValueDataView>(
      in_value,
      value_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in RawAllocatorDumpEntry struct");
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::RawAllocatorDumpEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::RawAllocatorDumpEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::RawAllocatorDumpDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::RawAllocatorDumpDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::RawAllocatorDump_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::absolute_name(input)) in_absolute_name = Traits::absolute_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->absolute_name)::BaseType> absolute_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_absolute_name,
      absolute_name_fragment);

    fragment->absolute_name.Set(
        absolute_name_fragment.is_null() ? nullptr : absolute_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->absolute_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null absolute_name in RawAllocatorDump struct");

    fragment->weak = Traits::weak(input);

    
    mojo::internal::Serialize<::memory_instrumentation::mojom::LevelOfDetail>(
      Traits::level_of_detail(input),
      &fragment->level_of_detail);

    decltype(Traits::entries(input)) in_entries = Traits::entries(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->entries)::BaseType>
        entries_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::memory_instrumentation::mojom::RawAllocatorDumpEntryDataView>>(
      in_entries,
      entries_fragment,
      &entries_validate_params);

    fragment->entries.Set(
        entries_fragment.is_null() ? nullptr : entries_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->entries.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entries in RawAllocatorDump struct");
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::RawAllocatorDump_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::RawAllocatorDumpDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::RawProcessMemoryDumpDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::RawProcessMemoryDumpDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::RawProcessMemoryDump_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::memory_instrumentation::mojom::LevelOfDetail>(
      Traits::level_of_detail(input),
      &fragment->level_of_detail);

    decltype(Traits::allocator_dump_edges(input)) in_allocator_dump_edges = Traits::allocator_dump_edges(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allocator_dump_edges)::BaseType>
        allocator_dump_edges_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& allocator_dump_edges_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::memory_instrumentation::mojom::RawAllocatorDumpEdgeDataView>>(
      in_allocator_dump_edges,
      allocator_dump_edges_fragment,
      &allocator_dump_edges_validate_params);

    fragment->allocator_dump_edges.Set(
        allocator_dump_edges_fragment.is_null() ? nullptr : allocator_dump_edges_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->allocator_dump_edges.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allocator_dump_edges in RawProcessMemoryDump struct");

    decltype(Traits::allocator_dumps(input)) in_allocator_dumps = Traits::allocator_dumps(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allocator_dumps)::BaseType>
        allocator_dumps_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& allocator_dumps_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::memory_instrumentation::mojom::RawAllocatorDumpDataView>>(
      in_allocator_dumps,
      allocator_dumps_fragment,
      &allocator_dumps_validate_params);

    fragment->allocator_dumps.Set(
        allocator_dumps_fragment.is_null() ? nullptr : allocator_dumps_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->allocator_dumps.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allocator_dumps in RawProcessMemoryDump struct");
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::RawProcessMemoryDump_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::RawProcessMemoryDumpDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::VmRegionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::VmRegionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::VmRegion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->start_address = Traits::start_address(input);

    fragment->size_in_bytes = Traits::size_in_bytes(input);

    fragment->module_timestamp = Traits::module_timestamp(input);

    decltype(Traits::module_debugid(input)) in_module_debugid = Traits::module_debugid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->module_debugid)::BaseType> module_debugid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_module_debugid,
      module_debugid_fragment);

    fragment->module_debugid.Set(
        module_debugid_fragment.is_null() ? nullptr : module_debugid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->module_debugid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null module_debugid in VmRegion struct");

    decltype(Traits::module_debug_path(input)) in_module_debug_path = Traits::module_debug_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->module_debug_path)::BaseType> module_debug_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_module_debug_path,
      module_debug_path_fragment);

    fragment->module_debug_path.Set(
        module_debug_path_fragment.is_null() ? nullptr : module_debug_path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->module_debug_path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null module_debug_path in VmRegion struct");

    fragment->protection_flags = Traits::protection_flags(input);

    decltype(Traits::mapped_file(input)) in_mapped_file = Traits::mapped_file(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mapped_file)::BaseType> mapped_file_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_mapped_file,
      mapped_file_fragment);

    fragment->mapped_file.Set(
        mapped_file_fragment.is_null() ? nullptr : mapped_file_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mapped_file.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mapped_file in VmRegion struct");

    fragment->byte_stats_private_dirty_resident = Traits::byte_stats_private_dirty_resident(input);

    fragment->byte_stats_private_clean_resident = Traits::byte_stats_private_clean_resident(input);

    fragment->byte_stats_shared_dirty_resident = Traits::byte_stats_shared_dirty_resident(input);

    fragment->byte_stats_shared_clean_resident = Traits::byte_stats_shared_clean_resident(input);

    fragment->byte_stats_swapped = Traits::byte_stats_swapped(input);

    fragment->byte_locked = Traits::byte_locked(input);

    fragment->byte_stats_proportional_resident = Traits::byte_stats_proportional_resident(input);
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::VmRegion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::VmRegionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::PlatformPrivateFootprintDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::PlatformPrivateFootprintDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::PlatformPrivateFootprint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->phys_footprint_bytes = Traits::phys_footprint_bytes(input);

    fragment->internal_bytes = Traits::internal_bytes(input);

    fragment->compressed_bytes = Traits::compressed_bytes(input);

    fragment->rss_anon_bytes = Traits::rss_anon_bytes(input);

    fragment->vm_swap_bytes = Traits::vm_swap_bytes(input);

    fragment->private_bytes = Traits::private_bytes(input);
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::PlatformPrivateFootprint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::PlatformPrivateFootprintDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::RawOSMemDumpDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::RawOSMemDumpDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::RawOSMemDump_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->resident_set_kb = Traits::resident_set_kb(input);

    fragment->peak_resident_set_kb = Traits::peak_resident_set_kb(input);

    fragment->is_peak_rss_resettable = Traits::is_peak_rss_resettable(input);

    decltype(Traits::platform_private_footprint(input)) in_platform_private_footprint = Traits::platform_private_footprint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->platform_private_footprint)::BaseType> platform_private_footprint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::memory_instrumentation::mojom::PlatformPrivateFootprintDataView>(
      in_platform_private_footprint,
      platform_private_footprint_fragment);

    fragment->platform_private_footprint.Set(
        platform_private_footprint_fragment.is_null() ? nullptr : platform_private_footprint_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->platform_private_footprint.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null platform_private_footprint in RawOSMemDump struct");

    decltype(Traits::memory_maps(input)) in_memory_maps = Traits::memory_maps(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->memory_maps)::BaseType>
        memory_maps_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& memory_maps_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::memory_instrumentation::mojom::VmRegionDataView>>(
      in_memory_maps,
      memory_maps_fragment,
      &memory_maps_validate_params);

    fragment->memory_maps.Set(
        memory_maps_fragment.is_null() ? nullptr : memory_maps_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->memory_maps.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null memory_maps in RawOSMemDump struct");

    decltype(Traits::native_library_pages_bitmap(input)) in_native_library_pages_bitmap = Traits::native_library_pages_bitmap(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->native_library_pages_bitmap)::BaseType>
        native_library_pages_bitmap_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& native_library_pages_bitmap_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_native_library_pages_bitmap,
      native_library_pages_bitmap_fragment,
      &native_library_pages_bitmap_validate_params);

    fragment->native_library_pages_bitmap.Set(
        native_library_pages_bitmap_fragment.is_null() ? nullptr : native_library_pages_bitmap_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->native_library_pages_bitmap.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_library_pages_bitmap in RawOSMemDump struct");

    fragment->mappings_count = Traits::mappings_count(input);

    fragment->pss_kb = Traits::pss_kb(input);

    fragment->swap_pss_kb = Traits::swap_pss_kb(input);
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::RawOSMemDump_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::RawOSMemDumpDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::OSMemDumpDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::OSMemDumpDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::OSMemDump_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->resident_set_kb = Traits::resident_set_kb(input);

    fragment->peak_resident_set_kb = Traits::peak_resident_set_kb(input);

    fragment->is_peak_rss_resettable = Traits::is_peak_rss_resettable(input);

    fragment->private_footprint_kb = Traits::private_footprint_kb(input);

    fragment->shared_footprint_kb = Traits::shared_footprint_kb(input);

    fragment->private_footprint_swap_kb = Traits::private_footprint_swap_kb(input);

    fragment->mappings_count = Traits::mappings_count(input);

    fragment->pss_kb = Traits::pss_kb(input);

    fragment->swap_pss_kb = Traits::swap_pss_kb(input);
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::OSMemDump_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::OSMemDumpDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::AllocatorMemDumpDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::AllocatorMemDumpDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::AllocatorMemDump_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::numeric_entries(input)) in_numeric_entries = Traits::numeric_entries(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->numeric_entries)::BaseType>
        numeric_entries_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& numeric_entries_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, uint64_t>>(
      in_numeric_entries,
      numeric_entries_fragment,
      &numeric_entries_validate_params);

    fragment->numeric_entries.Set(
        numeric_entries_fragment.is_null() ? nullptr : numeric_entries_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->numeric_entries.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null numeric_entries in AllocatorMemDump struct");

    decltype(Traits::children(input)) in_children = Traits::children(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->children)::BaseType>
        children_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::memory_instrumentation::mojom::AllocatorMemDumpDataView>>(
      in_children,
      children_fragment,
      &children_validate_params);

    fragment->children.Set(
        children_fragment.is_null() ? nullptr : children_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->children.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null children in AllocatorMemDump struct");
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::AllocatorMemDump_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::AllocatorMemDumpDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::ProcessMemoryDumpDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::ProcessMemoryDumpDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::ProcessMemoryDump_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::memory_instrumentation::mojom::ProcessType>(
      Traits::process_type(input),
      &fragment->process_type);

    decltype(Traits::os_dump(input)) in_os_dump = Traits::os_dump(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->os_dump)::BaseType> os_dump_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::memory_instrumentation::mojom::OSMemDumpDataView>(
      in_os_dump,
      os_dump_fragment);

    fragment->os_dump.Set(
        os_dump_fragment.is_null() ? nullptr : os_dump_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->os_dump.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null os_dump in ProcessMemoryDump struct");

    decltype(Traits::chrome_allocator_dumps(input)) in_chrome_allocator_dumps = Traits::chrome_allocator_dumps(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->chrome_allocator_dumps)::BaseType>
        chrome_allocator_dumps_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& chrome_allocator_dumps_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::memory_instrumentation::mojom::AllocatorMemDumpDataView>>(
      in_chrome_allocator_dumps,
      chrome_allocator_dumps_fragment,
      &chrome_allocator_dumps_validate_params);

    fragment->chrome_allocator_dumps.Set(
        chrome_allocator_dumps_fragment.is_null() ? nullptr : chrome_allocator_dumps_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->chrome_allocator_dumps.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null chrome_allocator_dumps in ProcessMemoryDump struct");

    decltype(Traits::pid(input)) in_pid = Traits::pid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pid)::BaseType> pid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
      in_pid,
      pid_fragment);

    fragment->pid.Set(
        pid_fragment.is_null() ? nullptr : pid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pid in ProcessMemoryDump struct");

    decltype(Traits::service_name(input)) in_service_name = Traits::service_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_name)::BaseType> service_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_service_name,
      service_name_fragment);

    fragment->service_name.Set(
        service_name_fragment.is_null() ? nullptr : service_name_fragment.data());
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::ProcessMemoryDump_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::ProcessMemoryDumpDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::AggregatedMetricsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::AggregatedMetricsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::AggregatedMetrics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->native_library_resident_kb = Traits::native_library_resident_kb(input);

    fragment->native_library_resident_not_ordered_kb = Traits::native_library_resident_not_ordered_kb(input);

    fragment->native_library_not_resident_ordered_kb = Traits::native_library_not_resident_ordered_kb(input);
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::AggregatedMetrics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::AggregatedMetricsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::GlobalMemoryDumpDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::GlobalMemoryDumpDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::GlobalMemoryDump_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::start_time(input)) in_start_time = Traits::start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start_time)::BaseType> start_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_start_time,
      start_time_fragment);

    fragment->start_time.Set(
        start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->start_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_time in GlobalMemoryDump struct");

    decltype(Traits::process_dumps(input)) in_process_dumps = Traits::process_dumps(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->process_dumps)::BaseType>
        process_dumps_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& process_dumps_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::memory_instrumentation::mojom::ProcessMemoryDumpDataView>>(
      in_process_dumps,
      process_dumps_fragment,
      &process_dumps_validate_params);

    fragment->process_dumps.Set(
        process_dumps_fragment.is_null() ? nullptr : process_dumps_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->process_dumps.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null process_dumps in GlobalMemoryDump struct");

    decltype(Traits::aggregated_metrics(input)) in_aggregated_metrics = Traits::aggregated_metrics(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aggregated_metrics)::BaseType> aggregated_metrics_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::memory_instrumentation::mojom::AggregatedMetricsDataView>(
      in_aggregated_metrics,
      aggregated_metrics_fragment);

    fragment->aggregated_metrics.Set(
        aggregated_metrics_fragment.is_null() ? nullptr : aggregated_metrics_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->aggregated_metrics.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null aggregated_metrics in GlobalMemoryDump struct");
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::GlobalMemoryDump_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::GlobalMemoryDumpDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::HeapProfileResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::memory_instrumentation::mojom::HeapProfileResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::memory_instrumentation::mojom::internal::HeapProfileResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::pid(input)) in_pid = Traits::pid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pid)::BaseType> pid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
      in_pid,
      pid_fragment);

    fragment->pid.Set(
        pid_fragment.is_null() ? nullptr : pid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pid in HeapProfileResult struct");

    decltype(Traits::json(input)) in_json = Traits::json(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->json)::BaseType> json_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::BigStringDataView>(
      in_json,
      json_fragment);

    fragment->json.Set(
        json_fragment.is_null() ? nullptr : json_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->json.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null json in HeapProfileResult struct");
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::HeapProfileResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::HeapProfileResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::memory_instrumentation::mojom::RawAllocatorDumpEntryValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::memory_instrumentation::mojom::RawAllocatorDumpEntryValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::memory_instrumentation::mojom::internal::RawAllocatorDumpEntryValue_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::memory_instrumentation::mojom::RawAllocatorDumpEntryValueDataView::Tag::kValueUint64: {
    decltype(Traits::value_uint64(input))
    in_value_uint64 = Traits::value_uint64(input);
    fragment->data.f_value_uint64 = in_value_uint64;
    break;
  }
  case ::memory_instrumentation::mojom::RawAllocatorDumpEntryValueDataView::Tag::kValueString: {
    decltype(Traits::value_string(input))
    in_value_string = Traits::value_string(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_value_string)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_value_string,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null value_string in RawAllocatorDumpEntryValue union");
    fragment->data.f_value_string.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::memory_instrumentation::mojom::internal::RawAllocatorDumpEntryValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::memory_instrumentation::mojom::RawAllocatorDumpEntryValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace memory_instrumentation::mojom {





inline void RawAllocatorDumpEntryDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RawAllocatorDumpEntryDataView::GetUnitsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->units.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RawAllocatorDumpEntryDataView::GetValueDataView(
    RawAllocatorDumpEntryValueDataView* output) {
  auto pointer = &data_->value;
  *output = RawAllocatorDumpEntryValueDataView(pointer, message_);
}


inline void RawAllocatorDumpDataView::GetAbsoluteNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->absolute_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RawAllocatorDumpDataView::GetEntriesDataView(
    mojo::ArrayDataView<RawAllocatorDumpEntryDataView>* output) {
  auto pointer = data_->entries.Get();
  *output = mojo::ArrayDataView<RawAllocatorDumpEntryDataView>(pointer, message_);
}


inline void RawProcessMemoryDumpDataView::GetAllocatorDumpEdgesDataView(
    mojo::ArrayDataView<RawAllocatorDumpEdgeDataView>* output) {
  auto pointer = data_->allocator_dump_edges.Get();
  *output = mojo::ArrayDataView<RawAllocatorDumpEdgeDataView>(pointer, message_);
}
inline void RawProcessMemoryDumpDataView::GetAllocatorDumpsDataView(
    mojo::ArrayDataView<RawAllocatorDumpDataView>* output) {
  auto pointer = data_->allocator_dumps.Get();
  *output = mojo::ArrayDataView<RawAllocatorDumpDataView>(pointer, message_);
}


inline void VmRegionDataView::GetModuleDebugidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->module_debugid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VmRegionDataView::GetModuleDebugPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->module_debug_path.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VmRegionDataView::GetMappedFileDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mapped_file.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void RawOSMemDumpDataView::GetPlatformPrivateFootprintDataView(
    PlatformPrivateFootprintDataView* output) {
  auto pointer = data_->platform_private_footprint.Get();
  *output = PlatformPrivateFootprintDataView(pointer, message_);
}
inline void RawOSMemDumpDataView::GetMemoryMapsDataView(
    mojo::ArrayDataView<VmRegionDataView>* output) {
  auto pointer = data_->memory_maps.Get();
  *output = mojo::ArrayDataView<VmRegionDataView>(pointer, message_);
}
inline void RawOSMemDumpDataView::GetNativeLibraryPagesBitmapDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->native_library_pages_bitmap.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}




inline void AllocatorMemDumpDataView::GetNumericEntriesDataView(
    mojo::MapDataView<mojo::StringDataView, uint64_t>* output) {
  auto pointer = data_->numeric_entries.Get();
  *output = mojo::MapDataView<mojo::StringDataView, uint64_t>(pointer, message_);
}
inline void AllocatorMemDumpDataView::GetChildrenDataView(
    mojo::MapDataView<mojo::StringDataView, AllocatorMemDumpDataView>* output) {
  auto pointer = data_->children.Get();
  *output = mojo::MapDataView<mojo::StringDataView, AllocatorMemDumpDataView>(pointer, message_);
}


inline void ProcessMemoryDumpDataView::GetOsDumpDataView(
    OSMemDumpDataView* output) {
  auto pointer = data_->os_dump.Get();
  *output = OSMemDumpDataView(pointer, message_);
}
inline void ProcessMemoryDumpDataView::GetChromeAllocatorDumpsDataView(
    mojo::MapDataView<mojo::StringDataView, AllocatorMemDumpDataView>* output) {
  auto pointer = data_->chrome_allocator_dumps.Get();
  *output = mojo::MapDataView<mojo::StringDataView, AllocatorMemDumpDataView>(pointer, message_);
}
inline void ProcessMemoryDumpDataView::GetPidDataView(
    ::mojo_base::mojom::ProcessIdDataView* output) {
  auto pointer = data_->pid.Get();
  *output = ::mojo_base::mojom::ProcessIdDataView(pointer, message_);
}
inline void ProcessMemoryDumpDataView::GetServiceNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->service_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void GlobalMemoryDumpDataView::GetStartTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->start_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void GlobalMemoryDumpDataView::GetProcessDumpsDataView(
    mojo::ArrayDataView<ProcessMemoryDumpDataView>* output) {
  auto pointer = data_->process_dumps.Get();
  *output = mojo::ArrayDataView<ProcessMemoryDumpDataView>(pointer, message_);
}
inline void GlobalMemoryDumpDataView::GetAggregatedMetricsDataView(
    AggregatedMetricsDataView* output) {
  auto pointer = data_->aggregated_metrics.Get();
  *output = AggregatedMetricsDataView(pointer, message_);
}


inline void HeapProfileResultDataView::GetPidDataView(
    ::mojo_base::mojom::ProcessIdDataView* output) {
  auto pointer = data_->pid.Get();
  *output = ::mojo_base::mojom::ProcessIdDataView(pointer, message_);
}
inline void HeapProfileResultDataView::GetJsonDataView(
    ::mojo_base::mojom::BigStringDataView* output) {
  auto pointer = data_->json.Get();
  *output = ::mojo_base::mojom::BigStringDataView(pointer, message_);
}


inline void RawAllocatorDumpEntryValueDataView::GetValueStringDataView(
    mojo::StringDataView* output) const {
  CHECK(is_value_string());
  *output = mojo::StringDataView(data_->data.f_value_string.Get(), message_);
}


}  // memory_instrumentation::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM_SHARED) TraceFormatTraits<::memory_instrumentation::mojom::DumpType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::memory_instrumentation::mojom::DumpType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM_SHARED) TraceFormatTraits<::memory_instrumentation::mojom::LevelOfDetail> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::memory_instrumentation::mojom::LevelOfDetail value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM_SHARED) TraceFormatTraits<::memory_instrumentation::mojom::Determinism> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::memory_instrumentation::mojom::Determinism value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM_SHARED) TraceFormatTraits<::memory_instrumentation::mojom::ProcessType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::memory_instrumentation::mojom::ProcessType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM_SHARED) TraceFormatTraits<::memory_instrumentation::mojom::MemoryMapOption> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::memory_instrumentation::mojom::MemoryMapOption value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM_SHARED) TraceFormatTraits<::memory_instrumentation::mojom::MemDumpFlags> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::memory_instrumentation::mojom::MemDumpFlags value);
};

} // namespace perfetto

#endif  // SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_MEMORY_INSTRUMENTATION_MEMORY_INSTRUMENTATION_MOJOM_SHARED_H_