// services/network/public/mojom/shared_dictionary_usage_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_USAGE_INFO_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_USAGE_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/shared_dictionary_usage_info.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/shared_dictionary_usage_info.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/shared_dictionary_usage_info.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/shared_dictionary_usage_info_mojom_traits.h"




namespace network::mojom {








class  SharedDictionaryUsageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedDictionaryUsageInfo, T>::value>;
  using DataView = SharedDictionaryUsageInfoDataView;
  using Data_ = internal::SharedDictionaryUsageInfo_Data;

  template <typename... Args>
  static SharedDictionaryUsageInfoPtr New(Args&&... args) {
    return SharedDictionaryUsageInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedDictionaryUsageInfoPtr From(const U& u) {
    return mojo::TypeConverter<SharedDictionaryUsageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedDictionaryUsageInfo>::Convert(*this);
  }


  SharedDictionaryUsageInfo();

  SharedDictionaryUsageInfo(
      const ::net::SharedDictionaryIsolationKey& isolation_key,
      uint64_t total_size_bytes);


  ~SharedDictionaryUsageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedDictionaryUsageInfoPtr>
  SharedDictionaryUsageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedDictionaryUsageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedDictionaryUsageInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedDictionaryUsageInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedDictionaryUsageInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedDictionaryUsageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedDictionaryUsageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedDictionaryUsageInfo_UnserializedMessageContext<
            UserType, SharedDictionaryUsageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedDictionaryUsageInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedDictionaryUsageInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedDictionaryUsageInfo_UnserializedMessageContext<
            UserType, SharedDictionaryUsageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedDictionaryUsageInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::SharedDictionaryIsolationKey isolation_key;
  
  uint64_t total_size_bytes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedDictionaryUsageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedDictionaryUsageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedDictionaryUsageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedDictionaryUsageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SharedDictionaryUsageInfoPtr SharedDictionaryUsageInfo::Clone() const {
  return New(
      mojo::Clone(isolation_key),
      mojo::Clone(total_size_bytes)
  );
}

template <typename T, SharedDictionaryUsageInfo::EnableIfSame<T>*>
bool SharedDictionaryUsageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->isolation_key, other_struct.isolation_key))
    return false;
  if (!mojo::Equals(this->total_size_bytes, other_struct.total_size_bytes))
    return false;
  return true;
}

template <typename T, SharedDictionaryUsageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.isolation_key < rhs.isolation_key)
    return true;
  if (rhs.isolation_key < lhs.isolation_key)
    return false;
  if (lhs.total_size_bytes < rhs.total_size_bytes)
    return true;
  if (rhs.total_size_bytes < lhs.total_size_bytes)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::SharedDictionaryUsageInfo::DataView,
                                         ::network::mojom::SharedDictionaryUsageInfoPtr> {
  static bool IsNull(const ::network::mojom::SharedDictionaryUsageInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SharedDictionaryUsageInfoPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SharedDictionaryUsageInfo::isolation_key)& isolation_key(
      const ::network::mojom::SharedDictionaryUsageInfoPtr& input) {
    return input->isolation_key;
  }

  static decltype(::network::mojom::SharedDictionaryUsageInfo::total_size_bytes) total_size_bytes(
      const ::network::mojom::SharedDictionaryUsageInfoPtr& input) {
    return input->total_size_bytes;
  }

  static bool Read(::network::mojom::SharedDictionaryUsageInfo::DataView input, ::network::mojom::SharedDictionaryUsageInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_USAGE_INFO_MOJOM_H_