// services/network/public/mojom/parsed_headers.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/parsed_headers.mojom-shared-internal.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared.h"
#include "services/network/public/mojom/integrity_policy.mojom-shared.h"
#include "services/network/public/mojom/document_isolation_policy.mojom-shared.h"
#include "services/network/public/mojom/link_header.mojom-shared.h"
#include "services/network/public/mojom/no_vary_search.mojom-shared.h"
#include "services/network/public/mojom/supports_loading_mode.mojom-shared.h"
#include "services/network/public/mojom/timing_allow_origin.mojom-shared.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-shared.h"
#include "services/network/public/mojom/x_frame_options.mojom-shared.h"


namespace network::mojom {
class ParsedHeadersDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ParsedHeadersDataView> {
  using Data = ::network::mojom::internal::ParsedHeaders_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class OriginAgentClusterValue : int32_t {
  
  kAbsent = 0,
  
  kTrue = 1,
  
  kFalse = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, OriginAgentClusterValue value);
inline bool IsKnownEnumValue(OriginAgentClusterValue value) {
  return internal::OriginAgentClusterValue_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ParsedHeadersDataView {
 public:
  ParsedHeadersDataView() = default;

  ParsedHeadersDataView(
      internal::ParsedHeaders_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContentSecurityPolicyDataView(
      mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSecurityPolicy(UserType* output) {
    
    auto* pointer = data_->content_security_policy.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
        pointer, output, message_);
  }
  inline void GetAllowCspFromDataView(
      ::network::mojom::AllowCSPFromHeaderValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowCspFrom(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::AllowCSPFromHeaderValueDataView, UserType>(),
    "Attempting to read the optional `allow_csp_from` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllowCspFrom` instead "
    "of `ReadAllowCspFrom if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->allow_csp_from.is_null() ? &data_->allow_csp_from : nullptr;
    return mojo::internal::Deserialize<::network::mojom::AllowCSPFromHeaderValueDataView>(
        pointer, output, message_);
  }
  inline void GetCrossOriginEmbedderPolicyDataView(
      ::network::mojom::CrossOriginEmbedderPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCrossOriginEmbedderPolicy(UserType* output) {
    
    auto* pointer = data_->cross_origin_embedder_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetCrossOriginOpenerPolicyDataView(
      ::network::mojom::CrossOriginOpenerPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCrossOriginOpenerPolicy(UserType* output) {
    
    auto* pointer = data_->cross_origin_opener_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::CrossOriginOpenerPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetDocumentIsolationPolicyDataView(
      ::network::mojom::DocumentIsolationPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentIsolationPolicy(UserType* output) {
    
    auto* pointer = data_->document_isolation_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::DocumentIsolationPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetIntegrityPolicyDataView(
      ::network::mojom::IntegrityPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntegrityPolicy(UserType* output) {
    
    auto* pointer = data_->integrity_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::IntegrityPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetIntegrityPolicyReportOnlyDataView(
      ::network::mojom::IntegrityPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntegrityPolicyReportOnly(UserType* output) {
    
    auto* pointer = data_->integrity_policy_report_only.Get();
    return mojo::internal::Deserialize<::network::mojom::IntegrityPolicyDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOriginAgentCluster(UserType* output) const {
    auto data_value = data_->origin_agent_cluster;
    return mojo::internal::Deserialize<::network::mojom::OriginAgentClusterValue>(
        data_value, output);
  }
  OriginAgentClusterValue origin_agent_cluster() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::OriginAgentClusterValue>(data_->origin_agent_cluster));
  }
  inline void GetAcceptChDataView(
      mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAcceptCh(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::network::mojom::WebClientHintsType>, UserType>(),
    "Attempting to read the optional `accept_ch` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAcceptCh` instead "
    "of `ReadAcceptCh if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->accept_ch.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
        pointer, output, message_);
  }
  inline void GetCriticalChDataView(
      mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCriticalCh(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::network::mojom::WebClientHintsType>, UserType>(),
    "Attempting to read the optional `critical_ch` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCriticalCh` instead "
    "of `ReadCriticalCh if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->critical_ch.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
        pointer, output, message_);
  }
  bool client_hints_ignored_due_to_clear_site_data_header() const {
    return data_->client_hints_ignored_due_to_clear_site_data_header;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadXfo(UserType* output) const {
    auto data_value = data_->xfo;
    return mojo::internal::Deserialize<::network::mojom::XFrameOptionsValue>(
        data_value, output);
  }
  ::network::mojom::XFrameOptionsValue xfo() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::XFrameOptionsValue>(data_->xfo));
  }
  inline void GetLinkHeadersDataView(
      mojo::ArrayDataView<::network::mojom::LinkHeaderDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinkHeaders(UserType* output) {
    
    auto* pointer = data_->link_headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::LinkHeaderDataView>>(
        pointer, output, message_);
  }
  inline void GetTimingAllowOriginDataView(
      ::network::mojom::TimingAllowOriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimingAllowOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TimingAllowOriginDataView, UserType>(),
    "Attempting to read the optional `timing_allow_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimingAllowOrigin` instead "
    "of `ReadTimingAllowOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->timing_allow_origin.is_null() ? &data_->timing_allow_origin : nullptr;
    return mojo::internal::Deserialize<::network::mojom::TimingAllowOriginDataView>(
        pointer, output, message_);
  }
  inline void GetSupportsLoadingModeDataView(
      mojo::ArrayDataView<::network::mojom::LoadingMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportsLoadingMode(UserType* output) {
    
    auto* pointer = data_->supports_loading_mode.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::LoadingMode>>(
        pointer, output, message_);
  }
  inline void GetReportingEndpointsDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingEndpoints(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `reporting_endpoints` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingEndpoints` instead "
    "of `ReadReportingEndpoints if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_endpoints.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetCookieIndicesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieIndices(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `cookie_indices` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieIndices` instead "
    "of `ReadCookieIndices if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_indices.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetAvailLanguageDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAvailLanguage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `avail_language` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAvailLanguage` instead "
    "of `ReadAvailLanguage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->avail_language.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetContentLanguageDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentLanguage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `content_language` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContentLanguage` instead "
    "of `ReadContentLanguage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->content_language.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetNoVarySearchWithParseErrorDataView(
      ::network::mojom::NoVarySearchWithParseErrorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNoVarySearchWithParseError(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::NoVarySearchWithParseErrorDataView, UserType>(),
    "Attempting to read the optional `no_vary_search_with_parse_error` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNoVarySearchWithParseError` instead "
    "of `ReadNoVarySearchWithParseError if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->no_vary_search_with_parse_error.is_null() ? &data_->no_vary_search_with_parse_error : nullptr;
    return mojo::internal::Deserialize<::network::mojom::NoVarySearchWithParseErrorDataView>(
        pointer, output, message_);
  }
  bool observe_browsing_topics() const {
    return data_->observe_browsing_topics;
  }
  bool allow_cross_origin_event_reporting() const {
    return data_->allow_cross_origin_event_reporting;
  }
 private:
  internal::ParsedHeaders_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_DATA_VIEW_H_