// services/network/public/mojom/network_interface_change_listener.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_interface_change_listener.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_interface_change_listener.mojom-params-data.h"
#include "services/network/public/mojom/network_interface_change_listener.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_interface_change_listener.mojom-blink-import-headers.h"
#include "services/network/public/mojom/network_interface_change_listener.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
IfAddrMsg::IfAddrMsg()
    : ifa_family(),
      ifa_prefixlen(),
      ifa_flags(),
      ifa_scope(),
      ifa_index() {}

IfAddrMsg::IfAddrMsg(
    uint8_t ifa_family_in,
    uint8_t ifa_prefixlen_in,
    uint8_t ifa_flags_in,
    uint8_t ifa_scope_in,
    uint32_t ifa_index_in)
    : ifa_family(std::move(ifa_family_in)),
      ifa_prefixlen(std::move(ifa_prefixlen_in)),
      ifa_flags(std::move(ifa_flags_in)),
      ifa_scope(std::move(ifa_scope_in)),
      ifa_index(std::move(ifa_index_in)) {}

IfAddrMsg::~IfAddrMsg() = default;
size_t IfAddrMsg::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->ifa_family);
  seed = mojo::internal::WTFHash(seed, this->ifa_prefixlen);
  seed = mojo::internal::WTFHash(seed, this->ifa_flags);
  seed = mojo::internal::WTFHash(seed, this->ifa_scope);
  seed = mojo::internal::WTFHash(seed, this->ifa_index);
  return seed;
}

void IfAddrMsg::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ifa_family"), this->ifa_family,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ifa_prefixlen"), this->ifa_prefixlen,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ifa_flags"), this->ifa_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ifa_scope"), this->ifa_scope,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ifa_index"), this->ifa_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IfAddrMsg::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AddressMap::AddressMap()
    : address_map() {}

AddressMap::AddressMap(
    ::blink::HashMap<::net::IPAddress, IfAddrMsgPtr> address_map_in)
    : address_map(std::move(address_map_in)) {}

AddressMap::~AddressMap() = default;

void AddressMap::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "address_map"), this->address_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::HashMap<::net::IPAddress, IfAddrMsgPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AddressMap::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OnlineLinks::OnlineLinks()
    : online_links() {}

OnlineLinks::OnlineLinks(
    ::blink::Vector<int32_t> online_links_in)
    : online_links(std::move(online_links_in)) {}

OnlineLinks::~OnlineLinks() = default;

void OnlineLinks::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "online_links"), this->online_links,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OnlineLinks::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InitialAddressMap::InitialAddressMap()
    : address_map(),
      online_links() {}

InitialAddressMap::InitialAddressMap(
    AddressMapPtr address_map_in,
    OnlineLinksPtr online_links_in)
    : address_map(std::move(address_map_in)),
      online_links(std::move(online_links_in)) {}

InitialAddressMap::~InitialAddressMap() = default;

void InitialAddressMap::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "address_map"), this->address_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AddressMapPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "online_links"), this->online_links,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OnlineLinksPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InitialAddressMap::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkInterfaceChangeParams::NetworkInterfaceChangeParams()
    : address_map(),
      online_links() {}

NetworkInterfaceChangeParams::NetworkInterfaceChangeParams(
    ::blink::HashMap<::net::IPAddress, IfAddrMsgPtr> address_map_in,
    const ::blink::HashMap<int32_t, bool>& online_links_in)
    : address_map(std::move(address_map_in)),
      online_links(std::move(online_links_in)) {}

NetworkInterfaceChangeParams::~NetworkInterfaceChangeParams() = default;

void NetworkInterfaceChangeParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "address_map"), this->address_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::HashMap<::net::IPAddress, IfAddrMsgPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "online_links"), this->online_links,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<int32_t, bool>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NetworkInterfaceChangeParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

NetworkInterfaceChangeListener::IPCStableHashFunction NetworkInterfaceChangeListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkInterfaceChangeListener>(message.name())) {
    case messages::NetworkInterfaceChangeListener::kOnNetworkInterfacesChanged: {
      return &NetworkInterfaceChangeListener::OnNetworkInterfacesChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkInterfaceChangeListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkInterfaceChangeListener>(message.name())) {
      case messages::NetworkInterfaceChangeListener::kOnNetworkInterfacesChanged:
            return "Receive network::mojom::NetworkInterfaceChangeListener::OnNetworkInterfacesChanged";
    }
  } else {
    switch (static_cast<messages::NetworkInterfaceChangeListener>(message.name())) {
      case messages::NetworkInterfaceChangeListener::kOnNetworkInterfacesChanged:
            return "Receive reply network::mojom::NetworkInterfaceChangeListener::OnNetworkInterfacesChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkInterfaceChangeListener::OnNetworkInterfacesChanged_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe95ee213;  // IPCStableHash for network::mojom::NetworkInterfaceChangeListener::OnNetworkInterfacesChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NetworkInterfaceChangeListenerProxy::NetworkInterfaceChangeListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkInterfaceChangeListenerProxy::OnNetworkInterfacesChanged(
    NetworkInterfaceChangeParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkInterfaceChangeListener::OnNetworkInterfacesChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type NetworkInterfaceChangeParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkInterfaceChangeListener::kOnNetworkInterfacesChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::NetworkInterfaceChangeParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in NetworkInterfaceChangeListener.OnNetworkInterfacesChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkInterfaceChangeListener::Name_);
  message.set_method_name("OnNetworkInterfacesChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NetworkInterfaceChangeListenerStubDispatch::Accept(
    NetworkInterfaceChangeListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkInterfaceChangeListener>(message->header()->name)) {
    case messages::NetworkInterfaceChangeListener::kOnNetworkInterfacesChanged: {
      DCHECK(message->is_serialized());
      internal::NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_Params_Data* params =
          reinterpret_cast<internal::NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkInterfaceChangeListener.0
      bool success = true;
      NetworkInterfaceChangeParamsPtr p_params{};
      NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkInterfaceChangeListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkInterfacesChanged(        
        std::move(p_params));
      return true;
    }
  }
  return false;
}

// static
bool NetworkInterfaceChangeListenerStubDispatch::AcceptWithResponder(
    NetworkInterfaceChangeListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkInterfaceChangeListener>(message->header()->name)) {
    case messages::NetworkInterfaceChangeListener::kOnNetworkInterfacesChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkInterfaceChangeListenerValidationInfo[] = {
    {base::to_underlying(messages::NetworkInterfaceChangeListener::kOnNetworkInterfacesChanged),
     { &internal::NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetworkInterfaceChangeListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::blink::NetworkInterfaceChangeListener::Name_,
    kNetworkInterfaceChangeListenerValidationInfo);
}



}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::IfAddrMsg::DataView, ::network::mojom::blink::IfAddrMsgPtr>::Read(
    ::network::mojom::blink::IfAddrMsg::DataView input,
    ::network::mojom::blink::IfAddrMsgPtr* output) {
  bool success = true;
  ::network::mojom::blink::IfAddrMsgPtr result(::network::mojom::blink::IfAddrMsg::New());
  
      if (success)
        result->ifa_family = input.ifa_family();
      if (success)
        result->ifa_prefixlen = input.ifa_prefixlen();
      if (success)
        result->ifa_flags = input.ifa_flags();
      if (success)
        result->ifa_scope = input.ifa_scope();
      if (success)
        result->ifa_index = input.ifa_index();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::AddressMap::DataView, ::network::mojom::blink::AddressMapPtr>::Read(
    ::network::mojom::blink::AddressMap::DataView input,
    ::network::mojom::blink::AddressMapPtr* output) {
  bool success = true;
  ::network::mojom::blink::AddressMapPtr result(::network::mojom::blink::AddressMap::New());
  
      if (success && !input.ReadAddressMap(&result->address_map))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::OnlineLinks::DataView, ::network::mojom::blink::OnlineLinksPtr>::Read(
    ::network::mojom::blink::OnlineLinks::DataView input,
    ::network::mojom::blink::OnlineLinksPtr* output) {
  bool success = true;
  ::network::mojom::blink::OnlineLinksPtr result(::network::mojom::blink::OnlineLinks::New());
  
      if (success && !input.ReadOnlineLinks(&result->online_links))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::InitialAddressMap::DataView, ::network::mojom::blink::InitialAddressMapPtr>::Read(
    ::network::mojom::blink::InitialAddressMap::DataView input,
    ::network::mojom::blink::InitialAddressMapPtr* output) {
  bool success = true;
  ::network::mojom::blink::InitialAddressMapPtr result(::network::mojom::blink::InitialAddressMap::New());
  
      if (success && !input.ReadAddressMap(&result->address_map))
        success = false;
      if (success && !input.ReadOnlineLinks(&result->online_links))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::NetworkInterfaceChangeParams::DataView, ::network::mojom::blink::NetworkInterfaceChangeParamsPtr>::Read(
    ::network::mojom::blink::NetworkInterfaceChangeParams::DataView input,
    ::network::mojom::blink::NetworkInterfaceChangeParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::NetworkInterfaceChangeParamsPtr result(::network::mojom::blink::NetworkInterfaceChangeParams::New());
  
      if (success && !input.ReadAddressMap(&result->address_map))
        success = false;
      if (success && !input.ReadOnlineLinks(&result->online_links))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void NetworkInterfaceChangeListenerInterceptorForTesting::OnNetworkInterfacesChanged(NetworkInterfaceChangeParamsPtr params) {
  GetForwardingInterface()->OnNetworkInterfacesChanged(
    std::move(params)
    );
}
NetworkInterfaceChangeListenerAsyncWaiter::NetworkInterfaceChangeListenerAsyncWaiter(
    NetworkInterfaceChangeListener* proxy) : proxy_(proxy) {}

NetworkInterfaceChangeListenerAsyncWaiter::~NetworkInterfaceChangeListenerAsyncWaiter() = default;







}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif