// services/network/public/mojom/integrity_policy.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/integrity_policy.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/integrity_policy.mojom-params-data.h"
#include "services/network/public/mojom/integrity_policy.mojom-shared-message-ids.h"

#include "services/network/public/mojom/integrity_policy.mojom-import-headers.h"
#include "services/network/public/mojom/integrity_policy.mojom-test-utils.h"


namespace network::mojom {
IntegrityPolicy::IntegrityPolicy()
    : blocked_destinations(),
      sources(),
      endpoints(),
      parsing_errors() {}

IntegrityPolicy::IntegrityPolicy(
    std::vector<IntegrityPolicy::Destination> blocked_destinations_in,
    std::vector<IntegrityPolicy::Source> sources_in,
    std::vector<std::string> endpoints_in,
    std::vector<std::string> parsing_errors_in)
    : blocked_destinations(std::move(blocked_destinations_in)),
      sources(std::move(sources_in)),
      endpoints(std::move(endpoints_in)),
      parsing_errors(std::move(parsing_errors_in)) {}

IntegrityPolicy::~IntegrityPolicy() = default;

void IntegrityPolicy::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked_destinations"), this->blocked_destinations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<IntegrityPolicy::Destination>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sources"), this->sources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<IntegrityPolicy::Source>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "endpoints"), this->endpoints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parsing_errors"), this->parsing_errors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IntegrityPolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::IntegrityPolicy::DataView, ::network::mojom::IntegrityPolicyPtr>::Read(
    ::network::mojom::IntegrityPolicy::DataView input,
    ::network::mojom::IntegrityPolicyPtr* output) {
  bool success = true;
  ::network::mojom::IntegrityPolicyPtr result(::network::mojom::IntegrityPolicy::New());
  
      if (success && !input.ReadBlockedDestinations(&result->blocked_destinations))
        success = false;
      if (success && !input.ReadSources(&result->sources))
        success = false;
      if (success && !input.ReadEndpoints(&result->endpoints))
        success = false;
      if (success && !input.ReadParsingErrors(&result->parsing_errors))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif