// services/network/public/mojom/devtools_observer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/devtools_observer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/devtools_observer.mojom-params-data.h"
#include "services/network/public/mojom/devtools_observer.mojom-shared-message-ids.h"

#include "services/network/public/mojom/devtools_observer.mojom-import-headers.h"
#include "services/network/public/mojom/devtools_observer.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace network::mojom {
URLRequestDevToolsInfo::URLRequestDevToolsInfo()
    : method(),
      url(),
      priority(),
      referrer_policy(),
      trust_token_params(),
      has_user_gesture(),
      resource_type() {}

URLRequestDevToolsInfo::URLRequestDevToolsInfo(
    const std::string& method_in,
    const ::GURL& url_in,
    ::net::RequestPriority priority_in,
    ::net::ReferrerPolicy referrer_policy_in,
    ::network::mojom::TrustTokenParamsPtr trust_token_params_in,
    bool has_user_gesture_in,
    uint32_t resource_type_in)
    : method(std::move(method_in)),
      url(std::move(url_in)),
      priority(std::move(priority_in)),
      referrer_policy(std::move(referrer_policy_in)),
      trust_token_params(std::move(trust_token_params_in)),
      has_user_gesture(std::move(has_user_gesture_in)),
      resource_type(std::move(resource_type_in)) {}

URLRequestDevToolsInfo::~URLRequestDevToolsInfo() = default;

void URLRequestDevToolsInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::RequestPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer_policy"), this->referrer_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::ReferrerPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_params"), this->trust_token_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::TrustTokenParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_user_gesture"), this->has_user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_type"), this->resource_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLRequestDevToolsInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLResponseHeadDevToolsInfo::URLResponseHeadDevToolsInfo()
    : response_time(),
      headers(),
      mime_type(),
      charset(),
      load_timing(),
      cert_status(),
      encoded_data_length(),
      was_in_prefetch_cache(),
      was_fetched_via_service_worker(),
      cache_storage_cache_name(),
      alpn_negotiated_protocol(),
      alternate_protocol_usage(),
      was_fetched_via_spdy(),
      service_worker_response_source(),
      service_worker_router_info(),
      ssl_info(),
      remote_endpoint(),
      emitted_extra_info(),
      is_for_ip_protection() {}

URLResponseHeadDevToolsInfo::URLResponseHeadDevToolsInfo(
    ::base::Time response_time_in,
    const ::scoped_refptr<::net::HttpResponseHeaders>& headers_in,
    const std::string& mime_type_in,
    const std::string& charset_in,
    const ::net::LoadTimingInfo& load_timing_in,
    uint32_t cert_status_in,
    int64_t encoded_data_length_in,
    bool was_in_prefetch_cache_in,
    bool was_fetched_via_service_worker_in,
    const std::string& cache_storage_cache_name_in,
    const std::string& alpn_negotiated_protocol_in,
    ::net::AlternateProtocolUsage alternate_protocol_usage_in,
    bool was_fetched_via_spdy_in,
    ::network::mojom::FetchResponseSource service_worker_response_source_in,
    ::network::mojom::ServiceWorkerRouterInfoPtr service_worker_router_info_in,
    const std::optional<::net::SSLInfo>& ssl_info_in,
    const ::net::IPEndPoint& remote_endpoint_in,
    bool emitted_extra_info_in,
    bool is_for_ip_protection_in)
    : response_time(std::move(response_time_in)),
      headers(std::move(headers_in)),
      mime_type(std::move(mime_type_in)),
      charset(std::move(charset_in)),
      load_timing(std::move(load_timing_in)),
      cert_status(std::move(cert_status_in)),
      encoded_data_length(std::move(encoded_data_length_in)),
      was_in_prefetch_cache(std::move(was_in_prefetch_cache_in)),
      was_fetched_via_service_worker(std::move(was_fetched_via_service_worker_in)),
      cache_storage_cache_name(std::move(cache_storage_cache_name_in)),
      alpn_negotiated_protocol(std::move(alpn_negotiated_protocol_in)),
      alternate_protocol_usage(std::move(alternate_protocol_usage_in)),
      was_fetched_via_spdy(std::move(was_fetched_via_spdy_in)),
      service_worker_response_source(std::move(service_worker_response_source_in)),
      service_worker_router_info(std::move(service_worker_router_info_in)),
      ssl_info(std::move(ssl_info_in)),
      remote_endpoint(std::move(remote_endpoint_in)),
      emitted_extra_info(std::move(emitted_extra_info_in)),
      is_for_ip_protection(std::move(is_for_ip_protection_in)) {}

URLResponseHeadDevToolsInfo::~URLResponseHeadDevToolsInfo() = default;

void URLResponseHeadDevToolsInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_time"), this->response_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<::net::HttpResponseHeaders>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "charset"), this->charset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_timing"), this->load_timing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::LoadTimingInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cert_status"), this->cert_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_data_length"), this->encoded_data_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_in_prefetch_cache"), this->was_in_prefetch_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_fetched_via_service_worker"), this->was_fetched_via_service_worker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_storage_cache_name"), this->cache_storage_cache_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpn_negotiated_protocol"), this->alpn_negotiated_protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alternate_protocol_usage"), this->alternate_protocol_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::AlternateProtocolUsage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_fetched_via_spdy"), this->was_fetched_via_spdy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_response_source"), this->service_worker_response_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::FetchResponseSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_router_info"), this->service_worker_router_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::ServiceWorkerRouterInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ssl_info"), this->ssl_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::net::SSLInfo>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_endpoint"), this->remote_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPEndPoint&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "emitted_extra_info"), this->emitted_extra_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_for_ip_protection"), this->is_for_ip_protection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLResponseHeadDevToolsInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OtherPartitionInfo::OtherPartitionInfo()
    : site_has_cookie_in_other_partition() {}

OtherPartitionInfo::OtherPartitionInfo(
    bool site_has_cookie_in_other_partition_in)
    : site_has_cookie_in_other_partition(std::move(site_has_cookie_in_other_partition_in)) {}

OtherPartitionInfo::~OtherPartitionInfo() = default;
size_t OtherPartitionInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->site_has_cookie_in_other_partition);
  return seed;
}

void OtherPartitionInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_has_cookie_in_other_partition"), this->site_has_cookie_in_other_partition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OtherPartitionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

DevToolsObserver::IPCStableHashFunction DevToolsObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevToolsObserver>(message.name())) {
    case messages::DevToolsObserver::kOnRawRequest: {
      return &DevToolsObserver::OnRawRequest_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnRawResponse: {
      return &DevToolsObserver::OnRawResponse_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnEarlyHintsResponse: {
      return &DevToolsObserver::OnEarlyHintsResponse_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnPrivateNetworkRequest: {
      return &DevToolsObserver::OnPrivateNetworkRequest_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnCorsPreflightRequest: {
      return &DevToolsObserver::OnCorsPreflightRequest_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnCorsPreflightResponse: {
      return &DevToolsObserver::OnCorsPreflightResponse_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnCorsPreflightRequestCompleted: {
      return &DevToolsObserver::OnCorsPreflightRequestCompleted_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnTrustTokenOperationDone: {
      return &DevToolsObserver::OnTrustTokenOperationDone_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnCorsError: {
      return &DevToolsObserver::OnCorsError_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnOrbError: {
      return &DevToolsObserver::OnOrbError_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnSubresourceWebBundleMetadata: {
      return &DevToolsObserver::OnSubresourceWebBundleMetadata_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnSubresourceWebBundleMetadataError: {
      return &DevToolsObserver::OnSubresourceWebBundleMetadataError_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponse: {
      return &DevToolsObserver::OnSubresourceWebBundleInnerResponse_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponseError: {
      return &DevToolsObserver::OnSubresourceWebBundleInnerResponseError_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnSharedDictionaryError: {
      return &DevToolsObserver::OnSharedDictionaryError_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnSRIMessageSignatureIssue: {
      return &DevToolsObserver::OnSRIMessageSignatureIssue_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kOnUnencodedDigestError: {
      return &DevToolsObserver::OnUnencodedDigestError_Sym::IPCStableHash;
    }
    case messages::DevToolsObserver::kClone: {
      return &DevToolsObserver::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevToolsObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevToolsObserver>(message.name())) {
      case messages::DevToolsObserver::kOnRawRequest:
            return "Receive network::mojom::DevToolsObserver::OnRawRequest";
      case messages::DevToolsObserver::kOnRawResponse:
            return "Receive network::mojom::DevToolsObserver::OnRawResponse";
      case messages::DevToolsObserver::kOnEarlyHintsResponse:
            return "Receive network::mojom::DevToolsObserver::OnEarlyHintsResponse";
      case messages::DevToolsObserver::kOnPrivateNetworkRequest:
            return "Receive network::mojom::DevToolsObserver::OnPrivateNetworkRequest";
      case messages::DevToolsObserver::kOnCorsPreflightRequest:
            return "Receive network::mojom::DevToolsObserver::OnCorsPreflightRequest";
      case messages::DevToolsObserver::kOnCorsPreflightResponse:
            return "Receive network::mojom::DevToolsObserver::OnCorsPreflightResponse";
      case messages::DevToolsObserver::kOnCorsPreflightRequestCompleted:
            return "Receive network::mojom::DevToolsObserver::OnCorsPreflightRequestCompleted";
      case messages::DevToolsObserver::kOnTrustTokenOperationDone:
            return "Receive network::mojom::DevToolsObserver::OnTrustTokenOperationDone";
      case messages::DevToolsObserver::kOnCorsError:
            return "Receive network::mojom::DevToolsObserver::OnCorsError";
      case messages::DevToolsObserver::kOnOrbError:
            return "Receive network::mojom::DevToolsObserver::OnOrbError";
      case messages::DevToolsObserver::kOnSubresourceWebBundleMetadata:
            return "Receive network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadata";
      case messages::DevToolsObserver::kOnSubresourceWebBundleMetadataError:
            return "Receive network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadataError";
      case messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponse:
            return "Receive network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponse";
      case messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponseError:
            return "Receive network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponseError";
      case messages::DevToolsObserver::kOnSharedDictionaryError:
            return "Receive network::mojom::DevToolsObserver::OnSharedDictionaryError";
      case messages::DevToolsObserver::kOnSRIMessageSignatureIssue:
            return "Receive network::mojom::DevToolsObserver::OnSRIMessageSignatureIssue";
      case messages::DevToolsObserver::kOnUnencodedDigestError:
            return "Receive network::mojom::DevToolsObserver::OnUnencodedDigestError";
      case messages::DevToolsObserver::kClone:
            return "Receive network::mojom::DevToolsObserver::Clone";
    }
  } else {
    switch (static_cast<messages::DevToolsObserver>(message.name())) {
      case messages::DevToolsObserver::kOnRawRequest:
            return "Receive reply network::mojom::DevToolsObserver::OnRawRequest";
      case messages::DevToolsObserver::kOnRawResponse:
            return "Receive reply network::mojom::DevToolsObserver::OnRawResponse";
      case messages::DevToolsObserver::kOnEarlyHintsResponse:
            return "Receive reply network::mojom::DevToolsObserver::OnEarlyHintsResponse";
      case messages::DevToolsObserver::kOnPrivateNetworkRequest:
            return "Receive reply network::mojom::DevToolsObserver::OnPrivateNetworkRequest";
      case messages::DevToolsObserver::kOnCorsPreflightRequest:
            return "Receive reply network::mojom::DevToolsObserver::OnCorsPreflightRequest";
      case messages::DevToolsObserver::kOnCorsPreflightResponse:
            return "Receive reply network::mojom::DevToolsObserver::OnCorsPreflightResponse";
      case messages::DevToolsObserver::kOnCorsPreflightRequestCompleted:
            return "Receive reply network::mojom::DevToolsObserver::OnCorsPreflightRequestCompleted";
      case messages::DevToolsObserver::kOnTrustTokenOperationDone:
            return "Receive reply network::mojom::DevToolsObserver::OnTrustTokenOperationDone";
      case messages::DevToolsObserver::kOnCorsError:
            return "Receive reply network::mojom::DevToolsObserver::OnCorsError";
      case messages::DevToolsObserver::kOnOrbError:
            return "Receive reply network::mojom::DevToolsObserver::OnOrbError";
      case messages::DevToolsObserver::kOnSubresourceWebBundleMetadata:
            return "Receive reply network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadata";
      case messages::DevToolsObserver::kOnSubresourceWebBundleMetadataError:
            return "Receive reply network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadataError";
      case messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponse:
            return "Receive reply network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponse";
      case messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponseError:
            return "Receive reply network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponseError";
      case messages::DevToolsObserver::kOnSharedDictionaryError:
            return "Receive reply network::mojom::DevToolsObserver::OnSharedDictionaryError";
      case messages::DevToolsObserver::kOnSRIMessageSignatureIssue:
            return "Receive reply network::mojom::DevToolsObserver::OnSRIMessageSignatureIssue";
      case messages::DevToolsObserver::kOnUnencodedDigestError:
            return "Receive reply network::mojom::DevToolsObserver::OnUnencodedDigestError";
      case messages::DevToolsObserver::kClone:
            return "Receive reply network::mojom::DevToolsObserver::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevToolsObserver::OnRawRequest_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8abd7be0;  // IPCStableHash for network::mojom::DevToolsObserver::OnRawRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnRawResponse_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcbc268fe;  // IPCStableHash for network::mojom::DevToolsObserver::OnRawResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnEarlyHintsResponse_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9138fde1;  // IPCStableHash for network::mojom::DevToolsObserver::OnEarlyHintsResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnPrivateNetworkRequest_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe8ab405;  // IPCStableHash for network::mojom::DevToolsObserver::OnPrivateNetworkRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnCorsPreflightRequest_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15fdb55e;  // IPCStableHash for network::mojom::DevToolsObserver::OnCorsPreflightRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnCorsPreflightResponse_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc1105e8c;  // IPCStableHash for network::mojom::DevToolsObserver::OnCorsPreflightResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnCorsPreflightRequestCompleted_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0fce9639;  // IPCStableHash for network::mojom::DevToolsObserver::OnCorsPreflightRequestCompleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnTrustTokenOperationDone_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb0aac5da;  // IPCStableHash for network::mojom::DevToolsObserver::OnTrustTokenOperationDone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnCorsError_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7aa0c485;  // IPCStableHash for network::mojom::DevToolsObserver::OnCorsError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnOrbError_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf37a0a28;  // IPCStableHash for network::mojom::DevToolsObserver::OnOrbError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnSubresourceWebBundleMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x726380a8;  // IPCStableHash for network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnSubresourceWebBundleMetadataError_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbbc19a0a;  // IPCStableHash for network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadataError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnSubresourceWebBundleInnerResponse_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x72192bd1;  // IPCStableHash for network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnSubresourceWebBundleInnerResponseError_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xae390a40;  // IPCStableHash for network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponseError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnSharedDictionaryError_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe00c1991;  // IPCStableHash for network::mojom::DevToolsObserver::OnSharedDictionaryError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnSRIMessageSignatureIssue_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x834e4122;  // IPCStableHash for network::mojom::DevToolsObserver::OnSRIMessageSignatureIssue
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::OnUnencodedDigestError_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe3fbd48c;  // IPCStableHash for network::mojom::DevToolsObserver::OnUnencodedDigestError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsObserver::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1e215fea;  // IPCStableHash for network::mojom::DevToolsObserver::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DevToolsObserverProxy::DevToolsObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevToolsObserverProxy::OnRawRequest(
    const std::string& in_devtool_request_id, const std::vector<::net::CookieWithAccessResult>& in_cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> in_headers, ::base::TimeTicks in_timestamp, ::network::mojom::ClientSecurityStatePtr in_client_security_state, OtherPartitionInfoPtr in_other_partition_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnRawRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies_with_access_result"), in_cookies_with_access_result,
                        "<value of type const std::vector<::net::CookieWithAccessResult>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type std::vector<::network::mojom::HttpRawHeaderPairPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timestamp"), in_timestamp,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_security_state"), in_client_security_state,
                        "<value of type ::network::mojom::ClientSecurityStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("other_partition_info"), in_other_partition_info,
                        "<value of type OtherPartitionInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnRawRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnRawRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtool_request_id in DevToolsObserver.OnRawRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookies_with_access_result)::BaseType>
      cookies_with_access_result_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& cookies_with_access_result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
    in_cookies_with_access_result,
    cookies_with_access_result_fragment,
    &cookies_with_access_result_validate_params);

  params->cookies_with_access_result.Set(
      cookies_with_access_result_fragment.is_null() ? nullptr : cookies_with_access_result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookies_with_access_result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookies_with_access_result in DevToolsObserver.OnRawRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType>
      headers_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
    in_headers,
    headers_fragment,
    &headers_validate_params);

  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null headers in DevToolsObserver.OnRawRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->timestamp)::BaseType> timestamp_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_timestamp,
    timestamp_fragment);

  params->timestamp.Set(
      timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timestamp.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timestamp in DevToolsObserver.OnRawRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->client_security_state)::BaseType> client_security_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClientSecurityStateDataView>(
    in_client_security_state,
    client_security_state_fragment);

  params->client_security_state.Set(
      client_security_state_fragment.is_null() ? nullptr : client_security_state_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->other_partition_info)::BaseType> other_partition_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::OtherPartitionInfoDataView>(
    in_other_partition_info,
    other_partition_info_fragment);

  params->other_partition_info.Set(
      other_partition_info_fragment.is_null() ? nullptr : other_partition_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnRawRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnRawResponse(
    const std::string& in_devtool_request_id, const std::vector<::net::CookieAndLineWithAccessResult>& in_cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> in_headers, const std::optional<std::string>& in_raw_response_headers, ::network::mojom::IPAddressSpace in_resource_address_space, int32_t in_http_status_code, const std::optional<::net::CookiePartitionKey>& in_cookie_partition_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnRawResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies_with_access_result"), in_cookies_with_access_result,
                        "<value of type const std::vector<::net::CookieAndLineWithAccessResult>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type std::vector<::network::mojom::HttpRawHeaderPairPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raw_response_headers"), in_raw_response_headers,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_address_space"), in_resource_address_space,
                        "<value of type ::network::mojom::IPAddressSpace>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_status_code"), in_http_status_code,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie_partition_key"), in_cookie_partition_key,
                        "<value of type const std::optional<::net::CookiePartitionKey>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnRawResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnRawResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtool_request_id in DevToolsObserver.OnRawResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookies_with_access_result)::BaseType>
      cookies_with_access_result_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& cookies_with_access_result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieAndLineWithAccessResultDataView>>(
    in_cookies_with_access_result,
    cookies_with_access_result_fragment,
    &cookies_with_access_result_validate_params);

  params->cookies_with_access_result.Set(
      cookies_with_access_result_fragment.is_null() ? nullptr : cookies_with_access_result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookies_with_access_result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookies_with_access_result in DevToolsObserver.OnRawResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType>
      headers_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
    in_headers,
    headers_fragment,
    &headers_validate_params);

  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null headers in DevToolsObserver.OnRawResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->raw_response_headers)::BaseType> raw_response_headers_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_raw_response_headers,
    raw_response_headers_fragment);

  params->raw_response_headers.Set(
      raw_response_headers_fragment.is_null() ? nullptr : raw_response_headers_fragment.data());

  
  mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
    in_resource_address_space,
    &params->resource_address_space);

  params->http_status_code = in_http_status_code;
  mojo::internal::MessageFragment<
      typename decltype(params->cookie_partition_key)::BaseType> cookie_partition_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookiePartitionKeyDataView>(
    in_cookie_partition_key,
    cookie_partition_key_fragment);

  params->cookie_partition_key.Set(
      cookie_partition_key_fragment.is_null() ? nullptr : cookie_partition_key_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnRawResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnEarlyHintsResponse(
    const std::string& in_devtool_request_id, std::vector<::network::mojom::HttpRawHeaderPairPtr> in_headers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnEarlyHintsResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type std::vector<::network::mojom::HttpRawHeaderPairPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnEarlyHintsResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnEarlyHintsResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtool_request_id in DevToolsObserver.OnEarlyHintsResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType>
      headers_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
    in_headers,
    headers_fragment,
    &headers_validate_params);

  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null headers in DevToolsObserver.OnEarlyHintsResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnEarlyHintsResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnPrivateNetworkRequest(
    const std::optional<std::string>& in_devtool_request_id, const ::GURL& in_url, bool in_is_warning, ::network::mojom::IPAddressSpace in_resource_address_space, ::network::mojom::ClientSecurityStatePtr in_client_security_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnPrivateNetworkRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_warning"), in_is_warning,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_address_space"), in_resource_address_space,
                        "<value of type ::network::mojom::IPAddressSpace>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_security_state"), in_client_security_state,
                        "<value of type ::network::mojom::ClientSecurityStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnPrivateNetworkRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnPrivateNetworkRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in DevToolsObserver.OnPrivateNetworkRequest request");

  params->is_warning = in_is_warning;

  
  mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
    in_resource_address_space,
    &params->resource_address_space);
  mojo::internal::MessageFragment<
      typename decltype(params->client_security_state)::BaseType> client_security_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClientSecurityStateDataView>(
    in_client_security_state,
    client_security_state_fragment);

  params->client_security_state.Set(
      client_security_state_fragment.is_null() ? nullptr : client_security_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_security_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_security_state in DevToolsObserver.OnPrivateNetworkRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnPrivateNetworkRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnCorsPreflightRequest(
    const ::base::UnguessableToken& in_devtool_request_id, const ::net::HttpRequestHeaders& in_request_headers, URLRequestDevToolsInfoPtr in_request_info, const ::GURL& in_initiator_url, const std::string& in_initiator_devtool_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnCorsPreflightRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_headers"), in_request_headers,
                        "<value of type const ::net::HttpRequestHeaders&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_info"), in_request_info,
                        "<value of type URLRequestDevToolsInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initiator_url"), in_initiator_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initiator_devtool_request_id"), in_initiator_devtool_request_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnCorsPreflightRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnCorsPreflightRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtool_request_id in DevToolsObserver.OnCorsPreflightRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_headers)::BaseType> request_headers_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
    in_request_headers,
    request_headers_fragment);

  params->request_headers.Set(
      request_headers_fragment.is_null() ? nullptr : request_headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_headers in DevToolsObserver.OnCorsPreflightRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_info)::BaseType> request_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLRequestDevToolsInfoDataView>(
    in_request_info,
    request_info_fragment);

  params->request_info.Set(
      request_info_fragment.is_null() ? nullptr : request_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_info in DevToolsObserver.OnCorsPreflightRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->initiator_url)::BaseType> initiator_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_initiator_url,
    initiator_url_fragment);

  params->initiator_url.Set(
      initiator_url_fragment.is_null() ? nullptr : initiator_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->initiator_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null initiator_url in DevToolsObserver.OnCorsPreflightRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->initiator_devtool_request_id)::BaseType> initiator_devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_initiator_devtool_request_id,
    initiator_devtool_request_id_fragment);

  params->initiator_devtool_request_id.Set(
      initiator_devtool_request_id_fragment.is_null() ? nullptr : initiator_devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->initiator_devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null initiator_devtool_request_id in DevToolsObserver.OnCorsPreflightRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnCorsPreflightRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnCorsPreflightResponse(
    const ::base::UnguessableToken& in_devtool_request_id, const ::GURL& in_url, URLResponseHeadDevToolsInfoPtr in_head) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnCorsPreflightResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head"), in_head,
                        "<value of type URLResponseHeadDevToolsInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnCorsPreflightResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnCorsPreflightResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtool_request_id in DevToolsObserver.OnCorsPreflightResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in DevToolsObserver.OnCorsPreflightResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->head)::BaseType> head_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDevToolsInfoDataView>(
    in_head,
    head_fragment);

  params->head.Set(
      head_fragment.is_null() ? nullptr : head_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->head.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null head in DevToolsObserver.OnCorsPreflightResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnCorsPreflightResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnCorsPreflightRequestCompleted(
    const ::base::UnguessableToken& in_devtool_request_id, const ::network::URLLoaderCompletionStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnCorsPreflightRequestCompleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::network::URLLoaderCompletionStatus&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnCorsPreflightRequestCompleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtool_request_id in DevToolsObserver.OnCorsPreflightRequestCompleted request");
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLLoaderCompletionStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in DevToolsObserver.OnCorsPreflightRequestCompleted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnCorsPreflightRequestCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnTrustTokenOperationDone(
    const std::string& in_devtool_request_id, ::network::mojom::TrustTokenOperationResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnTrustTokenOperationDone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::network::mojom::TrustTokenOperationResultPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnTrustTokenOperationDone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnTrustTokenOperationDone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtool_request_id in DevToolsObserver.OnTrustTokenOperationDone request");
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::TrustTokenOperationResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in DevToolsObserver.OnTrustTokenOperationDone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnTrustTokenOperationDone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnCorsError(
    const std::optional<std::string>& in_devtool_request_id, const std::optional<::url::Origin>& in_initiator_origin, ::network::mojom::ClientSecurityStatePtr in_client_security_state, const ::GURL& in_url, const ::network::CorsErrorStatus& in_status, bool in_is_warning) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnCorsError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initiator_origin"), in_initiator_origin,
                        "<value of type const std::optional<::url::Origin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_security_state"), in_client_security_state,
                        "<value of type ::network::mojom::ClientSecurityStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::network::CorsErrorStatus&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_warning"), in_is_warning,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnCorsError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnCorsError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->initiator_origin)::BaseType> initiator_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_initiator_origin,
    initiator_origin_fragment);

  params->initiator_origin.Set(
      initiator_origin_fragment.is_null() ? nullptr : initiator_origin_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->client_security_state)::BaseType> client_security_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClientSecurityStateDataView>(
    in_client_security_state,
    client_security_state_fragment);

  params->client_security_state.Set(
      client_security_state_fragment.is_null() ? nullptr : client_security_state_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in DevToolsObserver.OnCorsError request");
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CorsErrorStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in DevToolsObserver.OnCorsError request");

  params->is_warning = in_is_warning;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnCorsError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnOrbError(
    const std::optional<std::string>& in_devtools_request_id, const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnOrbError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_request_id"), in_devtools_request_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnOrbError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnOrbError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_request_id)::BaseType> devtools_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_devtools_request_id,
    devtools_request_id_fragment);

  params->devtools_request_id.Set(
      devtools_request_id_fragment.is_null() ? nullptr : devtools_request_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in DevToolsObserver.OnOrbError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnOrbError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnSubresourceWebBundleMetadata(
    const std::string& in_devtool_request_id, const std::vector<::GURL>& in_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls"), in_urls,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnSubresourceWebBundleMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtool_request_id in DevToolsObserver.OnSubresourceWebBundleMetadata request");
  mojo::internal::MessageFragment<
      typename decltype(params->urls)::BaseType>
      urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_urls,
    urls_fragment,
    &urls_validate_params);

  params->urls.Set(
      urls_fragment.is_null() ? nullptr : urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null urls in DevToolsObserver.OnSubresourceWebBundleMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnSubresourceWebBundleMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnSubresourceWebBundleMetadataError(
    const std::string& in_devtool_request_id, const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadataError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnSubresourceWebBundleMetadataError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtool_request_id in DevToolsObserver.OnSubresourceWebBundleMetadataError request");
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in DevToolsObserver.OnSubresourceWebBundleMetadataError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnSubresourceWebBundleMetadataError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnSubresourceWebBundleInnerResponse(
    const std::string& in_inner_request_devtools_id, const ::GURL& in_url, const std::optional<std::string>& in_bundle_request_devtools_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("inner_request_devtools_id"), in_inner_request_devtools_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bundle_request_devtools_id"), in_bundle_request_devtools_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->inner_request_devtools_id)::BaseType> inner_request_devtools_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_inner_request_devtools_id,
    inner_request_devtools_id_fragment);

  params->inner_request_devtools_id.Set(
      inner_request_devtools_id_fragment.is_null() ? nullptr : inner_request_devtools_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->inner_request_devtools_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null inner_request_devtools_id in DevToolsObserver.OnSubresourceWebBundleInnerResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in DevToolsObserver.OnSubresourceWebBundleInnerResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->bundle_request_devtools_id)::BaseType> bundle_request_devtools_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_bundle_request_devtools_id,
    bundle_request_devtools_id_fragment);

  params->bundle_request_devtools_id.Set(
      bundle_request_devtools_id_fragment.is_null() ? nullptr : bundle_request_devtools_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnSubresourceWebBundleInnerResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnSubresourceWebBundleInnerResponseError(
    const std::string& in_inner_request_devtools_id, const ::GURL& in_url, const std::string& in_error_message, const std::optional<std::string>& in_bundle_request_devtools_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponseError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("inner_request_devtools_id"), in_inner_request_devtools_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bundle_request_devtools_id"), in_bundle_request_devtools_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponseError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->inner_request_devtools_id)::BaseType> inner_request_devtools_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_inner_request_devtools_id,
    inner_request_devtools_id_fragment);

  params->inner_request_devtools_id.Set(
      inner_request_devtools_id_fragment.is_null() ? nullptr : inner_request_devtools_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->inner_request_devtools_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null inner_request_devtools_id in DevToolsObserver.OnSubresourceWebBundleInnerResponseError request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in DevToolsObserver.OnSubresourceWebBundleInnerResponseError request");
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in DevToolsObserver.OnSubresourceWebBundleInnerResponseError request");
  mojo::internal::MessageFragment<
      typename decltype(params->bundle_request_devtools_id)::BaseType> bundle_request_devtools_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_bundle_request_devtools_id,
    bundle_request_devtools_id_fragment);

  params->bundle_request_devtools_id.Set(
      bundle_request_devtools_id_fragment.is_null() ? nullptr : bundle_request_devtools_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnSubresourceWebBundleInnerResponseError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnSharedDictionaryError(
    const std::string& in_devtool_request_id, const ::GURL& in_url, ::network::mojom::SharedDictionaryError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnSharedDictionaryError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::network::mojom::SharedDictionaryError>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnSharedDictionaryError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnSharedDictionaryError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtool_request_id in DevToolsObserver.OnSharedDictionaryError request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in DevToolsObserver.OnSharedDictionaryError request");

  
  mojo::internal::Serialize<::network::mojom::SharedDictionaryError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnSharedDictionaryError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnSRIMessageSignatureIssue(
    const std::string& in_devtool_request_id, const ::GURL& in_url, std::vector<::network::mojom::SRIMessageSignatureIssuePtr> in_issues) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnSRIMessageSignatureIssue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("issues"), in_issues,
                        "<value of type std::vector<::network::mojom::SRIMessageSignatureIssuePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnSRIMessageSignatureIssue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtool_request_id in DevToolsObserver.OnSRIMessageSignatureIssue request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in DevToolsObserver.OnSRIMessageSignatureIssue request");
  mojo::internal::MessageFragment<
      typename decltype(params->issues)::BaseType>
      issues_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& issues_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureIssueDataView>>(
    in_issues,
    issues_fragment,
    &issues_validate_params);

  params->issues.Set(
      issues_fragment.is_null() ? nullptr : issues_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->issues.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null issues in DevToolsObserver.OnSRIMessageSignatureIssue request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnSRIMessageSignatureIssue");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::OnUnencodedDigestError(
    const std::string& in_devtool_request_id, const ::GURL& in_url, ::network::mojom::UnencodedDigestIssue in_issue) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::OnUnencodedDigestError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("issue"), in_issue,
                        "<value of type ::network::mojom::UnencodedDigestIssue>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kOnUnencodedDigestError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnUnencodedDigestError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_devtool_request_id,
    devtool_request_id_fragment);

  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtool_request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtool_request_id in DevToolsObserver.OnUnencodedDigestError request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in DevToolsObserver.OnUnencodedDigestError request");

  
  mojo::internal::Serialize<::network::mojom::UnencodedDigestIssue>(
    in_issue,
    &params->issue);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnUnencodedDigestError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsObserverProxy::Clone(
    ::mojo::PendingReceiver<DevToolsObserver> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DevToolsObserver::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingReceiver<DevToolsObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsObserver::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::DevToolsObserverInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in DevToolsObserver.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DevToolsObserverStubDispatch::Accept(
    DevToolsObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevToolsObserver>(message->header()->name)) {
    case messages::DevToolsObserver::kOnRawRequest: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnRawRequest_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnRawRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.0
      bool success = true;
      std::string p_devtool_request_id{};
      std::vector<::net::CookieWithAccessResult> p_cookies_with_access_result{};
      std::vector<::network::mojom::HttpRawHeaderPairPtr> p_headers{};
      ::base::TimeTicks p_timestamp{};
      ::network::mojom::ClientSecurityStatePtr p_client_security_state{};
      OtherPartitionInfoPtr p_other_partition_info{};
      DevToolsObserver_OnRawRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadCookiesWithAccessResult(&p_cookies_with_access_result))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success && !input_data_view.ReadTimestamp(&p_timestamp))
        success = false;
      if (success && !input_data_view.ReadClientSecurityState(&p_client_security_state))
        success = false;
      if (success && !input_data_view.ReadOtherPartitionInfo(&p_other_partition_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRawRequest(        
        std::move(p_devtool_request_id), 
        std::move(p_cookies_with_access_result), 
        std::move(p_headers), 
        std::move(p_timestamp), 
        std::move(p_client_security_state), 
        std::move(p_other_partition_info));
      return true;
    }
    case messages::DevToolsObserver::kOnRawResponse: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnRawResponse_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnRawResponse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.1
      bool success = true;
      std::string p_devtool_request_id{};
      std::vector<::net::CookieAndLineWithAccessResult> p_cookies_with_access_result{};
      std::vector<::network::mojom::HttpRawHeaderPairPtr> p_headers{};
      std::optional<std::string> p_raw_response_headers{};
      ::network::mojom::IPAddressSpace p_resource_address_space{};
      int32_t p_http_status_code{};
      std::optional<::net::CookiePartitionKey> p_cookie_partition_key{};
      DevToolsObserver_OnRawResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadCookiesWithAccessResult(&p_cookies_with_access_result))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success && !input_data_view.ReadRawResponseHeaders(&p_raw_response_headers))
        success = false;
      if (success && !input_data_view.ReadResourceAddressSpace(&p_resource_address_space))
        success = false;
      if (success)
        p_http_status_code = input_data_view.http_status_code();
      if (success && !input_data_view.ReadCookiePartitionKey(&p_cookie_partition_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRawResponse(        
        std::move(p_devtool_request_id), 
        std::move(p_cookies_with_access_result), 
        std::move(p_headers), 
        std::move(p_raw_response_headers), 
        std::move(p_resource_address_space), 
        std::move(p_http_status_code), 
        std::move(p_cookie_partition_key));
      return true;
    }
    case messages::DevToolsObserver::kOnEarlyHintsResponse: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnEarlyHintsResponse_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnEarlyHintsResponse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.2
      bool success = true;
      std::string p_devtool_request_id{};
      std::vector<::network::mojom::HttpRawHeaderPairPtr> p_headers{};
      DevToolsObserver_OnEarlyHintsResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEarlyHintsResponse(        
        std::move(p_devtool_request_id), 
        std::move(p_headers));
      return true;
    }
    case messages::DevToolsObserver::kOnPrivateNetworkRequest: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnPrivateNetworkRequest_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnPrivateNetworkRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.3
      bool success = true;
      std::optional<std::string> p_devtool_request_id{};
      ::GURL p_url{};
      bool p_is_warning{};
      ::network::mojom::IPAddressSpace p_resource_address_space{};
      ::network::mojom::ClientSecurityStatePtr p_client_security_state{};
      DevToolsObserver_OnPrivateNetworkRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_is_warning = input_data_view.is_warning();
      if (success && !input_data_view.ReadResourceAddressSpace(&p_resource_address_space))
        success = false;
      if (success && !input_data_view.ReadClientSecurityState(&p_client_security_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPrivateNetworkRequest(        
        std::move(p_devtool_request_id), 
        std::move(p_url), 
        std::move(p_is_warning), 
        std::move(p_resource_address_space), 
        std::move(p_client_security_state));
      return true;
    }
    case messages::DevToolsObserver::kOnCorsPreflightRequest: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnCorsPreflightRequest_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnCorsPreflightRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.4
      bool success = true;
      ::base::UnguessableToken p_devtool_request_id{};
      ::net::HttpRequestHeaders p_request_headers{};
      URLRequestDevToolsInfoPtr p_request_info{};
      ::GURL p_initiator_url{};
      std::string p_initiator_devtool_request_id{};
      DevToolsObserver_OnCorsPreflightRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadRequestHeaders(&p_request_headers))
        success = false;
      if (success && !input_data_view.ReadRequestInfo(&p_request_info))
        success = false;
      if (success && !input_data_view.ReadInitiatorUrl(&p_initiator_url))
        success = false;
      if (success && !input_data_view.ReadInitiatorDevtoolRequestId(&p_initiator_devtool_request_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCorsPreflightRequest(        
        std::move(p_devtool_request_id), 
        std::move(p_request_headers), 
        std::move(p_request_info), 
        std::move(p_initiator_url), 
        std::move(p_initiator_devtool_request_id));
      return true;
    }
    case messages::DevToolsObserver::kOnCorsPreflightResponse: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnCorsPreflightResponse_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnCorsPreflightResponse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.5
      bool success = true;
      ::base::UnguessableToken p_devtool_request_id{};
      ::GURL p_url{};
      URLResponseHeadDevToolsInfoPtr p_head{};
      DevToolsObserver_OnCorsPreflightResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCorsPreflightResponse(        
        std::move(p_devtool_request_id), 
        std::move(p_url), 
        std::move(p_head));
      return true;
    }
    case messages::DevToolsObserver::kOnCorsPreflightRequestCompleted: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.6
      bool success = true;
      ::base::UnguessableToken p_devtool_request_id{};
      ::network::URLLoaderCompletionStatus p_status{};
      DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCorsPreflightRequestCompleted(        
        std::move(p_devtool_request_id), 
        std::move(p_status));
      return true;
    }
    case messages::DevToolsObserver::kOnTrustTokenOperationDone: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnTrustTokenOperationDone_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnTrustTokenOperationDone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.7
      bool success = true;
      std::string p_devtool_request_id{};
      ::network::mojom::TrustTokenOperationResultPtr p_result{};
      DevToolsObserver_OnTrustTokenOperationDone_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTrustTokenOperationDone(        
        std::move(p_devtool_request_id), 
        std::move(p_result));
      return true;
    }
    case messages::DevToolsObserver::kOnCorsError: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnCorsError_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnCorsError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.8
      bool success = true;
      std::optional<std::string> p_devtool_request_id{};
      std::optional<::url::Origin> p_initiator_origin{};
      ::network::mojom::ClientSecurityStatePtr p_client_security_state{};
      ::GURL p_url{};
      ::network::CorsErrorStatus p_status{mojo::internal::DefaultConstructTag()};
      bool p_is_warning{};
      DevToolsObserver_OnCorsError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadInitiatorOrigin(&p_initiator_origin))
        success = false;
      if (success && !input_data_view.ReadClientSecurityState(&p_client_security_state))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (success)
        p_is_warning = input_data_view.is_warning();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCorsError(        
        std::move(p_devtool_request_id), 
        std::move(p_initiator_origin), 
        std::move(p_client_security_state), 
        std::move(p_url), 
        std::move(p_status), 
        std::move(p_is_warning));
      return true;
    }
    case messages::DevToolsObserver::kOnOrbError: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnOrbError_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnOrbError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.9
      bool success = true;
      std::optional<std::string> p_devtools_request_id{};
      ::GURL p_url{};
      DevToolsObserver_OnOrbError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolsRequestId(&p_devtools_request_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnOrbError(        
        std::move(p_devtools_request_id), 
        std::move(p_url));
      return true;
    }
    case messages::DevToolsObserver::kOnSubresourceWebBundleMetadata: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.10
      bool success = true;
      std::string p_devtool_request_id{};
      std::vector<::GURL> p_urls{};
      DevToolsObserver_OnSubresourceWebBundleMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadUrls(&p_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubresourceWebBundleMetadata(        
        std::move(p_devtool_request_id), 
        std::move(p_urls));
      return true;
    }
    case messages::DevToolsObserver::kOnSubresourceWebBundleMetadataError: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.11
      bool success = true;
      std::string p_devtool_request_id{};
      std::string p_error_message{};
      DevToolsObserver_OnSubresourceWebBundleMetadataError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubresourceWebBundleMetadataError(        
        std::move(p_devtool_request_id), 
        std::move(p_error_message));
      return true;
    }
    case messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponse: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.12
      bool success = true;
      std::string p_inner_request_devtools_id{};
      ::GURL p_url{};
      std::optional<std::string> p_bundle_request_devtools_id{};
      DevToolsObserver_OnSubresourceWebBundleInnerResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInnerRequestDevtoolsId(&p_inner_request_devtools_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadBundleRequestDevtoolsId(&p_bundle_request_devtools_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubresourceWebBundleInnerResponse(        
        std::move(p_inner_request_devtools_id), 
        std::move(p_url), 
        std::move(p_bundle_request_devtools_id));
      return true;
    }
    case messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponseError: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.13
      bool success = true;
      std::string p_inner_request_devtools_id{};
      ::GURL p_url{};
      std::string p_error_message{};
      std::optional<std::string> p_bundle_request_devtools_id{};
      DevToolsObserver_OnSubresourceWebBundleInnerResponseError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInnerRequestDevtoolsId(&p_inner_request_devtools_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (success && !input_data_view.ReadBundleRequestDevtoolsId(&p_bundle_request_devtools_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubresourceWebBundleInnerResponseError(        
        std::move(p_inner_request_devtools_id), 
        std::move(p_url), 
        std::move(p_error_message), 
        std::move(p_bundle_request_devtools_id));
      return true;
    }
    case messages::DevToolsObserver::kOnSharedDictionaryError: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnSharedDictionaryError_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnSharedDictionaryError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.14
      bool success = true;
      std::string p_devtool_request_id{};
      ::GURL p_url{};
      ::network::mojom::SharedDictionaryError p_error{};
      DevToolsObserver_OnSharedDictionaryError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSharedDictionaryError(        
        std::move(p_devtool_request_id), 
        std::move(p_url), 
        std::move(p_error));
      return true;
    }
    case messages::DevToolsObserver::kOnSRIMessageSignatureIssue: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.15
      bool success = true;
      std::string p_devtool_request_id{};
      ::GURL p_url{};
      std::vector<::network::mojom::SRIMessageSignatureIssuePtr> p_issues{};
      DevToolsObserver_OnSRIMessageSignatureIssue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadIssues(&p_issues))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSRIMessageSignatureIssue(        
        std::move(p_devtool_request_id), 
        std::move(p_url), 
        std::move(p_issues));
      return true;
    }
    case messages::DevToolsObserver::kOnUnencodedDigestError: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnUnencodedDigestError_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnUnencodedDigestError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.16
      bool success = true;
      std::string p_devtool_request_id{};
      ::GURL p_url{};
      ::network::mojom::UnencodedDigestIssue p_issue{};
      DevToolsObserver_OnUnencodedDigestError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadIssue(&p_issue))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUnencodedDigestError(        
        std::move(p_devtool_request_id), 
        std::move(p_url), 
        std::move(p_issue));
      return true;
    }
    case messages::DevToolsObserver::kClone: {
      DCHECK(message->is_serialized());
      internal::DevToolsObserver_Clone_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsObserver.17
      bool success = true;
      ::mojo::PendingReceiver<DevToolsObserver> p_listener{};
      DevToolsObserver_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_listener));
      return true;
    }
  }
  return false;
}

// static
bool DevToolsObserverStubDispatch::AcceptWithResponder(
    DevToolsObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevToolsObserver>(message->header()->name)) {
    case messages::DevToolsObserver::kOnRawRequest: {
      break;
    }
    case messages::DevToolsObserver::kOnRawResponse: {
      break;
    }
    case messages::DevToolsObserver::kOnEarlyHintsResponse: {
      break;
    }
    case messages::DevToolsObserver::kOnPrivateNetworkRequest: {
      break;
    }
    case messages::DevToolsObserver::kOnCorsPreflightRequest: {
      break;
    }
    case messages::DevToolsObserver::kOnCorsPreflightResponse: {
      break;
    }
    case messages::DevToolsObserver::kOnCorsPreflightRequestCompleted: {
      break;
    }
    case messages::DevToolsObserver::kOnTrustTokenOperationDone: {
      break;
    }
    case messages::DevToolsObserver::kOnCorsError: {
      break;
    }
    case messages::DevToolsObserver::kOnOrbError: {
      break;
    }
    case messages::DevToolsObserver::kOnSubresourceWebBundleMetadata: {
      break;
    }
    case messages::DevToolsObserver::kOnSubresourceWebBundleMetadataError: {
      break;
    }
    case messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponse: {
      break;
    }
    case messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponseError: {
      break;
    }
    case messages::DevToolsObserver::kOnSharedDictionaryError: {
      break;
    }
    case messages::DevToolsObserver::kOnSRIMessageSignatureIssue: {
      break;
    }
    case messages::DevToolsObserver::kOnUnencodedDigestError: {
      break;
    }
    case messages::DevToolsObserver::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDevToolsObserverValidationInfo[] = {
    {base::to_underlying(messages::DevToolsObserver::kOnRawRequest),
     { &internal::DevToolsObserver_OnRawRequest_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnRawResponse),
     { &internal::DevToolsObserver_OnRawResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnEarlyHintsResponse),
     { &internal::DevToolsObserver_OnEarlyHintsResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnPrivateNetworkRequest),
     { &internal::DevToolsObserver_OnPrivateNetworkRequest_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnCorsPreflightRequest),
     { &internal::DevToolsObserver_OnCorsPreflightRequest_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnCorsPreflightResponse),
     { &internal::DevToolsObserver_OnCorsPreflightResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnCorsPreflightRequestCompleted),
     { &internal::DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnTrustTokenOperationDone),
     { &internal::DevToolsObserver_OnTrustTokenOperationDone_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnCorsError),
     { &internal::DevToolsObserver_OnCorsError_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnOrbError),
     { &internal::DevToolsObserver_OnOrbError_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnSubresourceWebBundleMetadata),
     { &internal::DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnSubresourceWebBundleMetadataError),
     { &internal::DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponse),
     { &internal::DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnSubresourceWebBundleInnerResponseError),
     { &internal::DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnSharedDictionaryError),
     { &internal::DevToolsObserver_OnSharedDictionaryError_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnSRIMessageSignatureIssue),
     { &internal::DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kOnUnencodedDigestError),
     { &internal::DevToolsObserver_OnUnencodedDigestError_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DevToolsObserver::kClone),
     { &internal::DevToolsObserver_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DevToolsObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::DevToolsObserver::Name_,
    kDevToolsObserverValidationInfo);
}



}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::URLRequestDevToolsInfo::DataView, ::network::mojom::URLRequestDevToolsInfoPtr>::Read(
    ::network::mojom::URLRequestDevToolsInfo::DataView input,
    ::network::mojom::URLRequestDevToolsInfoPtr* output) {
  bool success = true;
  ::network::mojom::URLRequestDevToolsInfoPtr result(::network::mojom::URLRequestDevToolsInfo::New());
  
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadPriority(&result->priority))
        success = false;
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
      if (success && !input.ReadTrustTokenParams(&result->trust_token_params))
        success = false;
      if (success)
        result->has_user_gesture = input.has_user_gesture();
      if (success)
        result->resource_type = input.resource_type();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::URLResponseHeadDevToolsInfo::DataView, ::network::mojom::URLResponseHeadDevToolsInfoPtr>::Read(
    ::network::mojom::URLResponseHeadDevToolsInfo::DataView input,
    ::network::mojom::URLResponseHeadDevToolsInfoPtr* output) {
  bool success = true;
  ::network::mojom::URLResponseHeadDevToolsInfoPtr result(::network::mojom::URLResponseHeadDevToolsInfo::New());
  
      if (success && !input.ReadResponseTime(&result->response_time))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadCharset(&result->charset))
        success = false;
      if (success && !input.ReadLoadTiming(&result->load_timing))
        success = false;
      if (success)
        result->cert_status = input.cert_status();
      if (success)
        result->encoded_data_length = input.encoded_data_length();
      if (success)
        result->was_in_prefetch_cache = input.was_in_prefetch_cache();
      if (success)
        result->was_fetched_via_service_worker = input.was_fetched_via_service_worker();
      if (success && !input.ReadCacheStorageCacheName(&result->cache_storage_cache_name))
        success = false;
      if (success && !input.ReadAlpnNegotiatedProtocol(&result->alpn_negotiated_protocol))
        success = false;
      if (success && !input.ReadAlternateProtocolUsage(&result->alternate_protocol_usage))
        success = false;
      if (success)
        result->was_fetched_via_spdy = input.was_fetched_via_spdy();
      if (success && !input.ReadServiceWorkerResponseSource(&result->service_worker_response_source))
        success = false;
      if (success && !input.ReadServiceWorkerRouterInfo(&result->service_worker_router_info))
        success = false;
      if (success && !input.ReadSslInfo(&result->ssl_info))
        success = false;
      if (success && !input.ReadRemoteEndpoint(&result->remote_endpoint))
        success = false;
      if (success)
        result->emitted_extra_info = input.emitted_extra_info();
      if (success)
        result->is_for_ip_protection = input.is_for_ip_protection();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::OtherPartitionInfo::DataView, ::network::mojom::OtherPartitionInfoPtr>::Read(
    ::network::mojom::OtherPartitionInfo::DataView input,
    ::network::mojom::OtherPartitionInfoPtr* output) {
  bool success = true;
  ::network::mojom::OtherPartitionInfoPtr result(::network::mojom::OtherPartitionInfo::New());
  
      if (success)
        result->site_has_cookie_in_other_partition = input.site_has_cookie_in_other_partition();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void DevToolsObserverInterceptorForTesting::OnRawRequest(const std::string& devtool_request_id, const std::vector<::net::CookieWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers, ::base::TimeTicks timestamp, ::network::mojom::ClientSecurityStatePtr client_security_state, OtherPartitionInfoPtr other_partition_info) {
  GetForwardingInterface()->OnRawRequest(
    std::move(devtool_request_id)
    , 
    std::move(cookies_with_access_result)
    , 
    std::move(headers)
    , 
    std::move(timestamp)
    , 
    std::move(client_security_state)
    , 
    std::move(other_partition_info)
    );
}
void DevToolsObserverInterceptorForTesting::OnRawResponse(const std::string& devtool_request_id, const std::vector<::net::CookieAndLineWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers, const std::optional<std::string>& raw_response_headers, ::network::mojom::IPAddressSpace resource_address_space, int32_t http_status_code, const std::optional<::net::CookiePartitionKey>& cookie_partition_key) {
  GetForwardingInterface()->OnRawResponse(
    std::move(devtool_request_id)
    , 
    std::move(cookies_with_access_result)
    , 
    std::move(headers)
    , 
    std::move(raw_response_headers)
    , 
    std::move(resource_address_space)
    , 
    std::move(http_status_code)
    , 
    std::move(cookie_partition_key)
    );
}
void DevToolsObserverInterceptorForTesting::OnEarlyHintsResponse(const std::string& devtool_request_id, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers) {
  GetForwardingInterface()->OnEarlyHintsResponse(
    std::move(devtool_request_id)
    , 
    std::move(headers)
    );
}
void DevToolsObserverInterceptorForTesting::OnPrivateNetworkRequest(const std::optional<std::string>& devtool_request_id, const ::GURL& url, bool is_warning, ::network::mojom::IPAddressSpace resource_address_space, ::network::mojom::ClientSecurityStatePtr client_security_state) {
  GetForwardingInterface()->OnPrivateNetworkRequest(
    std::move(devtool_request_id)
    , 
    std::move(url)
    , 
    std::move(is_warning)
    , 
    std::move(resource_address_space)
    , 
    std::move(client_security_state)
    );
}
void DevToolsObserverInterceptorForTesting::OnCorsPreflightRequest(const ::base::UnguessableToken& devtool_request_id, const ::net::HttpRequestHeaders& request_headers, URLRequestDevToolsInfoPtr request_info, const ::GURL& initiator_url, const std::string& initiator_devtool_request_id) {
  GetForwardingInterface()->OnCorsPreflightRequest(
    std::move(devtool_request_id)
    , 
    std::move(request_headers)
    , 
    std::move(request_info)
    , 
    std::move(initiator_url)
    , 
    std::move(initiator_devtool_request_id)
    );
}
void DevToolsObserverInterceptorForTesting::OnCorsPreflightResponse(const ::base::UnguessableToken& devtool_request_id, const ::GURL& url, URLResponseHeadDevToolsInfoPtr head) {
  GetForwardingInterface()->OnCorsPreflightResponse(
    std::move(devtool_request_id)
    , 
    std::move(url)
    , 
    std::move(head)
    );
}
void DevToolsObserverInterceptorForTesting::OnCorsPreflightRequestCompleted(const ::base::UnguessableToken& devtool_request_id, const ::network::URLLoaderCompletionStatus& status) {
  GetForwardingInterface()->OnCorsPreflightRequestCompleted(
    std::move(devtool_request_id)
    , 
    std::move(status)
    );
}
void DevToolsObserverInterceptorForTesting::OnTrustTokenOperationDone(const std::string& devtool_request_id, ::network::mojom::TrustTokenOperationResultPtr result) {
  GetForwardingInterface()->OnTrustTokenOperationDone(
    std::move(devtool_request_id)
    , 
    std::move(result)
    );
}
void DevToolsObserverInterceptorForTesting::OnCorsError(const std::optional<std::string>& devtool_request_id, const std::optional<::url::Origin>& initiator_origin, ::network::mojom::ClientSecurityStatePtr client_security_state, const ::GURL& url, const ::network::CorsErrorStatus& status, bool is_warning) {
  GetForwardingInterface()->OnCorsError(
    std::move(devtool_request_id)
    , 
    std::move(initiator_origin)
    , 
    std::move(client_security_state)
    , 
    std::move(url)
    , 
    std::move(status)
    , 
    std::move(is_warning)
    );
}
void DevToolsObserverInterceptorForTesting::OnOrbError(const std::optional<std::string>& devtools_request_id, const ::GURL& url) {
  GetForwardingInterface()->OnOrbError(
    std::move(devtools_request_id)
    , 
    std::move(url)
    );
}
void DevToolsObserverInterceptorForTesting::OnSubresourceWebBundleMetadata(const std::string& devtool_request_id, const std::vector<::GURL>& urls) {
  GetForwardingInterface()->OnSubresourceWebBundleMetadata(
    std::move(devtool_request_id)
    , 
    std::move(urls)
    );
}
void DevToolsObserverInterceptorForTesting::OnSubresourceWebBundleMetadataError(const std::string& devtool_request_id, const std::string& error_message) {
  GetForwardingInterface()->OnSubresourceWebBundleMetadataError(
    std::move(devtool_request_id)
    , 
    std::move(error_message)
    );
}
void DevToolsObserverInterceptorForTesting::OnSubresourceWebBundleInnerResponse(const std::string& inner_request_devtools_id, const ::GURL& url, const std::optional<std::string>& bundle_request_devtools_id) {
  GetForwardingInterface()->OnSubresourceWebBundleInnerResponse(
    std::move(inner_request_devtools_id)
    , 
    std::move(url)
    , 
    std::move(bundle_request_devtools_id)
    );
}
void DevToolsObserverInterceptorForTesting::OnSubresourceWebBundleInnerResponseError(const std::string& inner_request_devtools_id, const ::GURL& url, const std::string& error_message, const std::optional<std::string>& bundle_request_devtools_id) {
  GetForwardingInterface()->OnSubresourceWebBundleInnerResponseError(
    std::move(inner_request_devtools_id)
    , 
    std::move(url)
    , 
    std::move(error_message)
    , 
    std::move(bundle_request_devtools_id)
    );
}
void DevToolsObserverInterceptorForTesting::OnSharedDictionaryError(const std::string& devtool_request_id, const ::GURL& url, ::network::mojom::SharedDictionaryError error) {
  GetForwardingInterface()->OnSharedDictionaryError(
    std::move(devtool_request_id)
    , 
    std::move(url)
    , 
    std::move(error)
    );
}
void DevToolsObserverInterceptorForTesting::OnSRIMessageSignatureIssue(const std::string& devtool_request_id, const ::GURL& url, std::vector<::network::mojom::SRIMessageSignatureIssuePtr> issues) {
  GetForwardingInterface()->OnSRIMessageSignatureIssue(
    std::move(devtool_request_id)
    , 
    std::move(url)
    , 
    std::move(issues)
    );
}
void DevToolsObserverInterceptorForTesting::OnUnencodedDigestError(const std::string& devtool_request_id, const ::GURL& url, ::network::mojom::UnencodedDigestIssue issue) {
  GetForwardingInterface()->OnUnencodedDigestError(
    std::move(devtool_request_id)
    , 
    std::move(url)
    , 
    std::move(issue)
    );
}
void DevToolsObserverInterceptorForTesting::Clone(::mojo::PendingReceiver<DevToolsObserver> listener) {
  GetForwardingInterface()->Clone(
    std::move(listener)
    );
}
DevToolsObserverAsyncWaiter::DevToolsObserverAsyncWaiter(
    DevToolsObserver* proxy) : proxy_(proxy) {}

DevToolsObserverAsyncWaiter::~DevToolsObserverAsyncWaiter() = default;







}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif