// services/network/public/mojom/cross_origin_opener_policy.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/cross_origin_opener_policy.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::CoopAccessReportType>
    : public mojo::internal::EnumHashImpl<::network::mojom::CoopAccessReportType> {};

template <>
struct hash<::network::mojom::CrossOriginOpenerPolicyValue>
    : public mojo::internal::EnumHashImpl<::network::mojom::CrossOriginOpenerPolicyValue> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CoopAccessReportType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CoopAccessReportType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CoopAccessReportType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CrossOriginOpenerPolicyValue, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CrossOriginOpenerPolicyValue, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CrossOriginOpenerPolicyValue>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CrossOriginOpenerPolicyReporterParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CrossOriginOpenerPolicyReporterParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CrossOriginOpenerPolicyReporterParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::CoopAccessReportType>(
      Traits::report_type(input),
      &fragment->report_type);

    decltype(Traits::reporter(input)) in_reporter = Traits::reporter(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginOpenerPolicyReporterInterfaceBase>>(
      in_reporter,
      &fragment->reporter,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->reporter)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid reporter in CrossOriginOpenerPolicyReporterParams struct");

    fragment->endpoint_defined = Traits::endpoint_defined(input);

    decltype(Traits::reported_window_url(input)) in_reported_window_url = Traits::reported_window_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reported_window_url)::BaseType> reported_window_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_reported_window_url,
      reported_window_url_fragment);

    fragment->reported_window_url.Set(
        reported_window_url_fragment.is_null() ? nullptr : reported_window_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->reported_window_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reported_window_url in CrossOriginOpenerPolicyReporterParams struct");
  }

  static bool Deserialize(::network::mojom::internal::CrossOriginOpenerPolicyReporterParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CrossOriginOpenerPolicyReporterParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CrossOriginOpenerPolicyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CrossOriginOpenerPolicyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CrossOriginOpenerPolicy_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::CrossOriginOpenerPolicyValue>(
      Traits::value(input),
      &fragment->value);

    decltype(Traits::reporting_endpoint(input)) in_reporting_endpoint = Traits::reporting_endpoint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reporting_endpoint)::BaseType> reporting_endpoint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_reporting_endpoint,
      reporting_endpoint_fragment);

    fragment->reporting_endpoint.Set(
        reporting_endpoint_fragment.is_null() ? nullptr : reporting_endpoint_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::CrossOriginOpenerPolicyValue>(
      Traits::report_only_value(input),
      &fragment->report_only_value);

    decltype(Traits::report_only_reporting_endpoint(input)) in_report_only_reporting_endpoint = Traits::report_only_reporting_endpoint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->report_only_reporting_endpoint)::BaseType> report_only_reporting_endpoint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_report_only_reporting_endpoint,
      report_only_reporting_endpoint_fragment);

    fragment->report_only_reporting_endpoint.Set(
        report_only_reporting_endpoint_fragment.is_null() ? nullptr : report_only_reporting_endpoint_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::CrossOriginOpenerPolicyValue>(
      Traits::soap_by_default_value(input),
      &fragment->soap_by_default_value);
  }

  static bool Deserialize(::network::mojom::internal::CrossOriginOpenerPolicy_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CrossOriginOpenerPolicyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void CrossOriginOpenerPolicyReporterParamsDataView::GetReportedWindowUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reported_window_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CrossOriginOpenerPolicyDataView::GetReportingEndpointDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reporting_endpoint.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CrossOriginOpenerPolicyDataView::GetReportOnlyReportingEndpointDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->report_only_reporting_endpoint.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CoopAccessReportType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CoopAccessReportType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CrossOriginOpenerPolicyValue> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CrossOriginOpenerPolicyValue value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_SHARED_H_