// services/network/public/mojom/cors.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cors.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cors.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* CorsPreflightPolicyToStringHelper(CorsPreflightPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CorsPreflightPolicy::kConsiderPreflight:
      return "kConsiderPreflight";
    case CorsPreflightPolicy::kPreventPreflight:
      return "kPreventPreflight";
    default:
      return nullptr;
  }
}

std::string CorsPreflightPolicyToString(CorsPreflightPolicy value) {
  const char *str = CorsPreflightPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CorsPreflightPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CorsPreflightPolicy value) {
  return os << CorsPreflightPolicyToString(value);
}

NOINLINE static const char* CorsErrorToStringHelper(CorsError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CorsError::kDisallowedByMode:
      return "kDisallowedByMode";
    case CorsError::kInvalidResponse:
      return "kInvalidResponse";
    case CorsError::kWildcardOriginNotAllowed:
      return "kWildcardOriginNotAllowed";
    case CorsError::kMissingAllowOriginHeader:
      return "kMissingAllowOriginHeader";
    case CorsError::kMultipleAllowOriginValues:
      return "kMultipleAllowOriginValues";
    case CorsError::kInvalidAllowOriginValue:
      return "kInvalidAllowOriginValue";
    case CorsError::kAllowOriginMismatch:
      return "kAllowOriginMismatch";
    case CorsError::kInvalidAllowCredentials:
      return "kInvalidAllowCredentials";
    case CorsError::kCorsDisabledScheme:
      return "kCorsDisabledScheme";
    case CorsError::kPreflightInvalidStatus:
      return "kPreflightInvalidStatus";
    case CorsError::kPreflightDisallowedRedirect:
      return "kPreflightDisallowedRedirect";
    case CorsError::kPreflightWildcardOriginNotAllowed:
      return "kPreflightWildcardOriginNotAllowed";
    case CorsError::kPreflightMissingAllowOriginHeader:
      return "kPreflightMissingAllowOriginHeader";
    case CorsError::kPreflightMultipleAllowOriginValues:
      return "kPreflightMultipleAllowOriginValues";
    case CorsError::kPreflightInvalidAllowOriginValue:
      return "kPreflightInvalidAllowOriginValue";
    case CorsError::kPreflightAllowOriginMismatch:
      return "kPreflightAllowOriginMismatch";
    case CorsError::kPreflightInvalidAllowCredentials:
      return "kPreflightInvalidAllowCredentials";
    case CorsError::kPreflightMissingAllowPrivateNetwork:
      return "kPreflightMissingAllowPrivateNetwork";
    case CorsError::kPreflightInvalidAllowPrivateNetwork:
      return "kPreflightInvalidAllowPrivateNetwork";
    case CorsError::kInvalidAllowMethodsPreflightResponse:
      return "kInvalidAllowMethodsPreflightResponse";
    case CorsError::kInvalidAllowHeadersPreflightResponse:
      return "kInvalidAllowHeadersPreflightResponse";
    case CorsError::kMethodDisallowedByPreflightResponse:
      return "kMethodDisallowedByPreflightResponse";
    case CorsError::kHeaderDisallowedByPreflightResponse:
      return "kHeaderDisallowedByPreflightResponse";
    case CorsError::kRedirectContainsCredentials:
      return "kRedirectContainsCredentials";
    case CorsError::kInsecurePrivateNetwork:
      return "kInsecurePrivateNetwork";
    case CorsError::kInvalidPrivateNetworkAccess:
      return "kInvalidPrivateNetworkAccess";
    case CorsError::kUnexpectedPrivateNetworkAccess:
      return "kUnexpectedPrivateNetworkAccess";
    case CorsError::kPreflightMissingPrivateNetworkAccessId:
      return "kPreflightMissingPrivateNetworkAccessId";
    case CorsError::kPreflightMissingPrivateNetworkAccessName:
      return "kPreflightMissingPrivateNetworkAccessName";
    case CorsError::kPrivateNetworkAccessPermissionUnavailable:
      return "kPrivateNetworkAccessPermissionUnavailable";
    case CorsError::kPrivateNetworkAccessPermissionDenied:
      return "kPrivateNetworkAccessPermissionDenied";
    case CorsError::kLocalNetworkAccessPermissionDenied:
      return "kLocalNetworkAccessPermissionDenied";
    default:
      return nullptr;
  }
}

std::string CorsErrorToString(CorsError value) {
  const char *str = CorsErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CorsError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CorsError value) {
  return os << CorsErrorToString(value);
}

NOINLINE static const char* PrivateNetworkAccessPreflightResultToStringHelper(PrivateNetworkAccessPreflightResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PrivateNetworkAccessPreflightResult::kNone:
      return "kNone";
    case PrivateNetworkAccessPreflightResult::kSuccess:
      return "kSuccess";
    case PrivateNetworkAccessPreflightResult::kWarning:
      return "kWarning";
    case PrivateNetworkAccessPreflightResult::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string PrivateNetworkAccessPreflightResultToString(PrivateNetworkAccessPreflightResult value) {
  const char *str = PrivateNetworkAccessPreflightResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PrivateNetworkAccessPreflightResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PrivateNetworkAccessPreflightResult value) {
  return os << PrivateNetworkAccessPreflightResultToString(value);
}

namespace internal {


// static
bool CorsErrorStatus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CorsErrorStatus_Data* object =
      static_cast<const CorsErrorStatus_Data*>(data);


  if (!::network::mojom::internal::CorsError_Data
        ::Validate(object->cors_error, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->failed_parameter, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& failed_parameter_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->failed_parameter, validation_context,
                                         &failed_parameter_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->target_address_space, validation_context))
    return false;


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->resource_address_space, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->issue_id, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->issue_id, validation_context))
    return false;

  return true;
}

CorsErrorStatus_Data::CorsErrorStatus_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CorsPreflightPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CorsPreflightPolicy value) {
  return std::move(context).WriteString(::network::mojom::CorsPreflightPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CorsError>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CorsError value) {
  return std::move(context).WriteString(::network::mojom::CorsErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::PrivateNetworkAccessPreflightResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::PrivateNetworkAccessPreflightResult value) {
  return std::move(context).WriteString(::network::mojom::PrivateNetworkAccessPreflightResultToString(value));
}

} // namespace perfetto