// services/device/public/mojom/usb_enumeration_options.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_SHARED_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/usb_enumeration_options.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"




#include "services/device/public/mojom/usb_enumeration_options.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbDeviceFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbDeviceFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbDeviceFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->has_vendor_id = Traits::has_vendor_id(input);

    fragment->vendor_id = Traits::vendor_id(input);

    fragment->has_product_id = Traits::has_product_id(input);

    fragment->product_id = Traits::product_id(input);

    fragment->has_class_code = Traits::has_class_code(input);

    fragment->class_code = Traits::class_code(input);

    fragment->has_subclass_code = Traits::has_subclass_code(input);

    fragment->subclass_code = Traits::subclass_code(input);

    fragment->has_protocol_code = Traits::has_protocol_code(input);

    fragment->protocol_code = Traits::protocol_code(input);

    decltype(Traits::serial_number(input)) in_serial_number = Traits::serial_number(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serial_number)::BaseType> serial_number_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_serial_number,
      serial_number_fragment);

    fragment->serial_number.Set(
        serial_number_fragment.is_null() ? nullptr : serial_number_fragment.data());
  }

  static bool Deserialize(::device::mojom::internal::UsbDeviceFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::UsbDeviceFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbEnumerationOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbEnumerationOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbEnumerationOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::filters(input)) in_filters = Traits::filters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filters)::BaseType>
        filters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& filters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>>(
      in_filters,
      filters_fragment,
      &filters_validate_params);

    fragment->filters.Set(
        filters_fragment.is_null() ? nullptr : filters_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->filters.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filters in UsbEnumerationOptions struct");
  }

  static bool Deserialize(::device::mojom::internal::UsbEnumerationOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::UsbEnumerationOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void UsbDeviceFilterDataView::GetSerialNumberDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->serial_number.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void UsbEnumerationOptionsDataView::GetFiltersDataView(
    mojo::ArrayDataView<UsbDeviceFilterDataView>* output) {
  auto pointer = data_->filters.Get();
  *output = mojo::ArrayDataView<UsbDeviceFilterDataView>(pointer, message_);
}



}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_SHARED_H_