// media/mojo/mojom/speech_recognition_result.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RESULT_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RESULT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "media/mojo/mojom/speech_recognition_result.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"


namespace media::mojom {
class SpeechRecognitionHypothesisDataView;

class WebSpeechRecognitionResultDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::SpeechRecognitionHypothesisDataView> {
  using Data = ::media::mojom::internal::SpeechRecognitionHypothesis_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::WebSpeechRecognitionResultDataView> {
  using Data = ::media::mojom::internal::WebSpeechRecognitionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


class SpeechRecognitionHypothesisDataView {
 public:
  SpeechRecognitionHypothesisDataView() = default;

  SpeechRecognitionHypothesisDataView(
      internal::SpeechRecognitionHypothesis_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUtteranceDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUtterance(UserType* output) {
    
    auto* pointer = data_->utterance.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  double confidence() const {
    return data_->confidence;
  }
 private:
  internal::SpeechRecognitionHypothesis_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebSpeechRecognitionResultDataView {
 public:
  WebSpeechRecognitionResultDataView() = default;

  WebSpeechRecognitionResultDataView(
      internal::WebSpeechRecognitionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHypothesesDataView(
      mojo::ArrayDataView<SpeechRecognitionHypothesisDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHypotheses(UserType* output) {
    
    auto* pointer = data_->hypotheses.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::SpeechRecognitionHypothesisDataView>>(
        pointer, output, message_);
  }
  bool is_provisional() const {
    return data_->is_provisional;
  }
 private:
  internal::WebSpeechRecognitionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RESULT_MOJOM_DATA_VIEW_H_