// media/mojo/mojom/media_types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_H_
#define MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/media_types.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/exported_shared_image.mojom.h"
#include "gpu/ipc/common/mailbox.mojom-forward.h"
#include "gpu/ipc/common/sync_token.mojom.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-forward.h"
#include "media/mojo/mojom/audio_data.mojom-forward.h"
#include "media/mojo/mojom/encryption_pattern.mojom.h"
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"
#include "ui/gfx/mojom/color_space.mojom.h"
#include "ui/gfx/mojom/hdr_metadata.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "media/base/ipc/media_param_traits_macros.h"
#include "media/base/video_decoder_config.h"
#include "media/mojo/mojom/audio_decoder_config_mojom_traits.h"
#include "media/mojo/mojom/media_types_enum_mojom_traits.h"
#include "media/mojo/mojom/picture_in_picture_events_info_mojom_traits.h"
#include "media/mojo/mojom/pipeline_status_mojom_traits.h"
#include "media/mojo/mojom/status_mojom_traits.h"
#include "media/mojo/mojom/video_aspect_ratio_mojom_traits.h"
#include "media/mojo/mojom/video_color_space_mojom_traits.h"
#include "media/mojo/mojom/video_frame_metadata_mojom_traits.h"
#include "media/mojo/mojom/video_frame_mojom_traits.h"
#include "media/mojo/mojom/video_transformation_mojom_traits.h"




namespace media::mojom {






class  VideoTransformation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoTransformation, T>::value>;
  using DataView = VideoTransformationDataView;
  using Data_ = internal::VideoTransformation_Data;

  template <typename... Args>
  static VideoTransformationPtr New(Args&&... args) {
    return VideoTransformationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoTransformationPtr From(const U& u) {
    return mojo::TypeConverter<VideoTransformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoTransformation>::Convert(*this);
  }


  VideoTransformation();

  VideoTransformation(
      ::media::VideoRotation rotation,
      bool mirrored);


  ~VideoTransformation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoTransformationPtr>
  VideoTransformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoTransformation::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoTransformation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoTransformation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoTransformation_UnserializedMessageContext<
            UserType, VideoTransformation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoTransformation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoTransformation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoTransformation_UnserializedMessageContext<
            UserType, VideoTransformation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoTransformation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::VideoRotation rotation;
  
  bool mirrored;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoAspectRatio {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoAspectRatio, T>::value>;
  using DataView = VideoAspectRatioDataView;
  using Data_ = internal::VideoAspectRatio_Data;
  using Type = VideoAspectRatio_Type;

  template <typename... Args>
  static VideoAspectRatioPtr New(Args&&... args) {
    return VideoAspectRatioPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoAspectRatioPtr From(const U& u) {
    return mojo::TypeConverter<VideoAspectRatioPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoAspectRatio>::Convert(*this);
  }


  VideoAspectRatio();

  VideoAspectRatio(
      VideoAspectRatio::Type type,
      double value);


  ~VideoAspectRatio();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoAspectRatioPtr>
  VideoAspectRatioPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoAspectRatio::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoAspectRatio::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoAspectRatio::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoAspectRatio_UnserializedMessageContext<
            UserType, VideoAspectRatio::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoAspectRatio::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoAspectRatio::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoAspectRatio_UnserializedMessageContext<
            UserType, VideoAspectRatio::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoAspectRatio::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  VideoAspectRatio::Type type;
  
  double value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoAspectRatio::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoColorSpace {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoColorSpace, T>::value>;
  using DataView = VideoColorSpaceDataView;
  using Data_ = internal::VideoColorSpace_Data;
  using PrimaryID = VideoColorSpace_PrimaryID;
  using TransferID = VideoColorSpace_TransferID;
  using MatrixID = VideoColorSpace_MatrixID;
  using RangeID = VideoColorSpace_RangeID;

  template <typename... Args>
  static VideoColorSpacePtr New(Args&&... args) {
    return VideoColorSpacePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoColorSpacePtr From(const U& u) {
    return mojo::TypeConverter<VideoColorSpacePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoColorSpace>::Convert(*this);
  }


  VideoColorSpace();

  VideoColorSpace(
      ::media::VideoColorSpace::PrimaryID primaries,
      ::media::VideoColorSpace::TransferID transfer,
      ::media::VideoColorSpace::MatrixID matrix,
      ::gfx::ColorSpace::RangeID range);


  ~VideoColorSpace();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoColorSpacePtr>
  VideoColorSpacePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoColorSpace::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoColorSpace::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoColorSpace::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoColorSpace_UnserializedMessageContext<
            UserType, VideoColorSpace::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoColorSpace::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoColorSpace::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoColorSpace_UnserializedMessageContext<
            UserType, VideoColorSpace::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoColorSpace::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::VideoColorSpace::PrimaryID primaries;
  
  ::media::VideoColorSpace::TransferID transfer;
  
  ::media::VideoColorSpace::MatrixID matrix;
  
  ::gfx::ColorSpace::RangeID range;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}















class  EosVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EosVideoFrameData, T>::value>;
  using DataView = EosVideoFrameDataDataView;
  using Data_ = internal::EosVideoFrameData_Data;

  template <typename... Args>
  static EosVideoFrameDataPtr New(Args&&... args) {
    return EosVideoFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EosVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<EosVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EosVideoFrameData>::Convert(*this);
  }


  EosVideoFrameData();


  ~EosVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EosVideoFrameDataPtr>
  EosVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EosVideoFrameData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EosVideoFrameData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EosVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EosVideoFrameData_UnserializedMessageContext<
            UserType, EosVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EosVideoFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EosVideoFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EosVideoFrameData_UnserializedMessageContext<
            UserType, EosVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EosVideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  OpaqueVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OpaqueVideoFrameData, T>::value>;
  using DataView = OpaqueVideoFrameDataDataView;
  using Data_ = internal::OpaqueVideoFrameData_Data;

  template <typename... Args>
  static OpaqueVideoFrameDataPtr New(Args&&... args) {
    return OpaqueVideoFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OpaqueVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<OpaqueVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OpaqueVideoFrameData>::Convert(*this);
  }


  OpaqueVideoFrameData();


  ~OpaqueVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OpaqueVideoFrameDataPtr>
  OpaqueVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpaqueVideoFrameData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpaqueVideoFrameData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OpaqueVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OpaqueVideoFrameData_UnserializedMessageContext<
            UserType, OpaqueVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OpaqueVideoFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OpaqueVideoFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OpaqueVideoFrameData_UnserializedMessageContext<
            UserType, OpaqueVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OpaqueVideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OpaqueVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ColorPlaneLayout {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ColorPlaneLayout, T>::value>;
  using DataView = ColorPlaneLayoutDataView;
  using Data_ = internal::ColorPlaneLayout_Data;

  template <typename... Args>
  static ColorPlaneLayoutPtr New(Args&&... args) {
    return ColorPlaneLayoutPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ColorPlaneLayoutPtr From(const U& u) {
    return mojo::TypeConverter<ColorPlaneLayoutPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ColorPlaneLayout>::Convert(*this);
  }


  ColorPlaneLayout();

  ColorPlaneLayout(
      uint64_t stride,
      uint64_t offset,
      uint64_t size);


  ~ColorPlaneLayout();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ColorPlaneLayoutPtr>
  ColorPlaneLayoutPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ColorPlaneLayout::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ColorPlaneLayout::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ColorPlaneLayout::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ColorPlaneLayout::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ColorPlaneLayout::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ColorPlaneLayout::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ColorPlaneLayout_UnserializedMessageContext<
            UserType, ColorPlaneLayout::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ColorPlaneLayout::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ColorPlaneLayout::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ColorPlaneLayout_UnserializedMessageContext<
            UserType, ColorPlaneLayout::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ColorPlaneLayout::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t stride;
  
  uint64_t offset;
  
  uint64_t size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ColorPlaneLayout::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ColorPlaneLayout::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ColorPlaneLayout::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ColorPlaneLayout::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  PredictionTargets {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PredictionTargets, T>::value>;
  using DataView = PredictionTargetsDataView;
  using Data_ = internal::PredictionTargets_Data;

  template <typename... Args>
  static PredictionTargetsPtr New(Args&&... args) {
    return PredictionTargetsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PredictionTargetsPtr From(const U& u) {
    return mojo::TypeConverter<PredictionTargetsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PredictionTargets>::Convert(*this);
  }


  PredictionTargets();

  PredictionTargets(
      uint32_t frames_decoded,
      uint32_t frames_dropped,
      uint32_t frames_power_efficient);


  ~PredictionTargets();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PredictionTargetsPtr>
  PredictionTargetsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PredictionTargets::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PredictionTargets::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PredictionTargets::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PredictionTargets_UnserializedMessageContext<
            UserType, PredictionTargets::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PredictionTargets::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PredictionTargets::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PredictionTargets_UnserializedMessageContext<
            UserType, PredictionTargets::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PredictionTargets::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t frames_decoded;
  
  uint32_t frames_dropped;
  
  uint32_t frames_power_efficient;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AudioPipelineInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioPipelineInfo, T>::value>;
  using DataView = AudioPipelineInfoDataView;
  using Data_ = internal::AudioPipelineInfo_Data;

  template <typename... Args>
  static AudioPipelineInfoPtr New(Args&&... args) {
    return AudioPipelineInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioPipelineInfoPtr From(const U& u) {
    return mojo::TypeConverter<AudioPipelineInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioPipelineInfo>::Convert(*this);
  }


  AudioPipelineInfo();

  AudioPipelineInfo(
      ::media::AudioDecoderType decoder_type,
      bool is_platform_decoder,
      bool has_decrypting_demuxer_stream,
      EncryptionType encryption_type);


  ~AudioPipelineInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioPipelineInfoPtr>
  AudioPipelineInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioPipelineInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioPipelineInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioPipelineInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioPipelineInfo_UnserializedMessageContext<
            UserType, AudioPipelineInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioPipelineInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioPipelineInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioPipelineInfo_UnserializedMessageContext<
            UserType, AudioPipelineInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioPipelineInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::AudioDecoderType decoder_type;
  
  bool is_platform_decoder;
  
  bool has_decrypting_demuxer_stream;
  
  EncryptionType encryption_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoPipelineInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoPipelineInfo, T>::value>;
  using DataView = VideoPipelineInfoDataView;
  using Data_ = internal::VideoPipelineInfo_Data;

  template <typename... Args>
  static VideoPipelineInfoPtr New(Args&&... args) {
    return VideoPipelineInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoPipelineInfoPtr From(const U& u) {
    return mojo::TypeConverter<VideoPipelineInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoPipelineInfo>::Convert(*this);
  }


  VideoPipelineInfo();

  VideoPipelineInfo(
      ::media::VideoDecoderType decoder_type,
      bool is_platform_decoder,
      bool has_decrypting_demuxer_stream,
      EncryptionType encryption_type);


  ~VideoPipelineInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoPipelineInfoPtr>
  VideoPipelineInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoPipelineInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoPipelineInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoPipelineInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoPipelineInfo_UnserializedMessageContext<
            UserType, VideoPipelineInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoPipelineInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoPipelineInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoPipelineInfo_UnserializedMessageContext<
            UserType, VideoPipelineInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoPipelineInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::VideoDecoderType decoder_type;
  
  bool is_platform_decoder;
  
  bool has_decrypting_demuxer_stream;
  
  EncryptionType encryption_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoPipelineInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  DecoderBufferSideDataNextConfig {
 public:
  using DataView = DecoderBufferSideDataNextConfigDataView;
  using Data_ = internal::DecoderBufferSideDataNextConfig_Data;
  using Tag = Data_::DecoderBufferSideDataNextConfig_Tag;

  template <typename... Args>
  static DecoderBufferSideDataNextConfigPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |next_audio_config|.
  static DecoderBufferSideDataNextConfigPtr NewNextAudioConfig(
      const ::media::AudioDecoderConfig& value);
  // Construct an instance holding |next_video_config|.
  static DecoderBufferSideDataNextConfigPtr NewNextVideoConfig(
      const ::media::VideoDecoderConfig& value);

  template <typename U>
  static DecoderBufferSideDataNextConfigPtr From(const U& u) {
    return mojo::TypeConverter<DecoderBufferSideDataNextConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecoderBufferSideDataNextConfig>::Convert(*this);
  }
  ~DecoderBufferSideDataNextConfig();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DecoderBufferSideDataNextConfig(const DecoderBufferSideDataNextConfig& other) = delete;
  DecoderBufferSideDataNextConfig& operator=(const DecoderBufferSideDataNextConfig& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DecoderBufferSideDataNextConfigPtr>
  DecoderBufferSideDataNextConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DecoderBufferSideDataNextConfig>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DecoderBufferSideDataNextConfig>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_next_audio_config() const { return tag_ == Tag::kNextAudioConfig; }
  const ::media::AudioDecoderConfig& get_next_audio_config() const {
    CHECK(tag_ == Tag::kNextAudioConfig);
    return data_.next_audio_config;
  }
  ::media::AudioDecoderConfig& get_next_audio_config() {
    CHECK(tag_ == Tag::kNextAudioConfig);
    return data_.next_audio_config;
  }
  void set_next_audio_config(const ::media::AudioDecoderConfig& next_audio_config);

  bool is_next_video_config() const { return tag_ == Tag::kNextVideoConfig; }
  const ::media::VideoDecoderConfig& get_next_video_config() const {
    CHECK(tag_ == Tag::kNextVideoConfig);
    return data_.next_video_config;
  }
  ::media::VideoDecoderConfig& get_next_video_config() {
    CHECK(tag_ == Tag::kNextVideoConfig);
    return data_.next_video_config;
  }
  void set_next_video_config(const ::media::VideoDecoderConfig& next_video_config);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecoderBufferSideDataNextConfig::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DecoderBufferSideDataNextConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNextAudioConfig)>,
        const ::media::AudioDecoderConfig& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNextVideoConfig)>,
        const ::media::VideoDecoderConfig& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::media::AudioDecoderConfig next_audio_config;
    ::media::VideoDecoderConfig next_video_config;
  };

  DecoderBufferSideDataNextConfig(
      std::in_place_index_t<static_cast<size_t>(Tag::kNextAudioConfig)>,
      const ::media::AudioDecoderConfig& value);
  DecoderBufferSideDataNextConfig(
      std::in_place_index_t<static_cast<size_t>(Tag::kNextVideoConfig)>,
      const ::media::VideoDecoderConfig& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  DecoderBuffer {
 public:
  using DataView = DecoderBufferDataView;
  using Data_ = internal::DecoderBuffer_Data;
  using Tag = Data_::DecoderBuffer_Tag;

  template <typename... Args>
  static DecoderBufferPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |eos|.
  static DecoderBufferPtr NewEos(
      EosDecoderBufferPtr value);
  // Construct an instance holding |data|.
  static DecoderBufferPtr NewData(
      DataDecoderBufferPtr value);

  template <typename U>
  static DecoderBufferPtr From(const U& u) {
    return mojo::TypeConverter<DecoderBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecoderBuffer>::Convert(*this);
  }
  ~DecoderBuffer();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DecoderBuffer(const DecoderBuffer& other) = delete;
  DecoderBuffer& operator=(const DecoderBuffer& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DecoderBufferPtr>
  DecoderBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DecoderBuffer>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DecoderBuffer>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_eos() const { return tag_ == Tag::kEos; }
  const EosDecoderBufferPtr& get_eos() const {
    CHECK(tag_ == Tag::kEos);
    return data_.eos;
  }
  EosDecoderBufferPtr& get_eos() {
    CHECK(tag_ == Tag::kEos);
    return data_.eos;
  }
  void set_eos(EosDecoderBufferPtr eos);

  bool is_data() const { return tag_ == Tag::kData; }
  const DataDecoderBufferPtr& get_data() const {
    CHECK(tag_ == Tag::kData);
    return data_.data;
  }
  DataDecoderBufferPtr& get_data() {
    CHECK(tag_ == Tag::kData);
    return data_.data;
  }
  void set_data(DataDecoderBufferPtr data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecoderBuffer::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DecoderBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEos)>,
        EosDecoderBufferPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
        DataDecoderBufferPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    EosDecoderBufferPtr eos;
    DataDecoderBufferPtr data;
  };

  DecoderBuffer(
      std::in_place_index_t<static_cast<size_t>(Tag::kEos)>,
      EosDecoderBufferPtr value);
  DecoderBuffer(
      std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
      DataDecoderBufferPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  VideoFrameData {
 public:
  using DataView = VideoFrameDataDataView;
  using Data_ = internal::VideoFrameData_Data;
  using Tag = Data_::VideoFrameData_Tag;

  template <typename... Args>
  static VideoFrameDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |eos_data|.
  static VideoFrameDataPtr NewEosData(
      EosVideoFrameDataPtr value);
  // Construct an instance holding |shared_memory_data|.
  static VideoFrameDataPtr NewSharedMemoryData(
      SharedMemoryVideoFrameDataPtr value);
  // Construct an instance holding |gpu_memory_buffer_shared_image_data|.
  static VideoFrameDataPtr NewGpuMemoryBufferSharedImageData(
      GpuMemoryBufferSharedImageVideoFrameDataPtr value);
  // Construct an instance holding |shared_image_data|.
  static VideoFrameDataPtr NewSharedImageData(
      SharedImageVideoFrameDataPtr value);
  // Construct an instance holding |opaque_data|.
  static VideoFrameDataPtr NewOpaqueData(
      OpaqueVideoFrameDataPtr value);
  // Construct an instance holding |dmabuf_data|.
  static VideoFrameDataPtr NewDmabufData(
      DmabufVideoFrameDataPtr value);

  template <typename U>
  static VideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<VideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrameData>::Convert(*this);
  }
  ~VideoFrameData();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  VideoFrameData(const VideoFrameData& other) = delete;
  VideoFrameData& operator=(const VideoFrameData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = VideoFrameDataPtr>
  VideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, VideoFrameData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, VideoFrameData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_eos_data() const { return tag_ == Tag::kEosData; }
  const EosVideoFrameDataPtr& get_eos_data() const {
    CHECK(tag_ == Tag::kEosData);
    return data_.eos_data;
  }
  EosVideoFrameDataPtr& get_eos_data() {
    CHECK(tag_ == Tag::kEosData);
    return data_.eos_data;
  }
  void set_eos_data(EosVideoFrameDataPtr eos_data);

  bool is_shared_memory_data() const { return tag_ == Tag::kSharedMemoryData; }
  const SharedMemoryVideoFrameDataPtr& get_shared_memory_data() const {
    CHECK(tag_ == Tag::kSharedMemoryData);
    return data_.shared_memory_data;
  }
  SharedMemoryVideoFrameDataPtr& get_shared_memory_data() {
    CHECK(tag_ == Tag::kSharedMemoryData);
    return data_.shared_memory_data;
  }
  void set_shared_memory_data(SharedMemoryVideoFrameDataPtr shared_memory_data);

  bool is_gpu_memory_buffer_shared_image_data() const { return tag_ == Tag::kGpuMemoryBufferSharedImageData; }
  const GpuMemoryBufferSharedImageVideoFrameDataPtr& get_gpu_memory_buffer_shared_image_data() const {
    CHECK(tag_ == Tag::kGpuMemoryBufferSharedImageData);
    return data_.gpu_memory_buffer_shared_image_data;
  }
  GpuMemoryBufferSharedImageVideoFrameDataPtr& get_gpu_memory_buffer_shared_image_data() {
    CHECK(tag_ == Tag::kGpuMemoryBufferSharedImageData);
    return data_.gpu_memory_buffer_shared_image_data;
  }
  void set_gpu_memory_buffer_shared_image_data(GpuMemoryBufferSharedImageVideoFrameDataPtr gpu_memory_buffer_shared_image_data);

  bool is_shared_image_data() const { return tag_ == Tag::kSharedImageData; }
  const SharedImageVideoFrameDataPtr& get_shared_image_data() const {
    CHECK(tag_ == Tag::kSharedImageData);
    return data_.shared_image_data;
  }
  SharedImageVideoFrameDataPtr& get_shared_image_data() {
    CHECK(tag_ == Tag::kSharedImageData);
    return data_.shared_image_data;
  }
  void set_shared_image_data(SharedImageVideoFrameDataPtr shared_image_data);

  bool is_opaque_data() const { return tag_ == Tag::kOpaqueData; }
  const OpaqueVideoFrameDataPtr& get_opaque_data() const {
    CHECK(tag_ == Tag::kOpaqueData);
    return data_.opaque_data;
  }
  OpaqueVideoFrameDataPtr& get_opaque_data() {
    CHECK(tag_ == Tag::kOpaqueData);
    return data_.opaque_data;
  }
  void set_opaque_data(OpaqueVideoFrameDataPtr opaque_data);

  bool is_dmabuf_data() const { return tag_ == Tag::kDmabufData; }
  const DmabufVideoFrameDataPtr& get_dmabuf_data() const {
    CHECK(tag_ == Tag::kDmabufData);
    return data_.dmabuf_data;
  }
  DmabufVideoFrameDataPtr& get_dmabuf_data() {
    CHECK(tag_ == Tag::kDmabufData);
    return data_.dmabuf_data;
  }
  void set_dmabuf_data(DmabufVideoFrameDataPtr dmabuf_data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrameData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<VideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEosData)>,
        EosVideoFrameDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSharedMemoryData)>,
        SharedMemoryVideoFrameDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGpuMemoryBufferSharedImageData)>,
        GpuMemoryBufferSharedImageVideoFrameDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSharedImageData)>,
        SharedImageVideoFrameDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOpaqueData)>,
        OpaqueVideoFrameDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDmabufData)>,
        DmabufVideoFrameDataPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    EosVideoFrameDataPtr eos_data;
    SharedMemoryVideoFrameDataPtr shared_memory_data;
    GpuMemoryBufferSharedImageVideoFrameDataPtr gpu_memory_buffer_shared_image_data;
    SharedImageVideoFrameDataPtr shared_image_data;
    OpaqueVideoFrameDataPtr opaque_data;
    DmabufVideoFrameDataPtr dmabuf_data;
  };

  VideoFrameData(
      std::in_place_index_t<static_cast<size_t>(Tag::kEosData)>,
      EosVideoFrameDataPtr value);
  VideoFrameData(
      std::in_place_index_t<static_cast<size_t>(Tag::kSharedMemoryData)>,
      SharedMemoryVideoFrameDataPtr value);
  VideoFrameData(
      std::in_place_index_t<static_cast<size_t>(Tag::kGpuMemoryBufferSharedImageData)>,
      GpuMemoryBufferSharedImageVideoFrameDataPtr value);
  VideoFrameData(
      std::in_place_index_t<static_cast<size_t>(Tag::kSharedImageData)>,
      SharedImageVideoFrameDataPtr value);
  VideoFrameData(
      std::in_place_index_t<static_cast<size_t>(Tag::kOpaqueData)>,
      OpaqueVideoFrameDataPtr value);
  VideoFrameData(
      std::in_place_index_t<static_cast<size_t>(Tag::kDmabufData)>,
      DmabufVideoFrameDataPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};









class  AudioDecoderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioDecoderConfig, T>::value>;
  using DataView = AudioDecoderConfigDataView;
  using Data_ = internal::AudioDecoderConfig_Data;

  template <typename... Args>
  static AudioDecoderConfigPtr New(Args&&... args) {
    return AudioDecoderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioDecoderConfigPtr From(const U& u) {
    return mojo::TypeConverter<AudioDecoderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioDecoderConfig>::Convert(*this);
  }


  AudioDecoderConfig();

  AudioDecoderConfig(
      ::media::AudioCodec codec,
      ::media::SampleFormat sample_format,
      ::media::ChannelLayout channel_layout,
      int32_t samples_per_second,
      std::vector<uint8_t> extra_data,
      ::media::EncryptionScheme encryption_scheme,
      ::base::TimeDelta seek_preroll,
      int32_t codec_delay,
      ::media::AudioCodecProfile profile,
      ::media::ChannelLayout target_output_channel_layout,
      ::media::SampleFormat target_output_sample_format,
      bool should_discard_decoder_delay);


  ~AudioDecoderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioDecoderConfigPtr>
  AudioDecoderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioDecoderConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioDecoderConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioDecoderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioDecoderConfig_UnserializedMessageContext<
            UserType, AudioDecoderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioDecoderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioDecoderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioDecoderConfig_UnserializedMessageContext<
            UserType, AudioDecoderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioDecoderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::AudioCodec codec;
  
  ::media::SampleFormat sample_format;
  
  ::media::ChannelLayout channel_layout;
  
  int32_t samples_per_second;
  
  std::vector<uint8_t> extra_data;
  
  ::media::EncryptionScheme encryption_scheme;
  
  ::base::TimeDelta seek_preroll;
  
  int32_t codec_delay;
  
  ::media::AudioCodecProfile profile;
  
  ::media::ChannelLayout target_output_channel_layout;
  
  ::media::SampleFormat target_output_sample_format;
  
  bool should_discard_decoder_delay;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoDecoderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoDecoderConfig, T>::value>;
  using DataView = VideoDecoderConfigDataView;
  using Data_ = internal::VideoDecoderConfig_Data;

  template <typename... Args>
  static VideoDecoderConfigPtr New(Args&&... args) {
    return VideoDecoderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoDecoderConfigPtr From(const U& u) {
    return mojo::TypeConverter<VideoDecoderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoDecoderConfig>::Convert(*this);
  }


  VideoDecoderConfig();

  VideoDecoderConfig(
      ::media::VideoCodec codec,
      ::media::VideoCodecProfile profile,
      uint32_t level,
      bool has_alpha,
      const ::media::VideoTransformation& transformation,
      const ::gfx::Size& coded_size,
      const ::gfx::Rect& visible_rect,
      const ::gfx::Size& natural_size,
      const ::media::VideoAspectRatio& aspect_ratio,
      std::vector<uint8_t> extra_data,
      ::media::EncryptionScheme encryption_scheme,
      const ::media::VideoColorSpace& color_space_info,
      const std::optional<::gfx::HDRMetadata>& hdr_metadata);


  ~VideoDecoderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoDecoderConfigPtr>
  VideoDecoderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoDecoderConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoDecoderConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoDecoderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoDecoderConfig_UnserializedMessageContext<
            UserType, VideoDecoderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoDecoderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoDecoderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoDecoderConfig_UnserializedMessageContext<
            UserType, VideoDecoderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoDecoderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::VideoCodec codec;
  
  ::media::VideoCodecProfile profile;
  
  uint32_t level;
  
  bool has_alpha;
  
  ::media::VideoTransformation transformation;
  
  ::gfx::Size coded_size;
  
  ::gfx::Rect visible_rect;
  
  ::gfx::Size natural_size;
  
  ::media::VideoAspectRatio aspect_ratio;
  
  std::vector<uint8_t> extra_data;
  
  ::media::EncryptionScheme encryption_scheme;
  
  ::media::VideoColorSpace color_space_info;
  
  std::optional<::gfx::HDRMetadata> hdr_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  DecryptConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DecryptConfig, T>::value>;
  using DataView = DecryptConfigDataView;
  using Data_ = internal::DecryptConfig_Data;

  template <typename... Args>
  static DecryptConfigPtr New(Args&&... args) {
    return DecryptConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DecryptConfigPtr From(const U& u) {
    return mojo::TypeConverter<DecryptConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecryptConfig>::Convert(*this);
  }


  DecryptConfig();

  DecryptConfig(
      ::media::EncryptionScheme encryption_scheme,
      const std::string& key_id,
      const std::string& iv,
      std::vector<::media::SubsampleEntry> subsamples,
      const std::optional<::media::EncryptionPattern>& encryption_pattern);


  ~DecryptConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DecryptConfigPtr>
  DecryptConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecryptConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecryptConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecryptConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DecryptConfig_UnserializedMessageContext<
            UserType, DecryptConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DecryptConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DecryptConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DecryptConfig_UnserializedMessageContext<
            UserType, DecryptConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DecryptConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::EncryptionScheme encryption_scheme;
  
  std::string key_id;
  
  std::string iv;
  
  std::vector<::media::SubsampleEntry> subsamples;
  
  std::optional<::media::EncryptionPattern> encryption_pattern;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DecoderBufferSideData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DecoderBufferSideData, T>::value>;
  using DataView = DecoderBufferSideDataDataView;
  using Data_ = internal::DecoderBufferSideData_Data;

  template <typename... Args>
  static DecoderBufferSideDataPtr New(Args&&... args) {
    return DecoderBufferSideDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DecoderBufferSideDataPtr From(const U& u) {
    return mojo::TypeConverter<DecoderBufferSideDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecoderBufferSideData>::Convert(*this);
  }


  DecoderBufferSideData();

  DecoderBufferSideData(
      std::vector<uint32_t> spatial_layers,
      std::vector<uint8_t> alpha_data,
      uint64_t secure_handle,
      ::base::TimeDelta front_discard,
      ::base::TimeDelta back_discard);


  ~DecoderBufferSideData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DecoderBufferSideDataPtr>
  DecoderBufferSideDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecoderBufferSideData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecoderBufferSideData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecoderBufferSideData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DecoderBufferSideData_UnserializedMessageContext<
            UserType, DecoderBufferSideData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DecoderBufferSideData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DecoderBufferSideData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DecoderBufferSideData_UnserializedMessageContext<
            UserType, DecoderBufferSideData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DecoderBufferSideData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint32_t> spatial_layers;
  
  std::vector<uint8_t> alpha_data;
  
  uint64_t secure_handle;
  
  ::base::TimeDelta front_discard;
  
  ::base::TimeDelta back_discard;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DataDecoderBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataDecoderBuffer, T>::value>;
  using DataView = DataDecoderBufferDataView;
  using Data_ = internal::DataDecoderBuffer_Data;

  template <typename... Args>
  static DataDecoderBufferPtr New(Args&&... args) {
    return DataDecoderBufferPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataDecoderBufferPtr From(const U& u) {
    return mojo::TypeConverter<DataDecoderBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataDecoderBuffer>::Convert(*this);
  }


  DataDecoderBuffer();

  DataDecoderBuffer(
      ::base::TimeDelta timestamp,
      ::base::TimeDelta duration,
      uint32_t data_size,
      bool is_key_frame,
      DecryptConfigPtr decrypt_config,
      DecoderBufferSideDataPtr side_data);

DataDecoderBuffer(const DataDecoderBuffer&) = delete;
DataDecoderBuffer& operator=(const DataDecoderBuffer&) = delete;

  ~DataDecoderBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataDecoderBufferPtr>
  DataDecoderBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataDecoderBuffer::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataDecoderBuffer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataDecoderBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataDecoderBuffer_UnserializedMessageContext<
            UserType, DataDecoderBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataDecoderBuffer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataDecoderBuffer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataDecoderBuffer_UnserializedMessageContext<
            UserType, DataDecoderBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataDecoderBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeDelta timestamp;
  
  ::base::TimeDelta duration;
  
  uint32_t data_size;
  
  bool is_key_frame;
  
  DecryptConfigPtr decrypt_config;
  
  DecoderBufferSideDataPtr side_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  EosDecoderBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EosDecoderBuffer, T>::value>;
  using DataView = EosDecoderBufferDataView;
  using Data_ = internal::EosDecoderBuffer_Data;

  template <typename... Args>
  static EosDecoderBufferPtr New(Args&&... args) {
    return EosDecoderBufferPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EosDecoderBufferPtr From(const U& u) {
    return mojo::TypeConverter<EosDecoderBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EosDecoderBuffer>::Convert(*this);
  }


  EosDecoderBuffer();

  explicit EosDecoderBuffer(
      DecoderBufferSideDataNextConfigPtr next_config);

EosDecoderBuffer(const EosDecoderBuffer&) = delete;
EosDecoderBuffer& operator=(const EosDecoderBuffer&) = delete;

  ~EosDecoderBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EosDecoderBufferPtr>
  EosDecoderBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EosDecoderBuffer::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EosDecoderBuffer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EosDecoderBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EosDecoderBuffer_UnserializedMessageContext<
            UserType, EosDecoderBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EosDecoderBuffer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EosDecoderBuffer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EosDecoderBuffer_UnserializedMessageContext<
            UserType, EosDecoderBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EosDecoderBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DecoderBufferSideDataNextConfigPtr next_config;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EosDecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AudioBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioBuffer, T>::value>;
  using DataView = AudioBufferDataView;
  using Data_ = internal::AudioBuffer_Data;

  template <typename... Args>
  static AudioBufferPtr New(Args&&... args) {
    return AudioBufferPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioBufferPtr From(const U& u) {
    return mojo::TypeConverter<AudioBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioBuffer>::Convert(*this);
  }


  AudioBuffer();

  AudioBuffer(
      ::media::SampleFormat sample_format,
      ::media::ChannelLayout channel_layout,
      int32_t channel_count,
      int32_t sample_rate,
      int32_t frame_count,
      bool end_of_stream,
      ::base::TimeDelta timestamp,
      std::vector<uint8_t> data);


  ~AudioBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioBufferPtr>
  AudioBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioBuffer::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioBuffer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioBuffer_UnserializedMessageContext<
            UserType, AudioBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioBuffer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioBuffer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioBuffer_UnserializedMessageContext<
            UserType, AudioBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::SampleFormat sample_format;
  
  ::media::ChannelLayout channel_layout;
  
  int32_t channel_count;
  
  int32_t sample_rate;
  
  int32_t frame_count;
  
  bool end_of_stream;
  
  ::base::TimeDelta timestamp;
  
  std::vector<uint8_t> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoFrameMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoFrameMetadata, T>::value>;
  using DataView = VideoFrameMetadataDataView;
  using Data_ = internal::VideoFrameMetadata_Data;

  template <typename... Args>
  static VideoFrameMetadataPtr New(Args&&... args) {
    return VideoFrameMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoFrameMetadataPtr From(const U& u) {
    return mojo::TypeConverter<VideoFrameMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrameMetadata>::Convert(*this);
  }


  VideoFrameMetadata();

  VideoFrameMetadata(
      bool allow_overlay,
      std::optional<::base::TimeTicks> capture_begin_time,
      std::optional<::base::TimeTicks> capture_end_time,
      bool has_capture_counter,
      int32_t capture_counter,
      const std::optional<::gfx::Rect>& capture_update_rect,
      const std::optional<::gfx::Size>& source_size,
      const std::optional<::gfx::Rect>& region_capture_rect,
      uint32_t sub_capture_target_version,
      bool copy_required,
      bool end_of_stream,
      std::optional<::base::TimeDelta> frame_duration,
      bool has_frame_rate,
      double frame_rate,
      bool interactive_content,
      std::optional<::base::TimeTicks> reference_time,
      bool read_lock_fences_enabled,
      const std::optional<::media::VideoTransformation>& transformation,
      bool in_surface_view,
      bool wants_promotion_hint,
      bool protected_video,
      bool hw_protected,
      bool needs_detiling,
      bool is_webgpu_compatible,
      const std::optional<::base::UnguessableToken>& tracking_token,
      bool power_efficient,
      bool has_device_scale_factor,
      double device_scale_factor,
      bool has_page_scale_factor,
      double page_scale_factor,
      bool has_root_scroll_offset_x,
      double root_scroll_offset_x,
      bool has_root_scroll_offset_y,
      double root_scroll_offset_y,
      bool has_top_controls_visible_height,
      double top_controls_visible_height,
      std::optional<::base::TimeTicks> decode_begin_time,
      std::optional<::base::TimeTicks> decode_end_time,
      std::optional<::base::TimeDelta> processing_time,
      bool has_rtp_timestamp,
      double rtp_timestamp,
      std::optional<::base::TimeTicks> receive_time,
      std::optional<::base::TimeDelta> wallclock_frame_duration,
      std::optional<uint64_t> frame_sequence,
      std::optional<uint64_t> source_id,
      EffectState background_blur);


  ~VideoFrameMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoFrameMetadataPtr>
  VideoFrameMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoFrameMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoFrameMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrameMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoFrameMetadata_UnserializedMessageContext<
            UserType, VideoFrameMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoFrameMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoFrameMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoFrameMetadata_UnserializedMessageContext<
            UserType, VideoFrameMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoFrameMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool allow_overlay;
  
  std::optional<::base::TimeTicks> capture_begin_time;
  
  std::optional<::base::TimeTicks> capture_end_time;
  
  bool has_capture_counter;
  
  int32_t capture_counter;
  
  std::optional<::gfx::Rect> capture_update_rect;
  
  std::optional<::gfx::Size> source_size;
  
  std::optional<::gfx::Rect> region_capture_rect;
  
  uint32_t sub_capture_target_version;
  
  bool copy_required;
  
  bool end_of_stream;
  
  std::optional<::base::TimeDelta> frame_duration;
  
  bool has_frame_rate;
  
  double frame_rate;
  
  bool interactive_content;
  
  std::optional<::base::TimeTicks> reference_time;
  
  bool read_lock_fences_enabled;
  
  std::optional<::media::VideoTransformation> transformation;
  
  bool in_surface_view;
  
  bool wants_promotion_hint;
  
  bool protected_video;
  
  bool hw_protected;
  
  bool needs_detiling;
  
  bool is_webgpu_compatible;
  
  std::optional<::base::UnguessableToken> tracking_token;
  
  bool power_efficient;
  
  bool has_device_scale_factor;
  
  double device_scale_factor;
  
  bool has_page_scale_factor;
  
  double page_scale_factor;
  
  bool has_root_scroll_offset_x;
  
  double root_scroll_offset_x;
  
  bool has_root_scroll_offset_y;
  
  double root_scroll_offset_y;
  
  bool has_top_controls_visible_height;
  
  double top_controls_visible_height;
  
  std::optional<::base::TimeTicks> decode_begin_time;
  
  std::optional<::base::TimeTicks> decode_end_time;
  
  std::optional<::base::TimeDelta> processing_time;
  
  bool has_rtp_timestamp;
  
  double rtp_timestamp;
  
  std::optional<::base::TimeTicks> receive_time;
  
  std::optional<::base::TimeDelta> wallclock_frame_duration;
  
  std::optional<uint64_t> frame_sequence;
  
  std::optional<uint64_t> source_id;
  
  EffectState background_blur;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoFrame {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoFrame, T>::value>;
  using DataView = VideoFrameDataView;
  using Data_ = internal::VideoFrame_Data;

  template <typename... Args>
  static VideoFramePtr New(Args&&... args) {
    return VideoFramePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoFramePtr From(const U& u) {
    return mojo::TypeConverter<VideoFramePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrame>::Convert(*this);
  }


  VideoFrame();

  VideoFrame(
      ::media::VideoPixelFormat format,
      const ::gfx::Size& coded_size,
      const ::gfx::Rect& visible_rect,
      const ::gfx::Size& natural_size,
      ::base::TimeDelta timestamp,
      VideoFrameDataPtr data,
      const ::media::VideoFrameMetadata& metadata,
      const ::gfx::ColorSpace& color_space,
      const std::optional<::gfx::HDRMetadata>& hdr_metadata);

VideoFrame(const VideoFrame&) = delete;
VideoFrame& operator=(const VideoFrame&) = delete;

  ~VideoFrame();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoFramePtr>
  VideoFramePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrame::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoFrame_UnserializedMessageContext<
            UserType, VideoFrame::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoFrame::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoFrame::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoFrame_UnserializedMessageContext<
            UserType, VideoFrame::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoFrame::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::VideoPixelFormat format;
  
  ::gfx::Size coded_size;
  
  ::gfx::Rect visible_rect;
  
  ::gfx::Size natural_size;
  
  ::base::TimeDelta timestamp;
  
  VideoFrameDataPtr data;
  
  ::media::VideoFrameMetadata metadata;
  
  ::gfx::ColorSpace color_space;
  
  std::optional<::gfx::HDRMetadata> hdr_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SharedMemoryVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedMemoryVideoFrameData, T>::value>;
  using DataView = SharedMemoryVideoFrameDataDataView;
  using Data_ = internal::SharedMemoryVideoFrameData_Data;

  template <typename... Args>
  static SharedMemoryVideoFrameDataPtr New(Args&&... args) {
    return SharedMemoryVideoFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedMemoryVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<SharedMemoryVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedMemoryVideoFrameData>::Convert(*this);
  }


  SharedMemoryVideoFrameData();

  SharedMemoryVideoFrameData(
      ::base::ReadOnlySharedMemoryRegion frame_data,
      std::vector<int32_t> strides,
      std::vector<uint32_t> offsets);

SharedMemoryVideoFrameData(const SharedMemoryVideoFrameData&) = delete;
SharedMemoryVideoFrameData& operator=(const SharedMemoryVideoFrameData&) = delete;

  ~SharedMemoryVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedMemoryVideoFrameDataPtr>
  SharedMemoryVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedMemoryVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedMemoryVideoFrameData_UnserializedMessageContext<
            UserType, SharedMemoryVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedMemoryVideoFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedMemoryVideoFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedMemoryVideoFrameData_UnserializedMessageContext<
            UserType, SharedMemoryVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedMemoryVideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::ReadOnlySharedMemoryRegion frame_data;
  
  std::vector<int32_t> strides;
  
  std::vector<uint32_t> offsets;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GpuMemoryBufferSharedImageVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuMemoryBufferSharedImageVideoFrameData, T>::value>;
  using DataView = GpuMemoryBufferSharedImageVideoFrameDataDataView;
  using Data_ = internal::GpuMemoryBufferSharedImageVideoFrameData_Data;

  template <typename... Args>
  static GpuMemoryBufferSharedImageVideoFrameDataPtr New(Args&&... args) {
    return GpuMemoryBufferSharedImageVideoFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuMemoryBufferSharedImageVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<GpuMemoryBufferSharedImageVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuMemoryBufferSharedImageVideoFrameData>::Convert(*this);
  }


  GpuMemoryBufferSharedImageVideoFrameData();

  GpuMemoryBufferSharedImageVideoFrameData(
      ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle,
      std::optional<::gpu::ExportedSharedImage> shared_image,
      const ::gpu::SyncToken& sync_token);

GpuMemoryBufferSharedImageVideoFrameData(const GpuMemoryBufferSharedImageVideoFrameData&) = delete;
GpuMemoryBufferSharedImageVideoFrameData& operator=(const GpuMemoryBufferSharedImageVideoFrameData&) = delete;

  ~GpuMemoryBufferSharedImageVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuMemoryBufferSharedImageVideoFrameDataPtr>
  GpuMemoryBufferSharedImageVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuMemoryBufferSharedImageVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuMemoryBufferSharedImageVideoFrameData_UnserializedMessageContext<
            UserType, GpuMemoryBufferSharedImageVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GpuMemoryBufferSharedImageVideoFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GpuMemoryBufferSharedImageVideoFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuMemoryBufferSharedImageVideoFrameData_UnserializedMessageContext<
            UserType, GpuMemoryBufferSharedImageVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuMemoryBufferSharedImageVideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle;
  
  std::optional<::gpu::ExportedSharedImage> shared_image;
  
  ::gpu::SyncToken sync_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SharedImageVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedImageVideoFrameData, T>::value>;
  using DataView = SharedImageVideoFrameDataDataView;
  using Data_ = internal::SharedImageVideoFrameData_Data;

  template <typename... Args>
  static SharedImageVideoFrameDataPtr New(Args&&... args) {
    return SharedImageVideoFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedImageVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<SharedImageVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedImageVideoFrameData>::Convert(*this);
  }


  SharedImageVideoFrameData();

  SharedImageVideoFrameData(
      ::gpu::ExportedSharedImage shared_image,
      const ::gpu::SyncToken& sync_token,
      bool is_mappable_si_enabled);

SharedImageVideoFrameData(const SharedImageVideoFrameData&) = delete;
SharedImageVideoFrameData& operator=(const SharedImageVideoFrameData&) = delete;

  ~SharedImageVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedImageVideoFrameDataPtr>
  SharedImageVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedImageVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedImageVideoFrameData_UnserializedMessageContext<
            UserType, SharedImageVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedImageVideoFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedImageVideoFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedImageVideoFrameData_UnserializedMessageContext<
            UserType, SharedImageVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedImageVideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::ExportedSharedImage shared_image;
  
  ::gpu::SyncToken sync_token;
  
  bool is_mappable_si_enabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedImageVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  DmabufVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DmabufVideoFrameData, T>::value>;
  using DataView = DmabufVideoFrameDataDataView;
  using Data_ = internal::DmabufVideoFrameData_Data;

  template <typename... Args>
  static DmabufVideoFrameDataPtr New(Args&&... args) {
    return DmabufVideoFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DmabufVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<DmabufVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DmabufVideoFrameData>::Convert(*this);
  }


  DmabufVideoFrameData();

  DmabufVideoFrameData(
      std::vector<ColorPlaneLayoutPtr> planes,
      bool is_multi_planar,
      uint64_t buffer_addr_align,
      uint64_t modifier,
      std::vector<::mojo::PlatformHandle> fds);

DmabufVideoFrameData(const DmabufVideoFrameData&) = delete;
DmabufVideoFrameData& operator=(const DmabufVideoFrameData&) = delete;

  ~DmabufVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DmabufVideoFrameDataPtr>
  DmabufVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DmabufVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DmabufVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DmabufVideoFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DmabufVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DmabufVideoFrameData_UnserializedMessageContext<
            UserType, DmabufVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DmabufVideoFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DmabufVideoFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DmabufVideoFrameData_UnserializedMessageContext<
            UserType, DmabufVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DmabufVideoFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<ColorPlaneLayoutPtr> planes;
  
  bool is_multi_planar;
  
  uint64_t buffer_addr_align;
  
  uint64_t modifier;
  
  std::vector<::mojo::PlatformHandle> fds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DmabufVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DmabufVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DmabufVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DmabufVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PipelineStatistics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PipelineStatistics, T>::value>;
  using DataView = PipelineStatisticsDataView;
  using Data_ = internal::PipelineStatistics_Data;

  template <typename... Args>
  static PipelineStatisticsPtr New(Args&&... args) {
    return PipelineStatisticsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PipelineStatisticsPtr From(const U& u) {
    return mojo::TypeConverter<PipelineStatisticsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PipelineStatistics>::Convert(*this);
  }


  PipelineStatistics();

  PipelineStatistics(
      uint64_t audio_bytes_decoded,
      uint64_t video_bytes_decoded,
      uint32_t video_frames_decoded,
      uint32_t video_frames_dropped,
      int64_t audio_memory_usage,
      int64_t video_memory_usage);


  ~PipelineStatistics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PipelineStatisticsPtr>
  PipelineStatisticsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PipelineStatistics::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PipelineStatistics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PipelineStatistics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PipelineStatistics_UnserializedMessageContext<
            UserType, PipelineStatistics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PipelineStatistics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PipelineStatistics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PipelineStatistics_UnserializedMessageContext<
            UserType, PipelineStatistics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PipelineStatistics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t audio_bytes_decoded;
  
  uint64_t video_bytes_decoded;
  
  uint32_t video_frames_decoded;
  
  uint32_t video_frames_dropped;
  
  int64_t audio_memory_usage;
  
  int64_t video_memory_usage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PredictionFeatures {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PredictionFeatures, T>::value>;
  using DataView = PredictionFeaturesDataView;
  using Data_ = internal::PredictionFeatures_Data;

  template <typename... Args>
  static PredictionFeaturesPtr New(Args&&... args) {
    return PredictionFeaturesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PredictionFeaturesPtr From(const U& u) {
    return mojo::TypeConverter<PredictionFeaturesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PredictionFeatures>::Convert(*this);
  }


  PredictionFeatures();

  PredictionFeatures(
      ::media::VideoCodecProfile profile,
      const ::gfx::Size& video_size,
      double frames_per_sec,
      const std::string& key_system,
      bool use_hw_secure_codecs);


  ~PredictionFeatures();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PredictionFeaturesPtr>
  PredictionFeaturesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PredictionFeatures::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PredictionFeatures::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PredictionFeatures::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PredictionFeatures_UnserializedMessageContext<
            UserType, PredictionFeatures::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PredictionFeatures::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PredictionFeatures::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PredictionFeatures_UnserializedMessageContext<
            UserType, PredictionFeatures::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PredictionFeatures::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::VideoCodecProfile profile;
  
  ::gfx::Size video_size;
  
  double frames_per_sec;
  
  std::string key_system;
  
  bool use_hw_secure_codecs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  StatusData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StatusData, T>::value>;
  using DataView = StatusDataDataView;
  using Data_ = internal::StatusData_Data;

  template <typename... Args>
  static StatusDataPtr New(Args&&... args) {
    return StatusDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StatusDataPtr From(const U& u) {
    return mojo::TypeConverter<StatusDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StatusData>::Convert(*this);
  }


  StatusData();

  StatusData(
      const std::string& group,
      uint16_t code,
      const std::string& message,
      ::base::Value::List frames,
      const std::optional<::media::internal::StatusData>& cause,
      ::base::Value data);

StatusData(const StatusData&) = delete;
StatusData& operator=(const StatusData&) = delete;

  ~StatusData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StatusDataPtr>
  StatusDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StatusData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StatusData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StatusData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StatusData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StatusData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StatusData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StatusData_UnserializedMessageContext<
            UserType, StatusData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StatusData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StatusData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StatusData_UnserializedMessageContext<
            UserType, StatusData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StatusData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string group;
  
  uint16_t code;
  
  std::string message;
  
  ::base::Value::List frames;
  
  std::optional<::media::internal::StatusData> cause;
  
  ::base::Value data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StatusData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StatusData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StatusData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StatusData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  EncoderStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EncoderStatus, T>::value>;
  using DataView = EncoderStatusDataView;
  using Data_ = internal::EncoderStatus_Data;

  template <typename... Args>
  static EncoderStatusPtr New(Args&&... args) {
    return EncoderStatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EncoderStatusPtr From(const U& u) {
    return mojo::TypeConverter<EncoderStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EncoderStatus>::Convert(*this);
  }


  EncoderStatus();

  explicit EncoderStatus(
      const std::optional<::media::internal::StatusData>& internal);


  ~EncoderStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EncoderStatusPtr>
  EncoderStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EncoderStatus::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EncoderStatus::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EncoderStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EncoderStatus_UnserializedMessageContext<
            UserType, EncoderStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EncoderStatus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EncoderStatus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EncoderStatus_UnserializedMessageContext<
            UserType, EncoderStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EncoderStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::media::internal::StatusData> internal;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EncoderStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DecoderStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DecoderStatus, T>::value>;
  using DataView = DecoderStatusDataView;
  using Data_ = internal::DecoderStatus_Data;

  template <typename... Args>
  static DecoderStatusPtr New(Args&&... args) {
    return DecoderStatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DecoderStatusPtr From(const U& u) {
    return mojo::TypeConverter<DecoderStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecoderStatus>::Convert(*this);
  }


  DecoderStatus();

  explicit DecoderStatus(
      const std::optional<::media::internal::StatusData>& internal);


  ~DecoderStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DecoderStatusPtr>
  DecoderStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecoderStatus::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecoderStatus::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecoderStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DecoderStatus_UnserializedMessageContext<
            UserType, DecoderStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DecoderStatus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DecoderStatus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DecoderStatus_UnserializedMessageContext<
            UserType, DecoderStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DecoderStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::media::internal::StatusData> internal;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DecoderStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PipelineStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PipelineStatus, T>::value>;
  using DataView = PipelineStatusDataView;
  using Data_ = internal::PipelineStatus_Data;

  template <typename... Args>
  static PipelineStatusPtr New(Args&&... args) {
    return PipelineStatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PipelineStatusPtr From(const U& u) {
    return mojo::TypeConverter<PipelineStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PipelineStatus>::Convert(*this);
  }


  PipelineStatus();

  explicit PipelineStatus(
      const std::optional<::media::internal::StatusData>& internal);


  ~PipelineStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PipelineStatusPtr>
  PipelineStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PipelineStatus::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PipelineStatus::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PipelineStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PipelineStatus_UnserializedMessageContext<
            UserType, PipelineStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PipelineStatus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PipelineStatus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PipelineStatus_UnserializedMessageContext<
            UserType, PipelineStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PipelineStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::media::internal::StatusData> internal;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PipelineStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AutoPipInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutoPipInfo, T>::value>;
  using DataView = AutoPipInfoDataView;
  using Data_ = internal::AutoPipInfo_Data;

  template <typename... Args>
  static AutoPipInfoPtr New(Args&&... args) {
    return AutoPipInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutoPipInfoPtr From(const U& u) {
    return mojo::TypeConverter<AutoPipInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutoPipInfo>::Convert(*this);
  }


  AutoPipInfo();

  AutoPipInfo(
      AutoPipReason auto_pip_reason,
      bool has_audio_focus,
      bool is_playing,
      bool was_recently_audible,
      bool has_safe_url,
      bool meets_media_engagement_conditions,
      bool blocked_due_to_content_setting);


  ~AutoPipInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutoPipInfoPtr>
  AutoPipInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutoPipInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutoPipInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutoPipInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutoPipInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutoPipInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutoPipInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutoPipInfo_UnserializedMessageContext<
            UserType, AutoPipInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutoPipInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutoPipInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutoPipInfo_UnserializedMessageContext<
            UserType, AutoPipInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutoPipInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AutoPipReason auto_pip_reason;
  
  bool has_audio_focus;
  
  bool is_playing;
  
  bool was_recently_audible;
  
  bool has_safe_url;
  
  bool meets_media_engagement_conditions;
  
  bool blocked_due_to_content_setting;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutoPipInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutoPipInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutoPipInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutoPipInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DecoderBufferSideDataNextConfigPtr DecoderBufferSideDataNextConfig::Clone() const {
  switch (tag_) {
    case Tag::kNextAudioConfig:
      return NewNextAudioConfig(
          mojo::Clone(data_.next_audio_config));
    case Tag::kNextVideoConfig:
      return NewNextVideoConfig(
          mojo::Clone(data_.next_video_config));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DecoderBufferSideDataNextConfig>::value>::type*>
bool DecoderBufferSideDataNextConfig::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNextAudioConfig:
      return mojo::Equals(data_.next_audio_config, other.data_.next_audio_config);
    case Tag::kNextVideoConfig:
      return mojo::Equals(data_.next_video_config, other.data_.next_video_config);
  }

  return false;
}
template <typename UnionPtrType>
DecoderBufferPtr DecoderBuffer::Clone() const {
  switch (tag_) {
    case Tag::kEos:
      return NewEos(
          mojo::Clone(data_.eos));
    case Tag::kData:
      return NewData(
          mojo::Clone(data_.data));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DecoderBuffer>::value>::type*>
bool DecoderBuffer::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kEos:
      return mojo::Equals(data_.eos, other.data_.eos);
    case Tag::kData:
      return mojo::Equals(data_.data, other.data_.data);
  }

  return false;
}
template <typename UnionPtrType>
VideoFrameDataPtr VideoFrameData::Clone() const {
  switch (tag_) {
    case Tag::kEosData:
      return NewEosData(
          mojo::Clone(data_.eos_data));
    case Tag::kSharedMemoryData:
      return NewSharedMemoryData(
          mojo::Clone(data_.shared_memory_data));
    case Tag::kGpuMemoryBufferSharedImageData:
      return NewGpuMemoryBufferSharedImageData(
          mojo::Clone(data_.gpu_memory_buffer_shared_image_data));
    case Tag::kSharedImageData:
      return NewSharedImageData(
          mojo::Clone(data_.shared_image_data));
    case Tag::kOpaqueData:
      return NewOpaqueData(
          mojo::Clone(data_.opaque_data));
    case Tag::kDmabufData:
      return NewDmabufData(
          mojo::Clone(data_.dmabuf_data));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, VideoFrameData>::value>::type*>
bool VideoFrameData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kEosData:
      return mojo::Equals(data_.eos_data, other.data_.eos_data);
    case Tag::kSharedMemoryData:
      return mojo::Equals(data_.shared_memory_data, other.data_.shared_memory_data);
    case Tag::kGpuMemoryBufferSharedImageData:
      return mojo::Equals(data_.gpu_memory_buffer_shared_image_data, other.data_.gpu_memory_buffer_shared_image_data);
    case Tag::kSharedImageData:
      return mojo::Equals(data_.shared_image_data, other.data_.shared_image_data);
    case Tag::kOpaqueData:
      return mojo::Equals(data_.opaque_data, other.data_.opaque_data);
    case Tag::kDmabufData:
      return mojo::Equals(data_.dmabuf_data, other.data_.dmabuf_data);
  }

  return false;
}
template <typename StructPtrType>
VideoTransformationPtr VideoTransformation::Clone() const {
  return New(
      mojo::Clone(rotation),
      mojo::Clone(mirrored)
  );
}

template <typename T, VideoTransformation::EnableIfSame<T>*>
bool VideoTransformation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rotation, other_struct.rotation))
    return false;
  if (!mojo::Equals(this->mirrored, other_struct.mirrored))
    return false;
  return true;
}

template <typename T, VideoTransformation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rotation < rhs.rotation)
    return true;
  if (rhs.rotation < lhs.rotation)
    return false;
  if (lhs.mirrored < rhs.mirrored)
    return true;
  if (rhs.mirrored < lhs.mirrored)
    return false;
  return false;
}
template <typename StructPtrType>
VideoAspectRatioPtr VideoAspectRatio::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(value)
  );
}

template <typename T, VideoAspectRatio::EnableIfSame<T>*>
bool VideoAspectRatio::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, VideoAspectRatio::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
VideoColorSpacePtr VideoColorSpace::Clone() const {
  return New(
      mojo::Clone(primaries),
      mojo::Clone(transfer),
      mojo::Clone(matrix),
      mojo::Clone(range)
  );
}

template <typename T, VideoColorSpace::EnableIfSame<T>*>
bool VideoColorSpace::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primaries, other_struct.primaries))
    return false;
  if (!mojo::Equals(this->transfer, other_struct.transfer))
    return false;
  if (!mojo::Equals(this->matrix, other_struct.matrix))
    return false;
  if (!mojo::Equals(this->range, other_struct.range))
    return false;
  return true;
}

template <typename T, VideoColorSpace::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.primaries < rhs.primaries)
    return true;
  if (rhs.primaries < lhs.primaries)
    return false;
  if (lhs.transfer < rhs.transfer)
    return true;
  if (rhs.transfer < lhs.transfer)
    return false;
  if (lhs.matrix < rhs.matrix)
    return true;
  if (rhs.matrix < lhs.matrix)
    return false;
  if (lhs.range < rhs.range)
    return true;
  if (rhs.range < lhs.range)
    return false;
  return false;
}
template <typename StructPtrType>
AudioDecoderConfigPtr AudioDecoderConfig::Clone() const {
  return New(
      mojo::Clone(codec),
      mojo::Clone(sample_format),
      mojo::Clone(channel_layout),
      mojo::Clone(samples_per_second),
      mojo::Clone(extra_data),
      mojo::Clone(encryption_scheme),
      mojo::Clone(seek_preroll),
      mojo::Clone(codec_delay),
      mojo::Clone(profile),
      mojo::Clone(target_output_channel_layout),
      mojo::Clone(target_output_sample_format),
      mojo::Clone(should_discard_decoder_delay)
  );
}

template <typename T, AudioDecoderConfig::EnableIfSame<T>*>
bool AudioDecoderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->codec, other_struct.codec))
    return false;
  if (!mojo::Equals(this->sample_format, other_struct.sample_format))
    return false;
  if (!mojo::Equals(this->channel_layout, other_struct.channel_layout))
    return false;
  if (!mojo::Equals(this->samples_per_second, other_struct.samples_per_second))
    return false;
  if (!mojo::Equals(this->extra_data, other_struct.extra_data))
    return false;
  if (!mojo::Equals(this->encryption_scheme, other_struct.encryption_scheme))
    return false;
  if (!mojo::Equals(this->seek_preroll, other_struct.seek_preroll))
    return false;
  if (!mojo::Equals(this->codec_delay, other_struct.codec_delay))
    return false;
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->target_output_channel_layout, other_struct.target_output_channel_layout))
    return false;
  if (!mojo::Equals(this->target_output_sample_format, other_struct.target_output_sample_format))
    return false;
  if (!mojo::Equals(this->should_discard_decoder_delay, other_struct.should_discard_decoder_delay))
    return false;
  return true;
}

template <typename T, AudioDecoderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.codec < rhs.codec)
    return true;
  if (rhs.codec < lhs.codec)
    return false;
  if (lhs.sample_format < rhs.sample_format)
    return true;
  if (rhs.sample_format < lhs.sample_format)
    return false;
  if (lhs.channel_layout < rhs.channel_layout)
    return true;
  if (rhs.channel_layout < lhs.channel_layout)
    return false;
  if (lhs.samples_per_second < rhs.samples_per_second)
    return true;
  if (rhs.samples_per_second < lhs.samples_per_second)
    return false;
  if (lhs.extra_data < rhs.extra_data)
    return true;
  if (rhs.extra_data < lhs.extra_data)
    return false;
  if (lhs.encryption_scheme < rhs.encryption_scheme)
    return true;
  if (rhs.encryption_scheme < lhs.encryption_scheme)
    return false;
  if (lhs.seek_preroll < rhs.seek_preroll)
    return true;
  if (rhs.seek_preroll < lhs.seek_preroll)
    return false;
  if (lhs.codec_delay < rhs.codec_delay)
    return true;
  if (rhs.codec_delay < lhs.codec_delay)
    return false;
  if (lhs.profile < rhs.profile)
    return true;
  if (rhs.profile < lhs.profile)
    return false;
  if (lhs.target_output_channel_layout < rhs.target_output_channel_layout)
    return true;
  if (rhs.target_output_channel_layout < lhs.target_output_channel_layout)
    return false;
  if (lhs.target_output_sample_format < rhs.target_output_sample_format)
    return true;
  if (rhs.target_output_sample_format < lhs.target_output_sample_format)
    return false;
  if (lhs.should_discard_decoder_delay < rhs.should_discard_decoder_delay)
    return true;
  if (rhs.should_discard_decoder_delay < lhs.should_discard_decoder_delay)
    return false;
  return false;
}
template <typename StructPtrType>
VideoDecoderConfigPtr VideoDecoderConfig::Clone() const {
  return New(
      mojo::Clone(codec),
      mojo::Clone(profile),
      mojo::Clone(level),
      mojo::Clone(has_alpha),
      mojo::Clone(transformation),
      mojo::Clone(coded_size),
      mojo::Clone(visible_rect),
      mojo::Clone(natural_size),
      mojo::Clone(aspect_ratio),
      mojo::Clone(extra_data),
      mojo::Clone(encryption_scheme),
      mojo::Clone(color_space_info),
      mojo::Clone(hdr_metadata)
  );
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>*>
bool VideoDecoderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->codec, other_struct.codec))
    return false;
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->level, other_struct.level))
    return false;
  if (!mojo::Equals(this->has_alpha, other_struct.has_alpha))
    return false;
  if (!mojo::Equals(this->transformation, other_struct.transformation))
    return false;
  if (!mojo::Equals(this->coded_size, other_struct.coded_size))
    return false;
  if (!mojo::Equals(this->visible_rect, other_struct.visible_rect))
    return false;
  if (!mojo::Equals(this->natural_size, other_struct.natural_size))
    return false;
  if (!mojo::Equals(this->aspect_ratio, other_struct.aspect_ratio))
    return false;
  if (!mojo::Equals(this->extra_data, other_struct.extra_data))
    return false;
  if (!mojo::Equals(this->encryption_scheme, other_struct.encryption_scheme))
    return false;
  if (!mojo::Equals(this->color_space_info, other_struct.color_space_info))
    return false;
  if (!mojo::Equals(this->hdr_metadata, other_struct.hdr_metadata))
    return false;
  return true;
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.codec < rhs.codec)
    return true;
  if (rhs.codec < lhs.codec)
    return false;
  if (lhs.profile < rhs.profile)
    return true;
  if (rhs.profile < lhs.profile)
    return false;
  if (lhs.level < rhs.level)
    return true;
  if (rhs.level < lhs.level)
    return false;
  if (lhs.has_alpha < rhs.has_alpha)
    return true;
  if (rhs.has_alpha < lhs.has_alpha)
    return false;
  if (lhs.transformation < rhs.transformation)
    return true;
  if (rhs.transformation < lhs.transformation)
    return false;
  if (lhs.coded_size < rhs.coded_size)
    return true;
  if (rhs.coded_size < lhs.coded_size)
    return false;
  if (lhs.visible_rect < rhs.visible_rect)
    return true;
  if (rhs.visible_rect < lhs.visible_rect)
    return false;
  if (lhs.natural_size < rhs.natural_size)
    return true;
  if (rhs.natural_size < lhs.natural_size)
    return false;
  if (lhs.aspect_ratio < rhs.aspect_ratio)
    return true;
  if (rhs.aspect_ratio < lhs.aspect_ratio)
    return false;
  if (lhs.extra_data < rhs.extra_data)
    return true;
  if (rhs.extra_data < lhs.extra_data)
    return false;
  if (lhs.encryption_scheme < rhs.encryption_scheme)
    return true;
  if (rhs.encryption_scheme < lhs.encryption_scheme)
    return false;
  if (lhs.color_space_info < rhs.color_space_info)
    return true;
  if (rhs.color_space_info < lhs.color_space_info)
    return false;
  if (lhs.hdr_metadata < rhs.hdr_metadata)
    return true;
  if (rhs.hdr_metadata < lhs.hdr_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
DecryptConfigPtr DecryptConfig::Clone() const {
  return New(
      mojo::Clone(encryption_scheme),
      mojo::Clone(key_id),
      mojo::Clone(iv),
      mojo::Clone(subsamples),
      mojo::Clone(encryption_pattern)
  );
}

template <typename T, DecryptConfig::EnableIfSame<T>*>
bool DecryptConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->encryption_scheme, other_struct.encryption_scheme))
    return false;
  if (!mojo::Equals(this->key_id, other_struct.key_id))
    return false;
  if (!mojo::Equals(this->iv, other_struct.iv))
    return false;
  if (!mojo::Equals(this->subsamples, other_struct.subsamples))
    return false;
  if (!mojo::Equals(this->encryption_pattern, other_struct.encryption_pattern))
    return false;
  return true;
}

template <typename T, DecryptConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.encryption_scheme < rhs.encryption_scheme)
    return true;
  if (rhs.encryption_scheme < lhs.encryption_scheme)
    return false;
  if (lhs.key_id < rhs.key_id)
    return true;
  if (rhs.key_id < lhs.key_id)
    return false;
  if (lhs.iv < rhs.iv)
    return true;
  if (rhs.iv < lhs.iv)
    return false;
  if (lhs.subsamples < rhs.subsamples)
    return true;
  if (rhs.subsamples < lhs.subsamples)
    return false;
  if (lhs.encryption_pattern < rhs.encryption_pattern)
    return true;
  if (rhs.encryption_pattern < lhs.encryption_pattern)
    return false;
  return false;
}
template <typename StructPtrType>
DecoderBufferSideDataPtr DecoderBufferSideData::Clone() const {
  return New(
      mojo::Clone(spatial_layers),
      mojo::Clone(alpha_data),
      mojo::Clone(secure_handle),
      mojo::Clone(front_discard),
      mojo::Clone(back_discard)
  );
}

template <typename T, DecoderBufferSideData::EnableIfSame<T>*>
bool DecoderBufferSideData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->spatial_layers, other_struct.spatial_layers))
    return false;
  if (!mojo::Equals(this->alpha_data, other_struct.alpha_data))
    return false;
  if (!mojo::Equals(this->secure_handle, other_struct.secure_handle))
    return false;
  if (!mojo::Equals(this->front_discard, other_struct.front_discard))
    return false;
  if (!mojo::Equals(this->back_discard, other_struct.back_discard))
    return false;
  return true;
}

template <typename T, DecoderBufferSideData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.spatial_layers < rhs.spatial_layers)
    return true;
  if (rhs.spatial_layers < lhs.spatial_layers)
    return false;
  if (lhs.alpha_data < rhs.alpha_data)
    return true;
  if (rhs.alpha_data < lhs.alpha_data)
    return false;
  if (lhs.secure_handle < rhs.secure_handle)
    return true;
  if (rhs.secure_handle < lhs.secure_handle)
    return false;
  if (lhs.front_discard < rhs.front_discard)
    return true;
  if (rhs.front_discard < lhs.front_discard)
    return false;
  if (lhs.back_discard < rhs.back_discard)
    return true;
  if (rhs.back_discard < lhs.back_discard)
    return false;
  return false;
}
template <typename StructPtrType>
DataDecoderBufferPtr DataDecoderBuffer::Clone() const {
  return New(
      mojo::Clone(timestamp),
      mojo::Clone(duration),
      mojo::Clone(data_size),
      mojo::Clone(is_key_frame),
      mojo::Clone(decrypt_config),
      mojo::Clone(side_data)
  );
}

template <typename T, DataDecoderBuffer::EnableIfSame<T>*>
bool DataDecoderBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  if (!mojo::Equals(this->data_size, other_struct.data_size))
    return false;
  if (!mojo::Equals(this->is_key_frame, other_struct.is_key_frame))
    return false;
  if (!mojo::Equals(this->decrypt_config, other_struct.decrypt_config))
    return false;
  if (!mojo::Equals(this->side_data, other_struct.side_data))
    return false;
  return true;
}

template <typename T, DataDecoderBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  if (lhs.data_size < rhs.data_size)
    return true;
  if (rhs.data_size < lhs.data_size)
    return false;
  if (lhs.is_key_frame < rhs.is_key_frame)
    return true;
  if (rhs.is_key_frame < lhs.is_key_frame)
    return false;
  if (lhs.decrypt_config < rhs.decrypt_config)
    return true;
  if (rhs.decrypt_config < lhs.decrypt_config)
    return false;
  if (lhs.side_data < rhs.side_data)
    return true;
  if (rhs.side_data < lhs.side_data)
    return false;
  return false;
}
template <typename StructPtrType>
EosDecoderBufferPtr EosDecoderBuffer::Clone() const {
  return New(
      mojo::Clone(next_config)
  );
}

template <typename T, EosDecoderBuffer::EnableIfSame<T>*>
bool EosDecoderBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->next_config, other_struct.next_config))
    return false;
  return true;
}

template <typename T, EosDecoderBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.next_config < rhs.next_config)
    return true;
  if (rhs.next_config < lhs.next_config)
    return false;
  return false;
}
template <typename StructPtrType>
AudioBufferPtr AudioBuffer::Clone() const {
  return New(
      mojo::Clone(sample_format),
      mojo::Clone(channel_layout),
      mojo::Clone(channel_count),
      mojo::Clone(sample_rate),
      mojo::Clone(frame_count),
      mojo::Clone(end_of_stream),
      mojo::Clone(timestamp),
      mojo::Clone(data)
  );
}

template <typename T, AudioBuffer::EnableIfSame<T>*>
bool AudioBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sample_format, other_struct.sample_format))
    return false;
  if (!mojo::Equals(this->channel_layout, other_struct.channel_layout))
    return false;
  if (!mojo::Equals(this->channel_count, other_struct.channel_count))
    return false;
  if (!mojo::Equals(this->sample_rate, other_struct.sample_rate))
    return false;
  if (!mojo::Equals(this->frame_count, other_struct.frame_count))
    return false;
  if (!mojo::Equals(this->end_of_stream, other_struct.end_of_stream))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, AudioBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sample_format < rhs.sample_format)
    return true;
  if (rhs.sample_format < lhs.sample_format)
    return false;
  if (lhs.channel_layout < rhs.channel_layout)
    return true;
  if (rhs.channel_layout < lhs.channel_layout)
    return false;
  if (lhs.channel_count < rhs.channel_count)
    return true;
  if (rhs.channel_count < lhs.channel_count)
    return false;
  if (lhs.sample_rate < rhs.sample_rate)
    return true;
  if (rhs.sample_rate < lhs.sample_rate)
    return false;
  if (lhs.frame_count < rhs.frame_count)
    return true;
  if (rhs.frame_count < lhs.frame_count)
    return false;
  if (lhs.end_of_stream < rhs.end_of_stream)
    return true;
  if (rhs.end_of_stream < lhs.end_of_stream)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
VideoFrameMetadataPtr VideoFrameMetadata::Clone() const {
  return New(
      mojo::Clone(allow_overlay),
      mojo::Clone(capture_begin_time),
      mojo::Clone(capture_end_time),
      mojo::Clone(has_capture_counter),
      mojo::Clone(capture_counter),
      mojo::Clone(capture_update_rect),
      mojo::Clone(source_size),
      mojo::Clone(region_capture_rect),
      mojo::Clone(sub_capture_target_version),
      mojo::Clone(copy_required),
      mojo::Clone(end_of_stream),
      mojo::Clone(frame_duration),
      mojo::Clone(has_frame_rate),
      mojo::Clone(frame_rate),
      mojo::Clone(interactive_content),
      mojo::Clone(reference_time),
      mojo::Clone(read_lock_fences_enabled),
      mojo::Clone(transformation),
      mojo::Clone(in_surface_view),
      mojo::Clone(wants_promotion_hint),
      mojo::Clone(protected_video),
      mojo::Clone(hw_protected),
      mojo::Clone(needs_detiling),
      mojo::Clone(is_webgpu_compatible),
      mojo::Clone(tracking_token),
      mojo::Clone(power_efficient),
      mojo::Clone(has_device_scale_factor),
      mojo::Clone(device_scale_factor),
      mojo::Clone(has_page_scale_factor),
      mojo::Clone(page_scale_factor),
      mojo::Clone(has_root_scroll_offset_x),
      mojo::Clone(root_scroll_offset_x),
      mojo::Clone(has_root_scroll_offset_y),
      mojo::Clone(root_scroll_offset_y),
      mojo::Clone(has_top_controls_visible_height),
      mojo::Clone(top_controls_visible_height),
      mojo::Clone(decode_begin_time),
      mojo::Clone(decode_end_time),
      mojo::Clone(processing_time),
      mojo::Clone(has_rtp_timestamp),
      mojo::Clone(rtp_timestamp),
      mojo::Clone(receive_time),
      mojo::Clone(wallclock_frame_duration),
      mojo::Clone(frame_sequence),
      mojo::Clone(source_id),
      mojo::Clone(background_blur)
  );
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>*>
bool VideoFrameMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_overlay, other_struct.allow_overlay))
    return false;
  if (!mojo::Equals(this->capture_begin_time, other_struct.capture_begin_time))
    return false;
  if (!mojo::Equals(this->capture_end_time, other_struct.capture_end_time))
    return false;
  if (!mojo::Equals(this->has_capture_counter, other_struct.has_capture_counter))
    return false;
  if (!mojo::Equals(this->capture_counter, other_struct.capture_counter))
    return false;
  if (!mojo::Equals(this->capture_update_rect, other_struct.capture_update_rect))
    return false;
  if (!mojo::Equals(this->source_size, other_struct.source_size))
    return false;
  if (!mojo::Equals(this->region_capture_rect, other_struct.region_capture_rect))
    return false;
  if (!mojo::Equals(this->sub_capture_target_version, other_struct.sub_capture_target_version))
    return false;
  if (!mojo::Equals(this->copy_required, other_struct.copy_required))
    return false;
  if (!mojo::Equals(this->end_of_stream, other_struct.end_of_stream))
    return false;
  if (!mojo::Equals(this->frame_duration, other_struct.frame_duration))
    return false;
  if (!mojo::Equals(this->has_frame_rate, other_struct.has_frame_rate))
    return false;
  if (!mojo::Equals(this->frame_rate, other_struct.frame_rate))
    return false;
  if (!mojo::Equals(this->interactive_content, other_struct.interactive_content))
    return false;
  if (!mojo::Equals(this->reference_time, other_struct.reference_time))
    return false;
  if (!mojo::Equals(this->read_lock_fences_enabled, other_struct.read_lock_fences_enabled))
    return false;
  if (!mojo::Equals(this->transformation, other_struct.transformation))
    return false;
  if (!mojo::Equals(this->in_surface_view, other_struct.in_surface_view))
    return false;
  if (!mojo::Equals(this->wants_promotion_hint, other_struct.wants_promotion_hint))
    return false;
  if (!mojo::Equals(this->protected_video, other_struct.protected_video))
    return false;
  if (!mojo::Equals(this->hw_protected, other_struct.hw_protected))
    return false;
  if (!mojo::Equals(this->needs_detiling, other_struct.needs_detiling))
    return false;
  if (!mojo::Equals(this->is_webgpu_compatible, other_struct.is_webgpu_compatible))
    return false;
  if (!mojo::Equals(this->tracking_token, other_struct.tracking_token))
    return false;
  if (!mojo::Equals(this->power_efficient, other_struct.power_efficient))
    return false;
  if (!mojo::Equals(this->has_device_scale_factor, other_struct.has_device_scale_factor))
    return false;
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->has_page_scale_factor, other_struct.has_page_scale_factor))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->has_root_scroll_offset_x, other_struct.has_root_scroll_offset_x))
    return false;
  if (!mojo::Equals(this->root_scroll_offset_x, other_struct.root_scroll_offset_x))
    return false;
  if (!mojo::Equals(this->has_root_scroll_offset_y, other_struct.has_root_scroll_offset_y))
    return false;
  if (!mojo::Equals(this->root_scroll_offset_y, other_struct.root_scroll_offset_y))
    return false;
  if (!mojo::Equals(this->has_top_controls_visible_height, other_struct.has_top_controls_visible_height))
    return false;
  if (!mojo::Equals(this->top_controls_visible_height, other_struct.top_controls_visible_height))
    return false;
  if (!mojo::Equals(this->decode_begin_time, other_struct.decode_begin_time))
    return false;
  if (!mojo::Equals(this->decode_end_time, other_struct.decode_end_time))
    return false;
  if (!mojo::Equals(this->processing_time, other_struct.processing_time))
    return false;
  if (!mojo::Equals(this->has_rtp_timestamp, other_struct.has_rtp_timestamp))
    return false;
  if (!mojo::Equals(this->rtp_timestamp, other_struct.rtp_timestamp))
    return false;
  if (!mojo::Equals(this->receive_time, other_struct.receive_time))
    return false;
  if (!mojo::Equals(this->wallclock_frame_duration, other_struct.wallclock_frame_duration))
    return false;
  if (!mojo::Equals(this->frame_sequence, other_struct.frame_sequence))
    return false;
  if (!mojo::Equals(this->source_id, other_struct.source_id))
    return false;
  if (!mojo::Equals(this->background_blur, other_struct.background_blur))
    return false;
  return true;
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allow_overlay < rhs.allow_overlay)
    return true;
  if (rhs.allow_overlay < lhs.allow_overlay)
    return false;
  if (lhs.capture_begin_time < rhs.capture_begin_time)
    return true;
  if (rhs.capture_begin_time < lhs.capture_begin_time)
    return false;
  if (lhs.capture_end_time < rhs.capture_end_time)
    return true;
  if (rhs.capture_end_time < lhs.capture_end_time)
    return false;
  if (lhs.has_capture_counter < rhs.has_capture_counter)
    return true;
  if (rhs.has_capture_counter < lhs.has_capture_counter)
    return false;
  if (lhs.capture_counter < rhs.capture_counter)
    return true;
  if (rhs.capture_counter < lhs.capture_counter)
    return false;
  if (lhs.capture_update_rect < rhs.capture_update_rect)
    return true;
  if (rhs.capture_update_rect < lhs.capture_update_rect)
    return false;
  if (lhs.source_size < rhs.source_size)
    return true;
  if (rhs.source_size < lhs.source_size)
    return false;
  if (lhs.region_capture_rect < rhs.region_capture_rect)
    return true;
  if (rhs.region_capture_rect < lhs.region_capture_rect)
    return false;
  if (lhs.sub_capture_target_version < rhs.sub_capture_target_version)
    return true;
  if (rhs.sub_capture_target_version < lhs.sub_capture_target_version)
    return false;
  if (lhs.copy_required < rhs.copy_required)
    return true;
  if (rhs.copy_required < lhs.copy_required)
    return false;
  if (lhs.end_of_stream < rhs.end_of_stream)
    return true;
  if (rhs.end_of_stream < lhs.end_of_stream)
    return false;
  if (lhs.frame_duration < rhs.frame_duration)
    return true;
  if (rhs.frame_duration < lhs.frame_duration)
    return false;
  if (lhs.has_frame_rate < rhs.has_frame_rate)
    return true;
  if (rhs.has_frame_rate < lhs.has_frame_rate)
    return false;
  if (lhs.frame_rate < rhs.frame_rate)
    return true;
  if (rhs.frame_rate < lhs.frame_rate)
    return false;
  if (lhs.interactive_content < rhs.interactive_content)
    return true;
  if (rhs.interactive_content < lhs.interactive_content)
    return false;
  if (lhs.reference_time < rhs.reference_time)
    return true;
  if (rhs.reference_time < lhs.reference_time)
    return false;
  if (lhs.read_lock_fences_enabled < rhs.read_lock_fences_enabled)
    return true;
  if (rhs.read_lock_fences_enabled < lhs.read_lock_fences_enabled)
    return false;
  if (lhs.transformation < rhs.transformation)
    return true;
  if (rhs.transformation < lhs.transformation)
    return false;
  if (lhs.in_surface_view < rhs.in_surface_view)
    return true;
  if (rhs.in_surface_view < lhs.in_surface_view)
    return false;
  if (lhs.wants_promotion_hint < rhs.wants_promotion_hint)
    return true;
  if (rhs.wants_promotion_hint < lhs.wants_promotion_hint)
    return false;
  if (lhs.protected_video < rhs.protected_video)
    return true;
  if (rhs.protected_video < lhs.protected_video)
    return false;
  if (lhs.hw_protected < rhs.hw_protected)
    return true;
  if (rhs.hw_protected < lhs.hw_protected)
    return false;
  if (lhs.needs_detiling < rhs.needs_detiling)
    return true;
  if (rhs.needs_detiling < lhs.needs_detiling)
    return false;
  if (lhs.is_webgpu_compatible < rhs.is_webgpu_compatible)
    return true;
  if (rhs.is_webgpu_compatible < lhs.is_webgpu_compatible)
    return false;
  if (lhs.tracking_token < rhs.tracking_token)
    return true;
  if (rhs.tracking_token < lhs.tracking_token)
    return false;
  if (lhs.power_efficient < rhs.power_efficient)
    return true;
  if (rhs.power_efficient < lhs.power_efficient)
    return false;
  if (lhs.has_device_scale_factor < rhs.has_device_scale_factor)
    return true;
  if (rhs.has_device_scale_factor < lhs.has_device_scale_factor)
    return false;
  if (lhs.device_scale_factor < rhs.device_scale_factor)
    return true;
  if (rhs.device_scale_factor < lhs.device_scale_factor)
    return false;
  if (lhs.has_page_scale_factor < rhs.has_page_scale_factor)
    return true;
  if (rhs.has_page_scale_factor < lhs.has_page_scale_factor)
    return false;
  if (lhs.page_scale_factor < rhs.page_scale_factor)
    return true;
  if (rhs.page_scale_factor < lhs.page_scale_factor)
    return false;
  if (lhs.has_root_scroll_offset_x < rhs.has_root_scroll_offset_x)
    return true;
  if (rhs.has_root_scroll_offset_x < lhs.has_root_scroll_offset_x)
    return false;
  if (lhs.root_scroll_offset_x < rhs.root_scroll_offset_x)
    return true;
  if (rhs.root_scroll_offset_x < lhs.root_scroll_offset_x)
    return false;
  if (lhs.has_root_scroll_offset_y < rhs.has_root_scroll_offset_y)
    return true;
  if (rhs.has_root_scroll_offset_y < lhs.has_root_scroll_offset_y)
    return false;
  if (lhs.root_scroll_offset_y < rhs.root_scroll_offset_y)
    return true;
  if (rhs.root_scroll_offset_y < lhs.root_scroll_offset_y)
    return false;
  if (lhs.has_top_controls_visible_height < rhs.has_top_controls_visible_height)
    return true;
  if (rhs.has_top_controls_visible_height < lhs.has_top_controls_visible_height)
    return false;
  if (lhs.top_controls_visible_height < rhs.top_controls_visible_height)
    return true;
  if (rhs.top_controls_visible_height < lhs.top_controls_visible_height)
    return false;
  if (lhs.decode_begin_time < rhs.decode_begin_time)
    return true;
  if (rhs.decode_begin_time < lhs.decode_begin_time)
    return false;
  if (lhs.decode_end_time < rhs.decode_end_time)
    return true;
  if (rhs.decode_end_time < lhs.decode_end_time)
    return false;
  if (lhs.processing_time < rhs.processing_time)
    return true;
  if (rhs.processing_time < lhs.processing_time)
    return false;
  if (lhs.has_rtp_timestamp < rhs.has_rtp_timestamp)
    return true;
  if (rhs.has_rtp_timestamp < lhs.has_rtp_timestamp)
    return false;
  if (lhs.rtp_timestamp < rhs.rtp_timestamp)
    return true;
  if (rhs.rtp_timestamp < lhs.rtp_timestamp)
    return false;
  if (lhs.receive_time < rhs.receive_time)
    return true;
  if (rhs.receive_time < lhs.receive_time)
    return false;
  if (lhs.wallclock_frame_duration < rhs.wallclock_frame_duration)
    return true;
  if (rhs.wallclock_frame_duration < lhs.wallclock_frame_duration)
    return false;
  if (lhs.frame_sequence < rhs.frame_sequence)
    return true;
  if (rhs.frame_sequence < lhs.frame_sequence)
    return false;
  if (lhs.source_id < rhs.source_id)
    return true;
  if (rhs.source_id < lhs.source_id)
    return false;
  if (lhs.background_blur < rhs.background_blur)
    return true;
  if (rhs.background_blur < lhs.background_blur)
    return false;
  return false;
}
template <typename StructPtrType>
VideoFramePtr VideoFrame::Clone() const {
  return New(
      mojo::Clone(format),
      mojo::Clone(coded_size),
      mojo::Clone(visible_rect),
      mojo::Clone(natural_size),
      mojo::Clone(timestamp),
      mojo::Clone(data),
      mojo::Clone(metadata),
      mojo::Clone(color_space),
      mojo::Clone(hdr_metadata)
  );
}

template <typename T, VideoFrame::EnableIfSame<T>*>
bool VideoFrame::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->format, other_struct.format))
    return false;
  if (!mojo::Equals(this->coded_size, other_struct.coded_size))
    return false;
  if (!mojo::Equals(this->visible_rect, other_struct.visible_rect))
    return false;
  if (!mojo::Equals(this->natural_size, other_struct.natural_size))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  if (!mojo::Equals(this->color_space, other_struct.color_space))
    return false;
  if (!mojo::Equals(this->hdr_metadata, other_struct.hdr_metadata))
    return false;
  return true;
}

template <typename T, VideoFrame::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.format < rhs.format)
    return true;
  if (rhs.format < lhs.format)
    return false;
  if (lhs.coded_size < rhs.coded_size)
    return true;
  if (rhs.coded_size < lhs.coded_size)
    return false;
  if (lhs.visible_rect < rhs.visible_rect)
    return true;
  if (rhs.visible_rect < lhs.visible_rect)
    return false;
  if (lhs.natural_size < rhs.natural_size)
    return true;
  if (rhs.natural_size < lhs.natural_size)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  if (lhs.color_space < rhs.color_space)
    return true;
  if (rhs.color_space < lhs.color_space)
    return false;
  if (lhs.hdr_metadata < rhs.hdr_metadata)
    return true;
  if (rhs.hdr_metadata < lhs.hdr_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
EosVideoFrameDataPtr EosVideoFrameData::Clone() const {
  return New(
  );
}

template <typename T, EosVideoFrameData::EnableIfSame<T>*>
bool EosVideoFrameData::Equals(const T& other_struct) const {
  return true;
}

template <typename T, EosVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
SharedMemoryVideoFrameDataPtr SharedMemoryVideoFrameData::Clone() const {
  return New(
      mojo::Clone(frame_data),
      mojo::Clone(strides),
      mojo::Clone(offsets)
  );
}

template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>*>
bool SharedMemoryVideoFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_data, other_struct.frame_data))
    return false;
  if (!mojo::Equals(this->strides, other_struct.strides))
    return false;
  if (!mojo::Equals(this->offsets, other_struct.offsets))
    return false;
  return true;
}

template <typename T, SharedMemoryVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_data < rhs.frame_data)
    return true;
  if (rhs.frame_data < lhs.frame_data)
    return false;
  if (lhs.strides < rhs.strides)
    return true;
  if (rhs.strides < lhs.strides)
    return false;
  if (lhs.offsets < rhs.offsets)
    return true;
  if (rhs.offsets < lhs.offsets)
    return false;
  return false;
}
template <typename StructPtrType>
GpuMemoryBufferSharedImageVideoFrameDataPtr GpuMemoryBufferSharedImageVideoFrameData::Clone() const {
  return New(
      mojo::Clone(gpu_memory_buffer_handle),
      mojo::Clone(shared_image),
      mojo::Clone(sync_token)
  );
}

template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>*>
bool GpuMemoryBufferSharedImageVideoFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->gpu_memory_buffer_handle, other_struct.gpu_memory_buffer_handle))
    return false;
  if (!mojo::Equals(this->shared_image, other_struct.shared_image))
    return false;
  if (!mojo::Equals(this->sync_token, other_struct.sync_token))
    return false;
  return true;
}

template <typename T, GpuMemoryBufferSharedImageVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.gpu_memory_buffer_handle < rhs.gpu_memory_buffer_handle)
    return true;
  if (rhs.gpu_memory_buffer_handle < lhs.gpu_memory_buffer_handle)
    return false;
  if (lhs.shared_image < rhs.shared_image)
    return true;
  if (rhs.shared_image < lhs.shared_image)
    return false;
  if (lhs.sync_token < rhs.sync_token)
    return true;
  if (rhs.sync_token < lhs.sync_token)
    return false;
  return false;
}
template <typename StructPtrType>
SharedImageVideoFrameDataPtr SharedImageVideoFrameData::Clone() const {
  return New(
      mojo::Clone(shared_image),
      mojo::Clone(sync_token),
      mojo::Clone(is_mappable_si_enabled)
  );
}

template <typename T, SharedImageVideoFrameData::EnableIfSame<T>*>
bool SharedImageVideoFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->shared_image, other_struct.shared_image))
    return false;
  if (!mojo::Equals(this->sync_token, other_struct.sync_token))
    return false;
  if (!mojo::Equals(this->is_mappable_si_enabled, other_struct.is_mappable_si_enabled))
    return false;
  return true;
}

template <typename T, SharedImageVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.shared_image < rhs.shared_image)
    return true;
  if (rhs.shared_image < lhs.shared_image)
    return false;
  if (lhs.sync_token < rhs.sync_token)
    return true;
  if (rhs.sync_token < lhs.sync_token)
    return false;
  if (lhs.is_mappable_si_enabled < rhs.is_mappable_si_enabled)
    return true;
  if (rhs.is_mappable_si_enabled < lhs.is_mappable_si_enabled)
    return false;
  return false;
}
template <typename StructPtrType>
OpaqueVideoFrameDataPtr OpaqueVideoFrameData::Clone() const {
  return New(
  );
}

template <typename T, OpaqueVideoFrameData::EnableIfSame<T>*>
bool OpaqueVideoFrameData::Equals(const T& other_struct) const {
  return true;
}

template <typename T, OpaqueVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
ColorPlaneLayoutPtr ColorPlaneLayout::Clone() const {
  return New(
      mojo::Clone(stride),
      mojo::Clone(offset),
      mojo::Clone(size)
  );
}

template <typename T, ColorPlaneLayout::EnableIfSame<T>*>
bool ColorPlaneLayout::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stride, other_struct.stride))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  return true;
}

template <typename T, ColorPlaneLayout::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.stride < rhs.stride)
    return true;
  if (rhs.stride < lhs.stride)
    return false;
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  return false;
}
template <typename StructPtrType>
DmabufVideoFrameDataPtr DmabufVideoFrameData::Clone() const {
  return New(
      mojo::Clone(planes),
      mojo::Clone(is_multi_planar),
      mojo::Clone(buffer_addr_align),
      mojo::Clone(modifier),
      mojo::Clone(fds)
  );
}

template <typename T, DmabufVideoFrameData::EnableIfSame<T>*>
bool DmabufVideoFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->planes, other_struct.planes))
    return false;
  if (!mojo::Equals(this->is_multi_planar, other_struct.is_multi_planar))
    return false;
  if (!mojo::Equals(this->buffer_addr_align, other_struct.buffer_addr_align))
    return false;
  if (!mojo::Equals(this->modifier, other_struct.modifier))
    return false;
  if (!mojo::Equals(this->fds, other_struct.fds))
    return false;
  return true;
}

template <typename T, DmabufVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.planes < rhs.planes)
    return true;
  if (rhs.planes < lhs.planes)
    return false;
  if (lhs.is_multi_planar < rhs.is_multi_planar)
    return true;
  if (rhs.is_multi_planar < lhs.is_multi_planar)
    return false;
  if (lhs.buffer_addr_align < rhs.buffer_addr_align)
    return true;
  if (rhs.buffer_addr_align < lhs.buffer_addr_align)
    return false;
  if (lhs.modifier < rhs.modifier)
    return true;
  if (rhs.modifier < lhs.modifier)
    return false;
  if (lhs.fds < rhs.fds)
    return true;
  if (rhs.fds < lhs.fds)
    return false;
  return false;
}
template <typename StructPtrType>
PipelineStatisticsPtr PipelineStatistics::Clone() const {
  return New(
      mojo::Clone(audio_bytes_decoded),
      mojo::Clone(video_bytes_decoded),
      mojo::Clone(video_frames_decoded),
      mojo::Clone(video_frames_dropped),
      mojo::Clone(audio_memory_usage),
      mojo::Clone(video_memory_usage)
  );
}

template <typename T, PipelineStatistics::EnableIfSame<T>*>
bool PipelineStatistics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->audio_bytes_decoded, other_struct.audio_bytes_decoded))
    return false;
  if (!mojo::Equals(this->video_bytes_decoded, other_struct.video_bytes_decoded))
    return false;
  if (!mojo::Equals(this->video_frames_decoded, other_struct.video_frames_decoded))
    return false;
  if (!mojo::Equals(this->video_frames_dropped, other_struct.video_frames_dropped))
    return false;
  if (!mojo::Equals(this->audio_memory_usage, other_struct.audio_memory_usage))
    return false;
  if (!mojo::Equals(this->video_memory_usage, other_struct.video_memory_usage))
    return false;
  return true;
}

template <typename T, PipelineStatistics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.audio_bytes_decoded < rhs.audio_bytes_decoded)
    return true;
  if (rhs.audio_bytes_decoded < lhs.audio_bytes_decoded)
    return false;
  if (lhs.video_bytes_decoded < rhs.video_bytes_decoded)
    return true;
  if (rhs.video_bytes_decoded < lhs.video_bytes_decoded)
    return false;
  if (lhs.video_frames_decoded < rhs.video_frames_decoded)
    return true;
  if (rhs.video_frames_decoded < lhs.video_frames_decoded)
    return false;
  if (lhs.video_frames_dropped < rhs.video_frames_dropped)
    return true;
  if (rhs.video_frames_dropped < lhs.video_frames_dropped)
    return false;
  if (lhs.audio_memory_usage < rhs.audio_memory_usage)
    return true;
  if (rhs.audio_memory_usage < lhs.audio_memory_usage)
    return false;
  if (lhs.video_memory_usage < rhs.video_memory_usage)
    return true;
  if (rhs.video_memory_usage < lhs.video_memory_usage)
    return false;
  return false;
}
template <typename StructPtrType>
PredictionFeaturesPtr PredictionFeatures::Clone() const {
  return New(
      mojo::Clone(profile),
      mojo::Clone(video_size),
      mojo::Clone(frames_per_sec),
      mojo::Clone(key_system),
      mojo::Clone(use_hw_secure_codecs)
  );
}

template <typename T, PredictionFeatures::EnableIfSame<T>*>
bool PredictionFeatures::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->video_size, other_struct.video_size))
    return false;
  if (!mojo::Equals(this->frames_per_sec, other_struct.frames_per_sec))
    return false;
  if (!mojo::Equals(this->key_system, other_struct.key_system))
    return false;
  if (!mojo::Equals(this->use_hw_secure_codecs, other_struct.use_hw_secure_codecs))
    return false;
  return true;
}

template <typename T, PredictionFeatures::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.profile < rhs.profile)
    return true;
  if (rhs.profile < lhs.profile)
    return false;
  if (lhs.video_size < rhs.video_size)
    return true;
  if (rhs.video_size < lhs.video_size)
    return false;
  if (lhs.frames_per_sec < rhs.frames_per_sec)
    return true;
  if (rhs.frames_per_sec < lhs.frames_per_sec)
    return false;
  if (lhs.key_system < rhs.key_system)
    return true;
  if (rhs.key_system < lhs.key_system)
    return false;
  if (lhs.use_hw_secure_codecs < rhs.use_hw_secure_codecs)
    return true;
  if (rhs.use_hw_secure_codecs < lhs.use_hw_secure_codecs)
    return false;
  return false;
}
template <typename StructPtrType>
PredictionTargetsPtr PredictionTargets::Clone() const {
  return New(
      mojo::Clone(frames_decoded),
      mojo::Clone(frames_dropped),
      mojo::Clone(frames_power_efficient)
  );
}

template <typename T, PredictionTargets::EnableIfSame<T>*>
bool PredictionTargets::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frames_decoded, other_struct.frames_decoded))
    return false;
  if (!mojo::Equals(this->frames_dropped, other_struct.frames_dropped))
    return false;
  if (!mojo::Equals(this->frames_power_efficient, other_struct.frames_power_efficient))
    return false;
  return true;
}

template <typename T, PredictionTargets::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frames_decoded < rhs.frames_decoded)
    return true;
  if (rhs.frames_decoded < lhs.frames_decoded)
    return false;
  if (lhs.frames_dropped < rhs.frames_dropped)
    return true;
  if (rhs.frames_dropped < lhs.frames_dropped)
    return false;
  if (lhs.frames_power_efficient < rhs.frames_power_efficient)
    return true;
  if (rhs.frames_power_efficient < lhs.frames_power_efficient)
    return false;
  return false;
}
template <typename StructPtrType>
AudioPipelineInfoPtr AudioPipelineInfo::Clone() const {
  return New(
      mojo::Clone(decoder_type),
      mojo::Clone(is_platform_decoder),
      mojo::Clone(has_decrypting_demuxer_stream),
      mojo::Clone(encryption_type)
  );
}

template <typename T, AudioPipelineInfo::EnableIfSame<T>*>
bool AudioPipelineInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->decoder_type, other_struct.decoder_type))
    return false;
  if (!mojo::Equals(this->is_platform_decoder, other_struct.is_platform_decoder))
    return false;
  if (!mojo::Equals(this->has_decrypting_demuxer_stream, other_struct.has_decrypting_demuxer_stream))
    return false;
  if (!mojo::Equals(this->encryption_type, other_struct.encryption_type))
    return false;
  return true;
}

template <typename T, AudioPipelineInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.decoder_type < rhs.decoder_type)
    return true;
  if (rhs.decoder_type < lhs.decoder_type)
    return false;
  if (lhs.is_platform_decoder < rhs.is_platform_decoder)
    return true;
  if (rhs.is_platform_decoder < lhs.is_platform_decoder)
    return false;
  if (lhs.has_decrypting_demuxer_stream < rhs.has_decrypting_demuxer_stream)
    return true;
  if (rhs.has_decrypting_demuxer_stream < lhs.has_decrypting_demuxer_stream)
    return false;
  if (lhs.encryption_type < rhs.encryption_type)
    return true;
  if (rhs.encryption_type < lhs.encryption_type)
    return false;
  return false;
}
template <typename StructPtrType>
VideoPipelineInfoPtr VideoPipelineInfo::Clone() const {
  return New(
      mojo::Clone(decoder_type),
      mojo::Clone(is_platform_decoder),
      mojo::Clone(has_decrypting_demuxer_stream),
      mojo::Clone(encryption_type)
  );
}

template <typename T, VideoPipelineInfo::EnableIfSame<T>*>
bool VideoPipelineInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->decoder_type, other_struct.decoder_type))
    return false;
  if (!mojo::Equals(this->is_platform_decoder, other_struct.is_platform_decoder))
    return false;
  if (!mojo::Equals(this->has_decrypting_demuxer_stream, other_struct.has_decrypting_demuxer_stream))
    return false;
  if (!mojo::Equals(this->encryption_type, other_struct.encryption_type))
    return false;
  return true;
}

template <typename T, VideoPipelineInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.decoder_type < rhs.decoder_type)
    return true;
  if (rhs.decoder_type < lhs.decoder_type)
    return false;
  if (lhs.is_platform_decoder < rhs.is_platform_decoder)
    return true;
  if (rhs.is_platform_decoder < lhs.is_platform_decoder)
    return false;
  if (lhs.has_decrypting_demuxer_stream < rhs.has_decrypting_demuxer_stream)
    return true;
  if (rhs.has_decrypting_demuxer_stream < lhs.has_decrypting_demuxer_stream)
    return false;
  if (lhs.encryption_type < rhs.encryption_type)
    return true;
  if (rhs.encryption_type < lhs.encryption_type)
    return false;
  return false;
}
template <typename StructPtrType>
StatusDataPtr StatusData::Clone() const {
  return New(
      mojo::Clone(group),
      mojo::Clone(code),
      mojo::Clone(message),
      mojo::Clone(frames),
      mojo::Clone(cause),
      mojo::Clone(data)
  );
}

template <typename T, StatusData::EnableIfSame<T>*>
bool StatusData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->group, other_struct.group))
    return false;
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->frames, other_struct.frames))
    return false;
  if (!mojo::Equals(this->cause, other_struct.cause))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, StatusData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.group < rhs.group)
    return true;
  if (rhs.group < lhs.group)
    return false;
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  if (lhs.frames < rhs.frames)
    return true;
  if (rhs.frames < lhs.frames)
    return false;
  if (lhs.cause < rhs.cause)
    return true;
  if (rhs.cause < lhs.cause)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
EncoderStatusPtr EncoderStatus::Clone() const {
  return New(
      mojo::Clone(internal)
  );
}

template <typename T, EncoderStatus::EnableIfSame<T>*>
bool EncoderStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->internal, other_struct.internal))
    return false;
  return true;
}

template <typename T, EncoderStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.internal < rhs.internal)
    return true;
  if (rhs.internal < lhs.internal)
    return false;
  return false;
}
template <typename StructPtrType>
DecoderStatusPtr DecoderStatus::Clone() const {
  return New(
      mojo::Clone(internal)
  );
}

template <typename T, DecoderStatus::EnableIfSame<T>*>
bool DecoderStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->internal, other_struct.internal))
    return false;
  return true;
}

template <typename T, DecoderStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.internal < rhs.internal)
    return true;
  if (rhs.internal < lhs.internal)
    return false;
  return false;
}
template <typename StructPtrType>
PipelineStatusPtr PipelineStatus::Clone() const {
  return New(
      mojo::Clone(internal)
  );
}

template <typename T, PipelineStatus::EnableIfSame<T>*>
bool PipelineStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->internal, other_struct.internal))
    return false;
  return true;
}

template <typename T, PipelineStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.internal < rhs.internal)
    return true;
  if (rhs.internal < lhs.internal)
    return false;
  return false;
}
template <typename StructPtrType>
AutoPipInfoPtr AutoPipInfo::Clone() const {
  return New(
      mojo::Clone(auto_pip_reason),
      mojo::Clone(has_audio_focus),
      mojo::Clone(is_playing),
      mojo::Clone(was_recently_audible),
      mojo::Clone(has_safe_url),
      mojo::Clone(meets_media_engagement_conditions),
      mojo::Clone(blocked_due_to_content_setting)
  );
}

template <typename T, AutoPipInfo::EnableIfSame<T>*>
bool AutoPipInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->auto_pip_reason, other_struct.auto_pip_reason))
    return false;
  if (!mojo::Equals(this->has_audio_focus, other_struct.has_audio_focus))
    return false;
  if (!mojo::Equals(this->is_playing, other_struct.is_playing))
    return false;
  if (!mojo::Equals(this->was_recently_audible, other_struct.was_recently_audible))
    return false;
  if (!mojo::Equals(this->has_safe_url, other_struct.has_safe_url))
    return false;
  if (!mojo::Equals(this->meets_media_engagement_conditions, other_struct.meets_media_engagement_conditions))
    return false;
  if (!mojo::Equals(this->blocked_due_to_content_setting, other_struct.blocked_due_to_content_setting))
    return false;
  return true;
}

template <typename T, AutoPipInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.auto_pip_reason < rhs.auto_pip_reason)
    return true;
  if (rhs.auto_pip_reason < lhs.auto_pip_reason)
    return false;
  if (lhs.has_audio_focus < rhs.has_audio_focus)
    return true;
  if (rhs.has_audio_focus < lhs.has_audio_focus)
    return false;
  if (lhs.is_playing < rhs.is_playing)
    return true;
  if (rhs.is_playing < lhs.is_playing)
    return false;
  if (lhs.was_recently_audible < rhs.was_recently_audible)
    return true;
  if (rhs.was_recently_audible < lhs.was_recently_audible)
    return false;
  if (lhs.has_safe_url < rhs.has_safe_url)
    return true;
  if (rhs.has_safe_url < lhs.has_safe_url)
    return false;
  if (lhs.meets_media_engagement_conditions < rhs.meets_media_engagement_conditions)
    return true;
  if (rhs.meets_media_engagement_conditions < lhs.meets_media_engagement_conditions)
    return false;
  if (lhs.blocked_due_to_content_setting < rhs.blocked_due_to_content_setting)
    return true;
  if (rhs.blocked_due_to_content_setting < lhs.blocked_due_to_content_setting)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::VideoTransformation::DataView,
                                         ::media::mojom::VideoTransformationPtr> {
  static bool IsNull(const ::media::mojom::VideoTransformationPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoTransformationPtr* output) { output->reset(); }

  static decltype(::media::mojom::VideoTransformation::rotation) rotation(
      const ::media::mojom::VideoTransformationPtr& input) {
    return input->rotation;
  }

  static decltype(::media::mojom::VideoTransformation::mirrored) mirrored(
      const ::media::mojom::VideoTransformationPtr& input) {
    return input->mirrored;
  }

  static bool Read(::media::mojom::VideoTransformation::DataView input, ::media::mojom::VideoTransformationPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoAspectRatio::DataView,
                                         ::media::mojom::VideoAspectRatioPtr> {
  static bool IsNull(const ::media::mojom::VideoAspectRatioPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoAspectRatioPtr* output) { output->reset(); }

  static decltype(::media::mojom::VideoAspectRatio::type) type(
      const ::media::mojom::VideoAspectRatioPtr& input) {
    return input->type;
  }

  static decltype(::media::mojom::VideoAspectRatio::value) value(
      const ::media::mojom::VideoAspectRatioPtr& input) {
    return input->value;
  }

  static bool Read(::media::mojom::VideoAspectRatio::DataView input, ::media::mojom::VideoAspectRatioPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoColorSpace::DataView,
                                         ::media::mojom::VideoColorSpacePtr> {
  static bool IsNull(const ::media::mojom::VideoColorSpacePtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoColorSpacePtr* output) { output->reset(); }

  static decltype(::media::mojom::VideoColorSpace::primaries) primaries(
      const ::media::mojom::VideoColorSpacePtr& input) {
    return input->primaries;
  }

  static decltype(::media::mojom::VideoColorSpace::transfer) transfer(
      const ::media::mojom::VideoColorSpacePtr& input) {
    return input->transfer;
  }

  static decltype(::media::mojom::VideoColorSpace::matrix) matrix(
      const ::media::mojom::VideoColorSpacePtr& input) {
    return input->matrix;
  }

  static decltype(::media::mojom::VideoColorSpace::range) range(
      const ::media::mojom::VideoColorSpacePtr& input) {
    return input->range;
  }

  static bool Read(::media::mojom::VideoColorSpace::DataView input, ::media::mojom::VideoColorSpacePtr* output);
};


template <>
struct  StructTraits<::media::mojom::AudioDecoderConfig::DataView,
                                         ::media::mojom::AudioDecoderConfigPtr> {
  static bool IsNull(const ::media::mojom::AudioDecoderConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::AudioDecoderConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::AudioDecoderConfig::codec) codec(
      const ::media::mojom::AudioDecoderConfigPtr& input) {
    return input->codec;
  }

  static decltype(::media::mojom::AudioDecoderConfig::sample_format) sample_format(
      const ::media::mojom::AudioDecoderConfigPtr& input) {
    return input->sample_format;
  }

  static decltype(::media::mojom::AudioDecoderConfig::channel_layout) channel_layout(
      const ::media::mojom::AudioDecoderConfigPtr& input) {
    return input->channel_layout;
  }

  static decltype(::media::mojom::AudioDecoderConfig::samples_per_second) samples_per_second(
      const ::media::mojom::AudioDecoderConfigPtr& input) {
    return input->samples_per_second;
  }

  static const decltype(::media::mojom::AudioDecoderConfig::extra_data)& extra_data(
      const ::media::mojom::AudioDecoderConfigPtr& input) {
    return input->extra_data;
  }

  static decltype(::media::mojom::AudioDecoderConfig::encryption_scheme) encryption_scheme(
      const ::media::mojom::AudioDecoderConfigPtr& input) {
    return input->encryption_scheme;
  }

  static const decltype(::media::mojom::AudioDecoderConfig::seek_preroll)& seek_preroll(
      const ::media::mojom::AudioDecoderConfigPtr& input) {
    return input->seek_preroll;
  }

  static decltype(::media::mojom::AudioDecoderConfig::codec_delay) codec_delay(
      const ::media::mojom::AudioDecoderConfigPtr& input) {
    return input->codec_delay;
  }

  static decltype(::media::mojom::AudioDecoderConfig::profile) profile(
      const ::media::mojom::AudioDecoderConfigPtr& input) {
    return input->profile;
  }

  static decltype(::media::mojom::AudioDecoderConfig::target_output_channel_layout) target_output_channel_layout(
      const ::media::mojom::AudioDecoderConfigPtr& input) {
    return input->target_output_channel_layout;
  }

  static decltype(::media::mojom::AudioDecoderConfig::target_output_sample_format) target_output_sample_format(
      const ::media::mojom::AudioDecoderConfigPtr& input) {
    return input->target_output_sample_format;
  }

  static decltype(::media::mojom::AudioDecoderConfig::should_discard_decoder_delay) should_discard_decoder_delay(
      const ::media::mojom::AudioDecoderConfigPtr& input) {
    return input->should_discard_decoder_delay;
  }

  static bool Read(::media::mojom::AudioDecoderConfig::DataView input, ::media::mojom::AudioDecoderConfigPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoDecoderConfig::DataView,
                                         ::media::mojom::VideoDecoderConfigPtr> {
  static bool IsNull(const ::media::mojom::VideoDecoderConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoDecoderConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::VideoDecoderConfig::codec) codec(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->codec;
  }

  static decltype(::media::mojom::VideoDecoderConfig::profile) profile(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->profile;
  }

  static decltype(::media::mojom::VideoDecoderConfig::level) level(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->level;
  }

  static decltype(::media::mojom::VideoDecoderConfig::has_alpha) has_alpha(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->has_alpha;
  }

  static const decltype(::media::mojom::VideoDecoderConfig::transformation)& transformation(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->transformation;
  }

  static const decltype(::media::mojom::VideoDecoderConfig::coded_size)& coded_size(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->coded_size;
  }

  static const decltype(::media::mojom::VideoDecoderConfig::visible_rect)& visible_rect(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->visible_rect;
  }

  static const decltype(::media::mojom::VideoDecoderConfig::natural_size)& natural_size(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->natural_size;
  }

  static const decltype(::media::mojom::VideoDecoderConfig::aspect_ratio)& aspect_ratio(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->aspect_ratio;
  }

  static const decltype(::media::mojom::VideoDecoderConfig::extra_data)& extra_data(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->extra_data;
  }

  static decltype(::media::mojom::VideoDecoderConfig::encryption_scheme) encryption_scheme(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->encryption_scheme;
  }

  static const decltype(::media::mojom::VideoDecoderConfig::color_space_info)& color_space_info(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->color_space_info;
  }

  static const decltype(::media::mojom::VideoDecoderConfig::hdr_metadata)& hdr_metadata(
      const ::media::mojom::VideoDecoderConfigPtr& input) {
    return input->hdr_metadata;
  }

  static bool Read(::media::mojom::VideoDecoderConfig::DataView input, ::media::mojom::VideoDecoderConfigPtr* output);
};


template <>
struct  StructTraits<::media::mojom::DecryptConfig::DataView,
                                         ::media::mojom::DecryptConfigPtr> {
  static bool IsNull(const ::media::mojom::DecryptConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::DecryptConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::DecryptConfig::encryption_scheme) encryption_scheme(
      const ::media::mojom::DecryptConfigPtr& input) {
    return input->encryption_scheme;
  }

  static const decltype(::media::mojom::DecryptConfig::key_id)& key_id(
      const ::media::mojom::DecryptConfigPtr& input) {
    return input->key_id;
  }

  static const decltype(::media::mojom::DecryptConfig::iv)& iv(
      const ::media::mojom::DecryptConfigPtr& input) {
    return input->iv;
  }

  static const decltype(::media::mojom::DecryptConfig::subsamples)& subsamples(
      const ::media::mojom::DecryptConfigPtr& input) {
    return input->subsamples;
  }

  static const decltype(::media::mojom::DecryptConfig::encryption_pattern)& encryption_pattern(
      const ::media::mojom::DecryptConfigPtr& input) {
    return input->encryption_pattern;
  }

  static bool Read(::media::mojom::DecryptConfig::DataView input, ::media::mojom::DecryptConfigPtr* output);
};


template <>
struct  StructTraits<::media::mojom::DecoderBufferSideData::DataView,
                                         ::media::mojom::DecoderBufferSideDataPtr> {
  static bool IsNull(const ::media::mojom::DecoderBufferSideDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::DecoderBufferSideDataPtr* output) { output->reset(); }

  static const decltype(::media::mojom::DecoderBufferSideData::spatial_layers)& spatial_layers(
      const ::media::mojom::DecoderBufferSideDataPtr& input) {
    return input->spatial_layers;
  }

  static const decltype(::media::mojom::DecoderBufferSideData::alpha_data)& alpha_data(
      const ::media::mojom::DecoderBufferSideDataPtr& input) {
    return input->alpha_data;
  }

  static decltype(::media::mojom::DecoderBufferSideData::secure_handle) secure_handle(
      const ::media::mojom::DecoderBufferSideDataPtr& input) {
    return input->secure_handle;
  }

  static const decltype(::media::mojom::DecoderBufferSideData::front_discard)& front_discard(
      const ::media::mojom::DecoderBufferSideDataPtr& input) {
    return input->front_discard;
  }

  static const decltype(::media::mojom::DecoderBufferSideData::back_discard)& back_discard(
      const ::media::mojom::DecoderBufferSideDataPtr& input) {
    return input->back_discard;
  }

  static bool Read(::media::mojom::DecoderBufferSideData::DataView input, ::media::mojom::DecoderBufferSideDataPtr* output);
};


template <>
struct  StructTraits<::media::mojom::DataDecoderBuffer::DataView,
                                         ::media::mojom::DataDecoderBufferPtr> {
  static bool IsNull(const ::media::mojom::DataDecoderBufferPtr& input) { return !input; }
  static void SetToNull(::media::mojom::DataDecoderBufferPtr* output) { output->reset(); }

  static const decltype(::media::mojom::DataDecoderBuffer::timestamp)& timestamp(
      const ::media::mojom::DataDecoderBufferPtr& input) {
    return input->timestamp;
  }

  static const decltype(::media::mojom::DataDecoderBuffer::duration)& duration(
      const ::media::mojom::DataDecoderBufferPtr& input) {
    return input->duration;
  }

  static decltype(::media::mojom::DataDecoderBuffer::data_size) data_size(
      const ::media::mojom::DataDecoderBufferPtr& input) {
    return input->data_size;
  }

  static decltype(::media::mojom::DataDecoderBuffer::is_key_frame) is_key_frame(
      const ::media::mojom::DataDecoderBufferPtr& input) {
    return input->is_key_frame;
  }

  static const decltype(::media::mojom::DataDecoderBuffer::decrypt_config)& decrypt_config(
      const ::media::mojom::DataDecoderBufferPtr& input) {
    return input->decrypt_config;
  }

  static const decltype(::media::mojom::DataDecoderBuffer::side_data)& side_data(
      const ::media::mojom::DataDecoderBufferPtr& input) {
    return input->side_data;
  }

  static bool Read(::media::mojom::DataDecoderBuffer::DataView input, ::media::mojom::DataDecoderBufferPtr* output);
};


template <>
struct  StructTraits<::media::mojom::EosDecoderBuffer::DataView,
                                         ::media::mojom::EosDecoderBufferPtr> {
  static bool IsNull(const ::media::mojom::EosDecoderBufferPtr& input) { return !input; }
  static void SetToNull(::media::mojom::EosDecoderBufferPtr* output) { output->reset(); }

  static const decltype(::media::mojom::EosDecoderBuffer::next_config)& next_config(
      const ::media::mojom::EosDecoderBufferPtr& input) {
    return input->next_config;
  }

  static bool Read(::media::mojom::EosDecoderBuffer::DataView input, ::media::mojom::EosDecoderBufferPtr* output);
};


template <>
struct  StructTraits<::media::mojom::AudioBuffer::DataView,
                                         ::media::mojom::AudioBufferPtr> {
  static bool IsNull(const ::media::mojom::AudioBufferPtr& input) { return !input; }
  static void SetToNull(::media::mojom::AudioBufferPtr* output) { output->reset(); }

  static decltype(::media::mojom::AudioBuffer::sample_format) sample_format(
      const ::media::mojom::AudioBufferPtr& input) {
    return input->sample_format;
  }

  static decltype(::media::mojom::AudioBuffer::channel_layout) channel_layout(
      const ::media::mojom::AudioBufferPtr& input) {
    return input->channel_layout;
  }

  static decltype(::media::mojom::AudioBuffer::channel_count) channel_count(
      const ::media::mojom::AudioBufferPtr& input) {
    return input->channel_count;
  }

  static decltype(::media::mojom::AudioBuffer::sample_rate) sample_rate(
      const ::media::mojom::AudioBufferPtr& input) {
    return input->sample_rate;
  }

  static decltype(::media::mojom::AudioBuffer::frame_count) frame_count(
      const ::media::mojom::AudioBufferPtr& input) {
    return input->frame_count;
  }

  static decltype(::media::mojom::AudioBuffer::end_of_stream) end_of_stream(
      const ::media::mojom::AudioBufferPtr& input) {
    return input->end_of_stream;
  }

  static const decltype(::media::mojom::AudioBuffer::timestamp)& timestamp(
      const ::media::mojom::AudioBufferPtr& input) {
    return input->timestamp;
  }

  static const decltype(::media::mojom::AudioBuffer::data)& data(
      const ::media::mojom::AudioBufferPtr& input) {
    return input->data;
  }

  static bool Read(::media::mojom::AudioBuffer::DataView input, ::media::mojom::AudioBufferPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoFrameMetadata::DataView,
                                         ::media::mojom::VideoFrameMetadataPtr> {
  static bool IsNull(const ::media::mojom::VideoFrameMetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoFrameMetadataPtr* output) { output->reset(); }

  static decltype(::media::mojom::VideoFrameMetadata::allow_overlay) allow_overlay(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->allow_overlay;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::capture_begin_time)& capture_begin_time(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->capture_begin_time;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::capture_end_time)& capture_end_time(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->capture_end_time;
  }

  static decltype(::media::mojom::VideoFrameMetadata::has_capture_counter) has_capture_counter(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->has_capture_counter;
  }

  static decltype(::media::mojom::VideoFrameMetadata::capture_counter) capture_counter(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->capture_counter;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::capture_update_rect)& capture_update_rect(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->capture_update_rect;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::source_size)& source_size(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->source_size;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::region_capture_rect)& region_capture_rect(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->region_capture_rect;
  }

  static decltype(::media::mojom::VideoFrameMetadata::sub_capture_target_version) sub_capture_target_version(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->sub_capture_target_version;
  }

  static decltype(::media::mojom::VideoFrameMetadata::copy_required) copy_required(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->copy_required;
  }

  static decltype(::media::mojom::VideoFrameMetadata::end_of_stream) end_of_stream(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->end_of_stream;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::frame_duration)& frame_duration(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->frame_duration;
  }

  static decltype(::media::mojom::VideoFrameMetadata::has_frame_rate) has_frame_rate(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->has_frame_rate;
  }

  static decltype(::media::mojom::VideoFrameMetadata::frame_rate) frame_rate(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->frame_rate;
  }

  static decltype(::media::mojom::VideoFrameMetadata::interactive_content) interactive_content(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->interactive_content;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::reference_time)& reference_time(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->reference_time;
  }

  static decltype(::media::mojom::VideoFrameMetadata::read_lock_fences_enabled) read_lock_fences_enabled(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->read_lock_fences_enabled;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::transformation)& transformation(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->transformation;
  }

  static decltype(::media::mojom::VideoFrameMetadata::in_surface_view) in_surface_view(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->in_surface_view;
  }

  static decltype(::media::mojom::VideoFrameMetadata::wants_promotion_hint) wants_promotion_hint(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->wants_promotion_hint;
  }

  static decltype(::media::mojom::VideoFrameMetadata::protected_video) protected_video(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->protected_video;
  }

  static decltype(::media::mojom::VideoFrameMetadata::hw_protected) hw_protected(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->hw_protected;
  }

  static decltype(::media::mojom::VideoFrameMetadata::needs_detiling) needs_detiling(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->needs_detiling;
  }

  static decltype(::media::mojom::VideoFrameMetadata::is_webgpu_compatible) is_webgpu_compatible(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->is_webgpu_compatible;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::tracking_token)& tracking_token(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->tracking_token;
  }

  static decltype(::media::mojom::VideoFrameMetadata::power_efficient) power_efficient(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->power_efficient;
  }

  static decltype(::media::mojom::VideoFrameMetadata::has_device_scale_factor) has_device_scale_factor(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->has_device_scale_factor;
  }

  static decltype(::media::mojom::VideoFrameMetadata::device_scale_factor) device_scale_factor(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->device_scale_factor;
  }

  static decltype(::media::mojom::VideoFrameMetadata::has_page_scale_factor) has_page_scale_factor(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->has_page_scale_factor;
  }

  static decltype(::media::mojom::VideoFrameMetadata::page_scale_factor) page_scale_factor(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->page_scale_factor;
  }

  static decltype(::media::mojom::VideoFrameMetadata::has_root_scroll_offset_x) has_root_scroll_offset_x(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->has_root_scroll_offset_x;
  }

  static decltype(::media::mojom::VideoFrameMetadata::root_scroll_offset_x) root_scroll_offset_x(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->root_scroll_offset_x;
  }

  static decltype(::media::mojom::VideoFrameMetadata::has_root_scroll_offset_y) has_root_scroll_offset_y(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->has_root_scroll_offset_y;
  }

  static decltype(::media::mojom::VideoFrameMetadata::root_scroll_offset_y) root_scroll_offset_y(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->root_scroll_offset_y;
  }

  static decltype(::media::mojom::VideoFrameMetadata::has_top_controls_visible_height) has_top_controls_visible_height(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->has_top_controls_visible_height;
  }

  static decltype(::media::mojom::VideoFrameMetadata::top_controls_visible_height) top_controls_visible_height(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->top_controls_visible_height;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::decode_begin_time)& decode_begin_time(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->decode_begin_time;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::decode_end_time)& decode_end_time(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->decode_end_time;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::processing_time)& processing_time(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->processing_time;
  }

  static decltype(::media::mojom::VideoFrameMetadata::has_rtp_timestamp) has_rtp_timestamp(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->has_rtp_timestamp;
  }

  static decltype(::media::mojom::VideoFrameMetadata::rtp_timestamp) rtp_timestamp(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->rtp_timestamp;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::receive_time)& receive_time(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->receive_time;
  }

  static const decltype(::media::mojom::VideoFrameMetadata::wallclock_frame_duration)& wallclock_frame_duration(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->wallclock_frame_duration;
  }

  static decltype(::media::mojom::VideoFrameMetadata::frame_sequence) frame_sequence(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->frame_sequence;
  }

  static decltype(::media::mojom::VideoFrameMetadata::source_id) source_id(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->source_id;
  }

  static decltype(::media::mojom::VideoFrameMetadata::background_blur) background_blur(
      const ::media::mojom::VideoFrameMetadataPtr& input) {
    return input->background_blur;
  }

  static bool Read(::media::mojom::VideoFrameMetadata::DataView input, ::media::mojom::VideoFrameMetadataPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoFrame::DataView,
                                         ::media::mojom::VideoFramePtr> {
  static bool IsNull(const ::media::mojom::VideoFramePtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoFramePtr* output) { output->reset(); }

  static decltype(::media::mojom::VideoFrame::format) format(
      const ::media::mojom::VideoFramePtr& input) {
    return input->format;
  }

  static const decltype(::media::mojom::VideoFrame::coded_size)& coded_size(
      const ::media::mojom::VideoFramePtr& input) {
    return input->coded_size;
  }

  static const decltype(::media::mojom::VideoFrame::visible_rect)& visible_rect(
      const ::media::mojom::VideoFramePtr& input) {
    return input->visible_rect;
  }

  static const decltype(::media::mojom::VideoFrame::natural_size)& natural_size(
      const ::media::mojom::VideoFramePtr& input) {
    return input->natural_size;
  }

  static const decltype(::media::mojom::VideoFrame::timestamp)& timestamp(
      const ::media::mojom::VideoFramePtr& input) {
    return input->timestamp;
  }

  static  decltype(::media::mojom::VideoFrame::data)& data(
       ::media::mojom::VideoFramePtr& input) {
    return input->data;
  }

  static const decltype(::media::mojom::VideoFrame::metadata)& metadata(
      const ::media::mojom::VideoFramePtr& input) {
    return input->metadata;
  }

  static const decltype(::media::mojom::VideoFrame::color_space)& color_space(
      const ::media::mojom::VideoFramePtr& input) {
    return input->color_space;
  }

  static const decltype(::media::mojom::VideoFrame::hdr_metadata)& hdr_metadata(
      const ::media::mojom::VideoFramePtr& input) {
    return input->hdr_metadata;
  }

  static bool Read(::media::mojom::VideoFrame::DataView input, ::media::mojom::VideoFramePtr* output);
};


template <>
struct  StructTraits<::media::mojom::EosVideoFrameData::DataView,
                                         ::media::mojom::EosVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::EosVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::EosVideoFrameDataPtr* output) { output->reset(); }

  static bool Read(::media::mojom::EosVideoFrameData::DataView input, ::media::mojom::EosVideoFrameDataPtr* output);
};


template <>
struct  StructTraits<::media::mojom::SharedMemoryVideoFrameData::DataView,
                                         ::media::mojom::SharedMemoryVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::SharedMemoryVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::SharedMemoryVideoFrameDataPtr* output) { output->reset(); }

  static  decltype(::media::mojom::SharedMemoryVideoFrameData::frame_data)& frame_data(
       ::media::mojom::SharedMemoryVideoFrameDataPtr& input) {
    return input->frame_data;
  }

  static const decltype(::media::mojom::SharedMemoryVideoFrameData::strides)& strides(
      const ::media::mojom::SharedMemoryVideoFrameDataPtr& input) {
    return input->strides;
  }

  static const decltype(::media::mojom::SharedMemoryVideoFrameData::offsets)& offsets(
      const ::media::mojom::SharedMemoryVideoFrameDataPtr& input) {
    return input->offsets;
  }

  static bool Read(::media::mojom::SharedMemoryVideoFrameData::DataView input, ::media::mojom::SharedMemoryVideoFrameDataPtr* output);
};


template <>
struct  StructTraits<::media::mojom::GpuMemoryBufferSharedImageVideoFrameData::DataView,
                                         ::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataPtr* output) { output->reset(); }

  static  decltype(::media::mojom::GpuMemoryBufferSharedImageVideoFrameData::gpu_memory_buffer_handle)& gpu_memory_buffer_handle(
       ::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataPtr& input) {
    return input->gpu_memory_buffer_handle;
  }

  static  decltype(::media::mojom::GpuMemoryBufferSharedImageVideoFrameData::shared_image)& shared_image(
       ::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataPtr& input) {
    return input->shared_image;
  }

  static const decltype(::media::mojom::GpuMemoryBufferSharedImageVideoFrameData::sync_token)& sync_token(
      const ::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataPtr& input) {
    return input->sync_token;
  }

  static bool Read(::media::mojom::GpuMemoryBufferSharedImageVideoFrameData::DataView input, ::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataPtr* output);
};


template <>
struct  StructTraits<::media::mojom::SharedImageVideoFrameData::DataView,
                                         ::media::mojom::SharedImageVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::SharedImageVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::SharedImageVideoFrameDataPtr* output) { output->reset(); }

  static  decltype(::media::mojom::SharedImageVideoFrameData::shared_image)& shared_image(
       ::media::mojom::SharedImageVideoFrameDataPtr& input) {
    return input->shared_image;
  }

  static const decltype(::media::mojom::SharedImageVideoFrameData::sync_token)& sync_token(
      const ::media::mojom::SharedImageVideoFrameDataPtr& input) {
    return input->sync_token;
  }

  static decltype(::media::mojom::SharedImageVideoFrameData::is_mappable_si_enabled) is_mappable_si_enabled(
      const ::media::mojom::SharedImageVideoFrameDataPtr& input) {
    return input->is_mappable_si_enabled;
  }

  static bool Read(::media::mojom::SharedImageVideoFrameData::DataView input, ::media::mojom::SharedImageVideoFrameDataPtr* output);
};


template <>
struct  StructTraits<::media::mojom::OpaqueVideoFrameData::DataView,
                                         ::media::mojom::OpaqueVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::OpaqueVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::OpaqueVideoFrameDataPtr* output) { output->reset(); }

  static bool Read(::media::mojom::OpaqueVideoFrameData::DataView input, ::media::mojom::OpaqueVideoFrameDataPtr* output);
};


template <>
struct  StructTraits<::media::mojom::ColorPlaneLayout::DataView,
                                         ::media::mojom::ColorPlaneLayoutPtr> {
  static bool IsNull(const ::media::mojom::ColorPlaneLayoutPtr& input) { return !input; }
  static void SetToNull(::media::mojom::ColorPlaneLayoutPtr* output) { output->reset(); }

  static decltype(::media::mojom::ColorPlaneLayout::stride) stride(
      const ::media::mojom::ColorPlaneLayoutPtr& input) {
    return input->stride;
  }

  static decltype(::media::mojom::ColorPlaneLayout::offset) offset(
      const ::media::mojom::ColorPlaneLayoutPtr& input) {
    return input->offset;
  }

  static decltype(::media::mojom::ColorPlaneLayout::size) size(
      const ::media::mojom::ColorPlaneLayoutPtr& input) {
    return input->size;
  }

  static bool Read(::media::mojom::ColorPlaneLayout::DataView input, ::media::mojom::ColorPlaneLayoutPtr* output);
};


template <>
struct  StructTraits<::media::mojom::DmabufVideoFrameData::DataView,
                                         ::media::mojom::DmabufVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::DmabufVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::DmabufVideoFrameDataPtr* output) { output->reset(); }

  static const decltype(::media::mojom::DmabufVideoFrameData::planes)& planes(
      const ::media::mojom::DmabufVideoFrameDataPtr& input) {
    return input->planes;
  }

  static decltype(::media::mojom::DmabufVideoFrameData::is_multi_planar) is_multi_planar(
      const ::media::mojom::DmabufVideoFrameDataPtr& input) {
    return input->is_multi_planar;
  }

  static decltype(::media::mojom::DmabufVideoFrameData::buffer_addr_align) buffer_addr_align(
      const ::media::mojom::DmabufVideoFrameDataPtr& input) {
    return input->buffer_addr_align;
  }

  static decltype(::media::mojom::DmabufVideoFrameData::modifier) modifier(
      const ::media::mojom::DmabufVideoFrameDataPtr& input) {
    return input->modifier;
  }

  static  decltype(::media::mojom::DmabufVideoFrameData::fds)& fds(
       ::media::mojom::DmabufVideoFrameDataPtr& input) {
    return input->fds;
  }

  static bool Read(::media::mojom::DmabufVideoFrameData::DataView input, ::media::mojom::DmabufVideoFrameDataPtr* output);
};


template <>
struct  StructTraits<::media::mojom::PipelineStatistics::DataView,
                                         ::media::mojom::PipelineStatisticsPtr> {
  static bool IsNull(const ::media::mojom::PipelineStatisticsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::PipelineStatisticsPtr* output) { output->reset(); }

  static decltype(::media::mojom::PipelineStatistics::audio_bytes_decoded) audio_bytes_decoded(
      const ::media::mojom::PipelineStatisticsPtr& input) {
    return input->audio_bytes_decoded;
  }

  static decltype(::media::mojom::PipelineStatistics::video_bytes_decoded) video_bytes_decoded(
      const ::media::mojom::PipelineStatisticsPtr& input) {
    return input->video_bytes_decoded;
  }

  static decltype(::media::mojom::PipelineStatistics::video_frames_decoded) video_frames_decoded(
      const ::media::mojom::PipelineStatisticsPtr& input) {
    return input->video_frames_decoded;
  }

  static decltype(::media::mojom::PipelineStatistics::video_frames_dropped) video_frames_dropped(
      const ::media::mojom::PipelineStatisticsPtr& input) {
    return input->video_frames_dropped;
  }

  static decltype(::media::mojom::PipelineStatistics::audio_memory_usage) audio_memory_usage(
      const ::media::mojom::PipelineStatisticsPtr& input) {
    return input->audio_memory_usage;
  }

  static decltype(::media::mojom::PipelineStatistics::video_memory_usage) video_memory_usage(
      const ::media::mojom::PipelineStatisticsPtr& input) {
    return input->video_memory_usage;
  }

  static bool Read(::media::mojom::PipelineStatistics::DataView input, ::media::mojom::PipelineStatisticsPtr* output);
};


template <>
struct  StructTraits<::media::mojom::PredictionFeatures::DataView,
                                         ::media::mojom::PredictionFeaturesPtr> {
  static bool IsNull(const ::media::mojom::PredictionFeaturesPtr& input) { return !input; }
  static void SetToNull(::media::mojom::PredictionFeaturesPtr* output) { output->reset(); }

  static decltype(::media::mojom::PredictionFeatures::profile) profile(
      const ::media::mojom::PredictionFeaturesPtr& input) {
    return input->profile;
  }

  static const decltype(::media::mojom::PredictionFeatures::video_size)& video_size(
      const ::media::mojom::PredictionFeaturesPtr& input) {
    return input->video_size;
  }

  static decltype(::media::mojom::PredictionFeatures::frames_per_sec) frames_per_sec(
      const ::media::mojom::PredictionFeaturesPtr& input) {
    return input->frames_per_sec;
  }

  static const decltype(::media::mojom::PredictionFeatures::key_system)& key_system(
      const ::media::mojom::PredictionFeaturesPtr& input) {
    return input->key_system;
  }

  static decltype(::media::mojom::PredictionFeatures::use_hw_secure_codecs) use_hw_secure_codecs(
      const ::media::mojom::PredictionFeaturesPtr& input) {
    return input->use_hw_secure_codecs;
  }

  static bool Read(::media::mojom::PredictionFeatures::DataView input, ::media::mojom::PredictionFeaturesPtr* output);
};


template <>
struct  StructTraits<::media::mojom::PredictionTargets::DataView,
                                         ::media::mojom::PredictionTargetsPtr> {
  static bool IsNull(const ::media::mojom::PredictionTargetsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::PredictionTargetsPtr* output) { output->reset(); }

  static decltype(::media::mojom::PredictionTargets::frames_decoded) frames_decoded(
      const ::media::mojom::PredictionTargetsPtr& input) {
    return input->frames_decoded;
  }

  static decltype(::media::mojom::PredictionTargets::frames_dropped) frames_dropped(
      const ::media::mojom::PredictionTargetsPtr& input) {
    return input->frames_dropped;
  }

  static decltype(::media::mojom::PredictionTargets::frames_power_efficient) frames_power_efficient(
      const ::media::mojom::PredictionTargetsPtr& input) {
    return input->frames_power_efficient;
  }

  static bool Read(::media::mojom::PredictionTargets::DataView input, ::media::mojom::PredictionTargetsPtr* output);
};


template <>
struct  StructTraits<::media::mojom::AudioPipelineInfo::DataView,
                                         ::media::mojom::AudioPipelineInfoPtr> {
  static bool IsNull(const ::media::mojom::AudioPipelineInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::AudioPipelineInfoPtr* output) { output->reset(); }

  static decltype(::media::mojom::AudioPipelineInfo::decoder_type) decoder_type(
      const ::media::mojom::AudioPipelineInfoPtr& input) {
    return input->decoder_type;
  }

  static decltype(::media::mojom::AudioPipelineInfo::is_platform_decoder) is_platform_decoder(
      const ::media::mojom::AudioPipelineInfoPtr& input) {
    return input->is_platform_decoder;
  }

  static decltype(::media::mojom::AudioPipelineInfo::has_decrypting_demuxer_stream) has_decrypting_demuxer_stream(
      const ::media::mojom::AudioPipelineInfoPtr& input) {
    return input->has_decrypting_demuxer_stream;
  }

  static decltype(::media::mojom::AudioPipelineInfo::encryption_type) encryption_type(
      const ::media::mojom::AudioPipelineInfoPtr& input) {
    return input->encryption_type;
  }

  static bool Read(::media::mojom::AudioPipelineInfo::DataView input, ::media::mojom::AudioPipelineInfoPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoPipelineInfo::DataView,
                                         ::media::mojom::VideoPipelineInfoPtr> {
  static bool IsNull(const ::media::mojom::VideoPipelineInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoPipelineInfoPtr* output) { output->reset(); }

  static decltype(::media::mojom::VideoPipelineInfo::decoder_type) decoder_type(
      const ::media::mojom::VideoPipelineInfoPtr& input) {
    return input->decoder_type;
  }

  static decltype(::media::mojom::VideoPipelineInfo::is_platform_decoder) is_platform_decoder(
      const ::media::mojom::VideoPipelineInfoPtr& input) {
    return input->is_platform_decoder;
  }

  static decltype(::media::mojom::VideoPipelineInfo::has_decrypting_demuxer_stream) has_decrypting_demuxer_stream(
      const ::media::mojom::VideoPipelineInfoPtr& input) {
    return input->has_decrypting_demuxer_stream;
  }

  static decltype(::media::mojom::VideoPipelineInfo::encryption_type) encryption_type(
      const ::media::mojom::VideoPipelineInfoPtr& input) {
    return input->encryption_type;
  }

  static bool Read(::media::mojom::VideoPipelineInfo::DataView input, ::media::mojom::VideoPipelineInfoPtr* output);
};


template <>
struct  StructTraits<::media::mojom::StatusData::DataView,
                                         ::media::mojom::StatusDataPtr> {
  static bool IsNull(const ::media::mojom::StatusDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::StatusDataPtr* output) { output->reset(); }

  static const decltype(::media::mojom::StatusData::group)& group(
      const ::media::mojom::StatusDataPtr& input) {
    return input->group;
  }

  static decltype(::media::mojom::StatusData::code) code(
      const ::media::mojom::StatusDataPtr& input) {
    return input->code;
  }

  static const decltype(::media::mojom::StatusData::message)& message(
      const ::media::mojom::StatusDataPtr& input) {
    return input->message;
  }

  static const decltype(::media::mojom::StatusData::frames)& frames(
      const ::media::mojom::StatusDataPtr& input) {
    return input->frames;
  }

  static const decltype(::media::mojom::StatusData::cause)& cause(
      const ::media::mojom::StatusDataPtr& input) {
    return input->cause;
  }

  static const decltype(::media::mojom::StatusData::data)& data(
      const ::media::mojom::StatusDataPtr& input) {
    return input->data;
  }

  static bool Read(::media::mojom::StatusData::DataView input, ::media::mojom::StatusDataPtr* output);
};


template <>
struct  StructTraits<::media::mojom::EncoderStatus::DataView,
                                         ::media::mojom::EncoderStatusPtr> {
  static bool IsNull(const ::media::mojom::EncoderStatusPtr& input) { return !input; }
  static void SetToNull(::media::mojom::EncoderStatusPtr* output) { output->reset(); }

  static const decltype(::media::mojom::EncoderStatus::internal)& internal(
      const ::media::mojom::EncoderStatusPtr& input) {
    return input->internal;
  }

  static bool Read(::media::mojom::EncoderStatus::DataView input, ::media::mojom::EncoderStatusPtr* output);
};


template <>
struct  StructTraits<::media::mojom::DecoderStatus::DataView,
                                         ::media::mojom::DecoderStatusPtr> {
  static bool IsNull(const ::media::mojom::DecoderStatusPtr& input) { return !input; }
  static void SetToNull(::media::mojom::DecoderStatusPtr* output) { output->reset(); }

  static const decltype(::media::mojom::DecoderStatus::internal)& internal(
      const ::media::mojom::DecoderStatusPtr& input) {
    return input->internal;
  }

  static bool Read(::media::mojom::DecoderStatus::DataView input, ::media::mojom::DecoderStatusPtr* output);
};


template <>
struct  StructTraits<::media::mojom::PipelineStatus::DataView,
                                         ::media::mojom::PipelineStatusPtr> {
  static bool IsNull(const ::media::mojom::PipelineStatusPtr& input) { return !input; }
  static void SetToNull(::media::mojom::PipelineStatusPtr* output) { output->reset(); }

  static const decltype(::media::mojom::PipelineStatus::internal)& internal(
      const ::media::mojom::PipelineStatusPtr& input) {
    return input->internal;
  }

  static bool Read(::media::mojom::PipelineStatus::DataView input, ::media::mojom::PipelineStatusPtr* output);
};


template <>
struct  StructTraits<::media::mojom::AutoPipInfo::DataView,
                                         ::media::mojom::AutoPipInfoPtr> {
  static bool IsNull(const ::media::mojom::AutoPipInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::AutoPipInfoPtr* output) { output->reset(); }

  static decltype(::media::mojom::AutoPipInfo::auto_pip_reason) auto_pip_reason(
      const ::media::mojom::AutoPipInfoPtr& input) {
    return input->auto_pip_reason;
  }

  static decltype(::media::mojom::AutoPipInfo::has_audio_focus) has_audio_focus(
      const ::media::mojom::AutoPipInfoPtr& input) {
    return input->has_audio_focus;
  }

  static decltype(::media::mojom::AutoPipInfo::is_playing) is_playing(
      const ::media::mojom::AutoPipInfoPtr& input) {
    return input->is_playing;
  }

  static decltype(::media::mojom::AutoPipInfo::was_recently_audible) was_recently_audible(
      const ::media::mojom::AutoPipInfoPtr& input) {
    return input->was_recently_audible;
  }

  static decltype(::media::mojom::AutoPipInfo::has_safe_url) has_safe_url(
      const ::media::mojom::AutoPipInfoPtr& input) {
    return input->has_safe_url;
  }

  static decltype(::media::mojom::AutoPipInfo::meets_media_engagement_conditions) meets_media_engagement_conditions(
      const ::media::mojom::AutoPipInfoPtr& input) {
    return input->meets_media_engagement_conditions;
  }

  static decltype(::media::mojom::AutoPipInfo::blocked_due_to_content_setting) blocked_due_to_content_setting(
      const ::media::mojom::AutoPipInfoPtr& input) {
    return input->blocked_due_to_content_setting;
  }

  static bool Read(::media::mojom::AutoPipInfo::DataView input, ::media::mojom::AutoPipInfoPtr* output);
};


template <>
struct  UnionTraits<::media::mojom::DecoderBufferSideDataNextConfig::DataView,
                                        ::media::mojom::DecoderBufferSideDataNextConfigPtr> {
  static bool IsNull(const ::media::mojom::DecoderBufferSideDataNextConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::DecoderBufferSideDataNextConfigPtr* output) { output->reset(); }

  static ::media::mojom::DecoderBufferSideDataNextConfig::Tag GetTag(const ::media::mojom::DecoderBufferSideDataNextConfigPtr& input) {
    return input->which();
  }

  static const ::media::AudioDecoderConfig& next_audio_config(const ::media::mojom::DecoderBufferSideDataNextConfigPtr& input) {
    return input->get_next_audio_config();
  }

  static const ::media::VideoDecoderConfig& next_video_config(const ::media::mojom::DecoderBufferSideDataNextConfigPtr& input) {
    return input->get_next_video_config();
  }

  static bool Read(::media::mojom::DecoderBufferSideDataNextConfig::DataView input, ::media::mojom::DecoderBufferSideDataNextConfigPtr* output);
};


template <>
struct  UnionTraits<::media::mojom::DecoderBuffer::DataView,
                                        ::media::mojom::DecoderBufferPtr> {
  static bool IsNull(const ::media::mojom::DecoderBufferPtr& input) { return !input; }
  static void SetToNull(::media::mojom::DecoderBufferPtr* output) { output->reset(); }

  static ::media::mojom::DecoderBuffer::Tag GetTag(const ::media::mojom::DecoderBufferPtr& input) {
    return input->which();
  }

  static const ::media::mojom::EosDecoderBufferPtr& eos(const ::media::mojom::DecoderBufferPtr& input) {
    return input->get_eos();
  }

  static const ::media::mojom::DataDecoderBufferPtr& data(const ::media::mojom::DecoderBufferPtr& input) {
    return input->get_data();
  }

  static bool Read(::media::mojom::DecoderBuffer::DataView input, ::media::mojom::DecoderBufferPtr* output);
};


template <>
struct  UnionTraits<::media::mojom::VideoFrameData::DataView,
                                        ::media::mojom::VideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::VideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoFrameDataPtr* output) { output->reset(); }

  static ::media::mojom::VideoFrameData::Tag GetTag(const ::media::mojom::VideoFrameDataPtr& input) {
    return input->which();
  }

  static const ::media::mojom::EosVideoFrameDataPtr& eos_data(const ::media::mojom::VideoFrameDataPtr& input) {
    return input->get_eos_data();
  }

  static  ::media::mojom::SharedMemoryVideoFrameDataPtr& shared_memory_data( ::media::mojom::VideoFrameDataPtr& input) {
    return input->get_shared_memory_data();
  }

  static  ::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataPtr& gpu_memory_buffer_shared_image_data( ::media::mojom::VideoFrameDataPtr& input) {
    return input->get_gpu_memory_buffer_shared_image_data();
  }

  static  ::media::mojom::SharedImageVideoFrameDataPtr& shared_image_data( ::media::mojom::VideoFrameDataPtr& input) {
    return input->get_shared_image_data();
  }

  static const ::media::mojom::OpaqueVideoFrameDataPtr& opaque_data(const ::media::mojom::VideoFrameDataPtr& input) {
    return input->get_opaque_data();
  }

  static  ::media::mojom::DmabufVideoFrameDataPtr& dmabuf_data( ::media::mojom::VideoFrameDataPtr& input) {
    return input->get_dmabuf_data();
  }

  static bool Read(::media::mojom::VideoFrameData::DataView input, ::media::mojom::VideoFrameDataPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_H_