// media/capture/mojom/video_capture_buffer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/capture/mojom/video_capture_buffer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/capture/mojom/video_capture_buffer.mojom-params-data.h"
#include "media/capture/mojom/video_capture_buffer.mojom-shared-message-ids.h"

#include "media/capture/mojom/video_capture_buffer.mojom-blink-import-headers.h"
#include "media/capture/mojom/video_capture_buffer.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
VideoFrameInfo::VideoFrameInfo()
    : timestamp(),
      metadata(),
      pixel_format(),
      coded_size(),
      visible_rect(),
      is_premapped(),
      color_space(),
      strides() {}

VideoFrameInfo::VideoFrameInfo(
    ::base::TimeDelta timestamp_in,
    const ::media::VideoFrameMetadata& metadata_in,
    ::media::VideoPixelFormat pixel_format_in,
    const ::gfx::Size& coded_size_in,
    const ::gfx::Rect& visible_rect_in,
    bool is_premapped_in,
    const ::gfx::ColorSpace& color_space_in,
    ::media::mojom::blink::PlaneStridesPtr strides_in)
    : timestamp(std::move(timestamp_in)),
      metadata(std::move(metadata_in)),
      pixel_format(std::move(pixel_format_in)),
      coded_size(std::move(coded_size_in)),
      visible_rect(std::move(visible_rect_in)),
      is_premapped(std::move(is_premapped_in)),
      color_space(std::move(color_space_in)),
      strides(std::move(strides_in)) {}

VideoFrameInfo::~VideoFrameInfo() = default;

void VideoFrameInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoFrameMetadata&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_format"), this->pixel_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoPixelFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size"), this->coded_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_premapped"), this->is_premapped,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strides"), this->strides,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::PlaneStridesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoFrameInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReadyBuffer::ReadyBuffer()
    : buffer_id(),
      info() {}

ReadyBuffer::ReadyBuffer(
    int32_t buffer_id_in,
    VideoFrameInfoPtr info_in)
    : buffer_id(std::move(buffer_id_in)),
      info(std::move(info_in)) {}

ReadyBuffer::~ReadyBuffer() = default;

void ReadyBuffer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_id"), this->buffer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "info"), this->info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoFrameInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReadyBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedImageBufferHandleSet::SharedImageBufferHandleSet()
    : shared_image(),
      sync_token() {}

SharedImageBufferHandleSet::SharedImageBufferHandleSet(
    ::gpu::ExportedSharedImage shared_image_in,
    const ::gpu::SyncToken& sync_token_in)
    : shared_image(std::move(shared_image_in)),
      sync_token(std::move(sync_token_in)) {}

SharedImageBufferHandleSet::~SharedImageBufferHandleSet() = default;

void SharedImageBufferHandleSet::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_image"), this->shared_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::ExportedSharedImage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sync_token"), this->sync_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::SyncToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedImageBufferHandleSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoBufferHandlePtr
VideoBufferHandle::NewUnsafeShmemRegion(
    ::base::UnsafeSharedMemoryRegion value) {
  return VideoBufferHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUnsafeShmemRegion)>,
      std::move(value));
}

VideoBufferHandlePtr
VideoBufferHandle::NewReadOnlyShmemRegion(
    ::base::ReadOnlySharedMemoryRegion value) {
  return VideoBufferHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kReadOnlyShmemRegion)>,
      std::move(value));
}

VideoBufferHandlePtr
VideoBufferHandle::NewSharedImageHandle(
    SharedImageBufferHandleSetPtr value) {
  return VideoBufferHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSharedImageHandle)>,
      std::move(value));
}

VideoBufferHandlePtr
VideoBufferHandle::NewGpuMemoryBufferHandle(
    ::gfx::GpuMemoryBufferHandle value) {
  return VideoBufferHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kGpuMemoryBufferHandle)>,
      std::move(value));
}

VideoBufferHandle::VideoBufferHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnsafeShmemRegion)>,
    ::base::UnsafeSharedMemoryRegion value)
    : tag_(Tag::kUnsafeShmemRegion),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUnsafeShmemRegion)>,
            std::move(value)) {}

VideoBufferHandle::VideoBufferHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kReadOnlyShmemRegion)>,
    ::base::ReadOnlySharedMemoryRegion value)
    : tag_(Tag::kReadOnlyShmemRegion),
      data_(std::in_place_index<static_cast<size_t>(Tag::kReadOnlyShmemRegion)>,
            std::move(value)) {}

VideoBufferHandle::VideoBufferHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedImageHandle)>,
    SharedImageBufferHandleSetPtr value)
    : tag_(Tag::kSharedImageHandle),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSharedImageHandle)>,
            std::move(value)) {}

VideoBufferHandle::VideoBufferHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kGpuMemoryBufferHandle)>,
    ::gfx::GpuMemoryBufferHandle value)
    : tag_(Tag::kGpuMemoryBufferHandle),
      data_(std::in_place_index<static_cast<size_t>(Tag::kGpuMemoryBufferHandle)>,
            std::move(value)) {}
VideoBufferHandle::~VideoBufferHandle() {
  DestroyActive();
}

void VideoBufferHandle::set_unsafe_shmem_region(::base::UnsafeSharedMemoryRegion unsafe_shmem_region) {
  if (tag_ == Tag::kUnsafeShmemRegion) {
    data_.unsafe_shmem_region = std::move(unsafe_shmem_region);
  } else {
    DestroyActive();
    tag_ = Tag::kUnsafeShmemRegion;
    new (&data_.unsafe_shmem_region) ::base::UnsafeSharedMemoryRegion(
        std::move(unsafe_shmem_region));
  }
}

void VideoBufferHandle::set_read_only_shmem_region(::base::ReadOnlySharedMemoryRegion read_only_shmem_region) {
  if (tag_ == Tag::kReadOnlyShmemRegion) {
    data_.read_only_shmem_region = std::move(read_only_shmem_region);
  } else {
    DestroyActive();
    tag_ = Tag::kReadOnlyShmemRegion;
    new (&data_.read_only_shmem_region) ::base::ReadOnlySharedMemoryRegion(
        std::move(read_only_shmem_region));
  }
}

void VideoBufferHandle::set_shared_image_handle(SharedImageBufferHandleSetPtr shared_image_handle) {
  if (tag_ == Tag::kSharedImageHandle) {
    data_.shared_image_handle = std::move(shared_image_handle);
  } else {
    DestroyActive();
    tag_ = Tag::kSharedImageHandle;
    new (&data_.shared_image_handle) SharedImageBufferHandleSetPtr(
        std::move(shared_image_handle));
  }
}

void VideoBufferHandle::set_gpu_memory_buffer_handle(::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle) {
  if (tag_ == Tag::kGpuMemoryBufferHandle) {
    data_.gpu_memory_buffer_handle = std::move(gpu_memory_buffer_handle);
  } else {
    DestroyActive();
    tag_ = Tag::kGpuMemoryBufferHandle;
    new (&data_.gpu_memory_buffer_handle) ::gfx::GpuMemoryBufferHandle(
        std::move(gpu_memory_buffer_handle));
  }
}


VideoBufferHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnsafeShmemRegion)>,
    ::base::UnsafeSharedMemoryRegion value)
    : unsafe_shmem_region(std::move(value)) {}

VideoBufferHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kReadOnlyShmemRegion)>,
    ::base::ReadOnlySharedMemoryRegion value)
    : read_only_shmem_region(std::move(value)) {}

VideoBufferHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedImageHandle)>,
    SharedImageBufferHandleSetPtr value)
    : shared_image_handle(std::move(value)) {}

VideoBufferHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kGpuMemoryBufferHandle)>,
    ::gfx::GpuMemoryBufferHandle value)
    : gpu_memory_buffer_handle(std::move(value)) {}

void VideoBufferHandle::DestroyActive() {
  switch (tag_) {

    case Tag::kUnsafeShmemRegion:
      std::destroy_at(&data_.unsafe_shmem_region);
      break;
    case Tag::kReadOnlyShmemRegion:
      std::destroy_at(&data_.read_only_shmem_region);
      break;
    case Tag::kSharedImageHandle:
      std::destroy_at(&data_.shared_image_handle);
      break;
    case Tag::kGpuMemoryBufferHandle:
      std::destroy_at(&data_.gpu_memory_buffer_handle);
      break;
  }
}

bool VideoBufferHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // media::mojom::blink


namespace mojo {


// static
bool StructTraits<::media::mojom::blink::VideoFrameInfo::DataView, ::media::mojom::blink::VideoFrameInfoPtr>::Read(
    ::media::mojom::blink::VideoFrameInfo::DataView input,
    ::media::mojom::blink::VideoFrameInfoPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoFrameInfoPtr result(::media::mojom::blink::VideoFrameInfo::New());
  
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
      if (success && !input.ReadPixelFormat(&result->pixel_format))
        success = false;
      if (success && !input.ReadCodedSize(&result->coded_size))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success)
        result->is_premapped = input.is_premapped();
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success && !input.ReadStrides(&result->strides))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::ReadyBuffer::DataView, ::media::mojom::blink::ReadyBufferPtr>::Read(
    ::media::mojom::blink::ReadyBuffer::DataView input,
    ::media::mojom::blink::ReadyBufferPtr* output) {
  bool success = true;
  ::media::mojom::blink::ReadyBufferPtr result(::media::mojom::blink::ReadyBuffer::New());
  
      if (success)
        result->buffer_id = input.buffer_id();
      if (success && !input.ReadInfo(&result->info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::SharedImageBufferHandleSet::DataView, ::media::mojom::blink::SharedImageBufferHandleSetPtr>::Read(
    ::media::mojom::blink::SharedImageBufferHandleSet::DataView input,
    ::media::mojom::blink::SharedImageBufferHandleSetPtr* output) {
  bool success = true;
  ::media::mojom::blink::SharedImageBufferHandleSetPtr result(::media::mojom::blink::SharedImageBufferHandleSet::New());
  
      if (success && !input.ReadSharedImage(&result->shared_image))
        success = false;
      if (success && !input.ReadSyncToken(&result->sync_token))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::media::mojom::blink::VideoBufferHandle::DataView, ::media::mojom::blink::VideoBufferHandlePtr>::Read(
    ::media::mojom::blink::VideoBufferHandle::DataView input,
    ::media::mojom::blink::VideoBufferHandlePtr* output) {
  using UnionType = ::media::mojom::blink::VideoBufferHandle;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kUnsafeShmemRegion: {
      ::base::UnsafeSharedMemoryRegion result_unsafe_shmem_region{};
      if (!input.ReadUnsafeShmemRegion(&result_unsafe_shmem_region))
        return false;

      *output = UnionType::NewUnsafeShmemRegion(
          std::move(result_unsafe_shmem_region));
      break;
    }
    case Tag::kReadOnlyShmemRegion: {
      ::base::ReadOnlySharedMemoryRegion result_read_only_shmem_region{};
      if (!input.ReadReadOnlyShmemRegion(&result_read_only_shmem_region))
        return false;

      *output = UnionType::NewReadOnlyShmemRegion(
          std::move(result_read_only_shmem_region));
      break;
    }
    case Tag::kSharedImageHandle: {
      ::media::mojom::blink::SharedImageBufferHandleSetPtr result_shared_image_handle{};
      if (!input.ReadSharedImageHandle(&result_shared_image_handle))
        return false;

      *output = UnionType::NewSharedImageHandle(
          std::move(result_shared_image_handle));
      break;
    }
    case Tag::kGpuMemoryBufferHandle: {
      ::gfx::GpuMemoryBufferHandle result_gpu_memory_buffer_handle{};
      if (!input.ReadGpuMemoryBufferHandle(&result_gpu_memory_buffer_handle))
        return false;

      *output = UnionType::NewGpuMemoryBufferHandle(
          std::move(result_gpu_memory_buffer_handle));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {




}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif