// extensions/common/mojom/host_id.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_HOST_ID_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_HOST_ID_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/host_id.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/host_id.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/host_id.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace extensions::mojom {





class  HostID {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HostID, T>::value>;
  using DataView = HostIDDataView;
  using Data_ = internal::HostID_Data;
  using HostType = HostID_HostType;

  template <typename... Args>
  static HostIDPtr New(Args&&... args) {
    return HostIDPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HostIDPtr From(const U& u) {
    return mojo::TypeConverter<HostIDPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HostID>::Convert(*this);
  }


  HostID();

  HostID(
      HostID::HostType type,
      const std::string& id);


  ~HostID();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HostIDPtr>
  HostIDPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HostID::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HostID::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HostID::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HostID::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HostID::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HostID::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HostID_UnserializedMessageContext<
            UserType, HostID::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HostID::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HostID::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HostID_UnserializedMessageContext<
            UserType, HostID::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HostID::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  HostID::HostType type;
  
  std::string id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HostID::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HostID::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HostID::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HostID::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
HostIDPtr HostID::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(id)
  );
}

template <typename T, HostID::EnableIfSame<T>*>
bool HostID::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, HostID::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}


}  // extensions::mojom

namespace mojo {


template <>
struct  StructTraits<::extensions::mojom::HostID::DataView,
                                         ::extensions::mojom::HostIDPtr> {
  static bool IsNull(const ::extensions::mojom::HostIDPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::HostIDPtr* output) { output->reset(); }

  static decltype(::extensions::mojom::HostID::type) type(
      const ::extensions::mojom::HostIDPtr& input) {
    return input->type;
  }

  static const decltype(::extensions::mojom::HostID::id)& id(
      const ::extensions::mojom::HostIDPtr& input) {
    return input->id;
  }

  static bool Read(::extensions::mojom::HostID::DataView input, ::extensions::mojom::HostIDPtr* output);
};

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_HOST_ID_MOJOM_H_