// content/common/input/input_injector.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/input/input_injector.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/input/input_injector.mojom-params-data.h"
#include "content/common/input/input_injector.mojom-shared-message-ids.h"

#include "content/common/input/input_injector.mojom-import-headers.h"
#include "content/common/input/input_injector.mojom-test-utils.h"
#include "content/common/content_param_traits_macros.h"
#include "content/public/common/common_param_traits.h"
#include "services/network/public/cpp/p2p_param_traits.h"


namespace content::mojom {
SyntheticSmoothDrag::SyntheticSmoothDrag()
    : gesture_source_type(),
      start_point(),
      distances(),
      speed_in_pixels_s(),
      vsync_offset_ms(),
      input_event_pattern() {}

SyntheticSmoothDrag::SyntheticSmoothDrag(
    GestureSourceType gesture_source_type_in,
    const ::gfx::PointF& start_point_in,
    std::vector<::gfx::Vector2dF> distances_in,
    float speed_in_pixels_s_in,
    float vsync_offset_ms_in,
    InputEventPattern input_event_pattern_in)
    : gesture_source_type(std::move(gesture_source_type_in)),
      start_point(std::move(start_point_in)),
      distances(std::move(distances_in)),
      speed_in_pixels_s(std::move(speed_in_pixels_s_in)),
      vsync_offset_ms(std::move(vsync_offset_ms_in)),
      input_event_pattern(std::move(input_event_pattern_in)) {}

SyntheticSmoothDrag::~SyntheticSmoothDrag() = default;

void SyntheticSmoothDrag::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture_source_type"), this->gesture_source_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GestureSourceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_point"), this->start_point,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "distances"), this->distances,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gfx::Vector2dF>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "speed_in_pixels_s"), this->speed_in_pixels_s,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vsync_offset_ms"), this->vsync_offset_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_event_pattern"), this->input_event_pattern,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InputEventPattern>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SyntheticSmoothDrag::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SyntheticSmoothScroll::SyntheticSmoothScroll()
    : gesture_source_type(),
      anchor(),
      distances(),
      prevent_fling(),
      speed_in_pixels_s(),
      fling_velocity_x(),
      fling_velocity_y(),
      granularity(),
      modifiers(),
      vsync_offset_ms(),
      input_event_pattern() {}

SyntheticSmoothScroll::SyntheticSmoothScroll(
    GestureSourceType gesture_source_type_in,
    const ::gfx::PointF& anchor_in,
    std::vector<::gfx::Vector2dF> distances_in,
    bool prevent_fling_in,
    float speed_in_pixels_s_in,
    float fling_velocity_x_in,
    float fling_velocity_y_in,
    ::ui::ScrollGranularity granularity_in,
    int32_t modifiers_in,
    float vsync_offset_ms_in,
    InputEventPattern input_event_pattern_in)
    : gesture_source_type(std::move(gesture_source_type_in)),
      anchor(std::move(anchor_in)),
      distances(std::move(distances_in)),
      prevent_fling(std::move(prevent_fling_in)),
      speed_in_pixels_s(std::move(speed_in_pixels_s_in)),
      fling_velocity_x(std::move(fling_velocity_x_in)),
      fling_velocity_y(std::move(fling_velocity_y_in)),
      granularity(std::move(granularity_in)),
      modifiers(std::move(modifiers_in)),
      vsync_offset_ms(std::move(vsync_offset_ms_in)),
      input_event_pattern(std::move(input_event_pattern_in)) {}

SyntheticSmoothScroll::~SyntheticSmoothScroll() = default;

void SyntheticSmoothScroll::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture_source_type"), this->gesture_source_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GestureSourceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor"), this->anchor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "distances"), this->distances,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gfx::Vector2dF>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prevent_fling"), this->prevent_fling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "speed_in_pixels_s"), this->speed_in_pixels_s,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fling_velocity_x"), this->fling_velocity_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fling_velocity_y"), this->fling_velocity_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "granularity"), this->granularity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::ScrollGranularity>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifiers"), this->modifiers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vsync_offset_ms"), this->vsync_offset_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_event_pattern"), this->input_event_pattern,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InputEventPattern>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SyntheticSmoothScroll::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SyntheticPinch::SyntheticPinch()
    : scale_factor(),
      anchor(),
      relative_pointer_speed_in_pixels_s(),
      vsync_offset_ms(),
      input_event_pattern() {}

SyntheticPinch::SyntheticPinch(
    float scale_factor_in,
    const ::gfx::PointF& anchor_in,
    float relative_pointer_speed_in_pixels_s_in,
    float vsync_offset_ms_in,
    InputEventPattern input_event_pattern_in)
    : scale_factor(std::move(scale_factor_in)),
      anchor(std::move(anchor_in)),
      relative_pointer_speed_in_pixels_s(std::move(relative_pointer_speed_in_pixels_s_in)),
      vsync_offset_ms(std::move(vsync_offset_ms_in)),
      input_event_pattern(std::move(input_event_pattern_in)) {}

SyntheticPinch::~SyntheticPinch() = default;

void SyntheticPinch::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_factor"), this->scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor"), this->anchor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relative_pointer_speed_in_pixels_s"), this->relative_pointer_speed_in_pixels_s,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vsync_offset_ms"), this->vsync_offset_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_event_pattern"), this->input_event_pattern,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InputEventPattern>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SyntheticPinch::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SyntheticTap::SyntheticTap()
    : gesture_source_type(),
      position(),
      duration_ms() {}

SyntheticTap::SyntheticTap(
    GestureSourceType gesture_source_type_in,
    const ::gfx::PointF& position_in,
    float duration_ms_in)
    : gesture_source_type(std::move(gesture_source_type_in)),
      position(std::move(position_in)),
      duration_ms(std::move(duration_ms_in)) {}

SyntheticTap::~SyntheticTap() = default;

void SyntheticTap::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture_source_type"), this->gesture_source_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GestureSourceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration_ms"), this->duration_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SyntheticTap::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SyntheticPointerActionParams::SyntheticPointerActionParams()
    : pointer_action_type(),
      position(),
      pointer_id(),
      button(),
      key_modifiers(),
      width(),
      height(),
      rotation_angle(),
      force(),
      tangential_pressure(),
      tilt_x(),
      tilt_y(),
      timestamp(),
      duration() {}

SyntheticPointerActionParams::SyntheticPointerActionParams(
    PointerActionType pointer_action_type_in,
    const ::gfx::PointF& position_in,
    uint32_t pointer_id_in,
    SyntheticButton button_in,
    int32_t key_modifiers_in,
    float width_in,
    float height_in,
    float rotation_angle_in,
    float force_in,
    float tangential_pressure_in,
    int32_t tilt_x_in,
    int32_t tilt_y_in,
    ::base::TimeTicks timestamp_in,
    ::base::TimeDelta duration_in)
    : pointer_action_type(std::move(pointer_action_type_in)),
      position(std::move(position_in)),
      pointer_id(std::move(pointer_id_in)),
      button(std::move(button_in)),
      key_modifiers(std::move(key_modifiers_in)),
      width(std::move(width_in)),
      height(std::move(height_in)),
      rotation_angle(std::move(rotation_angle_in)),
      force(std::move(force_in)),
      tangential_pressure(std::move(tangential_pressure_in)),
      tilt_x(std::move(tilt_x_in)),
      tilt_y(std::move(tilt_y_in)),
      timestamp(std::move(timestamp_in)),
      duration(std::move(duration_in)) {}

SyntheticPointerActionParams::~SyntheticPointerActionParams() = default;

void SyntheticPointerActionParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_action_type"), this->pointer_action_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PointerActionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_id"), this->pointer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "button"), this->button,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SyntheticButton>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_modifiers"), this->key_modifiers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rotation_angle"), this->rotation_angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force"), this->force,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tangential_pressure"), this->tangential_pressure,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tilt_x"), this->tilt_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tilt_y"), this->tilt_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SyntheticPointerActionParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SyntheticPointerAction::SyntheticPointerAction()
    : gesture_source_type(),
      params() {}

SyntheticPointerAction::SyntheticPointerAction(
    GestureSourceType gesture_source_type_in,
    std::vector<std::vector<SyntheticPointerActionParamsPtr>> params_in)
    : gesture_source_type(std::move(gesture_source_type_in)),
      params(std::move(params_in)) {}

SyntheticPointerAction::~SyntheticPointerAction() = default;

void SyntheticPointerAction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture_source_type"), this->gesture_source_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GestureSourceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<std::vector<SyntheticPointerActionParamsPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SyntheticPointerAction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

InputInjector::IPCStableHashFunction InputInjector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::InputInjector>(message.name())) {
    case messages::InputInjector::kQueueSyntheticSmoothDrag: {
      return &InputInjector::QueueSyntheticSmoothDrag_Sym::IPCStableHash;
    }
    case messages::InputInjector::kQueueSyntheticSmoothScroll: {
      return &InputInjector::QueueSyntheticSmoothScroll_Sym::IPCStableHash;
    }
    case messages::InputInjector::kQueueSyntheticPinch: {
      return &InputInjector::QueueSyntheticPinch_Sym::IPCStableHash;
    }
    case messages::InputInjector::kQueueSyntheticTap: {
      return &InputInjector::QueueSyntheticTap_Sym::IPCStableHash;
    }
    case messages::InputInjector::kQueueSyntheticPointerAction: {
      return &InputInjector::QueueSyntheticPointerAction_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* InputInjector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::InputInjector>(message.name())) {
      case messages::InputInjector::kQueueSyntheticSmoothDrag:
            return "Receive content::mojom::InputInjector::QueueSyntheticSmoothDrag";
      case messages::InputInjector::kQueueSyntheticSmoothScroll:
            return "Receive content::mojom::InputInjector::QueueSyntheticSmoothScroll";
      case messages::InputInjector::kQueueSyntheticPinch:
            return "Receive content::mojom::InputInjector::QueueSyntheticPinch";
      case messages::InputInjector::kQueueSyntheticTap:
            return "Receive content::mojom::InputInjector::QueueSyntheticTap";
      case messages::InputInjector::kQueueSyntheticPointerAction:
            return "Receive content::mojom::InputInjector::QueueSyntheticPointerAction";
    }
  } else {
    switch (static_cast<messages::InputInjector>(message.name())) {
      case messages::InputInjector::kQueueSyntheticSmoothDrag:
            return "Receive reply content::mojom::InputInjector::QueueSyntheticSmoothDrag";
      case messages::InputInjector::kQueueSyntheticSmoothScroll:
            return "Receive reply content::mojom::InputInjector::QueueSyntheticSmoothScroll";
      case messages::InputInjector::kQueueSyntheticPinch:
            return "Receive reply content::mojom::InputInjector::QueueSyntheticPinch";
      case messages::InputInjector::kQueueSyntheticTap:
            return "Receive reply content::mojom::InputInjector::QueueSyntheticTap";
      case messages::InputInjector::kQueueSyntheticPointerAction:
            return "Receive reply content::mojom::InputInjector::QueueSyntheticPointerAction";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t InputInjector::QueueSyntheticSmoothDrag_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80de6810;  // IPCStableHash for content::mojom::InputInjector::QueueSyntheticSmoothDrag
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t InputInjector::QueueSyntheticSmoothScroll_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80870ced;  // IPCStableHash for content::mojom::InputInjector::QueueSyntheticSmoothScroll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t InputInjector::QueueSyntheticPinch_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb44b347f;  // IPCStableHash for content::mojom::InputInjector::QueueSyntheticPinch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t InputInjector::QueueSyntheticTap_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xceac2cd9;  // IPCStableHash for content::mojom::InputInjector::QueueSyntheticTap
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t InputInjector::QueueSyntheticPointerAction_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed77d313;  // IPCStableHash for content::mojom::InputInjector::QueueSyntheticPointerAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback(
      InputInjector::QueueSyntheticSmoothDragCallback callback
      ) : callback_(std::move(callback)) {
  }

  InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback(const InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback&) = delete;
  InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback& operator=(const InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  InputInjector::QueueSyntheticSmoothDragCallback callback_;
};

class InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback(
      InputInjector::QueueSyntheticSmoothScrollCallback callback
      ) : callback_(std::move(callback)) {
  }

  InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback(const InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback&) = delete;
  InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback& operator=(const InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  InputInjector::QueueSyntheticSmoothScrollCallback callback_;
};

class InputInjector_QueueSyntheticPinch_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputInjector_QueueSyntheticPinch_ForwardToCallback(
      InputInjector::QueueSyntheticPinchCallback callback
      ) : callback_(std::move(callback)) {
  }

  InputInjector_QueueSyntheticPinch_ForwardToCallback(const InputInjector_QueueSyntheticPinch_ForwardToCallback&) = delete;
  InputInjector_QueueSyntheticPinch_ForwardToCallback& operator=(const InputInjector_QueueSyntheticPinch_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  InputInjector::QueueSyntheticPinchCallback callback_;
};

class InputInjector_QueueSyntheticTap_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputInjector_QueueSyntheticTap_ForwardToCallback(
      InputInjector::QueueSyntheticTapCallback callback
      ) : callback_(std::move(callback)) {
  }

  InputInjector_QueueSyntheticTap_ForwardToCallback(const InputInjector_QueueSyntheticTap_ForwardToCallback&) = delete;
  InputInjector_QueueSyntheticTap_ForwardToCallback& operator=(const InputInjector_QueueSyntheticTap_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  InputInjector::QueueSyntheticTapCallback callback_;
};

class InputInjector_QueueSyntheticPointerAction_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputInjector_QueueSyntheticPointerAction_ForwardToCallback(
      InputInjector::QueueSyntheticPointerActionCallback callback
      ) : callback_(std::move(callback)) {
  }

  InputInjector_QueueSyntheticPointerAction_ForwardToCallback(const InputInjector_QueueSyntheticPointerAction_ForwardToCallback&) = delete;
  InputInjector_QueueSyntheticPointerAction_ForwardToCallback& operator=(const InputInjector_QueueSyntheticPointerAction_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  InputInjector::QueueSyntheticPointerActionCallback callback_;
};

InputInjectorProxy::InputInjectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void InputInjectorProxy::QueueSyntheticSmoothDrag(
    const ::content::SyntheticSmoothDragGestureParams& in_drag, QueueSyntheticSmoothDragCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::InputInjector::QueueSyntheticSmoothDrag", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drag"), in_drag,
                        "<value of type const ::content::SyntheticSmoothDragGestureParams&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputInjector::kQueueSyntheticSmoothDrag), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticSmoothDrag_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->drag)::BaseType> drag_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::SyntheticSmoothDragDataView>(
    in_drag,
    drag_fragment);

  params->drag.Set(
      drag_fragment.is_null() ? nullptr : drag_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->drag.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null drag in InputInjector.QueueSyntheticSmoothDrag request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticSmoothDrag");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void InputInjectorProxy::QueueSyntheticSmoothScroll(
    const ::content::SyntheticSmoothScrollGestureParams& in_scroll, QueueSyntheticSmoothScrollCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::InputInjector::QueueSyntheticSmoothScroll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scroll"), in_scroll,
                        "<value of type const ::content::SyntheticSmoothScrollGestureParams&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputInjector::kQueueSyntheticSmoothScroll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticSmoothScroll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->scroll)::BaseType> scroll_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::SyntheticSmoothScrollDataView>(
    in_scroll,
    scroll_fragment);

  params->scroll.Set(
      scroll_fragment.is_null() ? nullptr : scroll_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->scroll.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null scroll in InputInjector.QueueSyntheticSmoothScroll request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticSmoothScroll");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void InputInjectorProxy::QueueSyntheticPinch(
    const ::content::SyntheticPinchGestureParams& in_pinch, QueueSyntheticPinchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::InputInjector::QueueSyntheticPinch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pinch"), in_pinch,
                        "<value of type const ::content::SyntheticPinchGestureParams&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputInjector::kQueueSyntheticPinch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticPinch_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pinch)::BaseType> pinch_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::SyntheticPinchDataView>(
    in_pinch,
    pinch_fragment);

  params->pinch.Set(
      pinch_fragment.is_null() ? nullptr : pinch_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pinch.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pinch in InputInjector.QueueSyntheticPinch request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticPinch");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputInjector_QueueSyntheticPinch_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void InputInjectorProxy::QueueSyntheticTap(
    const ::content::SyntheticTapGestureParams& in_tap, QueueSyntheticTapCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::InputInjector::QueueSyntheticTap", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tap"), in_tap,
                        "<value of type const ::content::SyntheticTapGestureParams&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputInjector::kQueueSyntheticTap), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticTap_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tap)::BaseType> tap_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::SyntheticTapDataView>(
    in_tap,
    tap_fragment);

  params->tap.Set(
      tap_fragment.is_null() ? nullptr : tap_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tap.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tap in InputInjector.QueueSyntheticTap request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticTap");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputInjector_QueueSyntheticTap_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void InputInjectorProxy::QueueSyntheticPointerAction(
    const ::content::SyntheticPointerActionListParams& in_pointer_action, QueueSyntheticPointerActionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::InputInjector::QueueSyntheticPointerAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pointer_action"), in_pointer_action,
                        "<value of type const ::content::SyntheticPointerActionListParams&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputInjector::kQueueSyntheticPointerAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticPointerAction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pointer_action)::BaseType> pointer_action_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::SyntheticPointerActionDataView>(
    in_pointer_action,
    pointer_action_fragment);

  params->pointer_action.Set(
      pointer_action_fragment.is_null() ? nullptr : pointer_action_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pointer_action.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pointer_action in InputInjector.QueueSyntheticPointerAction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticPointerAction");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputInjector_QueueSyntheticPointerAction_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static InputInjector::QueueSyntheticSmoothDragCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder> proxy(
        new InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputInjector::QueueSyntheticSmoothDragCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for InputInjector.0
  bool success = true;
  InputInjector_QueueSyntheticSmoothDrag_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputInjector::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply content::mojom::InputInjector::QueueSyntheticSmoothDrag");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputInjector::kQueueSyntheticSmoothDrag), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticSmoothDrag");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static InputInjector::QueueSyntheticSmoothScrollCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder> proxy(
        new InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputInjector::QueueSyntheticSmoothScrollCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for InputInjector.1
  bool success = true;
  InputInjector_QueueSyntheticSmoothScroll_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputInjector::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply content::mojom::InputInjector::QueueSyntheticSmoothScroll");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputInjector::kQueueSyntheticSmoothScroll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticSmoothScroll");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class InputInjector_QueueSyntheticPinch_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static InputInjector::QueueSyntheticPinchCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<InputInjector_QueueSyntheticPinch_ProxyToResponder> proxy(
        new InputInjector_QueueSyntheticPinch_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&InputInjector_QueueSyntheticPinch_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputInjector_QueueSyntheticPinch_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  InputInjector_QueueSyntheticPinch_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputInjector::QueueSyntheticPinchCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool InputInjector_QueueSyntheticPinch_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::InputInjector_QueueSyntheticPinch_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputInjector_QueueSyntheticPinch_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for InputInjector.2
  bool success = true;
  InputInjector_QueueSyntheticPinch_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputInjector::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void InputInjector_QueueSyntheticPinch_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply content::mojom::InputInjector::QueueSyntheticPinch");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputInjector::kQueueSyntheticPinch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticPinch_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticPinch");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class InputInjector_QueueSyntheticTap_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static InputInjector::QueueSyntheticTapCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<InputInjector_QueueSyntheticTap_ProxyToResponder> proxy(
        new InputInjector_QueueSyntheticTap_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&InputInjector_QueueSyntheticTap_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputInjector_QueueSyntheticTap_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  InputInjector_QueueSyntheticTap_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputInjector::QueueSyntheticTapCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool InputInjector_QueueSyntheticTap_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::InputInjector_QueueSyntheticTap_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputInjector_QueueSyntheticTap_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for InputInjector.3
  bool success = true;
  InputInjector_QueueSyntheticTap_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputInjector::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void InputInjector_QueueSyntheticTap_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply content::mojom::InputInjector::QueueSyntheticTap");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputInjector::kQueueSyntheticTap), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticTap_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticTap");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class InputInjector_QueueSyntheticPointerAction_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static InputInjector::QueueSyntheticPointerActionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<InputInjector_QueueSyntheticPointerAction_ProxyToResponder> proxy(
        new InputInjector_QueueSyntheticPointerAction_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&InputInjector_QueueSyntheticPointerAction_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputInjector_QueueSyntheticPointerAction_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  InputInjector_QueueSyntheticPointerAction_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputInjector::QueueSyntheticPointerActionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool InputInjector_QueueSyntheticPointerAction_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::InputInjector_QueueSyntheticPointerAction_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputInjector_QueueSyntheticPointerAction_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for InputInjector.4
  bool success = true;
  InputInjector_QueueSyntheticPointerAction_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputInjector::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void InputInjector_QueueSyntheticPointerAction_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply content::mojom::InputInjector::QueueSyntheticPointerAction");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputInjector::kQueueSyntheticPointerAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticPointerAction_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticPointerAction");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool InputInjectorStubDispatch::Accept(
    InputInjector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::InputInjector>(message->header()->name)) {
    case messages::InputInjector::kQueueSyntheticSmoothDrag: {
      break;
    }
    case messages::InputInjector::kQueueSyntheticSmoothScroll: {
      break;
    }
    case messages::InputInjector::kQueueSyntheticPinch: {
      break;
    }
    case messages::InputInjector::kQueueSyntheticTap: {
      break;
    }
    case messages::InputInjector::kQueueSyntheticPointerAction: {
      break;
    }
  }
  return false;
}

// static
bool InputInjectorStubDispatch::AcceptWithResponder(
    InputInjector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::InputInjector>(message->header()->name)) {
    case messages::InputInjector::kQueueSyntheticSmoothDrag: {
      internal::InputInjector_QueueSyntheticSmoothDrag_Params_Data* params =
          reinterpret_cast<
              internal::InputInjector_QueueSyntheticSmoothDrag_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for InputInjector.0
      bool success = true;
      ::content::SyntheticSmoothDragGestureParams p_drag{};
      InputInjector_QueueSyntheticSmoothDrag_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDrag(&p_drag))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputInjector::Name_, 0, false);
        return false;
      }
      auto callback =
          InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueSyntheticSmoothDrag(        
        std::move(p_drag), std::move(callback));
      return true;
    }
    case messages::InputInjector::kQueueSyntheticSmoothScroll: {
      internal::InputInjector_QueueSyntheticSmoothScroll_Params_Data* params =
          reinterpret_cast<
              internal::InputInjector_QueueSyntheticSmoothScroll_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for InputInjector.1
      bool success = true;
      ::content::SyntheticSmoothScrollGestureParams p_scroll{};
      InputInjector_QueueSyntheticSmoothScroll_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScroll(&p_scroll))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputInjector::Name_, 1, false);
        return false;
      }
      auto callback =
          InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueSyntheticSmoothScroll(        
        std::move(p_scroll), std::move(callback));
      return true;
    }
    case messages::InputInjector::kQueueSyntheticPinch: {
      internal::InputInjector_QueueSyntheticPinch_Params_Data* params =
          reinterpret_cast<
              internal::InputInjector_QueueSyntheticPinch_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for InputInjector.2
      bool success = true;
      ::content::SyntheticPinchGestureParams p_pinch{};
      InputInjector_QueueSyntheticPinch_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPinch(&p_pinch))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputInjector::Name_, 2, false);
        return false;
      }
      auto callback =
          InputInjector_QueueSyntheticPinch_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueSyntheticPinch(        
        std::move(p_pinch), std::move(callback));
      return true;
    }
    case messages::InputInjector::kQueueSyntheticTap: {
      internal::InputInjector_QueueSyntheticTap_Params_Data* params =
          reinterpret_cast<
              internal::InputInjector_QueueSyntheticTap_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for InputInjector.3
      bool success = true;
      ::content::SyntheticTapGestureParams p_tap{};
      InputInjector_QueueSyntheticTap_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTap(&p_tap))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputInjector::Name_, 3, false);
        return false;
      }
      auto callback =
          InputInjector_QueueSyntheticTap_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueSyntheticTap(        
        std::move(p_tap), std::move(callback));
      return true;
    }
    case messages::InputInjector::kQueueSyntheticPointerAction: {
      internal::InputInjector_QueueSyntheticPointerAction_Params_Data* params =
          reinterpret_cast<
              internal::InputInjector_QueueSyntheticPointerAction_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for InputInjector.4
      bool success = true;
      ::content::SyntheticPointerActionListParams p_pointer_action{};
      InputInjector_QueueSyntheticPointerAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPointerAction(&p_pointer_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputInjector::Name_, 4, false);
        return false;
      }
      auto callback =
          InputInjector_QueueSyntheticPointerAction_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueSyntheticPointerAction(        
        std::move(p_pointer_action), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kInputInjectorValidationInfo[] = {
    {base::to_underlying(messages::InputInjector::kQueueSyntheticSmoothDrag),
     { &internal::InputInjector_QueueSyntheticSmoothDrag_Params_Data::Validate,
      &internal::InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::InputInjector::kQueueSyntheticSmoothScroll),
     { &internal::InputInjector_QueueSyntheticSmoothScroll_Params_Data::Validate,
      &internal::InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::InputInjector::kQueueSyntheticPinch),
     { &internal::InputInjector_QueueSyntheticPinch_Params_Data::Validate,
      &internal::InputInjector_QueueSyntheticPinch_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::InputInjector::kQueueSyntheticTap),
     { &internal::InputInjector_QueueSyntheticTap_Params_Data::Validate,
      &internal::InputInjector_QueueSyntheticTap_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::InputInjector::kQueueSyntheticPointerAction),
     { &internal::InputInjector_QueueSyntheticPointerAction_Params_Data::Validate,
      &internal::InputInjector_QueueSyntheticPointerAction_ResponseParams_Data::Validate}},
};

bool InputInjectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::content::mojom::InputInjector::Name_,
    kInputInjectorValidationInfo);
}

bool InputInjectorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::content::mojom::InputInjector::Name_,
    kInputInjectorValidationInfo);

}


}  // content::mojom


namespace mojo {


// static
bool StructTraits<::content::mojom::SyntheticSmoothDrag::DataView, ::content::mojom::SyntheticSmoothDragPtr>::Read(
    ::content::mojom::SyntheticSmoothDrag::DataView input,
    ::content::mojom::SyntheticSmoothDragPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticSmoothDragPtr result(::content::mojom::SyntheticSmoothDrag::New());
  
      if (success && !input.ReadGestureSourceType(&result->gesture_source_type))
        success = false;
      if (success && !input.ReadStartPoint(&result->start_point))
        success = false;
      if (success && !input.ReadDistances(&result->distances))
        success = false;
      if (success)
        result->speed_in_pixels_s = input.speed_in_pixels_s();
      if (success)
        result->vsync_offset_ms = input.vsync_offset_ms();
      if (success && !input.ReadInputEventPattern(&result->input_event_pattern))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::SyntheticSmoothScroll::DataView, ::content::mojom::SyntheticSmoothScrollPtr>::Read(
    ::content::mojom::SyntheticSmoothScroll::DataView input,
    ::content::mojom::SyntheticSmoothScrollPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticSmoothScrollPtr result(::content::mojom::SyntheticSmoothScroll::New());
  
      if (success && !input.ReadGestureSourceType(&result->gesture_source_type))
        success = false;
      if (success && !input.ReadAnchor(&result->anchor))
        success = false;
      if (success && !input.ReadDistances(&result->distances))
        success = false;
      if (success)
        result->prevent_fling = input.prevent_fling();
      if (success)
        result->speed_in_pixels_s = input.speed_in_pixels_s();
      if (success)
        result->fling_velocity_x = input.fling_velocity_x();
      if (success)
        result->fling_velocity_y = input.fling_velocity_y();
      if (success && !input.ReadGranularity(&result->granularity))
        success = false;
      if (success)
        result->modifiers = input.modifiers();
      if (success)
        result->vsync_offset_ms = input.vsync_offset_ms();
      if (success && !input.ReadInputEventPattern(&result->input_event_pattern))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::SyntheticPinch::DataView, ::content::mojom::SyntheticPinchPtr>::Read(
    ::content::mojom::SyntheticPinch::DataView input,
    ::content::mojom::SyntheticPinchPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticPinchPtr result(::content::mojom::SyntheticPinch::New());
  
      if (success)
        result->scale_factor = input.scale_factor();
      if (success && !input.ReadAnchor(&result->anchor))
        success = false;
      if (success)
        result->relative_pointer_speed_in_pixels_s = input.relative_pointer_speed_in_pixels_s();
      if (success)
        result->vsync_offset_ms = input.vsync_offset_ms();
      if (success && !input.ReadInputEventPattern(&result->input_event_pattern))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::SyntheticTap::DataView, ::content::mojom::SyntheticTapPtr>::Read(
    ::content::mojom::SyntheticTap::DataView input,
    ::content::mojom::SyntheticTapPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticTapPtr result(::content::mojom::SyntheticTap::New());
  
      if (success && !input.ReadGestureSourceType(&result->gesture_source_type))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success)
        result->duration_ms = input.duration_ms();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::SyntheticPointerActionParams::DataView, ::content::mojom::SyntheticPointerActionParamsPtr>::Read(
    ::content::mojom::SyntheticPointerActionParams::DataView input,
    ::content::mojom::SyntheticPointerActionParamsPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticPointerActionParamsPtr result(::content::mojom::SyntheticPointerActionParams::New());
  
      if (success && !input.ReadPointerActionType(&result->pointer_action_type))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success)
        result->pointer_id = input.pointer_id();
      if (success && !input.ReadButton(&result->button))
        success = false;
      if (success)
        result->key_modifiers = input.key_modifiers();
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
      if (success)
        result->rotation_angle = input.rotation_angle();
      if (success)
        result->force = input.force();
      if (success)
        result->tangential_pressure = input.tangential_pressure();
      if (success)
        result->tilt_x = input.tilt_x();
      if (success)
        result->tilt_y = input.tilt_y();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadDuration(&result->duration))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::SyntheticPointerAction::DataView, ::content::mojom::SyntheticPointerActionPtr>::Read(
    ::content::mojom::SyntheticPointerAction::DataView input,
    ::content::mojom::SyntheticPointerActionPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticPointerActionPtr result(::content::mojom::SyntheticPointerAction::New());
  
      if (success && !input.ReadGestureSourceType(&result->gesture_source_type))
        success = false;
      if (success && !input.ReadParams(&result->params))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void InputInjectorInterceptorForTesting::QueueSyntheticSmoothDrag(const ::content::SyntheticSmoothDragGestureParams& drag, QueueSyntheticSmoothDragCallback callback) {
  GetForwardingInterface()->QueueSyntheticSmoothDrag(
    std::move(drag)
    , std::move(callback));
}
void InputInjectorInterceptorForTesting::QueueSyntheticSmoothScroll(const ::content::SyntheticSmoothScrollGestureParams& scroll, QueueSyntheticSmoothScrollCallback callback) {
  GetForwardingInterface()->QueueSyntheticSmoothScroll(
    std::move(scroll)
    , std::move(callback));
}
void InputInjectorInterceptorForTesting::QueueSyntheticPinch(const ::content::SyntheticPinchGestureParams& pinch, QueueSyntheticPinchCallback callback) {
  GetForwardingInterface()->QueueSyntheticPinch(
    std::move(pinch)
    , std::move(callback));
}
void InputInjectorInterceptorForTesting::QueueSyntheticTap(const ::content::SyntheticTapGestureParams& tap, QueueSyntheticTapCallback callback) {
  GetForwardingInterface()->QueueSyntheticTap(
    std::move(tap)
    , std::move(callback));
}
void InputInjectorInterceptorForTesting::QueueSyntheticPointerAction(const ::content::SyntheticPointerActionListParams& pointer_action, QueueSyntheticPointerActionCallback callback) {
  GetForwardingInterface()->QueueSyntheticPointerAction(
    std::move(pointer_action)
    , std::move(callback));
}
InputInjectorAsyncWaiter::InputInjectorAsyncWaiter(
    InputInjector* proxy) : proxy_(proxy) {}

InputInjectorAsyncWaiter::~InputInjectorAsyncWaiter() = default;


void InputInjectorAsyncWaiter::QueueSyntheticSmoothDrag(
    const ::content::SyntheticSmoothDragGestureParams& drag) {
  base::RunLoop loop;
  proxy_->QueueSyntheticSmoothDrag(
      std::move(drag),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void InputInjectorAsyncWaiter::QueueSyntheticSmoothScroll(
    const ::content::SyntheticSmoothScrollGestureParams& scroll) {
  base::RunLoop loop;
  proxy_->QueueSyntheticSmoothScroll(
      std::move(scroll),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void InputInjectorAsyncWaiter::QueueSyntheticPinch(
    const ::content::SyntheticPinchGestureParams& pinch) {
  base::RunLoop loop;
  proxy_->QueueSyntheticPinch(
      std::move(pinch),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void InputInjectorAsyncWaiter::QueueSyntheticTap(
    const ::content::SyntheticTapGestureParams& tap) {
  base::RunLoop loop;
  proxy_->QueueSyntheticTap(
      std::move(tap),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void InputInjectorAsyncWaiter::QueueSyntheticPointerAction(
    const ::content::SyntheticPointerActionListParams& pointer_action) {
  base::RunLoop loop;
  proxy_->QueueSyntheticPointerAction(
      std::move(pointer_action),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif