// content/common/frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/frame.mojom-params-data.h"
#include "content/common/frame.mojom-shared-message-ids.h"

#include "content/common/frame.mojom-import-headers.h"
#include "content/common/frame.mojom-test-utils.h"
#include "components/content_settings/core/common/content_settings_param_traits.h"
#include "content/common/content_param_traits_macros.h"
#include "content/public/common/common_param_traits.h"
#include "net/cert/cert_verify_result.h"
#include "services/network/public/cpp/p2p_param_traits.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"
#include "third_party/blink/public/common/frame/view_transition_state_mojom_traits.h"
#include "third_party/blink/public/common/messaging/task_attribution_id_mojom_traits.h"


namespace content::mojom {
CreateViewParams::CreateViewParams()
    : renderer_preferences(),
      web_preferences(),
      session_storage_namespace_id(),
      opener_frame_token(),
      replication_state(),
      devtools_main_frame_token(),
      main_frame(),
      hidden(),
      prerender_param(),
      never_composited(),
      window_was_opened_by_another_window(),
      type(),
      fenced_frame_mode(),
      outermost_origin(),
      blink_page_broadcast(),
      base_background_color(),
      color_provider_colors(),
      browsing_context_group_token(),
      attribution_support(),
      partitioned_popin_params(),
      navigation_metrics_token(),
      history_index(-1),
      history_length(0) {}

CreateViewParams::CreateViewParams(
    const ::blink::RendererPreferences& renderer_preferences_in,
    const ::blink::web_pref::WebPreferences& web_preferences_in,
    const std::string& session_storage_namespace_id_in,
    const std::optional<::blink::FrameToken>& opener_frame_token_in,
    ::blink::mojom::FrameReplicationStatePtr replication_state_in,
    const ::base::UnguessableToken& devtools_main_frame_token_in,
    CreateMainFrameUnionPtr main_frame_in,
    bool hidden_in,
    ::blink::mojom::PrerenderParamPtr prerender_param_in,
    bool never_composited_in,
    bool window_was_opened_by_another_window_in,
    ViewWidgetType type_in,
    ::blink::FencedFrame::DeprecatedFencedFrameMode fenced_frame_mode_in,
    const std::optional<::url::Origin>& outermost_origin_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast> blink_page_broadcast_in,
    std::optional<::SkColor> base_background_color_in,
    const ::blink::ColorProviderColorMaps& color_provider_colors_in,
    const ::base::UnguessableToken& browsing_context_group_token_in,
    ::network::mojom::AttributionSupport attribution_support_in,
    ::blink::mojom::PartitionedPopinParamsPtr partitioned_popin_params_in,
    const std::optional<::base::UnguessableToken>& navigation_metrics_token_in,
    int32_t history_index_in,
    int32_t history_length_in)
    : renderer_preferences(std::move(renderer_preferences_in)),
      web_preferences(std::move(web_preferences_in)),
      session_storage_namespace_id(std::move(session_storage_namespace_id_in)),
      opener_frame_token(std::move(opener_frame_token_in)),
      replication_state(std::move(replication_state_in)),
      devtools_main_frame_token(std::move(devtools_main_frame_token_in)),
      main_frame(std::move(main_frame_in)),
      hidden(std::move(hidden_in)),
      prerender_param(std::move(prerender_param_in)),
      never_composited(std::move(never_composited_in)),
      window_was_opened_by_another_window(std::move(window_was_opened_by_another_window_in)),
      type(std::move(type_in)),
      fenced_frame_mode(std::move(fenced_frame_mode_in)),
      outermost_origin(std::move(outermost_origin_in)),
      blink_page_broadcast(std::move(blink_page_broadcast_in)),
      base_background_color(std::move(base_background_color_in)),
      color_provider_colors(std::move(color_provider_colors_in)),
      browsing_context_group_token(std::move(browsing_context_group_token_in)),
      attribution_support(std::move(attribution_support_in)),
      partitioned_popin_params(std::move(partitioned_popin_params_in)),
      navigation_metrics_token(std::move(navigation_metrics_token_in)),
      history_index(std::move(history_index_in)),
      history_length(std::move(history_length_in)) {}

CreateViewParams::~CreateViewParams() = default;

void CreateViewParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_preferences"), this->renderer_preferences,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::RendererPreferences&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_preferences"), this->web_preferences,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::web_pref::WebPreferences&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_storage_namespace_id"), this->session_storage_namespace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opener_frame_token"), this->opener_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::FrameToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "replication_state"), this->replication_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::FrameReplicationStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_main_frame_token"), this->devtools_main_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame"), this->main_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CreateMainFrameUnionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hidden"), this->hidden,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prerender_param"), this->prerender_param,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PrerenderParamPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "never_composited"), this->never_composited,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_was_opened_by_another_window"), this->window_was_opened_by_another_window,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ViewWidgetType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fenced_frame_mode"), this->fenced_frame_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::FencedFrame::DeprecatedFencedFrameMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "outermost_origin"), this->outermost_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blink_page_broadcast"), this->blink_page_broadcast,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_background_color"), this->base_background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::SkColor>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_provider_colors"), this->color_provider_colors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::ColorProviderColorMaps&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browsing_context_group_token"), this->browsing_context_group_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_support"), this->attribution_support,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::AttributionSupport>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "partitioned_popin_params"), this->partitioned_popin_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PartitionedPopinParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_metrics_token"), this->navigation_metrics_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "history_index"), this->history_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "history_length"), this->history_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateViewParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateLocalMainFrameParams::CreateLocalMainFrameParams()
    : frame_token(),
      routing_id(::IPC::mojom::kRoutingIdNone),
      frame(),
      interface_broker(),
      associated_interface_provider_remote(),
      is_on_initial_empty_document(true),
      document_token(),
      policy_container(),
      widget_params(),
      subresource_loader_factories() {}

CreateLocalMainFrameParams::CreateLocalMainFrameParams(
    const ::blink::LocalFrameToken& frame_token_in,
    int32_t routing_id_in,
    ::mojo::PendingAssociatedReceiver<Frame> frame_in,
    ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> interface_broker_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider_remote_in,
    bool is_on_initial_empty_document_in,
    const ::blink::DocumentToken& document_token_in,
    ::blink::mojom::PolicyContainerPtr policy_container_in,
    CreateFrameWidgetParamsPtr widget_params_in,
    ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories_in)
    : frame_token(std::move(frame_token_in)),
      routing_id(std::move(routing_id_in)),
      frame(std::move(frame_in)),
      interface_broker(std::move(interface_broker_in)),
      associated_interface_provider_remote(std::move(associated_interface_provider_remote_in)),
      is_on_initial_empty_document(std::move(is_on_initial_empty_document_in)),
      document_token(std::move(document_token_in)),
      policy_container(std::move(policy_container_in)),
      widget_params(std::move(widget_params_in)),
      subresource_loader_factories(std::move(subresource_loader_factories_in)) {}

CreateLocalMainFrameParams::~CreateLocalMainFrameParams() = default;

void CreateLocalMainFrameParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_token"), this->frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::LocalFrameToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id"), this->routing_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame"), this->frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<Frame>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interface_broker"), this->interface_broker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "associated_interface_provider_remote"), this->associated_interface_provider_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::AssociatedInterfaceProvider>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_on_initial_empty_document"), this->is_on_initial_empty_document,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_token"), this->document_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::DocumentToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_container"), this->policy_container,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PolicyContainerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_params"), this->widget_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CreateFrameWidgetParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subresource_loader_factories"), this->subresource_loader_factories,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateLocalMainFrameParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateProvisionalLocalMainFrameParams::CreateProvisionalLocalMainFrameParams()
    : local_params(),
      previous_frame_token() {}

CreateProvisionalLocalMainFrameParams::CreateProvisionalLocalMainFrameParams(
    CreateLocalMainFrameParamsPtr local_params_in,
    const std::optional<::blink::FrameToken>& previous_frame_token_in)
    : local_params(std::move(local_params_in)),
      previous_frame_token(std::move(previous_frame_token_in)) {}

CreateProvisionalLocalMainFrameParams::~CreateProvisionalLocalMainFrameParams() = default;

void CreateProvisionalLocalMainFrameParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_params"), this->local_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CreateLocalMainFrameParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "previous_frame_token"), this->previous_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::FrameToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateProvisionalLocalMainFrameParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateRemoteMainFrameParams::CreateRemoteMainFrameParams()
    : token(),
      frame_interfaces(),
      main_frame_interfaces() {}

CreateRemoteMainFrameParams::CreateRemoteMainFrameParams(
    const ::blink::RemoteFrameToken& token_in,
    ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr frame_interfaces_in,
    ::blink::mojom::RemoteMainFrameInterfacesPtr main_frame_interfaces_in)
    : token(std::move(token_in)),
      frame_interfaces(std::move(frame_interfaces_in)),
      main_frame_interfaces(std::move(main_frame_interfaces_in)) {}

CreateRemoteMainFrameParams::~CreateRemoteMainFrameParams() = default;

void CreateRemoteMainFrameParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::RemoteFrameToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_interfaces"), this->frame_interfaces,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_interfaces"), this->main_frame_interfaces,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::RemoteMainFrameInterfacesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateRemoteMainFrameParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateFrameWidgetParams::CreateFrameWidgetParams()
    : routing_id(),
      frame_widget_host(),
      frame_widget(),
      widget_host(),
      widget(),
      visual_properties(),
      reuse_compositor() {}

CreateFrameWidgetParams::CreateFrameWidgetParams(
    int32_t routing_id_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget_in,
    const ::blink::VisualProperties& visual_properties_in,
    bool reuse_compositor_in)
    : routing_id(std::move(routing_id_in)),
      frame_widget_host(std::move(frame_widget_host_in)),
      frame_widget(std::move(frame_widget_in)),
      widget_host(std::move(widget_host_in)),
      widget(std::move(widget_in)),
      visual_properties(std::move(visual_properties_in)),
      reuse_compositor(std::move(reuse_compositor_in)) {}

CreateFrameWidgetParams::~CreateFrameWidgetParams() = default;

void CreateFrameWidgetParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id"), this->routing_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_widget_host"), this->frame_widget_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_widget"), this->frame_widget,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_host"), this->widget_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget"), this->widget,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visual_properties"), this->visual_properties,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::VisualProperties&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reuse_compositor"), this->reuse_compositor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateFrameWidgetParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateFrameParams::CreateFrameParams()
    : frame_token(),
      routing_id(),
      previous_frame_token(),
      opener_frame_token(),
      parent_frame_token(),
      previous_sibling_frame_token(),
      interface_broker(),
      tree_scope_type(),
      replication_state(),
      devtools_frame_token(),
      frame_owner_properties(),
      widget_params(),
      is_on_initial_empty_document(true),
      document_token(),
      policy_container(),
      frame(),
      associated_interface_provider_remote(),
      is_for_nested_main_frame(),
      navigation_metrics_token() {}

CreateFrameParams::CreateFrameParams(
    const ::blink::LocalFrameToken& frame_token_in,
    int32_t routing_id_in,
    const std::optional<::blink::FrameToken>& previous_frame_token_in,
    const std::optional<::blink::FrameToken>& opener_frame_token_in,
    const std::optional<::blink::FrameToken>& parent_frame_token_in,
    const std::optional<::blink::FrameToken>& previous_sibling_frame_token_in,
    ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> interface_broker_in,
    ::blink::mojom::TreeScopeType tree_scope_type_in,
    ::blink::mojom::FrameReplicationStatePtr replication_state_in,
    const ::base::UnguessableToken& devtools_frame_token_in,
    ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties_in,
    CreateFrameWidgetParamsPtr widget_params_in,
    bool is_on_initial_empty_document_in,
    const ::blink::DocumentToken& document_token_in,
    ::blink::mojom::PolicyContainerPtr policy_container_in,
    ::mojo::PendingAssociatedReceiver<Frame> frame_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider_remote_in,
    bool is_for_nested_main_frame_in,
    const std::optional<::base::UnguessableToken>& navigation_metrics_token_in)
    : frame_token(std::move(frame_token_in)),
      routing_id(std::move(routing_id_in)),
      previous_frame_token(std::move(previous_frame_token_in)),
      opener_frame_token(std::move(opener_frame_token_in)),
      parent_frame_token(std::move(parent_frame_token_in)),
      previous_sibling_frame_token(std::move(previous_sibling_frame_token_in)),
      interface_broker(std::move(interface_broker_in)),
      tree_scope_type(std::move(tree_scope_type_in)),
      replication_state(std::move(replication_state_in)),
      devtools_frame_token(std::move(devtools_frame_token_in)),
      frame_owner_properties(std::move(frame_owner_properties_in)),
      widget_params(std::move(widget_params_in)),
      is_on_initial_empty_document(std::move(is_on_initial_empty_document_in)),
      document_token(std::move(document_token_in)),
      policy_container(std::move(policy_container_in)),
      frame(std::move(frame_in)),
      associated_interface_provider_remote(std::move(associated_interface_provider_remote_in)),
      is_for_nested_main_frame(std::move(is_for_nested_main_frame_in)),
      navigation_metrics_token(std::move(navigation_metrics_token_in)) {}

CreateFrameParams::~CreateFrameParams() = default;

void CreateFrameParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_token"), this->frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::LocalFrameToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id"), this->routing_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "previous_frame_token"), this->previous_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::FrameToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opener_frame_token"), this->opener_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::FrameToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_frame_token"), this->parent_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::FrameToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "previous_sibling_frame_token"), this->previous_sibling_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::FrameToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interface_broker"), this->interface_broker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tree_scope_type"), this->tree_scope_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::TreeScopeType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "replication_state"), this->replication_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::FrameReplicationStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_frame_token"), this->devtools_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_owner_properties"), this->frame_owner_properties,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::FrameOwnerPropertiesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_params"), this->widget_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CreateFrameWidgetParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_on_initial_empty_document"), this->is_on_initial_empty_document,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_token"), this->document_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::DocumentToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_container"), this->policy_container,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PolicyContainerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame"), this->frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<Frame>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "associated_interface_provider_remote"), this->associated_interface_provider_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::AssociatedInterfaceProvider>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_for_nested_main_frame"), this->is_for_nested_main_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_metrics_token"), this->navigation_metrics_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateFrameParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SnapshotAccessibilityTreeParams::SnapshotAccessibilityTreeParams()
    : ax_mode(),
      max_nodes(),
      timeout() {}

SnapshotAccessibilityTreeParams::SnapshotAccessibilityTreeParams(
    uint32_t ax_mode_in,
    uint64_t max_nodes_in,
    ::base::TimeDelta timeout_in)
    : ax_mode(std::move(ax_mode_in)),
      max_nodes(std::move(max_nodes_in)),
      timeout(std::move(timeout_in)) {}

SnapshotAccessibilityTreeParams::~SnapshotAccessibilityTreeParams() = default;

void SnapshotAccessibilityTreeParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ax_mode"), this->ax_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_nodes"), this->max_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timeout"), this->timeout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SnapshotAccessibilityTreeParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateNewWindowParams::CreateNewWindowParams()
    : allow_popup(),
      window_container_type(),
      session_storage_namespace_id(),
      clone_from_session_storage_namespace_id(),
      frame_name(),
      opener_suppressed(),
      is_form_submission(),
      consumes_user_activation(),
      form_submission_post_data(),
      form_submission_post_content_type(),
      disposition(),
      target_url(),
      referrer(),
      features(),
      impression(),
      download_policy(),
      pip_options(),
      initiator_activation_and_ad_status(),
      frame_remote(),
      page_broadcast_remote(),
      main_frame_interface_broker(),
      associated_interface_provider(),
      widget_host(),
      widget(),
      frame_widget_host(),
      frame_widget() {}

CreateNewWindowParams::CreateNewWindowParams(
    bool allow_popup_in,
    ::content::mojom::WindowContainerType window_container_type_in,
    const std::string& session_storage_namespace_id_in,
    const std::string& clone_from_session_storage_namespace_id_in,
    const std::string& frame_name_in,
    bool opener_suppressed_in,
    bool is_form_submission_in,
    bool consumes_user_activation_in,
    ::scoped_refptr<::network::ResourceRequestBody> form_submission_post_data_in,
    const std::string& form_submission_post_content_type_in,
    ::WindowOpenDisposition disposition_in,
    const ::GURL& target_url_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    ::blink::mojom::WindowFeaturesPtr features_in,
    const std::optional<::blink::Impression>& impression_in,
    const ::blink::NavigationDownloadPolicy& download_policy_in,
    ::blink::mojom::PictureInPictureWindowOptionsPtr pip_options_in,
    ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status_in,
    ::mojo::PendingAssociatedRemote<Frame> frame_remote_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::PageBroadcast> page_broadcast_remote_in,
    ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> main_frame_interface_broker_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> widget_host_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> widget_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidgetHost> frame_widget_host_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidget> frame_widget_in)
    : allow_popup(std::move(allow_popup_in)),
      window_container_type(std::move(window_container_type_in)),
      session_storage_namespace_id(std::move(session_storage_namespace_id_in)),
      clone_from_session_storage_namespace_id(std::move(clone_from_session_storage_namespace_id_in)),
      frame_name(std::move(frame_name_in)),
      opener_suppressed(std::move(opener_suppressed_in)),
      is_form_submission(std::move(is_form_submission_in)),
      consumes_user_activation(std::move(consumes_user_activation_in)),
      form_submission_post_data(std::move(form_submission_post_data_in)),
      form_submission_post_content_type(std::move(form_submission_post_content_type_in)),
      disposition(std::move(disposition_in)),
      target_url(std::move(target_url_in)),
      referrer(std::move(referrer_in)),
      features(std::move(features_in)),
      impression(std::move(impression_in)),
      download_policy(std::move(download_policy_in)),
      pip_options(std::move(pip_options_in)),
      initiator_activation_and_ad_status(std::move(initiator_activation_and_ad_status_in)),
      frame_remote(std::move(frame_remote_in)),
      page_broadcast_remote(std::move(page_broadcast_remote_in)),
      main_frame_interface_broker(std::move(main_frame_interface_broker_in)),
      associated_interface_provider(std::move(associated_interface_provider_in)),
      widget_host(std::move(widget_host_in)),
      widget(std::move(widget_in)),
      frame_widget_host(std::move(frame_widget_host_in)),
      frame_widget(std::move(frame_widget_in)) {}

CreateNewWindowParams::~CreateNewWindowParams() = default;

void CreateNewWindowParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_popup"), this->allow_popup,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_container_type"), this->window_container_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::content::mojom::WindowContainerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_storage_namespace_id"), this->session_storage_namespace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clone_from_session_storage_namespace_id"), this->clone_from_session_storage_namespace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_name"), this->frame_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opener_suppressed"), this->opener_suppressed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_form_submission"), this->is_form_submission,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "consumes_user_activation"), this->consumes_user_activation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_submission_post_data"), this->form_submission_post_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::scoped_refptr<::network::ResourceRequestBody>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_submission_post_content_type"), this->form_submission_post_content_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disposition"), this->disposition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::WindowOpenDisposition>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_url"), this->target_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "features"), this->features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::WindowFeaturesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression"), this->impression,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Impression>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "download_policy"), this->download_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::NavigationDownloadPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pip_options"), this->pip_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PictureInPictureWindowOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_activation_and_ad_status"), this->initiator_activation_and_ad_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::NavigationInitiatorActivationAndAdStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_remote"), this->frame_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<Frame>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_broadcast_remote"), this->page_broadcast_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::PageBroadcast>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_interface_broker"), this->main_frame_interface_broker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "associated_interface_provider"), this->associated_interface_provider,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_host"), this->widget_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget"), this->widget,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::Widget>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_widget_host"), this->frame_widget_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidgetHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_widget"), this->frame_widget,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidget>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateNewWindowParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateNewWindowReply::CreateNewWindowReply()
    : main_frame_token(),
      main_frame_route_id(),
      widget_routing_id(),
      visual_properties(),
      cloned_session_storage_namespace_id(),
      devtools_main_frame_token(),
      wait_for_debugger(),
      document_token(),
      policy_container(),
      browsing_context_group_token(),
      color_provider_colors(),
      partitioned_popin_params(),
      widget_screen_rect(),
      window_screen_rect() {}

CreateNewWindowReply::CreateNewWindowReply(
    const ::blink::LocalFrameToken& main_frame_token_in,
    int32_t main_frame_route_id_in,
    int32_t widget_routing_id_in,
    const ::blink::VisualProperties& visual_properties_in,
    const std::string& cloned_session_storage_namespace_id_in,
    const ::base::UnguessableToken& devtools_main_frame_token_in,
    bool wait_for_debugger_in,
    const ::blink::DocumentToken& document_token_in,
    ::blink::mojom::PolicyContainerPtr policy_container_in,
    const ::base::UnguessableToken& browsing_context_group_token_in,
    const ::blink::ColorProviderColorMaps& color_provider_colors_in,
    ::blink::mojom::PartitionedPopinParamsPtr partitioned_popin_params_in,
    const std::optional<::gfx::Rect>& widget_screen_rect_in,
    const std::optional<::gfx::Rect>& window_screen_rect_in)
    : main_frame_token(std::move(main_frame_token_in)),
      main_frame_route_id(std::move(main_frame_route_id_in)),
      widget_routing_id(std::move(widget_routing_id_in)),
      visual_properties(std::move(visual_properties_in)),
      cloned_session_storage_namespace_id(std::move(cloned_session_storage_namespace_id_in)),
      devtools_main_frame_token(std::move(devtools_main_frame_token_in)),
      wait_for_debugger(std::move(wait_for_debugger_in)),
      document_token(std::move(document_token_in)),
      policy_container(std::move(policy_container_in)),
      browsing_context_group_token(std::move(browsing_context_group_token_in)),
      color_provider_colors(std::move(color_provider_colors_in)),
      partitioned_popin_params(std::move(partitioned_popin_params_in)),
      widget_screen_rect(std::move(widget_screen_rect_in)),
      window_screen_rect(std::move(window_screen_rect_in)) {}

CreateNewWindowReply::~CreateNewWindowReply() = default;

void CreateNewWindowReply::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_token"), this->main_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::LocalFrameToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_route_id"), this->main_frame_route_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_routing_id"), this->widget_routing_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visual_properties"), this->visual_properties,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::VisualProperties&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cloned_session_storage_namespace_id"), this->cloned_session_storage_namespace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_main_frame_token"), this->devtools_main_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_debugger"), this->wait_for_debugger,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_token"), this->document_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::DocumentToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_container"), this->policy_container,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PolicyContainerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browsing_context_group_token"), this->browsing_context_group_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_provider_colors"), this->color_provider_colors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::ColorProviderColorMaps&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "partitioned_popin_params"), this->partitioned_popin_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PartitionedPopinParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_screen_rect"), this->widget_screen_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_screen_rect"), this->window_screen_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateNewWindowReply::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateMainFrameUnionPtr
CreateMainFrameUnion::NewLocalParams(
    CreateLocalMainFrameParamsPtr value) {
  return CreateMainFrameUnionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kLocalParams)>,
      std::move(value));
}

CreateMainFrameUnionPtr
CreateMainFrameUnion::NewProvisionalLocalParams(
    CreateProvisionalLocalMainFrameParamsPtr value) {
  return CreateMainFrameUnionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kProvisionalLocalParams)>,
      std::move(value));
}

CreateMainFrameUnionPtr
CreateMainFrameUnion::NewRemoteParams(
    CreateRemoteMainFrameParamsPtr value) {
  return CreateMainFrameUnionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRemoteParams)>,
      std::move(value));
}

CreateMainFrameUnion::CreateMainFrameUnion(
    std::in_place_index_t<static_cast<size_t>(Tag::kLocalParams)>,
    CreateLocalMainFrameParamsPtr value)
    : tag_(Tag::kLocalParams),
      data_(std::in_place_index<static_cast<size_t>(Tag::kLocalParams)>,
            std::move(value)) {}

CreateMainFrameUnion::CreateMainFrameUnion(
    std::in_place_index_t<static_cast<size_t>(Tag::kProvisionalLocalParams)>,
    CreateProvisionalLocalMainFrameParamsPtr value)
    : tag_(Tag::kProvisionalLocalParams),
      data_(std::in_place_index<static_cast<size_t>(Tag::kProvisionalLocalParams)>,
            std::move(value)) {}

CreateMainFrameUnion::CreateMainFrameUnion(
    std::in_place_index_t<static_cast<size_t>(Tag::kRemoteParams)>,
    CreateRemoteMainFrameParamsPtr value)
    : tag_(Tag::kRemoteParams),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRemoteParams)>,
            std::move(value)) {}
CreateMainFrameUnion::~CreateMainFrameUnion() {
  DestroyActive();
}

void CreateMainFrameUnion::set_local_params(CreateLocalMainFrameParamsPtr local_params) {
  if (tag_ == Tag::kLocalParams) {
    data_.local_params = std::move(local_params);
  } else {
    DestroyActive();
    tag_ = Tag::kLocalParams;
    new (&data_.local_params) CreateLocalMainFrameParamsPtr(
        std::move(local_params));
  }
}

void CreateMainFrameUnion::set_provisional_local_params(CreateProvisionalLocalMainFrameParamsPtr provisional_local_params) {
  if (tag_ == Tag::kProvisionalLocalParams) {
    data_.provisional_local_params = std::move(provisional_local_params);
  } else {
    DestroyActive();
    tag_ = Tag::kProvisionalLocalParams;
    new (&data_.provisional_local_params) CreateProvisionalLocalMainFrameParamsPtr(
        std::move(provisional_local_params));
  }
}

void CreateMainFrameUnion::set_remote_params(CreateRemoteMainFrameParamsPtr remote_params) {
  if (tag_ == Tag::kRemoteParams) {
    data_.remote_params = std::move(remote_params);
  } else {
    DestroyActive();
    tag_ = Tag::kRemoteParams;
    new (&data_.remote_params) CreateRemoteMainFrameParamsPtr(
        std::move(remote_params));
  }
}


CreateMainFrameUnion::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kLocalParams)>,
    CreateLocalMainFrameParamsPtr value)
    : local_params(std::move(value)) {}

CreateMainFrameUnion::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kProvisionalLocalParams)>,
    CreateProvisionalLocalMainFrameParamsPtr value)
    : provisional_local_params(std::move(value)) {}

CreateMainFrameUnion::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRemoteParams)>,
    CreateRemoteMainFrameParamsPtr value)
    : remote_params(std::move(value)) {}

void CreateMainFrameUnion::DestroyActive() {
  switch (tag_) {

    case Tag::kLocalParams:
      std::destroy_at(&data_.local_params);
      break;
    case Tag::kProvisionalLocalParams:
      std::destroy_at(&data_.provisional_local_params);
      break;
    case Tag::kRemoteParams:
      std::destroy_at(&data_.remote_params);
      break;
  }
}

bool CreateMainFrameUnion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

FrameHTMLSerializerHandler::IPCStableHashFunction FrameHTMLSerializerHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameHTMLSerializerHandler>(message.name())) {
    case messages::FrameHTMLSerializerHandler::kDidReceiveData: {
      return &FrameHTMLSerializerHandler::DidReceiveData_Sym::IPCStableHash;
    }
    case messages::FrameHTMLSerializerHandler::kDone: {
      return &FrameHTMLSerializerHandler::Done_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameHTMLSerializerHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameHTMLSerializerHandler>(message.name())) {
      case messages::FrameHTMLSerializerHandler::kDidReceiveData:
            return "Receive content::mojom::FrameHTMLSerializerHandler::DidReceiveData";
      case messages::FrameHTMLSerializerHandler::kDone:
            return "Receive content::mojom::FrameHTMLSerializerHandler::Done";
    }
  } else {
    switch (static_cast<messages::FrameHTMLSerializerHandler>(message.name())) {
      case messages::FrameHTMLSerializerHandler::kDidReceiveData:
            return "Receive reply content::mojom::FrameHTMLSerializerHandler::DidReceiveData";
      case messages::FrameHTMLSerializerHandler::kDone:
            return "Receive reply content::mojom::FrameHTMLSerializerHandler::Done";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameHTMLSerializerHandler::DidReceiveData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x727514a7;  // IPCStableHash for content::mojom::FrameHTMLSerializerHandler::DidReceiveData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHTMLSerializerHandler::Done_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9c491728;  // IPCStableHash for content::mojom::FrameHTMLSerializerHandler::Done
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FrameHTMLSerializerHandlerProxy::FrameHTMLSerializerHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameHTMLSerializerHandlerProxy::DidReceiveData(
    const std::string& in_data_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHTMLSerializerHandler::DidReceiveData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_buffer"), in_data_buffer,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHTMLSerializerHandler::kDidReceiveData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHTMLSerializerHandler_DidReceiveData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data_buffer)::BaseType> data_buffer_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_data_buffer,
    data_buffer_fragment);

  params->data_buffer.Set(
      data_buffer_fragment.is_null() ? nullptr : data_buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data_buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data_buffer in FrameHTMLSerializerHandler.DidReceiveData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHTMLSerializerHandler::Name_);
  message.set_method_name("DidReceiveData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHTMLSerializerHandlerProxy::Done(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::FrameHTMLSerializerHandler::Done");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHTMLSerializerHandler::kDone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHTMLSerializerHandler_Done_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHTMLSerializerHandler::Name_);
  message.set_method_name("Done");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FrameHTMLSerializerHandlerStubDispatch::Accept(
    FrameHTMLSerializerHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameHTMLSerializerHandler>(message->header()->name)) {
    case messages::FrameHTMLSerializerHandler::kDidReceiveData: {
      DCHECK(message->is_serialized());
      internal::FrameHTMLSerializerHandler_DidReceiveData_Params_Data* params =
          reinterpret_cast<internal::FrameHTMLSerializerHandler_DidReceiveData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHTMLSerializerHandler.0
      bool success = true;
      std::string p_data_buffer{};
      FrameHTMLSerializerHandler_DidReceiveData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDataBuffer(&p_data_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHTMLSerializerHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReceiveData(        
        std::move(p_data_buffer));
      return true;
    }
    case messages::FrameHTMLSerializerHandler::kDone: {
      DCHECK(message->is_serialized());
      internal::FrameHTMLSerializerHandler_Done_Params_Data* params =
          reinterpret_cast<internal::FrameHTMLSerializerHandler_Done_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHTMLSerializerHandler.1
      bool success = true;
      FrameHTMLSerializerHandler_Done_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHTMLSerializerHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Done(        );
      return true;
    }
  }
  return false;
}

// static
bool FrameHTMLSerializerHandlerStubDispatch::AcceptWithResponder(
    FrameHTMLSerializerHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameHTMLSerializerHandler>(message->header()->name)) {
    case messages::FrameHTMLSerializerHandler::kDidReceiveData: {
      break;
    }
    case messages::FrameHTMLSerializerHandler::kDone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameHTMLSerializerHandlerValidationInfo[] = {
    {base::to_underlying(messages::FrameHTMLSerializerHandler::kDidReceiveData),
     { &internal::FrameHTMLSerializerHandler_DidReceiveData_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHTMLSerializerHandler::kDone),
     { &internal::FrameHTMLSerializerHandler_Done_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameHTMLSerializerHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::content::mojom::FrameHTMLSerializerHandler::Name_,
    kFrameHTMLSerializerHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

Frame::IPCStableHashFunction Frame::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Frame>(message.name())) {
    case messages::Frame::kCommitSameDocumentNavigation: {
      return &Frame::CommitSameDocumentNavigation_Sym::IPCStableHash;
    }
    case messages::Frame::kUpdateSubresourceLoaderFactories: {
      return &Frame::UpdateSubresourceLoaderFactories_Sym::IPCStableHash;
    }
    case messages::Frame::kSetWantErrorMessageStackTrace: {
      return &Frame::SetWantErrorMessageStackTrace_Sym::IPCStableHash;
    }
    case messages::Frame::kUnload: {
      return &Frame::Unload_Sym::IPCStableHash;
    }
    case messages::Frame::kDelete: {
      return &Frame::Delete_Sym::IPCStableHash;
    }
    case messages::Frame::kUndoCommitNavigation: {
      return &Frame::UndoCommitNavigation_Sym::IPCStableHash;
    }
    case messages::Frame::kGetInterfaceProvider: {
      return &Frame::GetInterfaceProvider_Sym::IPCStableHash;
    }
    case messages::Frame::kSnapshotAccessibilityTree: {
      return &Frame::SnapshotAccessibilityTree_Sym::IPCStableHash;
    }
    case messages::Frame::kGetSerializedHtmlWithLocalLinks: {
      return &Frame::GetSerializedHtmlWithLocalLinks_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Frame::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Frame>(message.name())) {
      case messages::Frame::kCommitSameDocumentNavigation:
            return "Receive content::mojom::Frame::CommitSameDocumentNavigation";
      case messages::Frame::kUpdateSubresourceLoaderFactories:
            return "Receive content::mojom::Frame::UpdateSubresourceLoaderFactories";
      case messages::Frame::kSetWantErrorMessageStackTrace:
            return "Receive content::mojom::Frame::SetWantErrorMessageStackTrace";
      case messages::Frame::kUnload:
            return "Receive content::mojom::Frame::Unload";
      case messages::Frame::kDelete:
            return "Receive content::mojom::Frame::Delete";
      case messages::Frame::kUndoCommitNavigation:
            return "Receive content::mojom::Frame::UndoCommitNavigation";
      case messages::Frame::kGetInterfaceProvider:
            return "Receive content::mojom::Frame::GetInterfaceProvider";
      case messages::Frame::kSnapshotAccessibilityTree:
            return "Receive content::mojom::Frame::SnapshotAccessibilityTree";
      case messages::Frame::kGetSerializedHtmlWithLocalLinks:
            return "Receive content::mojom::Frame::GetSerializedHtmlWithLocalLinks";
    }
  } else {
    switch (static_cast<messages::Frame>(message.name())) {
      case messages::Frame::kCommitSameDocumentNavigation:
            return "Receive reply content::mojom::Frame::CommitSameDocumentNavigation";
      case messages::Frame::kUpdateSubresourceLoaderFactories:
            return "Receive reply content::mojom::Frame::UpdateSubresourceLoaderFactories";
      case messages::Frame::kSetWantErrorMessageStackTrace:
            return "Receive reply content::mojom::Frame::SetWantErrorMessageStackTrace";
      case messages::Frame::kUnload:
            return "Receive reply content::mojom::Frame::Unload";
      case messages::Frame::kDelete:
            return "Receive reply content::mojom::Frame::Delete";
      case messages::Frame::kUndoCommitNavigation:
            return "Receive reply content::mojom::Frame::UndoCommitNavigation";
      case messages::Frame::kGetInterfaceProvider:
            return "Receive reply content::mojom::Frame::GetInterfaceProvider";
      case messages::Frame::kSnapshotAccessibilityTree:
            return "Receive reply content::mojom::Frame::SnapshotAccessibilityTree";
      case messages::Frame::kGetSerializedHtmlWithLocalLinks:
            return "Receive reply content::mojom::Frame::GetSerializedHtmlWithLocalLinks";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Frame::CommitSameDocumentNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeaba2488;  // IPCStableHash for content::mojom::Frame::CommitSameDocumentNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Frame::UpdateSubresourceLoaderFactories_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3592e723;  // IPCStableHash for content::mojom::Frame::UpdateSubresourceLoaderFactories
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Frame::SetWantErrorMessageStackTrace_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc1c9f8ff;  // IPCStableHash for content::mojom::Frame::SetWantErrorMessageStackTrace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Frame::Unload_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7535b86c;  // IPCStableHash for content::mojom::Frame::Unload
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Frame::Delete_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xecc16d96;  // IPCStableHash for content::mojom::Frame::Delete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Frame::UndoCommitNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe4e54aed;  // IPCStableHash for content::mojom::Frame::UndoCommitNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Frame::GetInterfaceProvider_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe817faf2;  // IPCStableHash for content::mojom::Frame::GetInterfaceProvider
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Frame::SnapshotAccessibilityTree_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x104c855d;  // IPCStableHash for content::mojom::Frame::SnapshotAccessibilityTree
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Frame::GetSerializedHtmlWithLocalLinks_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x18b998d7;  // IPCStableHash for content::mojom::Frame::GetSerializedHtmlWithLocalLinks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Frame_CommitSameDocumentNavigation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Frame_CommitSameDocumentNavigation_ForwardToCallback(
      Frame::CommitSameDocumentNavigationCallback callback
      ) : callback_(std::move(callback)) {
  }

  Frame_CommitSameDocumentNavigation_ForwardToCallback(const Frame_CommitSameDocumentNavigation_ForwardToCallback&) = delete;
  Frame_CommitSameDocumentNavigation_ForwardToCallback& operator=(const Frame_CommitSameDocumentNavigation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Frame::CommitSameDocumentNavigationCallback callback_;
};

class Frame_SnapshotAccessibilityTree_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Frame_SnapshotAccessibilityTree_ForwardToCallback(
      Frame::SnapshotAccessibilityTreeCallback callback
      ) : callback_(std::move(callback)) {
  }

  Frame_SnapshotAccessibilityTree_ForwardToCallback(const Frame_SnapshotAccessibilityTree_ForwardToCallback&) = delete;
  Frame_SnapshotAccessibilityTree_ForwardToCallback& operator=(const Frame_SnapshotAccessibilityTree_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Frame::SnapshotAccessibilityTreeCallback callback_;
};

FrameProxy::FrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameProxy::CommitSameDocumentNavigation(
    ::blink::mojom::CommonNavigationParamsPtr in_common_params, ::blink::mojom::CommitNavigationParamsPtr in_request_params, CommitSameDocumentNavigationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Frame::CommitSameDocumentNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("common_params"), in_common_params,
                        "<value of type ::blink::mojom::CommonNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_params"), in_request_params,
                        "<value of type ::blink::mojom::CommitNavigationParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = mojo::UrgentMessageScope::IsInUrgentScope();


  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Frame::kCommitSameDocumentNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_CommitSameDocumentNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->common_params)::BaseType> common_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CommonNavigationParamsDataView>(
    in_common_params,
    common_params_fragment);

  params->common_params.Set(
      common_params_fragment.is_null() ? nullptr : common_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->common_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null common_params in Frame.CommitSameDocumentNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_params)::BaseType> request_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CommitNavigationParamsDataView>(
    in_request_params,
    request_params_fragment);

  params->request_params.Set(
      request_params_fragment.is_null() ? nullptr : request_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_params in Frame.CommitSameDocumentNavigation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("CommitSameDocumentNavigation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Frame_CommitSameDocumentNavigation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameProxy::UpdateSubresourceLoaderFactories(
    ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Frame::UpdateSubresourceLoaderFactories", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_factories"), in_subresource_loader_factories,
                        "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Frame::kUpdateSubresourceLoaderFactories), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_UpdateSubresourceLoaderFactories_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
    in_subresource_loader_factories,
    subresource_loader_factories_fragment);

  params->subresource_loader_factories.Set(
      subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subresource_loader_factories.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subresource_loader_factories in Frame.UpdateSubresourceLoaderFactories request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("UpdateSubresourceLoaderFactories");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameProxy::SetWantErrorMessageStackTrace(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::Frame::SetWantErrorMessageStackTrace");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Frame::kSetWantErrorMessageStackTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_SetWantErrorMessageStackTrace_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("SetWantErrorMessageStackTrace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameProxy::Unload(
    bool in_is_loading, ::blink::mojom::FrameReplicationStatePtr in_new_remote_frame_replication_state, const ::blink::RemoteFrameToken& in_new_remote_frame_token, ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr in_new_remote_frame_interfaces, ::blink::mojom::RemoteMainFrameInterfacesPtr in_new_remote_main_frame_interfaces, const std::optional<::base::UnguessableToken>& in_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Frame::Unload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_loading"), in_is_loading,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_remote_frame_replication_state"), in_new_remote_frame_replication_state,
                        "<value of type ::blink::mojom::FrameReplicationStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_remote_frame_token"), in_new_remote_frame_token,
                        "<value of type const ::blink::RemoteFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_remote_frame_interfaces"), in_new_remote_frame_interfaces,
                        "<value of type ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_remote_main_frame_interfaces"), in_new_remote_main_frame_interfaces,
                        "<value of type ::blink::mojom::RemoteMainFrameInterfacesPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_frame_token"), in_devtools_frame_token,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Frame::kUnload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_Unload_Params_Data> params(
          message);
  params.Allocate();

  params->is_loading = in_is_loading;
  mojo::internal::MessageFragment<
      typename decltype(params->new_remote_frame_replication_state)::BaseType> new_remote_frame_replication_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FrameReplicationStateDataView>(
    in_new_remote_frame_replication_state,
    new_remote_frame_replication_state_fragment);

  params->new_remote_frame_replication_state.Set(
      new_remote_frame_replication_state_fragment.is_null() ? nullptr : new_remote_frame_replication_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_remote_frame_replication_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_remote_frame_replication_state in Frame.Unload request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_remote_frame_token)::BaseType> new_remote_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
    in_new_remote_frame_token,
    new_remote_frame_token_fragment);

  params->new_remote_frame_token.Set(
      new_remote_frame_token_fragment.is_null() ? nullptr : new_remote_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_remote_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_remote_frame_token in Frame.Unload request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_remote_frame_interfaces)::BaseType> new_remote_frame_interfaces_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView>(
    in_new_remote_frame_interfaces,
    new_remote_frame_interfaces_fragment);

  params->new_remote_frame_interfaces.Set(
      new_remote_frame_interfaces_fragment.is_null() ? nullptr : new_remote_frame_interfaces_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_remote_frame_interfaces.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_remote_frame_interfaces in Frame.Unload request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_remote_main_frame_interfaces)::BaseType> new_remote_main_frame_interfaces_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteMainFrameInterfacesDataView>(
    in_new_remote_main_frame_interfaces,
    new_remote_main_frame_interfaces_fragment);

  params->new_remote_main_frame_interfaces.Set(
      new_remote_main_frame_interfaces_fragment.is_null() ? nullptr : new_remote_main_frame_interfaces_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_remote_main_frame_interfaces.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_remote_main_frame_interfaces in Frame.Unload request");
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_frame_token)::BaseType> devtools_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_devtools_frame_token,
    devtools_frame_token_fragment);

  params->devtools_frame_token.Set(
      devtools_frame_token_fragment.is_null() ? nullptr : devtools_frame_token_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("Unload");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameProxy::Delete(
    FrameDeleteIntention in_intention) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Frame::Delete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intention"), in_intention,
                        "<value of type FrameDeleteIntention>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Frame::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_Delete_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::content::mojom::FrameDeleteIntention>(
    in_intention,
    &params->intention);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("Delete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameProxy::UndoCommitNavigation(
    bool in_is_loading, ::blink::mojom::FrameReplicationStatePtr in_new_remote_frame_replication_state, const ::blink::RemoteFrameToken& in_new_remote_frame_token, ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr in_new_remote_frame_interfaces, ::blink::mojom::RemoteMainFrameInterfacesPtr in_new_remote_main_frame_interfaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Frame::UndoCommitNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_loading"), in_is_loading,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_remote_frame_replication_state"), in_new_remote_frame_replication_state,
                        "<value of type ::blink::mojom::FrameReplicationStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_remote_frame_token"), in_new_remote_frame_token,
                        "<value of type const ::blink::RemoteFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_remote_frame_interfaces"), in_new_remote_frame_interfaces,
                        "<value of type ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_remote_main_frame_interfaces"), in_new_remote_main_frame_interfaces,
                        "<value of type ::blink::mojom::RemoteMainFrameInterfacesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Frame::kUndoCommitNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_UndoCommitNavigation_Params_Data> params(
          message);
  params.Allocate();

  params->is_loading = in_is_loading;
  mojo::internal::MessageFragment<
      typename decltype(params->new_remote_frame_replication_state)::BaseType> new_remote_frame_replication_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FrameReplicationStateDataView>(
    in_new_remote_frame_replication_state,
    new_remote_frame_replication_state_fragment);

  params->new_remote_frame_replication_state.Set(
      new_remote_frame_replication_state_fragment.is_null() ? nullptr : new_remote_frame_replication_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_remote_frame_replication_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_remote_frame_replication_state in Frame.UndoCommitNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_remote_frame_token)::BaseType> new_remote_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
    in_new_remote_frame_token,
    new_remote_frame_token_fragment);

  params->new_remote_frame_token.Set(
      new_remote_frame_token_fragment.is_null() ? nullptr : new_remote_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_remote_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_remote_frame_token in Frame.UndoCommitNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_remote_frame_interfaces)::BaseType> new_remote_frame_interfaces_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView>(
    in_new_remote_frame_interfaces,
    new_remote_frame_interfaces_fragment);

  params->new_remote_frame_interfaces.Set(
      new_remote_frame_interfaces_fragment.is_null() ? nullptr : new_remote_frame_interfaces_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_remote_frame_interfaces.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_remote_frame_interfaces in Frame.UndoCommitNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_remote_main_frame_interfaces)::BaseType> new_remote_main_frame_interfaces_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteMainFrameInterfacesDataView>(
    in_new_remote_main_frame_interfaces,
    new_remote_main_frame_interfaces_fragment);

  params->new_remote_main_frame_interfaces.Set(
      new_remote_main_frame_interfaces_fragment.is_null() ? nullptr : new_remote_main_frame_interfaces_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_remote_main_frame_interfaces.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_remote_main_frame_interfaces in Frame.UndoCommitNavigation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("UndoCommitNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameProxy::GetInterfaceProvider(
    ::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> in_interfaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Frame::GetInterfaceProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interfaces"), in_interfaces,
                        "<value of type ::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Frame::kGetInterfaceProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_GetInterfaceProvider_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::service_manager::mojom::InterfaceProviderInterfaceBase>>(
    in_interfaces,
    &params->interfaces,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->interfaces)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid interfaces in Frame.GetInterfaceProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("GetInterfaceProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameProxy::SnapshotAccessibilityTree(
    SnapshotAccessibilityTreeParamsPtr in_params, SnapshotAccessibilityTreeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Frame::SnapshotAccessibilityTree", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type SnapshotAccessibilityTreeParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Frame::kSnapshotAccessibilityTree), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_SnapshotAccessibilityTree_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::SnapshotAccessibilityTreeParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in Frame.SnapshotAccessibilityTree request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("SnapshotAccessibilityTree");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Frame_SnapshotAccessibilityTree_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameProxy::GetSerializedHtmlWithLocalLinks(
    const base::flat_map<::GURL, ::base::FilePath>& in_url_map, const base::flat_map<::blink::FrameToken, ::base::FilePath>& in_frame_token_map, bool in_save_with_empty_url, ::mojo::PendingRemote<FrameHTMLSerializerHandler> in_handler_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::Frame::GetSerializedHtmlWithLocalLinks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_map"), in_url_map,
                        "<value of type const base::flat_map<::GURL, ::base::FilePath>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token_map"), in_frame_token_map,
                        "<value of type const base::flat_map<::blink::FrameToken, ::base::FilePath>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("save_with_empty_url"), in_save_with_empty_url,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler_remote"), in_handler_remote,
                        "<value of type ::mojo::PendingRemote<FrameHTMLSerializerHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Frame::kGetSerializedHtmlWithLocalLinks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_GetSerializedHtmlWithLocalLinks_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url_map)::BaseType>
      url_map_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& url_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::url::mojom::UrlDataView, ::mojo_base::mojom::FilePathDataView>>(
    in_url_map,
    url_map_fragment,
    &url_map_validate_params);

  params->url_map.Set(
      url_map_fragment.is_null() ? nullptr : url_map_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url_map.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url_map in Frame.GetSerializedHtmlWithLocalLinks request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token_map)::BaseType>
      frame_token_map_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& frame_token_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::FrameTokenDataView, ::mojo_base::mojom::FilePathDataView>>(
    in_frame_token_map,
    frame_token_map_fragment,
    &frame_token_map_validate_params);

  params->frame_token_map.Set(
      frame_token_map_fragment.is_null() ? nullptr : frame_token_map_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_token_map.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_token_map in Frame.GetSerializedHtmlWithLocalLinks request");

  params->save_with_empty_url = in_save_with_empty_url;

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::content::mojom::FrameHTMLSerializerHandlerInterfaceBase>>(
    in_handler_remote,
    &params->handler_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler_remote in Frame.GetSerializedHtmlWithLocalLinks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("GetSerializedHtmlWithLocalLinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Frame_CommitSameDocumentNavigation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Frame::CommitSameDocumentNavigationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Frame_CommitSameDocumentNavigation_ProxyToResponder> proxy(
        new Frame_CommitSameDocumentNavigation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Frame_CommitSameDocumentNavigation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Frame_CommitSameDocumentNavigation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Frame_CommitSameDocumentNavigation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Frame::CommitSameDocumentNavigationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::CommitResult in_commit_result);
};

bool Frame_CommitSameDocumentNavigation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Frame_CommitSameDocumentNavigation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Frame_CommitSameDocumentNavigation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Frame.0
  bool success = true;
  ::blink::mojom::CommitResult p_commit_result{};
  Frame_CommitSameDocumentNavigation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCommitResult(&p_commit_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Frame::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_commit_result));
  }
  return true;
}

void Frame_CommitSameDocumentNavigation_ProxyToResponder::Run(
    ::blink::mojom::CommitResult in_commit_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content::mojom::Frame::CommitSameDocumentNavigation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("commit_result"), in_commit_result,
                        "<value of type ::blink::mojom::CommitResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Frame::kCommitSameDocumentNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_CommitSameDocumentNavigation_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::CommitResult>(
    in_commit_result,
    &params->commit_result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("CommitSameDocumentNavigation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Frame_SnapshotAccessibilityTree_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Frame::SnapshotAccessibilityTreeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Frame_SnapshotAccessibilityTree_ProxyToResponder> proxy(
        new Frame_SnapshotAccessibilityTree_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Frame_SnapshotAccessibilityTree_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Frame_SnapshotAccessibilityTree_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Frame_SnapshotAccessibilityTree_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Frame::SnapshotAccessibilityTreeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::ui::AXTreeUpdate& in_snapshot);
};

bool Frame_SnapshotAccessibilityTree_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Frame_SnapshotAccessibilityTree_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Frame_SnapshotAccessibilityTree_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Frame.7
  bool success = true;
  ::ui::AXTreeUpdate p_snapshot{};
  Frame_SnapshotAccessibilityTree_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSnapshot(&p_snapshot))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Frame::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_snapshot));
  }
  return true;
}

void Frame_SnapshotAccessibilityTree_ProxyToResponder::Run(
    const ::ui::AXTreeUpdate& in_snapshot) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content::mojom::Frame::SnapshotAccessibilityTree", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("snapshot"), in_snapshot,
                        "<value of type const ::ui::AXTreeUpdate&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Frame::kSnapshotAccessibilityTree), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_SnapshotAccessibilityTree_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->snapshot)::BaseType> snapshot_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView>(
    in_snapshot,
    snapshot_fragment);

  params->snapshot.Set(
      snapshot_fragment.is_null() ? nullptr : snapshot_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->snapshot.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null snapshot in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("SnapshotAccessibilityTree");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FrameStubDispatch::Accept(
    Frame* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Frame>(message->header()->name)) {
    case messages::Frame::kCommitSameDocumentNavigation: {
      break;
    }
    case messages::Frame::kUpdateSubresourceLoaderFactories: {
      DCHECK(message->is_serialized());
      internal::Frame_UpdateSubresourceLoaderFactories_Params_Data* params =
          reinterpret_cast<internal::Frame_UpdateSubresourceLoaderFactories_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Frame.1
      bool success = true;
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      Frame_UpdateSubresourceLoaderFactories_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSubresourceLoaderFactories(        
        std::move(p_subresource_loader_factories));
      return true;
    }
    case messages::Frame::kSetWantErrorMessageStackTrace: {
      DCHECK(message->is_serialized());
      internal::Frame_SetWantErrorMessageStackTrace_Params_Data* params =
          reinterpret_cast<internal::Frame_SetWantErrorMessageStackTrace_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Frame.2
      bool success = true;
      Frame_SetWantErrorMessageStackTrace_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWantErrorMessageStackTrace(        );
      return true;
    }
    case messages::Frame::kUnload: {
      DCHECK(message->is_serialized());
      internal::Frame_Unload_Params_Data* params =
          reinterpret_cast<internal::Frame_Unload_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Frame.3
      bool success = true;
      bool p_is_loading{};
      ::blink::mojom::FrameReplicationStatePtr p_new_remote_frame_replication_state{};
      ::blink::RemoteFrameToken p_new_remote_frame_token{};
      ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr p_new_remote_frame_interfaces{};
      ::blink::mojom::RemoteMainFrameInterfacesPtr p_new_remote_main_frame_interfaces{};
      std::optional<::base::UnguessableToken> p_devtools_frame_token{};
      Frame_Unload_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_loading = input_data_view.is_loading();
      if (success && !input_data_view.ReadNewRemoteFrameReplicationState(&p_new_remote_frame_replication_state))
        success = false;
      if (success && !input_data_view.ReadNewRemoteFrameToken(&p_new_remote_frame_token))
        success = false;
      if (success && !input_data_view.ReadNewRemoteFrameInterfaces(&p_new_remote_frame_interfaces))
        success = false;
      if (success && !input_data_view.ReadNewRemoteMainFrameInterfaces(&p_new_remote_main_frame_interfaces))
        success = false;
      if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unload(        
        std::move(p_is_loading), 
        std::move(p_new_remote_frame_replication_state), 
        std::move(p_new_remote_frame_token), 
        std::move(p_new_remote_frame_interfaces), 
        std::move(p_new_remote_main_frame_interfaces), 
        std::move(p_devtools_frame_token));
      return true;
    }
    case messages::Frame::kDelete: {
      DCHECK(message->is_serialized());
      internal::Frame_Delete_Params_Data* params =
          reinterpret_cast<internal::Frame_Delete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Frame.4
      bool success = true;
      FrameDeleteIntention p_intention{};
      Frame_Delete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIntention(&p_intention))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(        
        std::move(p_intention));
      return true;
    }
    case messages::Frame::kUndoCommitNavigation: {
      DCHECK(message->is_serialized());
      internal::Frame_UndoCommitNavigation_Params_Data* params =
          reinterpret_cast<internal::Frame_UndoCommitNavigation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Frame.5
      bool success = true;
      bool p_is_loading{};
      ::blink::mojom::FrameReplicationStatePtr p_new_remote_frame_replication_state{};
      ::blink::RemoteFrameToken p_new_remote_frame_token{};
      ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr p_new_remote_frame_interfaces{};
      ::blink::mojom::RemoteMainFrameInterfacesPtr p_new_remote_main_frame_interfaces{};
      Frame_UndoCommitNavigation_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_loading = input_data_view.is_loading();
      if (success && !input_data_view.ReadNewRemoteFrameReplicationState(&p_new_remote_frame_replication_state))
        success = false;
      if (success && !input_data_view.ReadNewRemoteFrameToken(&p_new_remote_frame_token))
        success = false;
      if (success && !input_data_view.ReadNewRemoteFrameInterfaces(&p_new_remote_frame_interfaces))
        success = false;
      if (success && !input_data_view.ReadNewRemoteMainFrameInterfaces(&p_new_remote_main_frame_interfaces))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UndoCommitNavigation(        
        std::move(p_is_loading), 
        std::move(p_new_remote_frame_replication_state), 
        std::move(p_new_remote_frame_token), 
        std::move(p_new_remote_frame_interfaces), 
        std::move(p_new_remote_main_frame_interfaces));
      return true;
    }
    case messages::Frame::kGetInterfaceProvider: {
      DCHECK(message->is_serialized());
      internal::Frame_GetInterfaceProvider_Params_Data* params =
          reinterpret_cast<internal::Frame_GetInterfaceProvider_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Frame.6
      bool success = true;
      ::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> p_interfaces{};
      Frame_GetInterfaceProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_interfaces =
            input_data_view.TakeInterfaces<decltype(p_interfaces)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInterfaceProvider(        
        std::move(p_interfaces));
      return true;
    }
    case messages::Frame::kSnapshotAccessibilityTree: {
      break;
    }
    case messages::Frame::kGetSerializedHtmlWithLocalLinks: {
      DCHECK(message->is_serialized());
      internal::Frame_GetSerializedHtmlWithLocalLinks_Params_Data* params =
          reinterpret_cast<internal::Frame_GetSerializedHtmlWithLocalLinks_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Frame.8
      bool success = true;
      base::flat_map<::GURL, ::base::FilePath> p_url_map{};
      base::flat_map<::blink::FrameToken, ::base::FilePath> p_frame_token_map{};
      bool p_save_with_empty_url{};
      ::mojo::PendingRemote<FrameHTMLSerializerHandler> p_handler_remote{};
      Frame_GetSerializedHtmlWithLocalLinks_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrlMap(&p_url_map))
        success = false;
      if (success && !input_data_view.ReadFrameTokenMap(&p_frame_token_map))
        success = false;
      if (success)
        p_save_with_empty_url = input_data_view.save_with_empty_url();
      if (success) {
        p_handler_remote =
            input_data_view.TakeHandlerRemote<decltype(p_handler_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSerializedHtmlWithLocalLinks(        
        std::move(p_url_map), 
        std::move(p_frame_token_map), 
        std::move(p_save_with_empty_url), 
        std::move(p_handler_remote));
      return true;
    }
  }
  return false;
}

// static
bool FrameStubDispatch::AcceptWithResponder(
    Frame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Frame>(message->header()->name)) {
    case messages::Frame::kCommitSameDocumentNavigation: {
      internal::Frame_CommitSameDocumentNavigation_Params_Data* params =
          reinterpret_cast<
              internal::Frame_CommitSameDocumentNavigation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Frame.0
      bool success = true;
      ::blink::mojom::CommonNavigationParamsPtr p_common_params{};
      ::blink::mojom::CommitNavigationParamsPtr p_request_params{};
      Frame_CommitSameDocumentNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommonParams(&p_common_params))
        success = false;
      if (success && !input_data_view.ReadRequestParams(&p_request_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 0, false);
        return false;
      }
      auto callback =
          Frame_CommitSameDocumentNavigation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitSameDocumentNavigation(        
        std::move(p_common_params), 
        std::move(p_request_params), std::move(callback));
      return true;
    }
    case messages::Frame::kUpdateSubresourceLoaderFactories: {
      break;
    }
    case messages::Frame::kSetWantErrorMessageStackTrace: {
      break;
    }
    case messages::Frame::kUnload: {
      break;
    }
    case messages::Frame::kDelete: {
      break;
    }
    case messages::Frame::kUndoCommitNavigation: {
      break;
    }
    case messages::Frame::kGetInterfaceProvider: {
      break;
    }
    case messages::Frame::kSnapshotAccessibilityTree: {
      internal::Frame_SnapshotAccessibilityTree_Params_Data* params =
          reinterpret_cast<
              internal::Frame_SnapshotAccessibilityTree_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Frame.7
      bool success = true;
      SnapshotAccessibilityTreeParamsPtr p_params{};
      Frame_SnapshotAccessibilityTree_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 7, false);
        return false;
      }
      auto callback =
          Frame_SnapshotAccessibilityTree_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SnapshotAccessibilityTree(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::Frame::kGetSerializedHtmlWithLocalLinks: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameValidationInfo[] = {
    {base::to_underlying(messages::Frame::kCommitSameDocumentNavigation),
     { &internal::Frame_CommitSameDocumentNavigation_Params_Data::Validate,
      &internal::Frame_CommitSameDocumentNavigation_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Frame::kUpdateSubresourceLoaderFactories),
     { &internal::Frame_UpdateSubresourceLoaderFactories_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Frame::kSetWantErrorMessageStackTrace),
     { &internal::Frame_SetWantErrorMessageStackTrace_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Frame::kUnload),
     { &internal::Frame_Unload_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Frame::kDelete),
     { &internal::Frame_Delete_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Frame::kUndoCommitNavigation),
     { &internal::Frame_UndoCommitNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Frame::kGetInterfaceProvider),
     { &internal::Frame_GetInterfaceProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Frame::kSnapshotAccessibilityTree),
     { &internal::Frame_SnapshotAccessibilityTree_Params_Data::Validate,
      &internal::Frame_SnapshotAccessibilityTree_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Frame::kGetSerializedHtmlWithLocalLinks),
     { &internal::Frame_GetSerializedHtmlWithLocalLinks_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::content::mojom::Frame::Name_,
    kFrameValidationInfo);
}

bool FrameResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::content::mojom::Frame::Name_,
    kFrameValidationInfo);

}
// The declaration includes the definition on other builds.

FrameBindingsControl::IPCStableHashFunction FrameBindingsControl::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameBindingsControl>(message.name())) {
    case messages::FrameBindingsControl::kAllowBindings: {
      return &FrameBindingsControl::AllowBindings_Sym::IPCStableHash;
    }
    case messages::FrameBindingsControl::kEnableMojoJsBindings: {
      return &FrameBindingsControl::EnableMojoJsBindings_Sym::IPCStableHash;
    }
    case messages::FrameBindingsControl::kEnableMojoJsBindingsWithBroker: {
      return &FrameBindingsControl::EnableMojoJsBindingsWithBroker_Sym::IPCStableHash;
    }
    case messages::FrameBindingsControl::kBindWebUI: {
      return &FrameBindingsControl::BindWebUI_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameBindingsControl::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameBindingsControl>(message.name())) {
      case messages::FrameBindingsControl::kAllowBindings:
            return "Receive content::mojom::FrameBindingsControl::AllowBindings";
      case messages::FrameBindingsControl::kEnableMojoJsBindings:
            return "Receive content::mojom::FrameBindingsControl::EnableMojoJsBindings";
      case messages::FrameBindingsControl::kEnableMojoJsBindingsWithBroker:
            return "Receive content::mojom::FrameBindingsControl::EnableMojoJsBindingsWithBroker";
      case messages::FrameBindingsControl::kBindWebUI:
            return "Receive content::mojom::FrameBindingsControl::BindWebUI";
    }
  } else {
    switch (static_cast<messages::FrameBindingsControl>(message.name())) {
      case messages::FrameBindingsControl::kAllowBindings:
            return "Receive reply content::mojom::FrameBindingsControl::AllowBindings";
      case messages::FrameBindingsControl::kEnableMojoJsBindings:
            return "Receive reply content::mojom::FrameBindingsControl::EnableMojoJsBindings";
      case messages::FrameBindingsControl::kEnableMojoJsBindingsWithBroker:
            return "Receive reply content::mojom::FrameBindingsControl::EnableMojoJsBindingsWithBroker";
      case messages::FrameBindingsControl::kBindWebUI:
            return "Receive reply content::mojom::FrameBindingsControl::BindWebUI";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameBindingsControl::AllowBindings_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa5813d7b;  // IPCStableHash for content::mojom::FrameBindingsControl::AllowBindings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameBindingsControl::EnableMojoJsBindings_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a7838b9;  // IPCStableHash for content::mojom::FrameBindingsControl::EnableMojoJsBindings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameBindingsControl::EnableMojoJsBindingsWithBroker_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xae859cff;  // IPCStableHash for content::mojom::FrameBindingsControl::EnableMojoJsBindingsWithBroker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameBindingsControl::BindWebUI_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb21928c;  // IPCStableHash for content::mojom::FrameBindingsControl::BindWebUI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FrameBindingsControlProxy::FrameBindingsControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameBindingsControlProxy::AllowBindings(
    int64_t in_enabled_bindings_flags) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameBindingsControl::AllowBindings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled_bindings_flags"), in_enabled_bindings_flags,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameBindingsControl::kAllowBindings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameBindingsControl_AllowBindings_Params_Data> params(
          message);
  params.Allocate();

  params->enabled_bindings_flags = in_enabled_bindings_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameBindingsControl::Name_);
  message.set_method_name("AllowBindings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameBindingsControlProxy::EnableMojoJsBindings(
    ::content::mojom::ExtraMojoJsFeaturesPtr in_features) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameBindingsControl::EnableMojoJsBindings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features"), in_features,
                        "<value of type ::content::mojom::ExtraMojoJsFeaturesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameBindingsControl::kEnableMojoJsBindings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameBindingsControl_EnableMojoJsBindings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->features)::BaseType> features_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::ExtraMojoJsFeaturesDataView>(
    in_features,
    features_fragment);

  params->features.Set(
      features_fragment.is_null() ? nullptr : features_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameBindingsControl::Name_);
  message.set_method_name("EnableMojoJsBindings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameBindingsControlProxy::EnableMojoJsBindingsWithBroker(
    ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> in_broker) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameBindingsControl::EnableMojoJsBindingsWithBroker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("broker"), in_broker,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameBindingsControl::kEnableMojoJsBindingsWithBroker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameBindingsControl_EnableMojoJsBindingsWithBroker_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
    in_broker,
    &params->broker,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->broker)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid broker in FrameBindingsControl.EnableMojoJsBindingsWithBroker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameBindingsControl::Name_);
  message.set_method_name("EnableMojoJsBindingsWithBroker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameBindingsControlProxy::BindWebUI(
    ::mojo::PendingAssociatedReceiver<::content::mojom::WebUI> in_receiver, ::mojo::PendingAssociatedRemote<::content::mojom::WebUIHost> in_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameBindingsControl::BindWebUI", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::content::mojom::WebUI>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote"), in_remote,
                        "<value of type ::mojo::PendingAssociatedRemote<::content::mojom::WebUIHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameBindingsControl::kBindWebUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameBindingsControl_BindWebUI_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::content::mojom::WebUIAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in FrameBindingsControl.BindWebUI request");

  
  mojo::internal::Serialize<::content::mojom::WebUIHostAssociatedPtrInfoDataView>(
    in_remote,
    &params->remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid remote in FrameBindingsControl.BindWebUI request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameBindingsControl::Name_);
  message.set_method_name("BindWebUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FrameBindingsControlStubDispatch::Accept(
    FrameBindingsControl* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameBindingsControl>(message->header()->name)) {
    case messages::FrameBindingsControl::kAllowBindings: {
      DCHECK(message->is_serialized());
      internal::FrameBindingsControl_AllowBindings_Params_Data* params =
          reinterpret_cast<internal::FrameBindingsControl_AllowBindings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameBindingsControl.0
      bool success = true;
      int64_t p_enabled_bindings_flags{};
      FrameBindingsControl_AllowBindings_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled_bindings_flags = input_data_view.enabled_bindings_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameBindingsControl::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllowBindings(        
        std::move(p_enabled_bindings_flags));
      return true;
    }
    case messages::FrameBindingsControl::kEnableMojoJsBindings: {
      DCHECK(message->is_serialized());
      internal::FrameBindingsControl_EnableMojoJsBindings_Params_Data* params =
          reinterpret_cast<internal::FrameBindingsControl_EnableMojoJsBindings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameBindingsControl.1
      bool success = true;
      ::content::mojom::ExtraMojoJsFeaturesPtr p_features{};
      FrameBindingsControl_EnableMojoJsBindings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameBindingsControl::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableMojoJsBindings(        
        std::move(p_features));
      return true;
    }
    case messages::FrameBindingsControl::kEnableMojoJsBindingsWithBroker: {
      DCHECK(message->is_serialized());
      internal::FrameBindingsControl_EnableMojoJsBindingsWithBroker_Params_Data* params =
          reinterpret_cast<internal::FrameBindingsControl_EnableMojoJsBindingsWithBroker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameBindingsControl.2
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> p_broker{};
      FrameBindingsControl_EnableMojoJsBindingsWithBroker_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_broker =
            input_data_view.TakeBroker<decltype(p_broker)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameBindingsControl::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableMojoJsBindingsWithBroker(        
        std::move(p_broker));
      return true;
    }
    case messages::FrameBindingsControl::kBindWebUI: {
      DCHECK(message->is_serialized());
      internal::FrameBindingsControl_BindWebUI_Params_Data* params =
          reinterpret_cast<internal::FrameBindingsControl_BindWebUI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameBindingsControl.3
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::content::mojom::WebUI> p_receiver{};
      ::mojo::PendingAssociatedRemote<::content::mojom::WebUIHost> p_remote{};
      FrameBindingsControl_BindWebUI_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_remote =
            input_data_view.TakeRemote<decltype(p_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameBindingsControl::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindWebUI(        
        std::move(p_receiver), 
        std::move(p_remote));
      return true;
    }
  }
  return false;
}

// static
bool FrameBindingsControlStubDispatch::AcceptWithResponder(
    FrameBindingsControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameBindingsControl>(message->header()->name)) {
    case messages::FrameBindingsControl::kAllowBindings: {
      break;
    }
    case messages::FrameBindingsControl::kEnableMojoJsBindings: {
      break;
    }
    case messages::FrameBindingsControl::kEnableMojoJsBindingsWithBroker: {
      break;
    }
    case messages::FrameBindingsControl::kBindWebUI: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameBindingsControlValidationInfo[] = {
    {base::to_underlying(messages::FrameBindingsControl::kAllowBindings),
     { &internal::FrameBindingsControl_AllowBindings_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameBindingsControl::kEnableMojoJsBindings),
     { &internal::FrameBindingsControl_EnableMojoJsBindings_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameBindingsControl::kEnableMojoJsBindingsWithBroker),
     { &internal::FrameBindingsControl_EnableMojoJsBindingsWithBroker_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameBindingsControl::kBindWebUI),
     { &internal::FrameBindingsControl_BindWebUI_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameBindingsControlRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::content::mojom::FrameBindingsControl::Name_,
    kFrameBindingsControlValidationInfo);
}

// The declaration includes the definition on other builds.

NavigationRendererCancellationListener::IPCStableHashFunction NavigationRendererCancellationListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NavigationRendererCancellationListener>(message.name())) {
    case messages::NavigationRendererCancellationListener::kRendererCancellationWindowEnded: {
      return &NavigationRendererCancellationListener::RendererCancellationWindowEnded_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NavigationRendererCancellationListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NavigationRendererCancellationListener>(message.name())) {
      case messages::NavigationRendererCancellationListener::kRendererCancellationWindowEnded:
            return "Receive content::mojom::NavigationRendererCancellationListener::RendererCancellationWindowEnded";
    }
  } else {
    switch (static_cast<messages::NavigationRendererCancellationListener>(message.name())) {
      case messages::NavigationRendererCancellationListener::kRendererCancellationWindowEnded:
            return "Receive reply content::mojom::NavigationRendererCancellationListener::RendererCancellationWindowEnded";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NavigationRendererCancellationListener::RendererCancellationWindowEnded_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf179d6bd;  // IPCStableHash for content::mojom::NavigationRendererCancellationListener::RendererCancellationWindowEnded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NavigationRendererCancellationListenerProxy::NavigationRendererCancellationListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NavigationRendererCancellationListenerProxy::RendererCancellationWindowEnded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::NavigationRendererCancellationListener::RendererCancellationWindowEnded");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NavigationRendererCancellationListener::kRendererCancellationWindowEnded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::NavigationRendererCancellationListener_RendererCancellationWindowEnded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationRendererCancellationListener::Name_);
  message.set_method_name("RendererCancellationWindowEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NavigationRendererCancellationListenerStubDispatch::Accept(
    NavigationRendererCancellationListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NavigationRendererCancellationListener>(message->header()->name)) {
    case messages::NavigationRendererCancellationListener::kRendererCancellationWindowEnded: {
      DCHECK(message->is_serialized());
      internal::NavigationRendererCancellationListener_RendererCancellationWindowEnded_Params_Data* params =
          reinterpret_cast<internal::NavigationRendererCancellationListener_RendererCancellationWindowEnded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NavigationRendererCancellationListener.0
      bool success = true;
      NavigationRendererCancellationListener_RendererCancellationWindowEnded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigationRendererCancellationListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RendererCancellationWindowEnded(        );
      return true;
    }
  }
  return false;
}

// static
bool NavigationRendererCancellationListenerStubDispatch::AcceptWithResponder(
    NavigationRendererCancellationListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NavigationRendererCancellationListener>(message->header()->name)) {
    case messages::NavigationRendererCancellationListener::kRendererCancellationWindowEnded: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNavigationRendererCancellationListenerValidationInfo[] = {
    {base::to_underlying(messages::NavigationRendererCancellationListener::kRendererCancellationWindowEnded),
     { &internal::NavigationRendererCancellationListener_RendererCancellationWindowEnded_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NavigationRendererCancellationListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::content::mojom::NavigationRendererCancellationListener::Name_,
    kNavigationRendererCancellationListenerValidationInfo);
}

// The declaration includes the definition on other builds.

FrameHost::IPCStableHashFunction FrameHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameHost>(message.name())) {
    case messages::FrameHost::kCreateNewWindow: {
      return &FrameHost::CreateNewWindow_Sym::IPCStableHash;
    }
    case messages::FrameHost::kCreateChildFrame: {
      return &FrameHost::CreateChildFrame_Sym::IPCStableHash;
    }
    case messages::FrameHost::kDidCommitProvisionalLoad: {
      return &FrameHost::DidCommitProvisionalLoad_Sym::IPCStableHash;
    }
    case messages::FrameHost::kDidCommitSameDocumentNavigation: {
      return &FrameHost::DidCommitSameDocumentNavigation_Sym::IPCStableHash;
    }
    case messages::FrameHost::kDidOpenDocumentInputStream: {
      return &FrameHost::DidOpenDocumentInputStream_Sym::IPCStableHash;
    }
    case messages::FrameHost::kBeginNavigation: {
      return &FrameHost::BeginNavigation_Sym::IPCStableHash;
    }
    case messages::FrameHost::kSubresourceResponseStarted: {
      return &FrameHost::SubresourceResponseStarted_Sym::IPCStableHash;
    }
    case messages::FrameHost::kResourceLoadComplete: {
      return &FrameHost::ResourceLoadComplete_Sym::IPCStableHash;
    }
    case messages::FrameHost::kDidChangeName: {
      return &FrameHost::DidChangeName_Sym::IPCStableHash;
    }
    case messages::FrameHost::kCancelInitialHistoryLoad: {
      return &FrameHost::CancelInitialHistoryLoad_Sym::IPCStableHash;
    }
    case messages::FrameHost::kUpdateEncoding: {
      return &FrameHost::UpdateEncoding_Sym::IPCStableHash;
    }
    case messages::FrameHost::kUpdateState: {
      return &FrameHost::UpdateState_Sym::IPCStableHash;
    }
    case messages::FrameHost::kOpenURL: {
      return &FrameHost::OpenURL_Sym::IPCStableHash;
    }
    case messages::FrameHost::kDidStopLoading: {
      return &FrameHost::DidStopLoading_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameHost>(message.name())) {
      case messages::FrameHost::kCreateNewWindow:
            return "Receive content::mojom::FrameHost::CreateNewWindow";
      case messages::FrameHost::kCreateChildFrame:
            return "Receive content::mojom::FrameHost::CreateChildFrame";
      case messages::FrameHost::kDidCommitProvisionalLoad:
            return "Receive content::mojom::FrameHost::DidCommitProvisionalLoad";
      case messages::FrameHost::kDidCommitSameDocumentNavigation:
            return "Receive content::mojom::FrameHost::DidCommitSameDocumentNavigation";
      case messages::FrameHost::kDidOpenDocumentInputStream:
            return "Receive content::mojom::FrameHost::DidOpenDocumentInputStream";
      case messages::FrameHost::kBeginNavigation:
            return "Receive content::mojom::FrameHost::BeginNavigation";
      case messages::FrameHost::kSubresourceResponseStarted:
            return "Receive content::mojom::FrameHost::SubresourceResponseStarted";
      case messages::FrameHost::kResourceLoadComplete:
            return "Receive content::mojom::FrameHost::ResourceLoadComplete";
      case messages::FrameHost::kDidChangeName:
            return "Receive content::mojom::FrameHost::DidChangeName";
      case messages::FrameHost::kCancelInitialHistoryLoad:
            return "Receive content::mojom::FrameHost::CancelInitialHistoryLoad";
      case messages::FrameHost::kUpdateEncoding:
            return "Receive content::mojom::FrameHost::UpdateEncoding";
      case messages::FrameHost::kUpdateState:
            return "Receive content::mojom::FrameHost::UpdateState";
      case messages::FrameHost::kOpenURL:
            return "Receive content::mojom::FrameHost::OpenURL";
      case messages::FrameHost::kDidStopLoading:
            return "Receive content::mojom::FrameHost::DidStopLoading";
    }
  } else {
    switch (static_cast<messages::FrameHost>(message.name())) {
      case messages::FrameHost::kCreateNewWindow:
            return "Receive reply content::mojom::FrameHost::CreateNewWindow";
      case messages::FrameHost::kCreateChildFrame:
            return "Receive reply content::mojom::FrameHost::CreateChildFrame";
      case messages::FrameHost::kDidCommitProvisionalLoad:
            return "Receive reply content::mojom::FrameHost::DidCommitProvisionalLoad";
      case messages::FrameHost::kDidCommitSameDocumentNavigation:
            return "Receive reply content::mojom::FrameHost::DidCommitSameDocumentNavigation";
      case messages::FrameHost::kDidOpenDocumentInputStream:
            return "Receive reply content::mojom::FrameHost::DidOpenDocumentInputStream";
      case messages::FrameHost::kBeginNavigation:
            return "Receive reply content::mojom::FrameHost::BeginNavigation";
      case messages::FrameHost::kSubresourceResponseStarted:
            return "Receive reply content::mojom::FrameHost::SubresourceResponseStarted";
      case messages::FrameHost::kResourceLoadComplete:
            return "Receive reply content::mojom::FrameHost::ResourceLoadComplete";
      case messages::FrameHost::kDidChangeName:
            return "Receive reply content::mojom::FrameHost::DidChangeName";
      case messages::FrameHost::kCancelInitialHistoryLoad:
            return "Receive reply content::mojom::FrameHost::CancelInitialHistoryLoad";
      case messages::FrameHost::kUpdateEncoding:
            return "Receive reply content::mojom::FrameHost::UpdateEncoding";
      case messages::FrameHost::kUpdateState:
            return "Receive reply content::mojom::FrameHost::UpdateState";
      case messages::FrameHost::kOpenURL:
            return "Receive reply content::mojom::FrameHost::OpenURL";
      case messages::FrameHost::kDidStopLoading:
            return "Receive reply content::mojom::FrameHost::DidStopLoading";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameHost::CreateNewWindow_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f11c1f7;  // IPCStableHash for content::mojom::FrameHost::CreateNewWindow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::CreateChildFrame_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1de9cce;  // IPCStableHash for content::mojom::FrameHost::CreateChildFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::DidCommitProvisionalLoad_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2d16e781;  // IPCStableHash for content::mojom::FrameHost::DidCommitProvisionalLoad
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::DidCommitSameDocumentNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x92cb554d;  // IPCStableHash for content::mojom::FrameHost::DidCommitSameDocumentNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::DidOpenDocumentInputStream_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x57448081;  // IPCStableHash for content::mojom::FrameHost::DidOpenDocumentInputStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::BeginNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x45909ce8;  // IPCStableHash for content::mojom::FrameHost::BeginNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::SubresourceResponseStarted_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9cc83cf4;  // IPCStableHash for content::mojom::FrameHost::SubresourceResponseStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::ResourceLoadComplete_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xddc73861;  // IPCStableHash for content::mojom::FrameHost::ResourceLoadComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::DidChangeName_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1135d568;  // IPCStableHash for content::mojom::FrameHost::DidChangeName
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::CancelInitialHistoryLoad_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0930154f;  // IPCStableHash for content::mojom::FrameHost::CancelInitialHistoryLoad
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::UpdateEncoding_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x209bdb72;  // IPCStableHash for content::mojom::FrameHost::UpdateEncoding
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::UpdateState_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2c25ae92;  // IPCStableHash for content::mojom::FrameHost::UpdateState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::OpenURL_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc79d1fd1;  // IPCStableHash for content::mojom::FrameHost::OpenURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameHost::DidStopLoading_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x11eb6bbf;  // IPCStableHash for content::mojom::FrameHost::DidStopLoading
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool FrameHost::CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply) {
  NOTREACHED();
}
class FrameHost_CreateNewWindow_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreateNewWindow_HandleSyncResponse(
      bool* result, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply)
      : result_(result), out_status_(out_status), out_reply_(out_reply) {
    DCHECK(!*result_);
  }

  FrameHost_CreateNewWindow_HandleSyncResponse(const FrameHost_CreateNewWindow_HandleSyncResponse&) = delete;
  FrameHost_CreateNewWindow_HandleSyncResponse& operator=(const FrameHost_CreateNewWindow_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  CreateNewWindowStatus* out_status_;
  CreateNewWindowReplyPtr* out_reply_;};

class FrameHost_CreateNewWindow_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreateNewWindow_ForwardToCallback(
      FrameHost::CreateNewWindowCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameHost_CreateNewWindow_ForwardToCallback(const FrameHost_CreateNewWindow_ForwardToCallback&) = delete;
  FrameHost_CreateNewWindow_ForwardToCallback& operator=(const FrameHost_CreateNewWindow_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameHost::CreateNewWindowCallback callback_;
};

FrameHostProxy::FrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FrameHostProxy::CreateNewWindow(
    CreateNewWindowParamsPtr param_params, CreateNewWindowStatus* out_param_status, CreateNewWindowReplyPtr* out_param_reply) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call content::mojom::FrameHost::CreateNewWindow (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), param_params,
                        "<value of type CreateNewWindowParamsPtr>");
   });
#else
  TRACE_EVENT0("mojom", "FrameHost::CreateNewWindow");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kCreateNewWindow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CreateNewWindow_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::CreateNewWindowParamsDataView>(
    param_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in FrameHost.CreateNewWindow request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewWindow");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreateNewWindow_HandleSyncResponse(
          &result, out_param_status, out_param_reply));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FrameHost::CreateNewWindow", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), out_param_status,
                        "<value of type CreateNewWindowStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reply"), out_param_reply,
                        "<value of type CreateNewWindowReplyPtr>");
   });
#endif
  return result;
}

void FrameHostProxy::CreateNewWindow(
    CreateNewWindowParamsPtr in_params, CreateNewWindowCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHost::CreateNewWindow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type CreateNewWindowParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kCreateNewWindow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CreateNewWindow_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::CreateNewWindowParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in FrameHost.CreateNewWindow request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewWindow");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreateNewWindow_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameHostProxy::CreateChildFrame(
    const ::blink::LocalFrameToken& in_child_frame_token, ::mojo::PendingAssociatedRemote<Frame> in_frame, ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> in_browser_interface_broker, ::blink::mojom::PolicyContainerBindParamsPtr in_policy_container_bind_params, ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> in_associated_interface_provider, ::blink::mojom::TreeScopeType in_scope, const std::string& in_frame_name, const std::string& in_frame_unique_name, bool in_is_created_by_script, const ::blink::FramePolicy& in_frame_policy, ::blink::mojom::FrameOwnerPropertiesPtr in_frame_owner_properties, ::blink::FrameOwnerElementType in_child_frame_owner_element_type, int64_t in_document_ukm_source_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHost::CreateChildFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_frame_token"), in_child_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type ::mojo::PendingAssociatedRemote<Frame>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_interface_broker"), in_browser_interface_broker,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_container_bind_params"), in_policy_container_bind_params,
                        "<value of type ::blink::mojom::PolicyContainerBindParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("associated_interface_provider"), in_associated_interface_provider,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scope"), in_scope,
                        "<value of type ::blink::mojom::TreeScopeType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_name"), in_frame_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_unique_name"), in_frame_unique_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_created_by_script"), in_is_created_by_script,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_policy"), in_frame_policy,
                        "<value of type const ::blink::FramePolicy&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_owner_properties"), in_frame_owner_properties,
                        "<value of type ::blink::mojom::FrameOwnerPropertiesPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_frame_owner_element_type"), in_child_frame_owner_element_type,
                        "<value of type ::blink::FrameOwnerElementType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_ukm_source_id"), in_document_ukm_source_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kCreateChildFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CreateChildFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->child_frame_token)::BaseType> child_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_child_frame_token,
    child_frame_token_fragment);

  params->child_frame_token.Set(
      child_frame_token_fragment.is_null() ? nullptr : child_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->child_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null child_frame_token in FrameHost.CreateChildFrame request");

  
  mojo::internal::Serialize<::content::mojom::FrameAssociatedPtrInfoDataView>(
    in_frame,
    &params->frame,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->frame)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid frame in FrameHost.CreateChildFrame request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
    in_browser_interface_broker,
    &params->browser_interface_broker,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->browser_interface_broker)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid browser_interface_broker in FrameHost.CreateChildFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_container_bind_params)::BaseType> policy_container_bind_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PolicyContainerBindParamsDataView>(
    in_policy_container_bind_params,
    policy_container_bind_params_fragment);

  params->policy_container_bind_params.Set(
      policy_container_bind_params_fragment.is_null() ? nullptr : policy_container_bind_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->policy_container_bind_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null policy_container_bind_params in FrameHost.CreateChildFrame request");

  
  mojo::internal::Serialize<::blink::mojom::AssociatedInterfaceProviderAssociatedRequestDataView>(
    in_associated_interface_provider,
    &params->associated_interface_provider,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->associated_interface_provider)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid associated_interface_provider in FrameHost.CreateChildFrame request");

  
  mojo::internal::Serialize<::blink::mojom::TreeScopeType>(
    in_scope,
    &params->scope);
  mojo::internal::MessageFragment<
      typename decltype(params->frame_name)::BaseType> frame_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_frame_name,
    frame_name_fragment);

  params->frame_name.Set(
      frame_name_fragment.is_null() ? nullptr : frame_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_name in FrameHost.CreateChildFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_unique_name)::BaseType> frame_unique_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_frame_unique_name,
    frame_unique_name_fragment);

  params->frame_unique_name.Set(
      frame_unique_name_fragment.is_null() ? nullptr : frame_unique_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_unique_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_unique_name in FrameHost.CreateChildFrame request");

  params->is_created_by_script = in_is_created_by_script;
  mojo::internal::MessageFragment<
      typename decltype(params->frame_policy)::BaseType> frame_policy_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
    in_frame_policy,
    frame_policy_fragment);

  params->frame_policy.Set(
      frame_policy_fragment.is_null() ? nullptr : frame_policy_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_policy.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_policy in FrameHost.CreateChildFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_owner_properties)::BaseType> frame_owner_properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
    in_frame_owner_properties,
    frame_owner_properties_fragment);

  params->frame_owner_properties.Set(
      frame_owner_properties_fragment.is_null() ? nullptr : frame_owner_properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_owner_properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_owner_properties in FrameHost.CreateChildFrame request");

  
  mojo::internal::Serialize<::content::mojom::ChildFrameOwnerElementType>(
    in_child_frame_owner_element_type,
    &params->child_frame_owner_element_type);

  params->document_ukm_source_id = in_document_ukm_source_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateChildFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHostProxy::DidCommitProvisionalLoad(
    ::content::mojom::DidCommitProvisionalLoadParamsPtr in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHost::DidCommitProvisionalLoad", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::content::mojom::DidCommitProvisionalLoadParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_params"), in_interface_params,
                        "<value of type ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kDidCommitProvisionalLoad), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_DidCommitProvisionalLoad_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in FrameHost.DidCommitProvisionalLoad request");
  mojo::internal::MessageFragment<
      typename decltype(params->interface_params)::BaseType> interface_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
    in_interface_params,
    interface_params_fragment);

  params->interface_params.Set(
      interface_params_fragment.is_null() ? nullptr : interface_params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidCommitProvisionalLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHostProxy::DidCommitSameDocumentNavigation(
    ::content::mojom::DidCommitProvisionalLoadParamsPtr in_params, ::content::mojom::DidCommitSameDocumentNavigationParamsPtr in_same_document_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHost::DidCommitSameDocumentNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::content::mojom::DidCommitProvisionalLoadParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("same_document_params"), in_same_document_params,
                        "<value of type ::content::mojom::DidCommitSameDocumentNavigationParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kDidCommitSameDocumentNavigation), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_DidCommitSameDocumentNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in FrameHost.DidCommitSameDocumentNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->same_document_params)::BaseType> same_document_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::DidCommitSameDocumentNavigationParamsDataView>(
    in_same_document_params,
    same_document_params_fragment);

  params->same_document_params.Set(
      same_document_params_fragment.is_null() ? nullptr : same_document_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->same_document_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null same_document_params in FrameHost.DidCommitSameDocumentNavigation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidCommitSameDocumentNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHostProxy::DidOpenDocumentInputStream(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHost::DidOpenDocumentInputStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kDidOpenDocumentInputStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_DidOpenDocumentInputStream_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in FrameHost.DidOpenDocumentInputStream request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidOpenDocumentInputStream");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHostProxy::BeginNavigation(
    ::blink::mojom::CommonNavigationParamsPtr in_common_params, ::blink::mojom::BeginNavigationParamsPtr in_begin_params, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> in_blob_url_token, ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> in_navigation_client, ::mojo::PendingRemote<::blink::mojom::NavigationStateKeepAliveHandle> in_initiator_navigation_state_keep_alive_handle, ::mojo::PendingReceiver<NavigationRendererCancellationListener> in_renderer_cancellation_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHost::BeginNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("common_params"), in_common_params,
                        "<value of type ::blink::mojom::CommonNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("begin_params"), in_begin_params,
                        "<value of type ::blink::mojom::BeginNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob_url_token"), in_blob_url_token,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::BlobURLToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("navigation_client"), in_navigation_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initiator_navigation_state_keep_alive_handle"), in_initiator_navigation_state_keep_alive_handle,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::NavigationStateKeepAliveHandle>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("renderer_cancellation_listener"), in_renderer_cancellation_listener,
                        "<value of type ::mojo::PendingReceiver<NavigationRendererCancellationListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kBeginNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_BeginNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->common_params)::BaseType> common_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CommonNavigationParamsDataView>(
    in_common_params,
    common_params_fragment);

  params->common_params.Set(
      common_params_fragment.is_null() ? nullptr : common_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->common_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null common_params in FrameHost.BeginNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->begin_params)::BaseType> begin_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::BeginNavigationParamsDataView>(
    in_begin_params,
    begin_params_fragment);

  params->begin_params.Set(
      begin_params_fragment.is_null() ? nullptr : begin_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->begin_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null begin_params in FrameHost.BeginNavigation request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
    in_blob_url_token,
    &params->blob_url_token,
    &params.message());

  
  mojo::internal::Serialize<::content::mojom::NavigationClientAssociatedPtrInfoDataView>(
    in_navigation_client,
    &params->navigation_client,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NavigationStateKeepAliveHandleInterfaceBase>>(
    in_initiator_navigation_state_keep_alive_handle,
    &params->initiator_navigation_state_keep_alive_handle,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::content::mojom::NavigationRendererCancellationListenerInterfaceBase>>(
    in_renderer_cancellation_listener,
    &params->renderer_cancellation_listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->renderer_cancellation_listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid renderer_cancellation_listener in FrameHost.BeginNavigation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("BeginNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHostProxy::SubresourceResponseStarted(
    const ::url::SchemeHostPort& in_final_response_url, uint32_t in_cert_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHost::SubresourceResponseStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("final_response_url"), in_final_response_url,
                        "<value of type const ::url::SchemeHostPort&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cert_status"), in_cert_status,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kSubresourceResponseStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_SubresourceResponseStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->final_response_url)::BaseType> final_response_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::SchemeHostPortDataView>(
    in_final_response_url,
    final_response_url_fragment);

  params->final_response_url.Set(
      final_response_url_fragment.is_null() ? nullptr : final_response_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->final_response_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null final_response_url in FrameHost.SubresourceResponseStarted request");

  params->cert_status = in_cert_status;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("SubresourceResponseStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHostProxy::ResourceLoadComplete(
    ::blink::mojom::ResourceLoadInfoPtr in_url_load_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHost::ResourceLoadComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_load_info"), in_url_load_info,
                        "<value of type ::blink::mojom::ResourceLoadInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kResourceLoadComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_ResourceLoadComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url_load_info)::BaseType> url_load_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ResourceLoadInfoDataView>(
    in_url_load_info,
    url_load_info_fragment);

  params->url_load_info.Set(
      url_load_info_fragment.is_null() ? nullptr : url_load_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url_load_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url_load_info in FrameHost.ResourceLoadComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("ResourceLoadComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHostProxy::DidChangeName(
    const std::string& in_name, const std::string& in_unique_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHost::DidChangeName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unique_name"), in_unique_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kDidChangeName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_DidChangeName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in FrameHost.DidChangeName request");
  mojo::internal::MessageFragment<
      typename decltype(params->unique_name)::BaseType> unique_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_unique_name,
    unique_name_fragment);

  params->unique_name.Set(
      unique_name_fragment.is_null() ? nullptr : unique_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->unique_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null unique_name in FrameHost.DidChangeName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidChangeName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHostProxy::CancelInitialHistoryLoad(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::FrameHost::CancelInitialHistoryLoad");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kCancelInitialHistoryLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CancelInitialHistoryLoad_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CancelInitialHistoryLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHostProxy::UpdateEncoding(
    const std::string& in_encoding_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHost::UpdateEncoding", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoding_name"), in_encoding_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kUpdateEncoding), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_UpdateEncoding_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->encoding_name)::BaseType> encoding_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_encoding_name,
    encoding_name_fragment);

  params->encoding_name.Set(
      encoding_name_fragment.is_null() ? nullptr : encoding_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->encoding_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null encoding_name in FrameHost.UpdateEncoding request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("UpdateEncoding");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHostProxy::UpdateState(
    const ::blink::PageState& in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHost::UpdateState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type const ::blink::PageState&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kUpdateState), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_UpdateState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::PageStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in FrameHost.UpdateState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("UpdateState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHostProxy::OpenURL(
    ::blink::mojom::OpenURLParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FrameHost::OpenURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::blink::mojom::OpenURLParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kOpenURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_OpenURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::OpenURLParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in FrameHost.OpenURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("OpenURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameHostProxy::DidStopLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::FrameHost::DidStopLoading");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kDidStopLoading), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_DidStopLoading_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidStopLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class FrameHost_CreateNewWindow_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameHost::CreateNewWindowCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameHost_CreateNewWindow_ProxyToResponder> proxy(
        new FrameHost_CreateNewWindow_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameHost_CreateNewWindow_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameHost_CreateNewWindow_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameHost_CreateNewWindow_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameHost::CreateNewWindowCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateNewWindowStatus in_status, CreateNewWindowReplyPtr in_reply);
};

bool FrameHost_CreateNewWindow_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameHost_CreateNewWindow_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameHost_CreateNewWindow_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameHost.0
  bool success = true;
  CreateNewWindowStatus p_status{};
  CreateNewWindowReplyPtr p_reply{};
  FrameHost_CreateNewWindow_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadReply(&p_reply))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_reply));
  }
  return true;
}

void FrameHost_CreateNewWindow_ProxyToResponder::Run(
    CreateNewWindowStatus in_status, CreateNewWindowReplyPtr in_reply) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content::mojom::FrameHost::CreateNewWindow", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type CreateNewWindowStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reply"), in_reply,
                        "<value of type CreateNewWindowReplyPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameHost::kCreateNewWindow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CreateNewWindow_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::content::mojom::CreateNewWindowStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->reply)::BaseType> reply_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::CreateNewWindowReplyDataView>(
    in_reply,
    reply_fragment);

  params->reply.Set(
      reply_fragment.is_null() ? nullptr : reply_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewWindow");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameHost_CreateNewWindow_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameHost_CreateNewWindow_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameHost_CreateNewWindow_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FrameHost.0
  bool success = true;
  CreateNewWindowStatus p_status{};
  CreateNewWindowReplyPtr p_reply{};
  FrameHost_CreateNewWindow_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadReply(&p_reply))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 0, true);
    return false;
  }
  *out_status_ = std::move(p_status);
  *out_reply_ = std::move(p_reply);
  *result_ = true;
  return true;
}

// static
bool FrameHostStubDispatch::Accept(
    FrameHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameHost>(message->header()->name)) {
    case messages::FrameHost::kCreateNewWindow: {
      break;
    }
    case messages::FrameHost::kCreateChildFrame: {
      DCHECK(message->is_serialized());
      internal::FrameHost_CreateChildFrame_Params_Data* params =
          reinterpret_cast<internal::FrameHost_CreateChildFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.1
      bool success = true;
      ::blink::LocalFrameToken p_child_frame_token{};
      ::mojo::PendingAssociatedRemote<Frame> p_frame{};
      ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> p_browser_interface_broker{};
      ::blink::mojom::PolicyContainerBindParamsPtr p_policy_container_bind_params{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> p_associated_interface_provider{};
      ::blink::mojom::TreeScopeType p_scope{};
      std::string p_frame_name{};
      std::string p_frame_unique_name{};
      bool p_is_created_by_script{};
      ::blink::FramePolicy p_frame_policy{};
      ::blink::mojom::FrameOwnerPropertiesPtr p_frame_owner_properties{};
      ::blink::FrameOwnerElementType p_child_frame_owner_element_type{};
      int64_t p_document_ukm_source_id{};
      FrameHost_CreateChildFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChildFrameToken(&p_child_frame_token))
        success = false;
      if (success) {
        p_frame =
            input_data_view.TakeFrame<decltype(p_frame)>();
      }
      if (success) {
        p_browser_interface_broker =
            input_data_view.TakeBrowserInterfaceBroker<decltype(p_browser_interface_broker)>();
      }
      if (success && !input_data_view.ReadPolicyContainerBindParams(&p_policy_container_bind_params))
        success = false;
      if (success) {
        p_associated_interface_provider =
            input_data_view.TakeAssociatedInterfaceProvider<decltype(p_associated_interface_provider)>();
      }
      if (success && !input_data_view.ReadScope(&p_scope))
        success = false;
      if (success && !input_data_view.ReadFrameName(&p_frame_name))
        success = false;
      if (success && !input_data_view.ReadFrameUniqueName(&p_frame_unique_name))
        success = false;
      if (success)
        p_is_created_by_script = input_data_view.is_created_by_script();
      if (success && !input_data_view.ReadFramePolicy(&p_frame_policy))
        success = false;
      if (success && !input_data_view.ReadFrameOwnerProperties(&p_frame_owner_properties))
        success = false;
      if (success && !input_data_view.ReadChildFrameOwnerElementType(&p_child_frame_owner_element_type))
        success = false;
      if (success)
        p_document_ukm_source_id = input_data_view.document_ukm_source_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateChildFrame(        
        std::move(p_child_frame_token), 
        std::move(p_frame), 
        std::move(p_browser_interface_broker), 
        std::move(p_policy_container_bind_params), 
        std::move(p_associated_interface_provider), 
        std::move(p_scope), 
        std::move(p_frame_name), 
        std::move(p_frame_unique_name), 
        std::move(p_is_created_by_script), 
        std::move(p_frame_policy), 
        std::move(p_frame_owner_properties), 
        std::move(p_child_frame_owner_element_type), 
        std::move(p_document_ukm_source_id));
      return true;
    }
    case messages::FrameHost::kDidCommitProvisionalLoad: {
      DCHECK(message->is_serialized());
      internal::FrameHost_DidCommitProvisionalLoad_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidCommitProvisionalLoad_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.2
      bool success = true;
      ::content::mojom::DidCommitProvisionalLoadParamsPtr p_params{};
      ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr p_interface_params{};
      FrameHost_DidCommitProvisionalLoad_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadInterfaceParams(&p_interface_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCommitProvisionalLoad(        
        std::move(p_params), 
        std::move(p_interface_params));
      return true;
    }
    case messages::FrameHost::kDidCommitSameDocumentNavigation: {
      DCHECK(message->is_serialized());
      internal::FrameHost_DidCommitSameDocumentNavigation_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidCommitSameDocumentNavigation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.3
      bool success = true;
      ::content::mojom::DidCommitProvisionalLoadParamsPtr p_params{};
      ::content::mojom::DidCommitSameDocumentNavigationParamsPtr p_same_document_params{};
      FrameHost_DidCommitSameDocumentNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadSameDocumentParams(&p_same_document_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCommitSameDocumentNavigation(        
        std::move(p_params), 
        std::move(p_same_document_params));
      return true;
    }
    case messages::FrameHost::kDidOpenDocumentInputStream: {
      DCHECK(message->is_serialized());
      internal::FrameHost_DidOpenDocumentInputStream_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidOpenDocumentInputStream_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.4
      bool success = true;
      ::GURL p_url{};
      FrameHost_DidOpenDocumentInputStream_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidOpenDocumentInputStream(        
        std::move(p_url));
      return true;
    }
    case messages::FrameHost::kBeginNavigation: {
      DCHECK(message->is_serialized());
      internal::FrameHost_BeginNavigation_Params_Data* params =
          reinterpret_cast<internal::FrameHost_BeginNavigation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.5
      bool success = true;
      ::blink::mojom::CommonNavigationParamsPtr p_common_params{};
      ::blink::mojom::BeginNavigationParamsPtr p_begin_params{};
      ::mojo::PendingRemote<::blink::mojom::BlobURLToken> p_blob_url_token{};
      ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> p_navigation_client{};
      ::mojo::PendingRemote<::blink::mojom::NavigationStateKeepAliveHandle> p_initiator_navigation_state_keep_alive_handle{};
      ::mojo::PendingReceiver<NavigationRendererCancellationListener> p_renderer_cancellation_listener{};
      FrameHost_BeginNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommonParams(&p_common_params))
        success = false;
      if (success && !input_data_view.ReadBeginParams(&p_begin_params))
        success = false;
      if (success) {
        p_blob_url_token =
            input_data_view.TakeBlobUrlToken<decltype(p_blob_url_token)>();
      }
      if (success) {
        p_navigation_client =
            input_data_view.TakeNavigationClient<decltype(p_navigation_client)>();
      }
      if (success) {
        p_initiator_navigation_state_keep_alive_handle =
            input_data_view.TakeInitiatorNavigationStateKeepAliveHandle<decltype(p_initiator_navigation_state_keep_alive_handle)>();
      }
      if (success) {
        p_renderer_cancellation_listener =
            input_data_view.TakeRendererCancellationListener<decltype(p_renderer_cancellation_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginNavigation(        
        std::move(p_common_params), 
        std::move(p_begin_params), 
        std::move(p_blob_url_token), 
        std::move(p_navigation_client), 
        std::move(p_initiator_navigation_state_keep_alive_handle), 
        std::move(p_renderer_cancellation_listener));
      return true;
    }
    case messages::FrameHost::kSubresourceResponseStarted: {
      DCHECK(message->is_serialized());
      internal::FrameHost_SubresourceResponseStarted_Params_Data* params =
          reinterpret_cast<internal::FrameHost_SubresourceResponseStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.6
      bool success = true;
      ::url::SchemeHostPort p_final_response_url{};
      uint32_t p_cert_status{};
      FrameHost_SubresourceResponseStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFinalResponseUrl(&p_final_response_url))
        success = false;
      if (success)
        p_cert_status = input_data_view.cert_status();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubresourceResponseStarted(        
        std::move(p_final_response_url), 
        std::move(p_cert_status));
      return true;
    }
    case messages::FrameHost::kResourceLoadComplete: {
      DCHECK(message->is_serialized());
      internal::FrameHost_ResourceLoadComplete_Params_Data* params =
          reinterpret_cast<internal::FrameHost_ResourceLoadComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.7
      bool success = true;
      ::blink::mojom::ResourceLoadInfoPtr p_url_load_info{};
      FrameHost_ResourceLoadComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrlLoadInfo(&p_url_load_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResourceLoadComplete(        
        std::move(p_url_load_info));
      return true;
    }
    case messages::FrameHost::kDidChangeName: {
      DCHECK(message->is_serialized());
      internal::FrameHost_DidChangeName_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidChangeName_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.8
      bool success = true;
      std::string p_name{};
      std::string p_unique_name{};
      FrameHost_DidChangeName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadUniqueName(&p_unique_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeName(        
        std::move(p_name), 
        std::move(p_unique_name));
      return true;
    }
    case messages::FrameHost::kCancelInitialHistoryLoad: {
      DCHECK(message->is_serialized());
      internal::FrameHost_CancelInitialHistoryLoad_Params_Data* params =
          reinterpret_cast<internal::FrameHost_CancelInitialHistoryLoad_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.9
      bool success = true;
      FrameHost_CancelInitialHistoryLoad_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelInitialHistoryLoad(        );
      return true;
    }
    case messages::FrameHost::kUpdateEncoding: {
      DCHECK(message->is_serialized());
      internal::FrameHost_UpdateEncoding_Params_Data* params =
          reinterpret_cast<internal::FrameHost_UpdateEncoding_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.10
      bool success = true;
      std::string p_encoding_name{};
      FrameHost_UpdateEncoding_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEncodingName(&p_encoding_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateEncoding(        
        std::move(p_encoding_name));
      return true;
    }
    case messages::FrameHost::kUpdateState: {
      DCHECK(message->is_serialized());
      internal::FrameHost_UpdateState_Params_Data* params =
          reinterpret_cast<internal::FrameHost_UpdateState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.11
      bool success = true;
      ::blink::PageState p_state{};
      FrameHost_UpdateState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateState(        
        std::move(p_state));
      return true;
    }
    case messages::FrameHost::kOpenURL: {
      DCHECK(message->is_serialized());
      internal::FrameHost_OpenURL_Params_Data* params =
          reinterpret_cast<internal::FrameHost_OpenURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.12
      bool success = true;
      ::blink::mojom::OpenURLParamsPtr p_params{};
      FrameHost_OpenURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenURL(        
        std::move(p_params));
      return true;
    }
    case messages::FrameHost::kDidStopLoading: {
      DCHECK(message->is_serialized());
      internal::FrameHost_DidStopLoading_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidStopLoading_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameHost.13
      bool success = true;
      FrameHost_DidStopLoading_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStopLoading(        );
      return true;
    }
  }
  return false;
}

// static
bool FrameHostStubDispatch::AcceptWithResponder(
    FrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameHost>(message->header()->name)) {
    case messages::FrameHost::kCreateNewWindow: {
      internal::FrameHost_CreateNewWindow_Params_Data* params =
          reinterpret_cast<
              internal::FrameHost_CreateNewWindow_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameHost.0
      bool success = true;
      CreateNewWindowParamsPtr p_params{};
      FrameHost_CreateNewWindow_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 0, false);
        return false;
      }
      auto callback =
          FrameHost_CreateNewWindow_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNewWindow(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::FrameHost::kCreateChildFrame: {
      break;
    }
    case messages::FrameHost::kDidCommitProvisionalLoad: {
      break;
    }
    case messages::FrameHost::kDidCommitSameDocumentNavigation: {
      break;
    }
    case messages::FrameHost::kDidOpenDocumentInputStream: {
      break;
    }
    case messages::FrameHost::kBeginNavigation: {
      break;
    }
    case messages::FrameHost::kSubresourceResponseStarted: {
      break;
    }
    case messages::FrameHost::kResourceLoadComplete: {
      break;
    }
    case messages::FrameHost::kDidChangeName: {
      break;
    }
    case messages::FrameHost::kCancelInitialHistoryLoad: {
      break;
    }
    case messages::FrameHost::kUpdateEncoding: {
      break;
    }
    case messages::FrameHost::kUpdateState: {
      break;
    }
    case messages::FrameHost::kOpenURL: {
      break;
    }
    case messages::FrameHost::kDidStopLoading: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameHostValidationInfo[] = {
    {base::to_underlying(messages::FrameHost::kCreateNewWindow),
     { &internal::FrameHost_CreateNewWindow_Params_Data::Validate,
      &internal::FrameHost_CreateNewWindow_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::FrameHost::kCreateChildFrame),
     { &internal::FrameHost_CreateChildFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHost::kDidCommitProvisionalLoad),
     { &internal::FrameHost_DidCommitProvisionalLoad_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHost::kDidCommitSameDocumentNavigation),
     { &internal::FrameHost_DidCommitSameDocumentNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHost::kDidOpenDocumentInputStream),
     { &internal::FrameHost_DidOpenDocumentInputStream_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHost::kBeginNavigation),
     { &internal::FrameHost_BeginNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHost::kSubresourceResponseStarted),
     { &internal::FrameHost_SubresourceResponseStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHost::kResourceLoadComplete),
     { &internal::FrameHost_ResourceLoadComplete_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHost::kDidChangeName),
     { &internal::FrameHost_DidChangeName_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHost::kCancelInitialHistoryLoad),
     { &internal::FrameHost_CancelInitialHistoryLoad_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHost::kUpdateEncoding),
     { &internal::FrameHost_UpdateEncoding_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHost::kUpdateState),
     { &internal::FrameHost_UpdateState_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHost::kOpenURL),
     { &internal::FrameHost_OpenURL_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameHost::kDidStopLoading),
     { &internal::FrameHost_DidStopLoading_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::content::mojom::FrameHost::Name_,
    kFrameHostValidationInfo);
}

bool FrameHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::content::mojom::FrameHost::Name_,
    kFrameHostValidationInfo);

}


}  // content::mojom


namespace mojo {


// static
bool StructTraits<::content::mojom::CreateViewParams::DataView, ::content::mojom::CreateViewParamsPtr>::Read(
    ::content::mojom::CreateViewParams::DataView input,
    ::content::mojom::CreateViewParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateViewParamsPtr result(::content::mojom::CreateViewParams::New());
  
      if (success && !input.ReadRendererPreferences(&result->renderer_preferences))
        success = false;
      if (success && !input.ReadWebPreferences(&result->web_preferences))
        success = false;
      if (success && !input.ReadSessionStorageNamespaceId(&result->session_storage_namespace_id))
        success = false;
      if (success && !input.ReadOpenerFrameToken(&result->opener_frame_token))
        success = false;
      if (success && !input.ReadReplicationState(&result->replication_state))
        success = false;
      if (success && !input.ReadDevtoolsMainFrameToken(&result->devtools_main_frame_token))
        success = false;
      if (success && !input.ReadMainFrame(&result->main_frame))
        success = false;
      if (success)
        result->hidden = input.hidden();
      if (success && !input.ReadPrerenderParam(&result->prerender_param))
        success = false;
      if (success)
        result->never_composited = input.never_composited();
      if (success)
        result->window_was_opened_by_another_window = input.window_was_opened_by_another_window();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadFencedFrameMode(&result->fenced_frame_mode))
        success = false;
      if (success && !input.ReadOutermostOrigin(&result->outermost_origin))
        success = false;
      if (success) {
        result->blink_page_broadcast =
            input.TakeBlinkPageBroadcast<decltype(result->blink_page_broadcast)>();
      }
      if (success && !input.ReadBaseBackgroundColor(&result->base_background_color))
        success = false;
      if (success && !input.ReadColorProviderColors(&result->color_provider_colors))
        success = false;
      if (success && !input.ReadBrowsingContextGroupToken(&result->browsing_context_group_token))
        success = false;
      if (success && !input.ReadAttributionSupport(&result->attribution_support))
        success = false;
      if (success && !input.ReadPartitionedPopinParams(&result->partitioned_popin_params))
        success = false;
      if (success && !input.ReadNavigationMetricsToken(&result->navigation_metrics_token))
        success = false;
      if (success)
        result->history_index = input.history_index();
      if (success)
        result->history_length = input.history_length();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateLocalMainFrameParams::DataView, ::content::mojom::CreateLocalMainFrameParamsPtr>::Read(
    ::content::mojom::CreateLocalMainFrameParams::DataView input,
    ::content::mojom::CreateLocalMainFrameParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateLocalMainFrameParamsPtr result(::content::mojom::CreateLocalMainFrameParams::New());
  
      if (success && !input.ReadFrameToken(&result->frame_token))
        success = false;
      if (success)
        result->routing_id = input.routing_id();
      if (success) {
        result->frame =
            input.TakeFrame<decltype(result->frame)>();
      }
      if (success) {
        result->interface_broker =
            input.TakeInterfaceBroker<decltype(result->interface_broker)>();
      }
      if (success) {
        result->associated_interface_provider_remote =
            input.TakeAssociatedInterfaceProviderRemote<decltype(result->associated_interface_provider_remote)>();
      }
      if (success)
        result->is_on_initial_empty_document = input.is_on_initial_empty_document();
      if (success && !input.ReadDocumentToken(&result->document_token))
        success = false;
      if (success && !input.ReadPolicyContainer(&result->policy_container))
        success = false;
      if (success && !input.ReadWidgetParams(&result->widget_params))
        success = false;
      if (success && !input.ReadSubresourceLoaderFactories(&result->subresource_loader_factories))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateProvisionalLocalMainFrameParams::DataView, ::content::mojom::CreateProvisionalLocalMainFrameParamsPtr>::Read(
    ::content::mojom::CreateProvisionalLocalMainFrameParams::DataView input,
    ::content::mojom::CreateProvisionalLocalMainFrameParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateProvisionalLocalMainFrameParamsPtr result(::content::mojom::CreateProvisionalLocalMainFrameParams::New());
  
      if (success && !input.ReadLocalParams(&result->local_params))
        success = false;
      if (success && !input.ReadPreviousFrameToken(&result->previous_frame_token))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateRemoteMainFrameParams::DataView, ::content::mojom::CreateRemoteMainFrameParamsPtr>::Read(
    ::content::mojom::CreateRemoteMainFrameParams::DataView input,
    ::content::mojom::CreateRemoteMainFrameParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateRemoteMainFrameParamsPtr result(::content::mojom::CreateRemoteMainFrameParams::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success && !input.ReadFrameInterfaces(&result->frame_interfaces))
        success = false;
      if (success && !input.ReadMainFrameInterfaces(&result->main_frame_interfaces))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateFrameWidgetParams::DataView, ::content::mojom::CreateFrameWidgetParamsPtr>::Read(
    ::content::mojom::CreateFrameWidgetParams::DataView input,
    ::content::mojom::CreateFrameWidgetParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateFrameWidgetParamsPtr result(::content::mojom::CreateFrameWidgetParams::New());
  
      if (success)
        result->routing_id = input.routing_id();
      if (success) {
        result->frame_widget_host =
            input.TakeFrameWidgetHost<decltype(result->frame_widget_host)>();
      }
      if (success) {
        result->frame_widget =
            input.TakeFrameWidget<decltype(result->frame_widget)>();
      }
      if (success) {
        result->widget_host =
            input.TakeWidgetHost<decltype(result->widget_host)>();
      }
      if (success) {
        result->widget =
            input.TakeWidget<decltype(result->widget)>();
      }
      if (success && !input.ReadVisualProperties(&result->visual_properties))
        success = false;
      if (success)
        result->reuse_compositor = input.reuse_compositor();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateFrameParams::DataView, ::content::mojom::CreateFrameParamsPtr>::Read(
    ::content::mojom::CreateFrameParams::DataView input,
    ::content::mojom::CreateFrameParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateFrameParamsPtr result(::content::mojom::CreateFrameParams::New());
  
      if (success && !input.ReadFrameToken(&result->frame_token))
        success = false;
      if (success)
        result->routing_id = input.routing_id();
      if (success && !input.ReadPreviousFrameToken(&result->previous_frame_token))
        success = false;
      if (success && !input.ReadOpenerFrameToken(&result->opener_frame_token))
        success = false;
      if (success && !input.ReadParentFrameToken(&result->parent_frame_token))
        success = false;
      if (success && !input.ReadPreviousSiblingFrameToken(&result->previous_sibling_frame_token))
        success = false;
      if (success) {
        result->interface_broker =
            input.TakeInterfaceBroker<decltype(result->interface_broker)>();
      }
      if (success && !input.ReadTreeScopeType(&result->tree_scope_type))
        success = false;
      if (success && !input.ReadReplicationState(&result->replication_state))
        success = false;
      if (success && !input.ReadDevtoolsFrameToken(&result->devtools_frame_token))
        success = false;
      if (success && !input.ReadFrameOwnerProperties(&result->frame_owner_properties))
        success = false;
      if (success && !input.ReadWidgetParams(&result->widget_params))
        success = false;
      if (success)
        result->is_on_initial_empty_document = input.is_on_initial_empty_document();
      if (success && !input.ReadDocumentToken(&result->document_token))
        success = false;
      if (success && !input.ReadPolicyContainer(&result->policy_container))
        success = false;
      if (success) {
        result->frame =
            input.TakeFrame<decltype(result->frame)>();
      }
      if (success) {
        result->associated_interface_provider_remote =
            input.TakeAssociatedInterfaceProviderRemote<decltype(result->associated_interface_provider_remote)>();
      }
      if (success)
        result->is_for_nested_main_frame = input.is_for_nested_main_frame();
      if (success && !input.ReadNavigationMetricsToken(&result->navigation_metrics_token))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::SnapshotAccessibilityTreeParams::DataView, ::content::mojom::SnapshotAccessibilityTreeParamsPtr>::Read(
    ::content::mojom::SnapshotAccessibilityTreeParams::DataView input,
    ::content::mojom::SnapshotAccessibilityTreeParamsPtr* output) {
  bool success = true;
  ::content::mojom::SnapshotAccessibilityTreeParamsPtr result(::content::mojom::SnapshotAccessibilityTreeParams::New());
  
      if (success)
        result->ax_mode = input.ax_mode();
      if (success)
        result->max_nodes = input.max_nodes();
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateNewWindowParams::DataView, ::content::mojom::CreateNewWindowParamsPtr>::Read(
    ::content::mojom::CreateNewWindowParams::DataView input,
    ::content::mojom::CreateNewWindowParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateNewWindowParamsPtr result(::content::mojom::CreateNewWindowParams::New());
  
      if (success)
        result->allow_popup = input.allow_popup();
      if (success && !input.ReadWindowContainerType(&result->window_container_type))
        success = false;
      if (success && !input.ReadSessionStorageNamespaceId(&result->session_storage_namespace_id))
        success = false;
      if (success && !input.ReadCloneFromSessionStorageNamespaceId(&result->clone_from_session_storage_namespace_id))
        success = false;
      if (success && !input.ReadFrameName(&result->frame_name))
        success = false;
      if (success)
        result->opener_suppressed = input.opener_suppressed();
      if (success)
        result->is_form_submission = input.is_form_submission();
      if (success)
        result->consumes_user_activation = input.consumes_user_activation();
      if (success && !input.ReadFormSubmissionPostData(&result->form_submission_post_data))
        success = false;
      if (success && !input.ReadFormSubmissionPostContentType(&result->form_submission_post_content_type))
        success = false;
      if (success && !input.ReadDisposition(&result->disposition))
        success = false;
      if (success && !input.ReadTargetUrl(&result->target_url))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadFeatures(&result->features))
        success = false;
      if (success && !input.ReadImpression(&result->impression))
        success = false;
      if (success && !input.ReadDownloadPolicy(&result->download_policy))
        success = false;
      if (success && !input.ReadPipOptions(&result->pip_options))
        success = false;
      if (success && !input.ReadInitiatorActivationAndAdStatus(&result->initiator_activation_and_ad_status))
        success = false;
      if (success) {
        result->frame_remote =
            input.TakeFrameRemote<decltype(result->frame_remote)>();
      }
      if (success) {
        result->page_broadcast_remote =
            input.TakePageBroadcastRemote<decltype(result->page_broadcast_remote)>();
      }
      if (success) {
        result->main_frame_interface_broker =
            input.TakeMainFrameInterfaceBroker<decltype(result->main_frame_interface_broker)>();
      }
      if (success) {
        result->associated_interface_provider =
            input.TakeAssociatedInterfaceProvider<decltype(result->associated_interface_provider)>();
      }
      if (success) {
        result->widget_host =
            input.TakeWidgetHost<decltype(result->widget_host)>();
      }
      if (success) {
        result->widget =
            input.TakeWidget<decltype(result->widget)>();
      }
      if (success) {
        result->frame_widget_host =
            input.TakeFrameWidgetHost<decltype(result->frame_widget_host)>();
      }
      if (success) {
        result->frame_widget =
            input.TakeFrameWidget<decltype(result->frame_widget)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateNewWindowReply::DataView, ::content::mojom::CreateNewWindowReplyPtr>::Read(
    ::content::mojom::CreateNewWindowReply::DataView input,
    ::content::mojom::CreateNewWindowReplyPtr* output) {
  bool success = true;
  ::content::mojom::CreateNewWindowReplyPtr result(::content::mojom::CreateNewWindowReply::New());
  
      if (success && !input.ReadMainFrameToken(&result->main_frame_token))
        success = false;
      if (success)
        result->main_frame_route_id = input.main_frame_route_id();
      if (success)
        result->widget_routing_id = input.widget_routing_id();
      if (success && !input.ReadVisualProperties(&result->visual_properties))
        success = false;
      if (success && !input.ReadClonedSessionStorageNamespaceId(&result->cloned_session_storage_namespace_id))
        success = false;
      if (success && !input.ReadDevtoolsMainFrameToken(&result->devtools_main_frame_token))
        success = false;
      if (success)
        result->wait_for_debugger = input.wait_for_debugger();
      if (success && !input.ReadDocumentToken(&result->document_token))
        success = false;
      if (success && !input.ReadPolicyContainer(&result->policy_container))
        success = false;
      if (success && !input.ReadBrowsingContextGroupToken(&result->browsing_context_group_token))
        success = false;
      if (success && !input.ReadColorProviderColors(&result->color_provider_colors))
        success = false;
      if (success && !input.ReadPartitionedPopinParams(&result->partitioned_popin_params))
        success = false;
      if (success && !input.ReadWidgetScreenRect(&result->widget_screen_rect))
        success = false;
      if (success && !input.ReadWindowScreenRect(&result->window_screen_rect))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::content::mojom::CreateMainFrameUnion::DataView, ::content::mojom::CreateMainFrameUnionPtr>::Read(
    ::content::mojom::CreateMainFrameUnion::DataView input,
    ::content::mojom::CreateMainFrameUnionPtr* output) {
  using UnionType = ::content::mojom::CreateMainFrameUnion;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kLocalParams: {
      ::content::mojom::CreateLocalMainFrameParamsPtr result_local_params{};
      if (!input.ReadLocalParams(&result_local_params))
        return false;

      *output = UnionType::NewLocalParams(
          std::move(result_local_params));
      break;
    }
    case Tag::kProvisionalLocalParams: {
      ::content::mojom::CreateProvisionalLocalMainFrameParamsPtr result_provisional_local_params{};
      if (!input.ReadProvisionalLocalParams(&result_provisional_local_params))
        return false;

      *output = UnionType::NewProvisionalLocalParams(
          std::move(result_provisional_local_params));
      break;
    }
    case Tag::kRemoteParams: {
      ::content::mojom::CreateRemoteMainFrameParamsPtr result_remote_params{};
      if (!input.ReadRemoteParams(&result_remote_params))
        return false;

      *output = UnionType::NewRemoteParams(
          std::move(result_remote_params));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void FrameHTMLSerializerHandlerInterceptorForTesting::DidReceiveData(const std::string& data_buffer) {
  GetForwardingInterface()->DidReceiveData(
    std::move(data_buffer)
    );
}
void FrameHTMLSerializerHandlerInterceptorForTesting::Done() {
  GetForwardingInterface()->Done();
}
FrameHTMLSerializerHandlerAsyncWaiter::FrameHTMLSerializerHandlerAsyncWaiter(
    FrameHTMLSerializerHandler* proxy) : proxy_(proxy) {}

FrameHTMLSerializerHandlerAsyncWaiter::~FrameHTMLSerializerHandlerAsyncWaiter() = default;





void FrameInterceptorForTesting::CommitSameDocumentNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, CommitSameDocumentNavigationCallback callback) {
  GetForwardingInterface()->CommitSameDocumentNavigation(
    std::move(common_params)
    , 
    std::move(request_params)
    , std::move(callback));
}
void FrameInterceptorForTesting::UpdateSubresourceLoaderFactories(::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories) {
  GetForwardingInterface()->UpdateSubresourceLoaderFactories(
    std::move(subresource_loader_factories)
    );
}
void FrameInterceptorForTesting::SetWantErrorMessageStackTrace() {
  GetForwardingInterface()->SetWantErrorMessageStackTrace();
}
void FrameInterceptorForTesting::Unload(bool is_loading, ::blink::mojom::FrameReplicationStatePtr new_remote_frame_replication_state, const ::blink::RemoteFrameToken& new_remote_frame_token, ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr new_remote_frame_interfaces, ::blink::mojom::RemoteMainFrameInterfacesPtr new_remote_main_frame_interfaces, const std::optional<::base::UnguessableToken>& devtools_frame_token) {
  GetForwardingInterface()->Unload(
    std::move(is_loading)
    , 
    std::move(new_remote_frame_replication_state)
    , 
    std::move(new_remote_frame_token)
    , 
    std::move(new_remote_frame_interfaces)
    , 
    std::move(new_remote_main_frame_interfaces)
    , 
    std::move(devtools_frame_token)
    );
}
void FrameInterceptorForTesting::Delete(FrameDeleteIntention intention) {
  GetForwardingInterface()->Delete(
    std::move(intention)
    );
}
void FrameInterceptorForTesting::UndoCommitNavigation(bool is_loading, ::blink::mojom::FrameReplicationStatePtr new_remote_frame_replication_state, const ::blink::RemoteFrameToken& new_remote_frame_token, ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr new_remote_frame_interfaces, ::blink::mojom::RemoteMainFrameInterfacesPtr new_remote_main_frame_interfaces) {
  GetForwardingInterface()->UndoCommitNavigation(
    std::move(is_loading)
    , 
    std::move(new_remote_frame_replication_state)
    , 
    std::move(new_remote_frame_token)
    , 
    std::move(new_remote_frame_interfaces)
    , 
    std::move(new_remote_main_frame_interfaces)
    );
}
void FrameInterceptorForTesting::GetInterfaceProvider(::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> interfaces) {
  GetForwardingInterface()->GetInterfaceProvider(
    std::move(interfaces)
    );
}
void FrameInterceptorForTesting::SnapshotAccessibilityTree(SnapshotAccessibilityTreeParamsPtr params, SnapshotAccessibilityTreeCallback callback) {
  GetForwardingInterface()->SnapshotAccessibilityTree(
    std::move(params)
    , std::move(callback));
}
void FrameInterceptorForTesting::GetSerializedHtmlWithLocalLinks(const base::flat_map<::GURL, ::base::FilePath>& url_map, const base::flat_map<::blink::FrameToken, ::base::FilePath>& frame_token_map, bool save_with_empty_url, ::mojo::PendingRemote<FrameHTMLSerializerHandler> handler_remote) {
  GetForwardingInterface()->GetSerializedHtmlWithLocalLinks(
    std::move(url_map)
    , 
    std::move(frame_token_map)
    , 
    std::move(save_with_empty_url)
    , 
    std::move(handler_remote)
    );
}
FrameAsyncWaiter::FrameAsyncWaiter(
    Frame* proxy) : proxy_(proxy) {}

FrameAsyncWaiter::~FrameAsyncWaiter() = default;


void FrameAsyncWaiter::CommitSameDocumentNavigation(
    ::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, ::blink::mojom::CommitResult* out_commit_result) {
  base::RunLoop loop;
  proxy_->CommitSameDocumentNavigation(
      std::move(common_params),
      std::move(request_params),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::CommitResult* out_commit_result
,
             ::blink::mojom::CommitResult commit_result) {*out_commit_result = std::move(commit_result);
            loop->Quit();
          },
          &loop,
          out_commit_result));
  loop.Run();
}

::blink::mojom::CommitResult FrameAsyncWaiter::CommitSameDocumentNavigation(
    ::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params) {
  ::blink::mojom::CommitResult async_wait_result;
  CommitSameDocumentNavigation(std::move(common_params),std::move(request_params),&async_wait_result);
  return async_wait_result;
}

void FrameAsyncWaiter::SnapshotAccessibilityTree(
    SnapshotAccessibilityTreeParamsPtr params, ::ui::AXTreeUpdate* out_snapshot) {
  base::RunLoop loop;
  proxy_->SnapshotAccessibilityTree(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::ui::AXTreeUpdate* out_snapshot
,
             const ::ui::AXTreeUpdate& snapshot) {*out_snapshot = std::move(snapshot);
            loop->Quit();
          },
          &loop,
          out_snapshot));
  loop.Run();
}

::ui::AXTreeUpdate FrameAsyncWaiter::SnapshotAccessibilityTree(
    SnapshotAccessibilityTreeParamsPtr params) {
  ::ui::AXTreeUpdate async_wait_result;
  SnapshotAccessibilityTree(std::move(params),&async_wait_result);
  return async_wait_result;
}




void FrameBindingsControlInterceptorForTesting::AllowBindings(int64_t enabled_bindings_flags) {
  GetForwardingInterface()->AllowBindings(
    std::move(enabled_bindings_flags)
    );
}
void FrameBindingsControlInterceptorForTesting::EnableMojoJsBindings(::content::mojom::ExtraMojoJsFeaturesPtr features) {
  GetForwardingInterface()->EnableMojoJsBindings(
    std::move(features)
    );
}
void FrameBindingsControlInterceptorForTesting::EnableMojoJsBindingsWithBroker(::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> broker) {
  GetForwardingInterface()->EnableMojoJsBindingsWithBroker(
    std::move(broker)
    );
}
void FrameBindingsControlInterceptorForTesting::BindWebUI(::mojo::PendingAssociatedReceiver<::content::mojom::WebUI> receiver, ::mojo::PendingAssociatedRemote<::content::mojom::WebUIHost> remote) {
  GetForwardingInterface()->BindWebUI(
    std::move(receiver)
    , 
    std::move(remote)
    );
}
FrameBindingsControlAsyncWaiter::FrameBindingsControlAsyncWaiter(
    FrameBindingsControl* proxy) : proxy_(proxy) {}

FrameBindingsControlAsyncWaiter::~FrameBindingsControlAsyncWaiter() = default;





void NavigationRendererCancellationListenerInterceptorForTesting::RendererCancellationWindowEnded() {
  GetForwardingInterface()->RendererCancellationWindowEnded();
}
NavigationRendererCancellationListenerAsyncWaiter::NavigationRendererCancellationListenerAsyncWaiter(
    NavigationRendererCancellationListener* proxy) : proxy_(proxy) {}

NavigationRendererCancellationListenerAsyncWaiter::~NavigationRendererCancellationListenerAsyncWaiter() = default;





void FrameHostInterceptorForTesting::CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowCallback callback) {
  GetForwardingInterface()->CreateNewWindow(
    std::move(params)
    , std::move(callback));
}
void FrameHostInterceptorForTesting::CreateChildFrame(const ::blink::LocalFrameToken& child_frame_token, ::mojo::PendingAssociatedRemote<Frame> frame, ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker, ::blink::mojom::PolicyContainerBindParamsPtr policy_container_bind_params, ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider, ::blink::mojom::TreeScopeType scope, const std::string& frame_name, const std::string& frame_unique_name, bool is_created_by_script, const ::blink::FramePolicy& frame_policy, ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties, ::blink::FrameOwnerElementType child_frame_owner_element_type, int64_t document_ukm_source_id) {
  GetForwardingInterface()->CreateChildFrame(
    std::move(child_frame_token)
    , 
    std::move(frame)
    , 
    std::move(browser_interface_broker)
    , 
    std::move(policy_container_bind_params)
    , 
    std::move(associated_interface_provider)
    , 
    std::move(scope)
    , 
    std::move(frame_name)
    , 
    std::move(frame_unique_name)
    , 
    std::move(is_created_by_script)
    , 
    std::move(frame_policy)
    , 
    std::move(frame_owner_properties)
    , 
    std::move(child_frame_owner_element_type)
    , 
    std::move(document_ukm_source_id)
    );
}
void FrameHostInterceptorForTesting::DidCommitProvisionalLoad(::content::mojom::DidCommitProvisionalLoadParamsPtr params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr interface_params) {
  GetForwardingInterface()->DidCommitProvisionalLoad(
    std::move(params)
    , 
    std::move(interface_params)
    );
}
void FrameHostInterceptorForTesting::DidCommitSameDocumentNavigation(::content::mojom::DidCommitProvisionalLoadParamsPtr params, ::content::mojom::DidCommitSameDocumentNavigationParamsPtr same_document_params) {
  GetForwardingInterface()->DidCommitSameDocumentNavigation(
    std::move(params)
    , 
    std::move(same_document_params)
    );
}
void FrameHostInterceptorForTesting::DidOpenDocumentInputStream(const ::GURL& url) {
  GetForwardingInterface()->DidOpenDocumentInputStream(
    std::move(url)
    );
}
void FrameHostInterceptorForTesting::BeginNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::BeginNavigationParamsPtr begin_params, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token, ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> navigation_client, ::mojo::PendingRemote<::blink::mojom::NavigationStateKeepAliveHandle> initiator_navigation_state_keep_alive_handle, ::mojo::PendingReceiver<NavigationRendererCancellationListener> renderer_cancellation_listener) {
  GetForwardingInterface()->BeginNavigation(
    std::move(common_params)
    , 
    std::move(begin_params)
    , 
    std::move(blob_url_token)
    , 
    std::move(navigation_client)
    , 
    std::move(initiator_navigation_state_keep_alive_handle)
    , 
    std::move(renderer_cancellation_listener)
    );
}
void FrameHostInterceptorForTesting::SubresourceResponseStarted(const ::url::SchemeHostPort& final_response_url, uint32_t cert_status) {
  GetForwardingInterface()->SubresourceResponseStarted(
    std::move(final_response_url)
    , 
    std::move(cert_status)
    );
}
void FrameHostInterceptorForTesting::ResourceLoadComplete(::blink::mojom::ResourceLoadInfoPtr url_load_info) {
  GetForwardingInterface()->ResourceLoadComplete(
    std::move(url_load_info)
    );
}
void FrameHostInterceptorForTesting::DidChangeName(const std::string& name, const std::string& unique_name) {
  GetForwardingInterface()->DidChangeName(
    std::move(name)
    , 
    std::move(unique_name)
    );
}
void FrameHostInterceptorForTesting::CancelInitialHistoryLoad() {
  GetForwardingInterface()->CancelInitialHistoryLoad();
}
void FrameHostInterceptorForTesting::UpdateEncoding(const std::string& encoding_name) {
  GetForwardingInterface()->UpdateEncoding(
    std::move(encoding_name)
    );
}
void FrameHostInterceptorForTesting::UpdateState(const ::blink::PageState& state) {
  GetForwardingInterface()->UpdateState(
    std::move(state)
    );
}
void FrameHostInterceptorForTesting::OpenURL(::blink::mojom::OpenURLParamsPtr params) {
  GetForwardingInterface()->OpenURL(
    std::move(params)
    );
}
void FrameHostInterceptorForTesting::DidStopLoading() {
  GetForwardingInterface()->DidStopLoading();
}
FrameHostAsyncWaiter::FrameHostAsyncWaiter(
    FrameHost* proxy) : proxy_(proxy) {}

FrameHostAsyncWaiter::~FrameHostAsyncWaiter() = default;


void FrameHostAsyncWaiter::CreateNewWindow(
    CreateNewWindowParamsPtr params, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply) {
  base::RunLoop loop;
  proxy_->CreateNewWindow(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateNewWindowStatus* out_status
,
             CreateNewWindowReplyPtr* out_reply
,
             CreateNewWindowStatus status,
             CreateNewWindowReplyPtr reply) {*out_status = std::move(status);*out_reply = std::move(reply);
            loop->Quit();
          },
          &loop,
          out_status,
          out_reply));
  loop.Run();
}








}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif