// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/devtools/protocol/memory.h"

#include "content/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace content {
namespace protocol {
namespace Memory {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Memory";
const char Metainfo::commandPrefix[] = "Memory.";
const char Metainfo::version[] = "1.3";

namespace PressureLevelEnum {
const char Moderate[] = "moderate";
const char Critical[] = "critical";
} // namespace PressureLevelEnum


CRDTP_BEGIN_DESERIALIZER(SamplingProfileNode)
    CRDTP_DESERIALIZE_FIELD("size", m_size),
    CRDTP_DESERIALIZE_FIELD("stack", m_stack),
    CRDTP_DESERIALIZE_FIELD("total", m_total),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SamplingProfileNode)
    CRDTP_SERIALIZE_FIELD("size", m_size);
    CRDTP_SERIALIZE_FIELD("total", m_total);
    CRDTP_SERIALIZE_FIELD("stack", m_stack);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SamplingProfile)
    CRDTP_DESERIALIZE_FIELD("modules", m_modules),
    CRDTP_DESERIALIZE_FIELD("samples", m_samples),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SamplingProfile)
    CRDTP_SERIALIZE_FIELD("samples", m_samples);
    CRDTP_SERIALIZE_FIELD("modules", m_modules);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Module)
    CRDTP_DESERIALIZE_FIELD("baseAddress", m_baseAddress),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("size", m_size),
    CRDTP_DESERIALIZE_FIELD("uuid", m_uuid),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Module)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("uuid", m_uuid);
    CRDTP_SERIALIZE_FIELD("baseAddress", m_baseAddress);
    CRDTP_SERIALIZE_FIELD("size", m_size);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(DOMCounter)
    CRDTP_DESERIALIZE_FIELD("count", m_count),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DOMCounter)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("count", m_count);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void getDOMCountersForLeakDetection(const crdtp::Dispatchable& dispatchable);
    void prepareForLeakDetection(const crdtp::Dispatchable& dispatchable);
    void setPressureNotificationsSuppressed(const crdtp::Dispatchable& dispatchable);
    void simulatePressureNotification(const crdtp::Dispatchable& dispatchable);
    void getBrowserSamplingProfile(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("getBrowserSamplingProfile"),
          &DomainDispatcherImpl::getBrowserSamplingProfile
    },
    {
          crdtp::SpanFrom("getDOMCountersForLeakDetection"),
          &DomainDispatcherImpl::getDOMCountersForLeakDetection
    },
    {
          crdtp::SpanFrom("prepareForLeakDetection"),
          &DomainDispatcherImpl::prepareForLeakDetection
    },
    {
          crdtp::SpanFrom("setPressureNotificationsSuppressed"),
          &DomainDispatcherImpl::setPressureNotificationsSuppressed
    },
    {
          crdtp::SpanFrom("simulatePressureNotification"),
          &DomainDispatcherImpl::simulatePressureNotification
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


class GetDOMCountersForLeakDetectionCallbackImpl : public Backend::GetDOMCountersForLeakDetectionCallback, public DomainDispatcher::Callback {
public:
    GetDOMCountersForLeakDetectionCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Memory.getDOMCountersForLeakDetection"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Array<protocol::Memory::DOMCounter>> counters) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("counters"), counters);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::getDOMCountersForLeakDetection(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    m_backend->GetDOMCountersForLeakDetection(std::make_unique<GetDOMCountersForLeakDetectionCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class PrepareForLeakDetectionCallbackImpl : public Backend::PrepareForLeakDetectionCallback, public DomainDispatcher::Callback {
public:
    PrepareForLeakDetectionCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Memory.prepareForLeakDetection"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::prepareForLeakDetection(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    m_backend->PrepareForLeakDetection(std::make_unique<PrepareForLeakDetectionCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct setPressureNotificationsSuppressedParams : public crdtp::DeserializableProtocolObject<setPressureNotificationsSuppressedParams> {
    bool suppressed;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setPressureNotificationsSuppressedParams)
    CRDTP_DESERIALIZE_FIELD("suppressed", suppressed),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setPressureNotificationsSuppressed(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setPressureNotificationsSuppressedParams params;
    if (!setPressureNotificationsSuppressedParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetPressureNotificationsSuppressed(params.suppressed);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Memory.setPressureNotificationsSuppressed"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct simulatePressureNotificationParams : public crdtp::DeserializableProtocolObject<simulatePressureNotificationParams> {
    String level;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(simulatePressureNotificationParams)
    CRDTP_DESERIALIZE_FIELD("level", level),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::simulatePressureNotification(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    simulatePressureNotificationParams params;
    if (!simulatePressureNotificationParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SimulatePressureNotification(params.level);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Memory.simulatePressureNotification"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getBrowserSamplingProfile(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Memory::SamplingProfile> out_profile;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->GetBrowserSamplingProfile(&out_profile);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Memory.getBrowserSamplingProfile"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("profile"), out_profile);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Memory"), SortedRedirects(), std::move(dispatcher));
}

} // Memory
} // namespace content
} // namespace protocol
