// components/services/storage/public/mojom/file_system_access_context.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_CONTEXT_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_CONTEXT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/file_system_access_context.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/file_system_access_context.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/file_system_access_context.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-forward.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace storage::mojom {

class FileSystemAccessContextProxy;

template <typename ImplRefTraits>
class FileSystemAccessContextStub;

class FileSystemAccessContextRequestValidator;
class FileSystemAccessContextResponseValidator;


class FileSystemAccessContext
    : public FileSystemAccessContextInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.FileSystemAccessContext";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileSystemAccessContextInterfaceBase;
  using Proxy_ = FileSystemAccessContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileSystemAccessContextStub<ImplRefTraits>;

  using RequestValidator_ = FileSystemAccessContextRequestValidator;
  using ResponseValidator_ = FileSystemAccessContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSerializeHandleMinVersion = 0,
    kDeserializeHandleMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SerializeHandle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeserializeHandle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileSystemAccessContext() = default;

  using SerializeHandleCallback = base::OnceCallback<void(const std::vector<uint8_t>&)>;
  using SerializeHandleMojoCallback = base::OnceCallback<void(const std::vector<uint8_t>&)>;

  virtual void SerializeHandle(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> token, SerializeHandleCallback callback) = 0;

  virtual void DeserializeHandle(const ::blink::StorageKey& storage_key, const std::vector<uint8_t>& bits, ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> token) = 0;

  virtual void Clone(::mojo::PendingReceiver<FileSystemAccessContext> receiever) = 0;
};



class  FileSystemAccessContextProxy
    : public FileSystemAccessContext {
 public:
  using InterfaceType = FileSystemAccessContext;

  explicit FileSystemAccessContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SerializeHandle(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> token, SerializeHandleCallback callback) final;
  
  void DeserializeHandle(const ::blink::StorageKey& storage_key, const std::vector<uint8_t>& bits, ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> token) final;
  
  void Clone(::mojo::PendingReceiver<FileSystemAccessContext> receiever) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FileSystemAccessContextStubDispatch {
 public:
  static bool Accept(FileSystemAccessContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileSystemAccessContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileSystemAccessContext>>
class FileSystemAccessContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileSystemAccessContextStub() = default;
  ~FileSystemAccessContextStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FileSystemAccessContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FileSystemAccessContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // storage::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_CONTEXT_MOJOM_H_