// components/schema_org/common/metadata.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_H_
#define COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/schema_org/common/metadata.mojom-features.h"  // IWYU pragma: export
#include "components/schema_org/common/metadata.mojom-shared.h"  // IWYU pragma: export
#include "components/schema_org/common/metadata.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace schema_org::mojom {







class  Values {
 public:
  using DataView = ValuesDataView;
  using Data_ = internal::Values_Data;
  using Tag = Data_::Values_Tag;

  template <typename... Args>
  static ValuesPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |bool_values|.
  static ValuesPtr NewBoolValues(
      std::vector<bool> value);
  // Construct an instance holding |long_values|.
  static ValuesPtr NewLongValues(
      std::vector<int64_t> value);
  // Construct an instance holding |string_values|.
  static ValuesPtr NewStringValues(
      std::vector<std::string> value);
  // Construct an instance holding |entity_values|.
  static ValuesPtr NewEntityValues(
      std::vector<EntityPtr> value);

  template <typename U>
  static ValuesPtr From(const U& u) {
    return mojo::TypeConverter<ValuesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Values>::Convert(*this);
  }
  ~Values();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  Values(const Values& other) = delete;
  Values& operator=(const Values& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ValuesPtr>
  ValuesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Values>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, Values>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_bool_values() const { return tag_ == Tag::kBoolValues; }
  const std::vector<bool>& get_bool_values() const {
    CHECK(tag_ == Tag::kBoolValues);
    return data_.bool_values;
  }
  std::vector<bool>& get_bool_values() {
    CHECK(tag_ == Tag::kBoolValues);
    return data_.bool_values;
  }
  void set_bool_values(std::vector<bool> bool_values);

  bool is_long_values() const { return tag_ == Tag::kLongValues; }
  const std::vector<int64_t>& get_long_values() const {
    CHECK(tag_ == Tag::kLongValues);
    return data_.long_values;
  }
  std::vector<int64_t>& get_long_values() {
    CHECK(tag_ == Tag::kLongValues);
    return data_.long_values;
  }
  void set_long_values(std::vector<int64_t> long_values);

  bool is_string_values() const { return tag_ == Tag::kStringValues; }
  const std::vector<std::string>& get_string_values() const {
    CHECK(tag_ == Tag::kStringValues);
    return data_.string_values;
  }
  std::vector<std::string>& get_string_values() {
    CHECK(tag_ == Tag::kStringValues);
    return data_.string_values;
  }
  void set_string_values(std::vector<std::string> string_values);

  bool is_entity_values() const { return tag_ == Tag::kEntityValues; }
  const std::vector<EntityPtr>& get_entity_values() const {
    CHECK(tag_ == Tag::kEntityValues);
    return data_.entity_values;
  }
  std::vector<EntityPtr>& get_entity_values() {
    CHECK(tag_ == Tag::kEntityValues);
    return data_.entity_values;
  }
  void set_entity_values(std::vector<EntityPtr> entity_values);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Values::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<Values::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBoolValues)>,
        std::vector<bool> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLongValues)>,
        std::vector<int64_t> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kStringValues)>,
        std::vector<std::string> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEntityValues)>,
        std::vector<EntityPtr> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::vector<bool> bool_values;
    std::vector<int64_t> long_values;
    std::vector<std::string> string_values;
    std::vector<EntityPtr> entity_values;
  };

  Values(
      std::in_place_index_t<static_cast<size_t>(Tag::kBoolValues)>,
      std::vector<bool> value);
  Values(
      std::in_place_index_t<static_cast<size_t>(Tag::kLongValues)>,
      std::vector<int64_t> value);
  Values(
      std::in_place_index_t<static_cast<size_t>(Tag::kStringValues)>,
      std::vector<std::string> value);
  Values(
      std::in_place_index_t<static_cast<size_t>(Tag::kEntityValues)>,
      std::vector<EntityPtr> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  Property {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Property, T>::value>;
  using DataView = PropertyDataView;
  using Data_ = internal::Property_Data;

  template <typename... Args>
  static PropertyPtr New(Args&&... args) {
    return PropertyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PropertyPtr From(const U& u) {
    return mojo::TypeConverter<PropertyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Property>::Convert(*this);
  }


  Property();

  Property(
      const std::string& name,
      ValuesPtr values);

Property(const Property&) = delete;
Property& operator=(const Property&) = delete;

  ~Property();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PropertyPtr>
  PropertyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Property::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Property::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Property::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Property::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Property::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Property::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Property_UnserializedMessageContext<
            UserType, Property::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Property::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Property::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Property_UnserializedMessageContext<
            UserType, Property::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Property::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  ValuesPtr values;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Property::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Property::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Property::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Property::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Entity {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Entity, T>::value>;
  using DataView = EntityDataView;
  using Data_ = internal::Entity_Data;

  template <typename... Args>
  static EntityPtr New(Args&&... args) {
    return EntityPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EntityPtr From(const U& u) {
    return mojo::TypeConverter<EntityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Entity>::Convert(*this);
  }


  Entity();

  Entity(
      const std::string& type,
      std::vector<PropertyPtr> properties);

Entity(const Entity&) = delete;
Entity& operator=(const Entity&) = delete;

  ~Entity();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EntityPtr>
  EntityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Entity::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Entity::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Entity::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Entity::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Entity::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Entity::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Entity_UnserializedMessageContext<
            UserType, Entity::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Entity::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Entity::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Entity_UnserializedMessageContext<
            UserType, Entity::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Entity::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string type;
  
  std::vector<PropertyPtr> properties;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Entity::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Entity::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Entity::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Entity::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ValuesPtr Values::Clone() const {
  switch (tag_) {
    case Tag::kBoolValues:
      return NewBoolValues(
          mojo::Clone(data_.bool_values));
    case Tag::kLongValues:
      return NewLongValues(
          mojo::Clone(data_.long_values));
    case Tag::kStringValues:
      return NewStringValues(
          mojo::Clone(data_.string_values));
    case Tag::kEntityValues:
      return NewEntityValues(
          mojo::Clone(data_.entity_values));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Values>::value>::type*>
bool Values::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kBoolValues:
      return mojo::Equals(data_.bool_values, other.data_.bool_values);
    case Tag::kLongValues:
      return mojo::Equals(data_.long_values, other.data_.long_values);
    case Tag::kStringValues:
      return mojo::Equals(data_.string_values, other.data_.string_values);
    case Tag::kEntityValues:
      return mojo::Equals(data_.entity_values, other.data_.entity_values);
  }

  return false;
}
template <typename StructPtrType>
PropertyPtr Property::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(values)
  );
}

template <typename T, Property::EnableIfSame<T>*>
bool Property::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->values, other_struct.values))
    return false;
  return true;
}

template <typename T, Property::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.values < rhs.values)
    return true;
  if (rhs.values < lhs.values)
    return false;
  return false;
}
template <typename StructPtrType>
EntityPtr Entity::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(properties)
  );
}

template <typename T, Entity::EnableIfSame<T>*>
bool Entity::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->properties, other_struct.properties))
    return false;
  return true;
}

template <typename T, Entity::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.properties < rhs.properties)
    return true;
  if (rhs.properties < lhs.properties)
    return false;
  return false;
}


}  // schema_org::mojom

namespace mojo {


template <>
struct  StructTraits<::schema_org::mojom::Property::DataView,
                                         ::schema_org::mojom::PropertyPtr> {
  static bool IsNull(const ::schema_org::mojom::PropertyPtr& input) { return !input; }
  static void SetToNull(::schema_org::mojom::PropertyPtr* output) { output->reset(); }

  static const decltype(::schema_org::mojom::Property::name)& name(
      const ::schema_org::mojom::PropertyPtr& input) {
    return input->name;
  }

  static const decltype(::schema_org::mojom::Property::values)& values(
      const ::schema_org::mojom::PropertyPtr& input) {
    return input->values;
  }

  static bool Read(::schema_org::mojom::Property::DataView input, ::schema_org::mojom::PropertyPtr* output);
};


template <>
struct  StructTraits<::schema_org::mojom::Entity::DataView,
                                         ::schema_org::mojom::EntityPtr> {
  static bool IsNull(const ::schema_org::mojom::EntityPtr& input) { return !input; }
  static void SetToNull(::schema_org::mojom::EntityPtr* output) { output->reset(); }

  static const decltype(::schema_org::mojom::Entity::type)& type(
      const ::schema_org::mojom::EntityPtr& input) {
    return input->type;
  }

  static const decltype(::schema_org::mojom::Entity::properties)& properties(
      const ::schema_org::mojom::EntityPtr& input) {
    return input->properties;
  }

  static bool Read(::schema_org::mojom::Entity::DataView input, ::schema_org::mojom::EntityPtr* output);
};


template <>
struct  UnionTraits<::schema_org::mojom::Values::DataView,
                                        ::schema_org::mojom::ValuesPtr> {
  static bool IsNull(const ::schema_org::mojom::ValuesPtr& input) { return !input; }
  static void SetToNull(::schema_org::mojom::ValuesPtr* output) { output->reset(); }

  static ::schema_org::mojom::Values::Tag GetTag(const ::schema_org::mojom::ValuesPtr& input) {
    return input->which();
  }

  static const std::vector<bool>& bool_values(const ::schema_org::mojom::ValuesPtr& input) {
    return input->get_bool_values();
  }

  static const std::vector<int64_t>& long_values(const ::schema_org::mojom::ValuesPtr& input) {
    return input->get_long_values();
  }

  static const std::vector<std::string>& string_values(const ::schema_org::mojom::ValuesPtr& input) {
    return input->get_string_values();
  }

  static const std::vector<::schema_org::mojom::EntityPtr>& entity_values(const ::schema_org::mojom::ValuesPtr& input) {
    return input->get_entity_values();
  }

  static bool Read(::schema_org::mojom::Values::DataView input, ::schema_org::mojom::ValuesPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_H_