// components/performance_manager/public/mojom/coordination_unit.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/performance_manager/public/mojom/coordination_unit.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/performance_manager/public/mojom/coordination_unit.mojom-params-data.h"
#include "components/performance_manager/public/mojom/coordination_unit.mojom-shared-message-ids.h"

#include "components/performance_manager/public/mojom/coordination_unit.mojom-blink-import-headers.h"
#include "components/performance_manager/public/mojom/coordination_unit.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace performance_manager::mojom::blink {
// The declaration includes the definition on other builds.

DocumentCoordinationUnit::IPCStableHashFunction DocumentCoordinationUnit::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DocumentCoordinationUnit>(message.name())) {
    case messages::DocumentCoordinationUnit::kSetNetworkAlmostIdle: {
      return &DocumentCoordinationUnit::SetNetworkAlmostIdle_Sym::IPCStableHash;
    }
    case messages::DocumentCoordinationUnit::kSetLifecycleState: {
      return &DocumentCoordinationUnit::SetLifecycleState_Sym::IPCStableHash;
    }
    case messages::DocumentCoordinationUnit::kSetHasNonEmptyBeforeUnload: {
      return &DocumentCoordinationUnit::SetHasNonEmptyBeforeUnload_Sym::IPCStableHash;
    }
    case messages::DocumentCoordinationUnit::kSetHadFormInteraction: {
      return &DocumentCoordinationUnit::SetHadFormInteraction_Sym::IPCStableHash;
    }
    case messages::DocumentCoordinationUnit::kSetHadUserEdits: {
      return &DocumentCoordinationUnit::SetHadUserEdits_Sym::IPCStableHash;
    }
    case messages::DocumentCoordinationUnit::kOnStartedUsingWebRTC: {
      return &DocumentCoordinationUnit::OnStartedUsingWebRTC_Sym::IPCStableHash;
    }
    case messages::DocumentCoordinationUnit::kOnStoppedUsingWebRTC: {
      return &DocumentCoordinationUnit::OnStoppedUsingWebRTC_Sym::IPCStableHash;
    }
    case messages::DocumentCoordinationUnit::kSetIsAdFrame: {
      return &DocumentCoordinationUnit::SetIsAdFrame_Sym::IPCStableHash;
    }
    case messages::DocumentCoordinationUnit::kOnNonPersistentNotificationCreated: {
      return &DocumentCoordinationUnit::OnNonPersistentNotificationCreated_Sym::IPCStableHash;
    }
    case messages::DocumentCoordinationUnit::kOnFirstContentfulPaint: {
      return &DocumentCoordinationUnit::OnFirstContentfulPaint_Sym::IPCStableHash;
    }
    case messages::DocumentCoordinationUnit::kOnWebMemoryMeasurementRequested: {
      return &DocumentCoordinationUnit::OnWebMemoryMeasurementRequested_Sym::IPCStableHash;
    }
    case messages::DocumentCoordinationUnit::kOnFreezingOriginTrialOptOut: {
      return &DocumentCoordinationUnit::OnFreezingOriginTrialOptOut_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DocumentCoordinationUnit::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DocumentCoordinationUnit>(message.name())) {
      case messages::DocumentCoordinationUnit::kSetNetworkAlmostIdle:
            return "Receive performance_manager::mojom::DocumentCoordinationUnit::SetNetworkAlmostIdle";
      case messages::DocumentCoordinationUnit::kSetLifecycleState:
            return "Receive performance_manager::mojom::DocumentCoordinationUnit::SetLifecycleState";
      case messages::DocumentCoordinationUnit::kSetHasNonEmptyBeforeUnload:
            return "Receive performance_manager::mojom::DocumentCoordinationUnit::SetHasNonEmptyBeforeUnload";
      case messages::DocumentCoordinationUnit::kSetHadFormInteraction:
            return "Receive performance_manager::mojom::DocumentCoordinationUnit::SetHadFormInteraction";
      case messages::DocumentCoordinationUnit::kSetHadUserEdits:
            return "Receive performance_manager::mojom::DocumentCoordinationUnit::SetHadUserEdits";
      case messages::DocumentCoordinationUnit::kOnStartedUsingWebRTC:
            return "Receive performance_manager::mojom::DocumentCoordinationUnit::OnStartedUsingWebRTC";
      case messages::DocumentCoordinationUnit::kOnStoppedUsingWebRTC:
            return "Receive performance_manager::mojom::DocumentCoordinationUnit::OnStoppedUsingWebRTC";
      case messages::DocumentCoordinationUnit::kSetIsAdFrame:
            return "Receive performance_manager::mojom::DocumentCoordinationUnit::SetIsAdFrame";
      case messages::DocumentCoordinationUnit::kOnNonPersistentNotificationCreated:
            return "Receive performance_manager::mojom::DocumentCoordinationUnit::OnNonPersistentNotificationCreated";
      case messages::DocumentCoordinationUnit::kOnFirstContentfulPaint:
            return "Receive performance_manager::mojom::DocumentCoordinationUnit::OnFirstContentfulPaint";
      case messages::DocumentCoordinationUnit::kOnWebMemoryMeasurementRequested:
            return "Receive performance_manager::mojom::DocumentCoordinationUnit::OnWebMemoryMeasurementRequested";
      case messages::DocumentCoordinationUnit::kOnFreezingOriginTrialOptOut:
            return "Receive performance_manager::mojom::DocumentCoordinationUnit::OnFreezingOriginTrialOptOut";
    }
  } else {
    switch (static_cast<messages::DocumentCoordinationUnit>(message.name())) {
      case messages::DocumentCoordinationUnit::kSetNetworkAlmostIdle:
            return "Receive reply performance_manager::mojom::DocumentCoordinationUnit::SetNetworkAlmostIdle";
      case messages::DocumentCoordinationUnit::kSetLifecycleState:
            return "Receive reply performance_manager::mojom::DocumentCoordinationUnit::SetLifecycleState";
      case messages::DocumentCoordinationUnit::kSetHasNonEmptyBeforeUnload:
            return "Receive reply performance_manager::mojom::DocumentCoordinationUnit::SetHasNonEmptyBeforeUnload";
      case messages::DocumentCoordinationUnit::kSetHadFormInteraction:
            return "Receive reply performance_manager::mojom::DocumentCoordinationUnit::SetHadFormInteraction";
      case messages::DocumentCoordinationUnit::kSetHadUserEdits:
            return "Receive reply performance_manager::mojom::DocumentCoordinationUnit::SetHadUserEdits";
      case messages::DocumentCoordinationUnit::kOnStartedUsingWebRTC:
            return "Receive reply performance_manager::mojom::DocumentCoordinationUnit::OnStartedUsingWebRTC";
      case messages::DocumentCoordinationUnit::kOnStoppedUsingWebRTC:
            return "Receive reply performance_manager::mojom::DocumentCoordinationUnit::OnStoppedUsingWebRTC";
      case messages::DocumentCoordinationUnit::kSetIsAdFrame:
            return "Receive reply performance_manager::mojom::DocumentCoordinationUnit::SetIsAdFrame";
      case messages::DocumentCoordinationUnit::kOnNonPersistentNotificationCreated:
            return "Receive reply performance_manager::mojom::DocumentCoordinationUnit::OnNonPersistentNotificationCreated";
      case messages::DocumentCoordinationUnit::kOnFirstContentfulPaint:
            return "Receive reply performance_manager::mojom::DocumentCoordinationUnit::OnFirstContentfulPaint";
      case messages::DocumentCoordinationUnit::kOnWebMemoryMeasurementRequested:
            return "Receive reply performance_manager::mojom::DocumentCoordinationUnit::OnWebMemoryMeasurementRequested";
      case messages::DocumentCoordinationUnit::kOnFreezingOriginTrialOptOut:
            return "Receive reply performance_manager::mojom::DocumentCoordinationUnit::OnFreezingOriginTrialOptOut";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DocumentCoordinationUnit::SetNetworkAlmostIdle_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6d9aaf75;  // IPCStableHash for performance_manager::mojom::DocumentCoordinationUnit::SetNetworkAlmostIdle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DocumentCoordinationUnit::SetLifecycleState_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbac4eac2;  // IPCStableHash for performance_manager::mojom::DocumentCoordinationUnit::SetLifecycleState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DocumentCoordinationUnit::SetHasNonEmptyBeforeUnload_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x042be95f;  // IPCStableHash for performance_manager::mojom::DocumentCoordinationUnit::SetHasNonEmptyBeforeUnload
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DocumentCoordinationUnit::SetHadFormInteraction_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf9673a44;  // IPCStableHash for performance_manager::mojom::DocumentCoordinationUnit::SetHadFormInteraction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DocumentCoordinationUnit::SetHadUserEdits_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95f88684;  // IPCStableHash for performance_manager::mojom::DocumentCoordinationUnit::SetHadUserEdits
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DocumentCoordinationUnit::OnStartedUsingWebRTC_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c26d134;  // IPCStableHash for performance_manager::mojom::DocumentCoordinationUnit::OnStartedUsingWebRTC
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DocumentCoordinationUnit::OnStoppedUsingWebRTC_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2a1321a2;  // IPCStableHash for performance_manager::mojom::DocumentCoordinationUnit::OnStoppedUsingWebRTC
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DocumentCoordinationUnit::SetIsAdFrame_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44f2a4ab;  // IPCStableHash for performance_manager::mojom::DocumentCoordinationUnit::SetIsAdFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DocumentCoordinationUnit::OnNonPersistentNotificationCreated_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5ec4c25c;  // IPCStableHash for performance_manager::mojom::DocumentCoordinationUnit::OnNonPersistentNotificationCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DocumentCoordinationUnit::OnFirstContentfulPaint_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xebc524bb;  // IPCStableHash for performance_manager::mojom::DocumentCoordinationUnit::OnFirstContentfulPaint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DocumentCoordinationUnit::OnWebMemoryMeasurementRequested_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd64c8527;  // IPCStableHash for performance_manager::mojom::DocumentCoordinationUnit::OnWebMemoryMeasurementRequested
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DocumentCoordinationUnit::OnFreezingOriginTrialOptOut_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x392cd9f8;  // IPCStableHash for performance_manager::mojom::DocumentCoordinationUnit::OnFreezingOriginTrialOptOut
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback(
      DocumentCoordinationUnit::OnWebMemoryMeasurementRequestedCallback callback
      ) : callback_(std::move(callback)) {
  }

  DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback(const DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback&) = delete;
  DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback& operator=(const DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DocumentCoordinationUnit::OnWebMemoryMeasurementRequestedCallback callback_;
};

DocumentCoordinationUnitProxy::DocumentCoordinationUnitProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DocumentCoordinationUnitProxy::SetNetworkAlmostIdle(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send performance_manager::mojom::DocumentCoordinationUnit::SetNetworkAlmostIdle");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kSetNetworkAlmostIdle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetNetworkAlmostIdle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DocumentCoordinationUnitProxy::SetLifecycleState(
    ::performance_manager::mojom::blink::LifecycleState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send performance_manager::mojom::DocumentCoordinationUnit::SetLifecycleState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::performance_manager::mojom::blink::LifecycleState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kSetLifecycleState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetLifecycleState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::performance_manager::mojom::LifecycleState>(
    in_state,
    &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetLifecycleState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DocumentCoordinationUnitProxy::SetHasNonEmptyBeforeUnload(
    bool in_has_nonempty_beforeunload) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send performance_manager::mojom::DocumentCoordinationUnit::SetHasNonEmptyBeforeUnload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_nonempty_beforeunload"), in_has_nonempty_beforeunload,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kSetHasNonEmptyBeforeUnload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data> params(
          message);
  params.Allocate();

  params->has_nonempty_beforeunload = in_has_nonempty_beforeunload;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetHasNonEmptyBeforeUnload");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DocumentCoordinationUnitProxy::SetHadFormInteraction(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send performance_manager::mojom::DocumentCoordinationUnit::SetHadFormInteraction");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kSetHadFormInteraction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetHadFormInteraction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DocumentCoordinationUnitProxy::SetHadUserEdits(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send performance_manager::mojom::DocumentCoordinationUnit::SetHadUserEdits");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kSetHadUserEdits), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetHadUserEdits_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetHadUserEdits");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DocumentCoordinationUnitProxy::OnStartedUsingWebRTC(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send performance_manager::mojom::DocumentCoordinationUnit::OnStartedUsingWebRTC");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kOnStartedUsingWebRTC), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnStartedUsingWebRTC_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnStartedUsingWebRTC");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DocumentCoordinationUnitProxy::OnStoppedUsingWebRTC(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send performance_manager::mojom::DocumentCoordinationUnit::OnStoppedUsingWebRTC");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kOnStoppedUsingWebRTC), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnStoppedUsingWebRTC_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnStoppedUsingWebRTC");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DocumentCoordinationUnitProxy::SetIsAdFrame(
    bool in_is_ad_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send performance_manager::mojom::DocumentCoordinationUnit::SetIsAdFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_ad_frame"), in_is_ad_frame,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kSetIsAdFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetIsAdFrame_Params_Data> params(
          message);
  params.Allocate();

  params->is_ad_frame = in_is_ad_frame;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetIsAdFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DocumentCoordinationUnitProxy::OnNonPersistentNotificationCreated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send performance_manager::mojom::DocumentCoordinationUnit::OnNonPersistentNotificationCreated");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kOnNonPersistentNotificationCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnNonPersistentNotificationCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DocumentCoordinationUnitProxy::OnFirstContentfulPaint(
    ::base::TimeDelta in_time_since_navigation_start) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send performance_manager::mojom::DocumentCoordinationUnit::OnFirstContentfulPaint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time_since_navigation_start"), in_time_since_navigation_start,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kOnFirstContentfulPaint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->time_since_navigation_start)::BaseType> time_since_navigation_start_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_time_since_navigation_start,
    time_since_navigation_start_fragment);

  params->time_since_navigation_start.Set(
      time_since_navigation_start_fragment.is_null() ? nullptr : time_since_navigation_start_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->time_since_navigation_start.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null time_since_navigation_start in DocumentCoordinationUnit.OnFirstContentfulPaint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnFirstContentfulPaint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DocumentCoordinationUnitProxy::OnWebMemoryMeasurementRequested(
    ::performance_manager::mojom::blink::WebMemoryMeasurement::Mode in_mode, OnWebMemoryMeasurementRequestedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send performance_manager::mojom::DocumentCoordinationUnit::OnWebMemoryMeasurementRequested", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type ::performance_manager::mojom::blink::WebMemoryMeasurement::Mode>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kOnWebMemoryMeasurementRequested), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::performance_manager::mojom::WebMemoryMeasurement_Mode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnWebMemoryMeasurementRequested");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DocumentCoordinationUnitProxy::OnFreezingOriginTrialOptOut(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send performance_manager::mojom::DocumentCoordinationUnit::OnFreezingOriginTrialOptOut");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kOnFreezingOriginTrialOptOut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnFreezingOriginTrialOptOut_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnFreezingOriginTrialOptOut");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DocumentCoordinationUnit::OnWebMemoryMeasurementRequestedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder> proxy(
        new DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DocumentCoordinationUnit::OnWebMemoryMeasurementRequestedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::performance_manager::mojom::blink::WebMemoryMeasurementPtr in_measurement);
};

bool DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DocumentCoordinationUnit.10
  bool success = true;
  ::performance_manager::mojom::blink::WebMemoryMeasurementPtr p_measurement{};
  DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMeasurement(&p_measurement))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DocumentCoordinationUnit::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_measurement));
  }
  return true;
}

void DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder::Run(
    ::performance_manager::mojom::blink::WebMemoryMeasurementPtr in_measurement) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply performance_manager::mojom::DocumentCoordinationUnit::OnWebMemoryMeasurementRequested", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("measurement"), in_measurement,
                        "<value of type ::performance_manager::mojom::blink::WebMemoryMeasurementPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentCoordinationUnit::kOnWebMemoryMeasurementRequested), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->measurement)::BaseType> measurement_fragment(
          params.message());
  
  mojo::internal::Serialize<::performance_manager::mojom::WebMemoryMeasurementDataView>(
    in_measurement,
    measurement_fragment);

  params->measurement.Set(
      measurement_fragment.is_null() ? nullptr : measurement_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->measurement.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null measurement in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnWebMemoryMeasurementRequested");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DocumentCoordinationUnitStubDispatch::Accept(
    DocumentCoordinationUnit* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DocumentCoordinationUnit>(message->header()->name)) {
    case messages::DocumentCoordinationUnit::kSetNetworkAlmostIdle: {
      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DocumentCoordinationUnit.0
      bool success = true;
      DocumentCoordinationUnit_SetNetworkAlmostIdle_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNetworkAlmostIdle(        );
      return true;
    }
    case messages::DocumentCoordinationUnit::kSetLifecycleState: {
      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetLifecycleState_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetLifecycleState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DocumentCoordinationUnit.1
      bool success = true;
      ::performance_manager::mojom::blink::LifecycleState p_state{};
      DocumentCoordinationUnit_SetLifecycleState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLifecycleState(        
        std::move(p_state));
      return true;
    }
    case messages::DocumentCoordinationUnit::kSetHasNonEmptyBeforeUnload: {
      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DocumentCoordinationUnit.2
      bool success = true;
      bool p_has_nonempty_beforeunload{};
      DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_has_nonempty_beforeunload = input_data_view.has_nonempty_beforeunload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasNonEmptyBeforeUnload(        
        std::move(p_has_nonempty_beforeunload));
      return true;
    }
    case messages::DocumentCoordinationUnit::kSetHadFormInteraction: {
      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DocumentCoordinationUnit.3
      bool success = true;
      DocumentCoordinationUnit_SetHadFormInteraction_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHadFormInteraction(        );
      return true;
    }
    case messages::DocumentCoordinationUnit::kSetHadUserEdits: {
      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetHadUserEdits_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetHadUserEdits_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DocumentCoordinationUnit.4
      bool success = true;
      DocumentCoordinationUnit_SetHadUserEdits_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHadUserEdits(        );
      return true;
    }
    case messages::DocumentCoordinationUnit::kOnStartedUsingWebRTC: {
      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_OnStartedUsingWebRTC_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_OnStartedUsingWebRTC_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DocumentCoordinationUnit.5
      bool success = true;
      DocumentCoordinationUnit_OnStartedUsingWebRTC_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStartedUsingWebRTC(        );
      return true;
    }
    case messages::DocumentCoordinationUnit::kOnStoppedUsingWebRTC: {
      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_OnStoppedUsingWebRTC_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_OnStoppedUsingWebRTC_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DocumentCoordinationUnit.6
      bool success = true;
      DocumentCoordinationUnit_OnStoppedUsingWebRTC_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStoppedUsingWebRTC(        );
      return true;
    }
    case messages::DocumentCoordinationUnit::kSetIsAdFrame: {
      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetIsAdFrame_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetIsAdFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DocumentCoordinationUnit.7
      bool success = true;
      bool p_is_ad_frame{};
      DocumentCoordinationUnit_SetIsAdFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_ad_frame = input_data_view.is_ad_frame();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsAdFrame(        
        std::move(p_is_ad_frame));
      return true;
    }
    case messages::DocumentCoordinationUnit::kOnNonPersistentNotificationCreated: {
      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DocumentCoordinationUnit.8
      bool success = true;
      DocumentCoordinationUnit_OnNonPersistentNotificationCreated_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNonPersistentNotificationCreated(        );
      return true;
    }
    case messages::DocumentCoordinationUnit::kOnFirstContentfulPaint: {
      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DocumentCoordinationUnit.9
      bool success = true;
      ::base::TimeDelta p_time_since_navigation_start{};
      DocumentCoordinationUnit_OnFirstContentfulPaint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTimeSinceNavigationStart(&p_time_since_navigation_start))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFirstContentfulPaint(        
        std::move(p_time_since_navigation_start));
      return true;
    }
    case messages::DocumentCoordinationUnit::kOnWebMemoryMeasurementRequested: {
      break;
    }
    case messages::DocumentCoordinationUnit::kOnFreezingOriginTrialOptOut: {
      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_OnFreezingOriginTrialOptOut_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_OnFreezingOriginTrialOptOut_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DocumentCoordinationUnit.11
      bool success = true;
      DocumentCoordinationUnit_OnFreezingOriginTrialOptOut_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFreezingOriginTrialOptOut(        );
      return true;
    }
  }
  return false;
}

// static
bool DocumentCoordinationUnitStubDispatch::AcceptWithResponder(
    DocumentCoordinationUnit* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DocumentCoordinationUnit>(message->header()->name)) {
    case messages::DocumentCoordinationUnit::kSetNetworkAlmostIdle: {
      break;
    }
    case messages::DocumentCoordinationUnit::kSetLifecycleState: {
      break;
    }
    case messages::DocumentCoordinationUnit::kSetHasNonEmptyBeforeUnload: {
      break;
    }
    case messages::DocumentCoordinationUnit::kSetHadFormInteraction: {
      break;
    }
    case messages::DocumentCoordinationUnit::kSetHadUserEdits: {
      break;
    }
    case messages::DocumentCoordinationUnit::kOnStartedUsingWebRTC: {
      break;
    }
    case messages::DocumentCoordinationUnit::kOnStoppedUsingWebRTC: {
      break;
    }
    case messages::DocumentCoordinationUnit::kSetIsAdFrame: {
      break;
    }
    case messages::DocumentCoordinationUnit::kOnNonPersistentNotificationCreated: {
      break;
    }
    case messages::DocumentCoordinationUnit::kOnFirstContentfulPaint: {
      break;
    }
    case messages::DocumentCoordinationUnit::kOnWebMemoryMeasurementRequested: {
      internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data* params =
          reinterpret_cast<
              internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DocumentCoordinationUnit.10
      bool success = true;
      ::performance_manager::mojom::blink::WebMemoryMeasurement::Mode p_mode{};
      DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 10, false);
        return false;
      }
      auto callback =
          DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWebMemoryMeasurementRequested(        
        std::move(p_mode), std::move(callback));
      return true;
    }
    case messages::DocumentCoordinationUnit::kOnFreezingOriginTrialOptOut: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDocumentCoordinationUnitValidationInfo[] = {
    {base::to_underlying(messages::DocumentCoordinationUnit::kSetNetworkAlmostIdle),
     { &internal::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DocumentCoordinationUnit::kSetLifecycleState),
     { &internal::DocumentCoordinationUnit_SetLifecycleState_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DocumentCoordinationUnit::kSetHasNonEmptyBeforeUnload),
     { &internal::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DocumentCoordinationUnit::kSetHadFormInteraction),
     { &internal::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DocumentCoordinationUnit::kSetHadUserEdits),
     { &internal::DocumentCoordinationUnit_SetHadUserEdits_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DocumentCoordinationUnit::kOnStartedUsingWebRTC),
     { &internal::DocumentCoordinationUnit_OnStartedUsingWebRTC_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DocumentCoordinationUnit::kOnStoppedUsingWebRTC),
     { &internal::DocumentCoordinationUnit_OnStoppedUsingWebRTC_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DocumentCoordinationUnit::kSetIsAdFrame),
     { &internal::DocumentCoordinationUnit_SetIsAdFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DocumentCoordinationUnit::kOnNonPersistentNotificationCreated),
     { &internal::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DocumentCoordinationUnit::kOnFirstContentfulPaint),
     { &internal::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DocumentCoordinationUnit::kOnWebMemoryMeasurementRequested),
     { &internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data::Validate,
      &internal::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::DocumentCoordinationUnit::kOnFreezingOriginTrialOptOut),
     { &internal::DocumentCoordinationUnit_OnFreezingOriginTrialOptOut_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DocumentCoordinationUnitRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::performance_manager::mojom::blink::DocumentCoordinationUnit::Name_,
    kDocumentCoordinationUnitValidationInfo);
}

bool DocumentCoordinationUnitResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::performance_manager::mojom::blink::DocumentCoordinationUnit::Name_,
    kDocumentCoordinationUnitValidationInfo);

}
// The declaration includes the definition on other builds.

ProcessCoordinationUnit::IPCStableHashFunction ProcessCoordinationUnit::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProcessCoordinationUnit>(message.name())) {
    case messages::ProcessCoordinationUnit::kSetMainThreadTaskLoadIsLow: {
      return &ProcessCoordinationUnit::SetMainThreadTaskLoadIsLow_Sym::IPCStableHash;
    }
    case messages::ProcessCoordinationUnit::kOnV8ContextCreated: {
      return &ProcessCoordinationUnit::OnV8ContextCreated_Sym::IPCStableHash;
    }
    case messages::ProcessCoordinationUnit::kOnV8ContextDetached: {
      return &ProcessCoordinationUnit::OnV8ContextDetached_Sym::IPCStableHash;
    }
    case messages::ProcessCoordinationUnit::kOnV8ContextDestroyed: {
      return &ProcessCoordinationUnit::OnV8ContextDestroyed_Sym::IPCStableHash;
    }
    case messages::ProcessCoordinationUnit::kOnRemoteIframeAttached: {
      return &ProcessCoordinationUnit::OnRemoteIframeAttached_Sym::IPCStableHash;
    }
    case messages::ProcessCoordinationUnit::kOnRemoteIframeDetached: {
      return &ProcessCoordinationUnit::OnRemoteIframeDetached_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProcessCoordinationUnit::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProcessCoordinationUnit>(message.name())) {
      case messages::ProcessCoordinationUnit::kSetMainThreadTaskLoadIsLow:
            return "Receive performance_manager::mojom::ProcessCoordinationUnit::SetMainThreadTaskLoadIsLow";
      case messages::ProcessCoordinationUnit::kOnV8ContextCreated:
            return "Receive performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextCreated";
      case messages::ProcessCoordinationUnit::kOnV8ContextDetached:
            return "Receive performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDetached";
      case messages::ProcessCoordinationUnit::kOnV8ContextDestroyed:
            return "Receive performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDestroyed";
      case messages::ProcessCoordinationUnit::kOnRemoteIframeAttached:
            return "Receive performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeAttached";
      case messages::ProcessCoordinationUnit::kOnRemoteIframeDetached:
            return "Receive performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeDetached";
    }
  } else {
    switch (static_cast<messages::ProcessCoordinationUnit>(message.name())) {
      case messages::ProcessCoordinationUnit::kSetMainThreadTaskLoadIsLow:
            return "Receive reply performance_manager::mojom::ProcessCoordinationUnit::SetMainThreadTaskLoadIsLow";
      case messages::ProcessCoordinationUnit::kOnV8ContextCreated:
            return "Receive reply performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextCreated";
      case messages::ProcessCoordinationUnit::kOnV8ContextDetached:
            return "Receive reply performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDetached";
      case messages::ProcessCoordinationUnit::kOnV8ContextDestroyed:
            return "Receive reply performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDestroyed";
      case messages::ProcessCoordinationUnit::kOnRemoteIframeAttached:
            return "Receive reply performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeAttached";
      case messages::ProcessCoordinationUnit::kOnRemoteIframeDetached:
            return "Receive reply performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeDetached";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProcessCoordinationUnit::SetMainThreadTaskLoadIsLow_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x97188ae6;  // IPCStableHash for performance_manager::mojom::ProcessCoordinationUnit::SetMainThreadTaskLoadIsLow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProcessCoordinationUnit::OnV8ContextCreated_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x73130109;  // IPCStableHash for performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProcessCoordinationUnit::OnV8ContextDetached_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaf69556a;  // IPCStableHash for performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDetached
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProcessCoordinationUnit::OnV8ContextDestroyed_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00d6763e;  // IPCStableHash for performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDestroyed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProcessCoordinationUnit::OnRemoteIframeAttached_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a431f26;  // IPCStableHash for performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeAttached
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProcessCoordinationUnit::OnRemoteIframeDetached_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc0c603f1;  // IPCStableHash for performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeDetached
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProcessCoordinationUnitProxy::ProcessCoordinationUnitProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProcessCoordinationUnitProxy::SetMainThreadTaskLoadIsLow(
    bool in_main_thread_task_load_is_low) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send performance_manager::mojom::ProcessCoordinationUnit::SetMainThreadTaskLoadIsLow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_thread_task_load_is_low"), in_main_thread_task_load_is_low,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessCoordinationUnit::kSetMainThreadTaskLoadIsLow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data> params(
          message);
  params.Allocate();

  params->main_thread_task_load_is_low = in_main_thread_task_load_is_low;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("SetMainThreadTaskLoadIsLow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProcessCoordinationUnitProxy::OnV8ContextCreated(
    ::performance_manager::mojom::blink::V8ContextDescriptionPtr in_description, ::performance_manager::mojom::blink::IframeAttributionDataPtr in_iframe_attribution_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("description"), in_description,
                        "<value of type ::performance_manager::mojom::blink::V8ContextDescriptionPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("iframe_attribution_data"), in_iframe_attribution_data,
                        "<value of type ::performance_manager::mojom::blink::IframeAttributionDataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessCoordinationUnit::kOnV8ContextCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_OnV8ContextCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->description)::BaseType> description_fragment(
          params.message());
  
  mojo::internal::Serialize<::performance_manager::mojom::V8ContextDescriptionDataView>(
    in_description,
    description_fragment);

  params->description.Set(
      description_fragment.is_null() ? nullptr : description_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->description.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null description in ProcessCoordinationUnit.OnV8ContextCreated request");
  mojo::internal::MessageFragment<
      typename decltype(params->iframe_attribution_data)::BaseType> iframe_attribution_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::performance_manager::mojom::IframeAttributionDataDataView>(
    in_iframe_attribution_data,
    iframe_attribution_data_fragment);

  params->iframe_attribution_data.Set(
      iframe_attribution_data_fragment.is_null() ? nullptr : iframe_attribution_data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("OnV8ContextCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProcessCoordinationUnitProxy::OnV8ContextDetached(
    const ::blink::V8ContextToken& in_v8_context_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDetached", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("v8_context_token"), in_v8_context_token,
                        "<value of type const ::blink::V8ContextToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessCoordinationUnit::kOnV8ContextDetached), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_OnV8ContextDetached_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->v8_context_token)::BaseType> v8_context_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::V8ContextTokenDataView>(
    in_v8_context_token,
    v8_context_token_fragment);

  params->v8_context_token.Set(
      v8_context_token_fragment.is_null() ? nullptr : v8_context_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->v8_context_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null v8_context_token in ProcessCoordinationUnit.OnV8ContextDetached request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("OnV8ContextDetached");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProcessCoordinationUnitProxy::OnV8ContextDestroyed(
    const ::blink::V8ContextToken& in_v8_context_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send performance_manager::mojom::ProcessCoordinationUnit::OnV8ContextDestroyed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("v8_context_token"), in_v8_context_token,
                        "<value of type const ::blink::V8ContextToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessCoordinationUnit::kOnV8ContextDestroyed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->v8_context_token)::BaseType> v8_context_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::V8ContextTokenDataView>(
    in_v8_context_token,
    v8_context_token_fragment);

  params->v8_context_token.Set(
      v8_context_token_fragment.is_null() ? nullptr : v8_context_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->v8_context_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null v8_context_token in ProcessCoordinationUnit.OnV8ContextDestroyed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("OnV8ContextDestroyed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProcessCoordinationUnitProxy::OnRemoteIframeAttached(
    const ::blink::LocalFrameToken& in_parent_frame_token, const ::blink::RemoteFrameToken& in_remote_frame_token, ::performance_manager::mojom::blink::IframeAttributionDataPtr in_iframe_attribution_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeAttached", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_frame_token"), in_parent_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_frame_token"), in_remote_frame_token,
                        "<value of type const ::blink::RemoteFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("iframe_attribution_data"), in_iframe_attribution_data,
                        "<value of type ::performance_manager::mojom::blink::IframeAttributionDataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessCoordinationUnit::kOnRemoteIframeAttached), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parent_frame_token)::BaseType> parent_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_parent_frame_token,
    parent_frame_token_fragment);

  params->parent_frame_token.Set(
      parent_frame_token_fragment.is_null() ? nullptr : parent_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parent_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parent_frame_token in ProcessCoordinationUnit.OnRemoteIframeAttached request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_frame_token)::BaseType> remote_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
    in_remote_frame_token,
    remote_frame_token_fragment);

  params->remote_frame_token.Set(
      remote_frame_token_fragment.is_null() ? nullptr : remote_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_frame_token in ProcessCoordinationUnit.OnRemoteIframeAttached request");
  mojo::internal::MessageFragment<
      typename decltype(params->iframe_attribution_data)::BaseType> iframe_attribution_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::performance_manager::mojom::IframeAttributionDataDataView>(
    in_iframe_attribution_data,
    iframe_attribution_data_fragment);

  params->iframe_attribution_data.Set(
      iframe_attribution_data_fragment.is_null() ? nullptr : iframe_attribution_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->iframe_attribution_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null iframe_attribution_data in ProcessCoordinationUnit.OnRemoteIframeAttached request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("OnRemoteIframeAttached");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProcessCoordinationUnitProxy::OnRemoteIframeDetached(
    const ::blink::LocalFrameToken& in_parent_frame_token, const ::blink::RemoteFrameToken& in_remote_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send performance_manager::mojom::ProcessCoordinationUnit::OnRemoteIframeDetached", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_frame_token"), in_parent_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_frame_token"), in_remote_frame_token,
                        "<value of type const ::blink::RemoteFrameToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessCoordinationUnit::kOnRemoteIframeDetached), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parent_frame_token)::BaseType> parent_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_parent_frame_token,
    parent_frame_token_fragment);

  params->parent_frame_token.Set(
      parent_frame_token_fragment.is_null() ? nullptr : parent_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parent_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parent_frame_token in ProcessCoordinationUnit.OnRemoteIframeDetached request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_frame_token)::BaseType> remote_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
    in_remote_frame_token,
    remote_frame_token_fragment);

  params->remote_frame_token.Set(
      remote_frame_token_fragment.is_null() ? nullptr : remote_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_frame_token in ProcessCoordinationUnit.OnRemoteIframeDetached request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("OnRemoteIframeDetached");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProcessCoordinationUnitStubDispatch::Accept(
    ProcessCoordinationUnit* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProcessCoordinationUnit>(message->header()->name)) {
    case messages::ProcessCoordinationUnit::kSetMainThreadTaskLoadIsLow: {
      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProcessCoordinationUnit.0
      bool success = true;
      bool p_main_thread_task_load_is_low{};
      ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_main_thread_task_load_is_low = input_data_view.main_thread_task_load_is_low();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMainThreadTaskLoadIsLow(        
        std::move(p_main_thread_task_load_is_low));
      return true;
    }
    case messages::ProcessCoordinationUnit::kOnV8ContextCreated: {
      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_OnV8ContextCreated_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_OnV8ContextCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProcessCoordinationUnit.1
      bool success = true;
      ::performance_manager::mojom::blink::V8ContextDescriptionPtr p_description{};
      ::performance_manager::mojom::blink::IframeAttributionDataPtr p_iframe_attribution_data{};
      ProcessCoordinationUnit_OnV8ContextCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDescription(&p_description))
        success = false;
      if (success && !input_data_view.ReadIframeAttributionData(&p_iframe_attribution_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnV8ContextCreated(        
        std::move(p_description), 
        std::move(p_iframe_attribution_data));
      return true;
    }
    case messages::ProcessCoordinationUnit::kOnV8ContextDetached: {
      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_OnV8ContextDetached_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_OnV8ContextDetached_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProcessCoordinationUnit.2
      bool success = true;
      ::blink::V8ContextToken p_v8_context_token{};
      ProcessCoordinationUnit_OnV8ContextDetached_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadV8ContextToken(&p_v8_context_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnV8ContextDetached(        
        std::move(p_v8_context_token));
      return true;
    }
    case messages::ProcessCoordinationUnit::kOnV8ContextDestroyed: {
      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProcessCoordinationUnit.3
      bool success = true;
      ::blink::V8ContextToken p_v8_context_token{};
      ProcessCoordinationUnit_OnV8ContextDestroyed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadV8ContextToken(&p_v8_context_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnV8ContextDestroyed(        
        std::move(p_v8_context_token));
      return true;
    }
    case messages::ProcessCoordinationUnit::kOnRemoteIframeAttached: {
      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProcessCoordinationUnit.4
      bool success = true;
      ::blink::LocalFrameToken p_parent_frame_token{};
      ::blink::RemoteFrameToken p_remote_frame_token{};
      ::performance_manager::mojom::blink::IframeAttributionDataPtr p_iframe_attribution_data{};
      ProcessCoordinationUnit_OnRemoteIframeAttached_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParentFrameToken(&p_parent_frame_token))
        success = false;
      if (success && !input_data_view.ReadRemoteFrameToken(&p_remote_frame_token))
        success = false;
      if (success && !input_data_view.ReadIframeAttributionData(&p_iframe_attribution_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRemoteIframeAttached(        
        std::move(p_parent_frame_token), 
        std::move(p_remote_frame_token), 
        std::move(p_iframe_attribution_data));
      return true;
    }
    case messages::ProcessCoordinationUnit::kOnRemoteIframeDetached: {
      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProcessCoordinationUnit.5
      bool success = true;
      ::blink::LocalFrameToken p_parent_frame_token{};
      ::blink::RemoteFrameToken p_remote_frame_token{};
      ProcessCoordinationUnit_OnRemoteIframeDetached_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParentFrameToken(&p_parent_frame_token))
        success = false;
      if (success && !input_data_view.ReadRemoteFrameToken(&p_remote_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRemoteIframeDetached(        
        std::move(p_parent_frame_token), 
        std::move(p_remote_frame_token));
      return true;
    }
  }
  return false;
}

// static
bool ProcessCoordinationUnitStubDispatch::AcceptWithResponder(
    ProcessCoordinationUnit* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProcessCoordinationUnit>(message->header()->name)) {
    case messages::ProcessCoordinationUnit::kSetMainThreadTaskLoadIsLow: {
      break;
    }
    case messages::ProcessCoordinationUnit::kOnV8ContextCreated: {
      break;
    }
    case messages::ProcessCoordinationUnit::kOnV8ContextDetached: {
      break;
    }
    case messages::ProcessCoordinationUnit::kOnV8ContextDestroyed: {
      break;
    }
    case messages::ProcessCoordinationUnit::kOnRemoteIframeAttached: {
      break;
    }
    case messages::ProcessCoordinationUnit::kOnRemoteIframeDetached: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProcessCoordinationUnitValidationInfo[] = {
    {base::to_underlying(messages::ProcessCoordinationUnit::kSetMainThreadTaskLoadIsLow),
     { &internal::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ProcessCoordinationUnit::kOnV8ContextCreated),
     { &internal::ProcessCoordinationUnit_OnV8ContextCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ProcessCoordinationUnit::kOnV8ContextDetached),
     { &internal::ProcessCoordinationUnit_OnV8ContextDetached_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ProcessCoordinationUnit::kOnV8ContextDestroyed),
     { &internal::ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ProcessCoordinationUnit::kOnRemoteIframeAttached),
     { &internal::ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ProcessCoordinationUnit::kOnRemoteIframeDetached),
     { &internal::ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProcessCoordinationUnitRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::performance_manager::mojom::blink::ProcessCoordinationUnit::Name_,
    kProcessCoordinationUnitValidationInfo);
}

// The declaration includes the definition on other builds.

ChildProcessCoordinationUnit::IPCStableHashFunction ChildProcessCoordinationUnit::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ChildProcessCoordinationUnit>(message.name())) {
    case messages::ChildProcessCoordinationUnit::kInitializeChildProcessCoordination: {
      return &ChildProcessCoordinationUnit::InitializeChildProcessCoordination_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ChildProcessCoordinationUnit::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ChildProcessCoordinationUnit>(message.name())) {
      case messages::ChildProcessCoordinationUnit::kInitializeChildProcessCoordination:
            return "Receive performance_manager::mojom::ChildProcessCoordinationUnit::InitializeChildProcessCoordination";
    }
  } else {
    switch (static_cast<messages::ChildProcessCoordinationUnit>(message.name())) {
      case messages::ChildProcessCoordinationUnit::kInitializeChildProcessCoordination:
            return "Receive reply performance_manager::mojom::ChildProcessCoordinationUnit::InitializeChildProcessCoordination";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ChildProcessCoordinationUnit::InitializeChildProcessCoordination_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x78f38f87;  // IPCStableHash for performance_manager::mojom::ChildProcessCoordinationUnit::InitializeChildProcessCoordination
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ForwardToCallback(
      ChildProcessCoordinationUnit::InitializeChildProcessCoordinationCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ForwardToCallback(const ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ForwardToCallback&) = delete;
  ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ForwardToCallback& operator=(const ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChildProcessCoordinationUnit::InitializeChildProcessCoordinationCallback callback_;
};

ChildProcessCoordinationUnitProxy::ChildProcessCoordinationUnitProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChildProcessCoordinationUnitProxy::InitializeChildProcessCoordination(
    uint64_t in_process_track_id, InitializeChildProcessCoordinationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send performance_manager::mojom::ChildProcessCoordinationUnit::InitializeChildProcessCoordination", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_track_id"), in_process_track_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcessCoordinationUnit::kInitializeChildProcessCoordination), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ChildProcessCoordinationUnit_InitializeChildProcessCoordination_Params_Data> params(
          message);
  params.Allocate();

  params->process_track_id = in_process_track_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcessCoordinationUnit::Name_);
  message.set_method_name("InitializeChildProcessCoordination");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChildProcessCoordinationUnit::InitializeChildProcessCoordinationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ProxyToResponder> proxy(
        new ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ChildProcessCoordinationUnit::InitializeChildProcessCoordinationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::ReadOnlySharedMemoryRegion in_global_region, ::base::ReadOnlySharedMemoryRegion in_process_region);
};

bool ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ChildProcessCoordinationUnit.0
  bool success = true;
  ::base::ReadOnlySharedMemoryRegion p_global_region{};
  ::base::ReadOnlySharedMemoryRegion p_process_region{};
  ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadGlobalRegion(&p_global_region))
    success = false;
  if (success && !input_data_view.ReadProcessRegion(&p_process_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChildProcessCoordinationUnit::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_global_region), 
std::move(p_process_region));
  }
  return true;
}

void ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ProxyToResponder::Run(
    ::base::ReadOnlySharedMemoryRegion in_global_region, ::base::ReadOnlySharedMemoryRegion in_process_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply performance_manager::mojom::ChildProcessCoordinationUnit::InitializeChildProcessCoordination", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("global_region"), in_global_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_region"), in_process_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcessCoordinationUnit::kInitializeChildProcessCoordination), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::performance_manager::mojom::internal::ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->global_region)::BaseType> global_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_global_region,
    global_region_fragment);

  params->global_region.Set(
      global_region_fragment.is_null() ? nullptr : global_region_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->process_region)::BaseType> process_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_process_region,
    process_region_fragment);

  params->process_region.Set(
      process_region_fragment.is_null() ? nullptr : process_region_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcessCoordinationUnit::Name_);
  message.set_method_name("InitializeChildProcessCoordination");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ChildProcessCoordinationUnitStubDispatch::Accept(
    ChildProcessCoordinationUnit* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ChildProcessCoordinationUnit>(message->header()->name)) {
    case messages::ChildProcessCoordinationUnit::kInitializeChildProcessCoordination: {
      break;
    }
  }
  return false;
}

// static
bool ChildProcessCoordinationUnitStubDispatch::AcceptWithResponder(
    ChildProcessCoordinationUnit* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ChildProcessCoordinationUnit>(message->header()->name)) {
    case messages::ChildProcessCoordinationUnit::kInitializeChildProcessCoordination: {
      internal::ChildProcessCoordinationUnit_InitializeChildProcessCoordination_Params_Data* params =
          reinterpret_cast<
              internal::ChildProcessCoordinationUnit_InitializeChildProcessCoordination_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ChildProcessCoordinationUnit.0
      bool success = true;
      uint64_t p_process_track_id{};
      ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_track_id = input_data_view.process_track_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcessCoordinationUnit::Name_, 0, false);
        return false;
      }
      auto callback =
          ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeChildProcessCoordination(        
        std::move(p_process_track_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kChildProcessCoordinationUnitValidationInfo[] = {
    {base::to_underlying(messages::ChildProcessCoordinationUnit::kInitializeChildProcessCoordination),
     { &internal::ChildProcessCoordinationUnit_InitializeChildProcessCoordination_Params_Data::Validate,
      &internal::ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ResponseParams_Data::Validate}},
};

bool ChildProcessCoordinationUnitRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::performance_manager::mojom::blink::ChildProcessCoordinationUnit::Name_,
    kChildProcessCoordinationUnitValidationInfo);
}

bool ChildProcessCoordinationUnitResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::performance_manager::mojom::blink::ChildProcessCoordinationUnit::Name_,
    kChildProcessCoordinationUnitValidationInfo);

}


}  // performance_manager::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace performance_manager::mojom::blink {


void DocumentCoordinationUnitInterceptorForTesting::SetNetworkAlmostIdle() {
  GetForwardingInterface()->SetNetworkAlmostIdle();
}
void DocumentCoordinationUnitInterceptorForTesting::SetLifecycleState(::performance_manager::mojom::blink::LifecycleState state) {
  GetForwardingInterface()->SetLifecycleState(
    std::move(state)
    );
}
void DocumentCoordinationUnitInterceptorForTesting::SetHasNonEmptyBeforeUnload(bool has_nonempty_beforeunload) {
  GetForwardingInterface()->SetHasNonEmptyBeforeUnload(
    std::move(has_nonempty_beforeunload)
    );
}
void DocumentCoordinationUnitInterceptorForTesting::SetHadFormInteraction() {
  GetForwardingInterface()->SetHadFormInteraction();
}
void DocumentCoordinationUnitInterceptorForTesting::SetHadUserEdits() {
  GetForwardingInterface()->SetHadUserEdits();
}
void DocumentCoordinationUnitInterceptorForTesting::OnStartedUsingWebRTC() {
  GetForwardingInterface()->OnStartedUsingWebRTC();
}
void DocumentCoordinationUnitInterceptorForTesting::OnStoppedUsingWebRTC() {
  GetForwardingInterface()->OnStoppedUsingWebRTC();
}
void DocumentCoordinationUnitInterceptorForTesting::SetIsAdFrame(bool is_ad_frame) {
  GetForwardingInterface()->SetIsAdFrame(
    std::move(is_ad_frame)
    );
}
void DocumentCoordinationUnitInterceptorForTesting::OnNonPersistentNotificationCreated() {
  GetForwardingInterface()->OnNonPersistentNotificationCreated();
}
void DocumentCoordinationUnitInterceptorForTesting::OnFirstContentfulPaint(::base::TimeDelta time_since_navigation_start) {
  GetForwardingInterface()->OnFirstContentfulPaint(
    std::move(time_since_navigation_start)
    );
}
void DocumentCoordinationUnitInterceptorForTesting::OnWebMemoryMeasurementRequested(::performance_manager::mojom::blink::WebMemoryMeasurement::Mode mode, OnWebMemoryMeasurementRequestedCallback callback) {
  GetForwardingInterface()->OnWebMemoryMeasurementRequested(
    std::move(mode)
    , std::move(callback));
}
void DocumentCoordinationUnitInterceptorForTesting::OnFreezingOriginTrialOptOut() {
  GetForwardingInterface()->OnFreezingOriginTrialOptOut();
}
DocumentCoordinationUnitAsyncWaiter::DocumentCoordinationUnitAsyncWaiter(
    DocumentCoordinationUnit* proxy) : proxy_(proxy) {}

DocumentCoordinationUnitAsyncWaiter::~DocumentCoordinationUnitAsyncWaiter() = default;


void DocumentCoordinationUnitAsyncWaiter::OnWebMemoryMeasurementRequested(
    ::performance_manager::mojom::blink::WebMemoryMeasurement::Mode mode, ::performance_manager::mojom::blink::WebMemoryMeasurementPtr* out_measurement) {
  base::RunLoop loop;
  proxy_->OnWebMemoryMeasurementRequested(
      std::move(mode),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::performance_manager::mojom::blink::WebMemoryMeasurementPtr* out_measurement
,
             ::performance_manager::mojom::blink::WebMemoryMeasurementPtr measurement) {*out_measurement = std::move(measurement);
            loop->Quit();
          },
          &loop,
          out_measurement));
  loop.Run();
}

::performance_manager::mojom::blink::WebMemoryMeasurementPtr DocumentCoordinationUnitAsyncWaiter::OnWebMemoryMeasurementRequested(
    ::performance_manager::mojom::blink::WebMemoryMeasurement::Mode mode) {
  ::performance_manager::mojom::blink::WebMemoryMeasurementPtr async_wait_result;
  OnWebMemoryMeasurementRequested(std::move(mode),&async_wait_result);
  return async_wait_result;
}




void ProcessCoordinationUnitInterceptorForTesting::SetMainThreadTaskLoadIsLow(bool main_thread_task_load_is_low) {
  GetForwardingInterface()->SetMainThreadTaskLoadIsLow(
    std::move(main_thread_task_load_is_low)
    );
}
void ProcessCoordinationUnitInterceptorForTesting::OnV8ContextCreated(::performance_manager::mojom::blink::V8ContextDescriptionPtr description, ::performance_manager::mojom::blink::IframeAttributionDataPtr iframe_attribution_data) {
  GetForwardingInterface()->OnV8ContextCreated(
    std::move(description)
    , 
    std::move(iframe_attribution_data)
    );
}
void ProcessCoordinationUnitInterceptorForTesting::OnV8ContextDetached(const ::blink::V8ContextToken& v8_context_token) {
  GetForwardingInterface()->OnV8ContextDetached(
    std::move(v8_context_token)
    );
}
void ProcessCoordinationUnitInterceptorForTesting::OnV8ContextDestroyed(const ::blink::V8ContextToken& v8_context_token) {
  GetForwardingInterface()->OnV8ContextDestroyed(
    std::move(v8_context_token)
    );
}
void ProcessCoordinationUnitInterceptorForTesting::OnRemoteIframeAttached(const ::blink::LocalFrameToken& parent_frame_token, const ::blink::RemoteFrameToken& remote_frame_token, ::performance_manager::mojom::blink::IframeAttributionDataPtr iframe_attribution_data) {
  GetForwardingInterface()->OnRemoteIframeAttached(
    std::move(parent_frame_token)
    , 
    std::move(remote_frame_token)
    , 
    std::move(iframe_attribution_data)
    );
}
void ProcessCoordinationUnitInterceptorForTesting::OnRemoteIframeDetached(const ::blink::LocalFrameToken& parent_frame_token, const ::blink::RemoteFrameToken& remote_frame_token) {
  GetForwardingInterface()->OnRemoteIframeDetached(
    std::move(parent_frame_token)
    , 
    std::move(remote_frame_token)
    );
}
ProcessCoordinationUnitAsyncWaiter::ProcessCoordinationUnitAsyncWaiter(
    ProcessCoordinationUnit* proxy) : proxy_(proxy) {}

ProcessCoordinationUnitAsyncWaiter::~ProcessCoordinationUnitAsyncWaiter() = default;





void ChildProcessCoordinationUnitInterceptorForTesting::InitializeChildProcessCoordination(uint64_t process_track_id, InitializeChildProcessCoordinationCallback callback) {
  GetForwardingInterface()->InitializeChildProcessCoordination(
    std::move(process_track_id)
    , std::move(callback));
}
ChildProcessCoordinationUnitAsyncWaiter::ChildProcessCoordinationUnitAsyncWaiter(
    ChildProcessCoordinationUnit* proxy) : proxy_(proxy) {}

ChildProcessCoordinationUnitAsyncWaiter::~ChildProcessCoordinationUnitAsyncWaiter() = default;


void ChildProcessCoordinationUnitAsyncWaiter::InitializeChildProcessCoordination(
    uint64_t process_track_id, ::base::ReadOnlySharedMemoryRegion* out_global_region, ::base::ReadOnlySharedMemoryRegion* out_process_region) {
  base::RunLoop loop;
  proxy_->InitializeChildProcessCoordination(
      std::move(process_track_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::ReadOnlySharedMemoryRegion* out_global_region
,
             ::base::ReadOnlySharedMemoryRegion* out_process_region
,
             ::base::ReadOnlySharedMemoryRegion global_region,
             ::base::ReadOnlySharedMemoryRegion process_region) {*out_global_region = std::move(global_region);*out_process_region = std::move(process_region);
            loop->Quit();
          },
          &loop,
          out_global_region,
          out_process_region));
  loop.Run();
}








}  // performance_manager::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif