// cc/mojom/layer_type.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "cc/mojom/layer_type.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "cc/mojom/layer_type.mojom-params-data.h"
namespace cc {
namespace mojom {

NOINLINE static const char* LayerTypeToStringHelper(LayerType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LayerType::kLayer:
      return "kLayer";
    case LayerType::kSolidColor:
      return "kSolidColor";
    case LayerType::kTexture:
      return "kTexture";
    case LayerType::kSurface:
      return "kSurface";
    case LayerType::kPicture:
      return "kPicture";
    case LayerType::kTileDisplay:
      return "kTileDisplay";
    case LayerType::kMirror:
      return "kMirror";
    case LayerType::kHeadsUpDisplay:
      return "kHeadsUpDisplay";
    case LayerType::kUIResource:
      return "kUIResource";
    case LayerType::kNinePatch:
      return "kNinePatch";
    case LayerType::kSolidColorScrollbar:
      return "kSolidColorScrollbar";
    case LayerType::kPaintedScrollbar:
      return "kPaintedScrollbar";
    case LayerType::kNinePatchThumbScrollbar:
      return "kNinePatchThumbScrollbar";
    case LayerType::kVideo:
      return "kVideo";
    case LayerType::kViewTransitionContent:
      return "kViewTransitionContent";
    default:
      return nullptr;
  }
}

std::string LayerTypeToString(LayerType value) {
  const char *str = LayerTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LayerType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LayerType value) {
  return os << LayerTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace cc

namespace perfetto {

// static
void TraceFormatTraits<::cc::mojom::LayerType>::WriteIntoTrace(
   perfetto::TracedValue context, ::cc::mojom::LayerType value) {
  return std::move(context).WriteString(::cc::mojom::LayerTypeToString(value));
}

} // namespace perfetto