// ui/gfx/range/mojom/range.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_RANGE_MOJOM_RANGE_MOJOM_SHARED_H_
#define UI_GFX_RANGE_MOJOM_RANGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/range/mojom/range.mojom-shared-internal.h"







namespace gfx::mojom {
class RangeDataView;

class RangeFDataView;



}  // gfx::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::RangeDataView> {
  using Data = ::gfx::mojom::internal::Range_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::RangeFDataView> {
  using Data = ::gfx::mojom::internal::RangeF_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


class RangeDataView {
 public:
  RangeDataView() = default;

  RangeDataView(
      internal::Range_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t start() const {
    return data_->start;
  }
  uint32_t end() const {
    return data_->end;
  }
 private:
  internal::Range_Data* data_ = nullptr;
};


class RangeFDataView {
 public:
  RangeFDataView() = default;

  RangeFDataView(
      internal::RangeF_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float start() const {
    return data_->start;
  }
  float end() const {
    return data_->end;
  }
 private:
  internal::RangeF_Data* data_ = nullptr;
};


}  // gfx::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::RangeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::RangeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::Range_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->start = Traits::start(input);
    fragment->end = Traits::end(input);
  }

  static bool Deserialize(::gfx::mojom::internal::Range_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::RangeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::RangeFDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::RangeFDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::RangeF_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->start = Traits::start(input);
    fragment->end = Traits::end(input);
  }

  static bool Deserialize(::gfx::mojom::internal::RangeF_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::RangeFDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {






}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_RANGE_MOJOM_RANGE_MOJOM_SHARED_H_