// ui/gfx/mojom/native_handle_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/gfx/mojom/native_handle_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/native_handle_types.mojom-params-data.h"
namespace gfx {
namespace mojom {

namespace internal {
// static
bool GpuMemoryBufferPlatformHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GpuMemoryBufferPlatformHandle_Data* object = static_cast<const GpuMemoryBufferPlatformHandle_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GpuMemoryBufferPlatformHandle_Tag::kSharedMemoryHandle: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_memory_handle, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_memory_handle, validation_context))
        return false;
      return true;
    }
    case GpuMemoryBufferPlatformHandle_Tag::kNativePixmapHandle: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_native_pixmap_handle, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_native_pixmap_handle, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GpuMemoryBufferPlatformHandle");
      return false;
    }
  }
}


// static
bool NativePixmapPlane_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativePixmapPlane_Data* object =
      static_cast<const NativePixmapPlane_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->buffer_handle, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->buffer_handle,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NativePixmapPlane_Data::NativePixmapPlane_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativePixmapHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativePixmapHandle_Data* object =
      static_cast<const NativePixmapHandle_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->planes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& planes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->planes, validation_context,
                                         &planes_validate_params)) {
    return false;
  }

  return true;
}

NativePixmapHandle_Data::NativePixmapHandle_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gfx