// third_party/blink/public/mojom/usb/web_usb_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_USB_WEB_USB_SERVICE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_USB_WEB_USB_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-shared-internal.h"
#include "services/device/public/mojom/usb_device.mojom-shared.h"
#include "services/device/public/mojom/usb_enumeration_options.mojom-shared.h"
#include "services/device/public/mojom/usb_manager_client.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class WebUsbRequestDeviceOptionsDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::WebUsbRequestDeviceOptionsDataView> {
  using Data = ::blink::mojom::internal::WebUsbRequestDeviceOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class WebUsbServiceInterfaceBase {};

using WebUsbServicePtrDataView =
    mojo::InterfacePtrDataView<WebUsbServiceInterfaceBase>;
using WebUsbServiceRequestDataView =
    mojo::InterfaceRequestDataView<WebUsbServiceInterfaceBase>;
using WebUsbServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebUsbServiceInterfaceBase>;
using WebUsbServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebUsbServiceInterfaceBase>;


class WebUsbRequestDeviceOptionsDataView {
 public:
  WebUsbRequestDeviceOptionsDataView() = default;

  WebUsbRequestDeviceOptionsDataView(
      internal::WebUsbRequestDeviceOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFiltersDataView(
      mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>>(
        pointer, output, message_);
  }
  inline void GetExclusionFiltersDataView(
      mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExclusionFilters(UserType* output) {
    
    auto* pointer = data_->exclusion_filters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>>(
        pointer, output, message_);
  }
 private:
  internal::WebUsbRequestDeviceOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebUsbRequestDeviceOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebUsbRequestDeviceOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebUsbRequestDeviceOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::filters(input)) in_filters = Traits::filters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filters)::BaseType>
        filters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& filters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>>(
        in_filters, filters_fragment, &filters_validate_params);
    fragment->filters.Set(
        filters_fragment.is_null() ? nullptr : filters_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->filters.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filters in WebUsbRequestDeviceOptions struct");
    decltype(Traits::exclusion_filters(input)) in_exclusion_filters = Traits::exclusion_filters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->exclusion_filters)::BaseType>
        exclusion_filters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& exclusion_filters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>>(
        in_exclusion_filters, exclusion_filters_fragment, &exclusion_filters_validate_params);
    fragment->exclusion_filters.Set(
        exclusion_filters_fragment.is_null() ? nullptr : exclusion_filters_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->exclusion_filters.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null exclusion_filters in WebUsbRequestDeviceOptions struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebUsbRequestDeviceOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebUsbRequestDeviceOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void WebUsbRequestDeviceOptionsDataView::GetFiltersDataView(
    mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>* output) {
  auto pointer = data_->filters.Get();
  *output = mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>(pointer, message_);
}
inline void WebUsbRequestDeviceOptionsDataView::GetExclusionFiltersDataView(
    mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>* output) {
  auto pointer = data_->exclusion_filters.Get();
  *output = mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_USB_WEB_USB_SERVICE_MOJOM_SHARED_H_