// third_party/blink/public/mojom/serial/serial.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERIAL_SERIAL_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERIAL_SERIAL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/serial/serial.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/serial/serial.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/serial/serial.mojom-forward.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/uuid.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/device/public/mojom/serial.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class SerialServiceProxy;

template <typename ImplRefTraits>
class SerialServiceStub;

class SerialServiceRequestValidator;
class SerialServiceResponseValidator;


class BLINK_COMMON_EXPORT SerialService
    : public SerialServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SerialServiceInterfaceBase;
  using Proxy_ = SerialServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SerialServiceStub<ImplRefTraits>;

  using RequestValidator_ = SerialServiceRequestValidator;
  using ResponseValidator_ = SerialServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kGetPortsMinVersion = 0,
    kRequestPortMinVersion = 0,
    kOpenPortMinVersion = 0,
    kForgetPortMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPorts_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestPort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenPort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForgetPort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SerialService() = default;

  
  virtual void SetClient(::mojo::PendingRemote<SerialServiceClient> client) = 0;


  using GetPortsCallback = base::OnceCallback<void(std::vector<SerialPortInfoPtr>)>;
  
  virtual void GetPorts(GetPortsCallback callback) = 0;


  using RequestPortCallback = base::OnceCallback<void(SerialPortInfoPtr)>;
  
  virtual void RequestPort(std::vector<SerialPortFilterPtr> filters, const std::vector<::device::BluetoothUUID>& allowed_bluetooth_service_class_ids, RequestPortCallback callback) = 0;


  using OpenPortCallback = base::OnceCallback<void(::mojo::PendingRemote<::device::mojom::SerialPort>)>;
  
  virtual void OpenPort(const ::base::UnguessableToken& token, ::device::mojom::SerialConnectionOptionsPtr options, ::mojo::PendingRemote<::device::mojom::SerialPortClient> client, OpenPortCallback callback) = 0;


  using ForgetPortCallback = base::OnceCallback<void()>;
  
  virtual void ForgetPort(const ::base::UnguessableToken& token, ForgetPortCallback callback) = 0;
};

class SerialServiceClientProxy;

template <typename ImplRefTraits>
class SerialServiceClientStub;

class SerialServiceClientRequestValidator;


class BLINK_COMMON_EXPORT SerialServiceClient
    : public SerialServiceClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SerialServiceClientInterfaceBase;
  using Proxy_ = SerialServiceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SerialServiceClientStub<ImplRefTraits>;

  using RequestValidator_ = SerialServiceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnPortConnectedStateChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnPortConnectedStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SerialServiceClient() = default;

  
  virtual void OnPortConnectedStateChanged(SerialPortInfoPtr port_info) = 0;
};



class BLINK_COMMON_EXPORT SerialServiceProxy
    : public SerialService {
 public:
  using InterfaceType = SerialService;

  explicit SerialServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingRemote<SerialServiceClient> client) final;
  
  void GetPorts(GetPortsCallback callback) final;
  
  void RequestPort(std::vector<SerialPortFilterPtr> filters, const std::vector<::device::BluetoothUUID>& allowed_bluetooth_service_class_ids, RequestPortCallback callback) final;
  
  void OpenPort(const ::base::UnguessableToken& token, ::device::mojom::SerialConnectionOptionsPtr options, ::mojo::PendingRemote<::device::mojom::SerialPortClient> client, OpenPortCallback callback) final;
  
  void ForgetPort(const ::base::UnguessableToken& token, ForgetPortCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT SerialServiceClientProxy
    : public SerialServiceClient {
 public:
  using InterfaceType = SerialServiceClient;

  explicit SerialServiceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPortConnectedStateChanged(SerialPortInfoPtr port_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT SerialServiceStubDispatch {
 public:
  static bool Accept(SerialService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SerialService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SerialService>>
class SerialServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SerialServiceStub() = default;
  ~SerialServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SerialServiceClientStubDispatch {
 public:
  static bool Accept(SerialServiceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SerialServiceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SerialServiceClient>>
class SerialServiceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SerialServiceClientStub() = default;
  ~SerialServiceClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialServiceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialServiceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SerialServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT SerialServiceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT SerialServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_COMMON_EXPORT SerialPortInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerialPortInfo, T>::value>;
  using DataView = SerialPortInfoDataView;
  using Data_ = internal::SerialPortInfo_Data;

  template <typename... Args>
  static SerialPortInfoPtr New(Args&&... args) {
    return SerialPortInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerialPortInfoPtr From(const U& u) {
    return mojo::TypeConverter<SerialPortInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerialPortInfo>::Convert(*this);
  }


  SerialPortInfo();

  SerialPortInfo(
      const ::base::UnguessableToken& token,
      uint16_t usb_vendor_id,
      bool has_usb_vendor_id,
      uint16_t usb_product_id,
      bool has_usb_product_id,
      const std::optional<::device::BluetoothUUID>& bluetooth_service_class_id,
      bool connected);


  ~SerialPortInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerialPortInfoPtr>
  SerialPortInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerialPortInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerialPortInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerialPortInfo_UnserializedMessageContext<
            UserType, SerialPortInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerialPortInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerialPortInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerialPortInfo_UnserializedMessageContext<
            UserType, SerialPortInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerialPortInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken token;
  
  uint16_t usb_vendor_id;
  
  bool has_usb_vendor_id;
  
  uint16_t usb_product_id;
  
  bool has_usb_product_id;
  
  std::optional<::device::BluetoothUUID> bluetooth_service_class_id;
  
  bool connected;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT SerialPortFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerialPortFilter, T>::value>;
  using DataView = SerialPortFilterDataView;
  using Data_ = internal::SerialPortFilter_Data;

  template <typename... Args>
  static SerialPortFilterPtr New(Args&&... args) {
    return SerialPortFilterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerialPortFilterPtr From(const U& u) {
    return mojo::TypeConverter<SerialPortFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerialPortFilter>::Convert(*this);
  }


  SerialPortFilter();

  SerialPortFilter(
      uint32_t vendor_id,
      bool has_vendor_id,
      uint16_t product_id,
      bool has_product_id,
      const std::optional<::device::BluetoothUUID>& bluetooth_service_class_id);


  ~SerialPortFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerialPortFilterPtr>
  SerialPortFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerialPortFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerialPortFilter::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerialPortFilter::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerialPortFilter::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerialPortFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerialPortFilter_UnserializedMessageContext<
            UserType, SerialPortFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerialPortFilter::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerialPortFilter::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerialPortFilter_UnserializedMessageContext<
            UserType, SerialPortFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerialPortFilter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t vendor_id;
  
  bool has_vendor_id;
  
  uint16_t product_id;
  
  bool has_product_id;
  
  std::optional<::device::BluetoothUUID> bluetooth_service_class_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerialPortFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerialPortFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerialPortFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerialPortFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SerialPortInfoPtr SerialPortInfo::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(usb_vendor_id),
      mojo::Clone(has_usb_vendor_id),
      mojo::Clone(usb_product_id),
      mojo::Clone(has_usb_product_id),
      mojo::Clone(bluetooth_service_class_id),
      mojo::Clone(connected)
  );
}

template <typename T, SerialPortInfo::EnableIfSame<T>*>
bool SerialPortInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->usb_vendor_id, other_struct.usb_vendor_id))
    return false;
  if (!mojo::Equals(this->has_usb_vendor_id, other_struct.has_usb_vendor_id))
    return false;
  if (!mojo::Equals(this->usb_product_id, other_struct.usb_product_id))
    return false;
  if (!mojo::Equals(this->has_usb_product_id, other_struct.has_usb_product_id))
    return false;
  if (!mojo::Equals(this->bluetooth_service_class_id, other_struct.bluetooth_service_class_id))
    return false;
  if (!mojo::Equals(this->connected, other_struct.connected))
    return false;
  return true;
}

template <typename T, SerialPortInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.usb_vendor_id < rhs.usb_vendor_id)
    return true;
  if (rhs.usb_vendor_id < lhs.usb_vendor_id)
    return false;
  if (lhs.has_usb_vendor_id < rhs.has_usb_vendor_id)
    return true;
  if (rhs.has_usb_vendor_id < lhs.has_usb_vendor_id)
    return false;
  if (lhs.usb_product_id < rhs.usb_product_id)
    return true;
  if (rhs.usb_product_id < lhs.usb_product_id)
    return false;
  if (lhs.has_usb_product_id < rhs.has_usb_product_id)
    return true;
  if (rhs.has_usb_product_id < lhs.has_usb_product_id)
    return false;
  if (lhs.bluetooth_service_class_id < rhs.bluetooth_service_class_id)
    return true;
  if (rhs.bluetooth_service_class_id < lhs.bluetooth_service_class_id)
    return false;
  if (lhs.connected < rhs.connected)
    return true;
  if (rhs.connected < lhs.connected)
    return false;
  return false;
}
template <typename StructPtrType>
SerialPortFilterPtr SerialPortFilter::Clone() const {
  return New(
      mojo::Clone(vendor_id),
      mojo::Clone(has_vendor_id),
      mojo::Clone(product_id),
      mojo::Clone(has_product_id),
      mojo::Clone(bluetooth_service_class_id)
  );
}

template <typename T, SerialPortFilter::EnableIfSame<T>*>
bool SerialPortFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->vendor_id, other_struct.vendor_id))
    return false;
  if (!mojo::Equals(this->has_vendor_id, other_struct.has_vendor_id))
    return false;
  if (!mojo::Equals(this->product_id, other_struct.product_id))
    return false;
  if (!mojo::Equals(this->has_product_id, other_struct.has_product_id))
    return false;
  if (!mojo::Equals(this->bluetooth_service_class_id, other_struct.bluetooth_service_class_id))
    return false;
  return true;
}

template <typename T, SerialPortFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.vendor_id < rhs.vendor_id)
    return true;
  if (rhs.vendor_id < lhs.vendor_id)
    return false;
  if (lhs.has_vendor_id < rhs.has_vendor_id)
    return true;
  if (rhs.has_vendor_id < lhs.has_vendor_id)
    return false;
  if (lhs.product_id < rhs.product_id)
    return true;
  if (rhs.product_id < lhs.product_id)
    return false;
  if (lhs.has_product_id < rhs.has_product_id)
    return true;
  if (rhs.has_product_id < lhs.has_product_id)
    return false;
  if (lhs.bluetooth_service_class_id < rhs.bluetooth_service_class_id)
    return true;
  if (rhs.bluetooth_service_class_id < lhs.bluetooth_service_class_id)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SerialPortInfo::DataView,
                                         ::blink::mojom::SerialPortInfoPtr> {
  static bool IsNull(const ::blink::mojom::SerialPortInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SerialPortInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SerialPortInfo::token)& token(
      const ::blink::mojom::SerialPortInfoPtr& input) {
    return input->token;
  }

  static decltype(::blink::mojom::SerialPortInfo::usb_vendor_id) usb_vendor_id(
      const ::blink::mojom::SerialPortInfoPtr& input) {
    return input->usb_vendor_id;
  }

  static decltype(::blink::mojom::SerialPortInfo::has_usb_vendor_id) has_usb_vendor_id(
      const ::blink::mojom::SerialPortInfoPtr& input) {
    return input->has_usb_vendor_id;
  }

  static decltype(::blink::mojom::SerialPortInfo::usb_product_id) usb_product_id(
      const ::blink::mojom::SerialPortInfoPtr& input) {
    return input->usb_product_id;
  }

  static decltype(::blink::mojom::SerialPortInfo::has_usb_product_id) has_usb_product_id(
      const ::blink::mojom::SerialPortInfoPtr& input) {
    return input->has_usb_product_id;
  }

  static const decltype(::blink::mojom::SerialPortInfo::bluetooth_service_class_id)& bluetooth_service_class_id(
      const ::blink::mojom::SerialPortInfoPtr& input) {
    return input->bluetooth_service_class_id;
  }

  static decltype(::blink::mojom::SerialPortInfo::connected) connected(
      const ::blink::mojom::SerialPortInfoPtr& input) {
    return input->connected;
  }

  static bool Read(::blink::mojom::SerialPortInfo::DataView input, ::blink::mojom::SerialPortInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SerialPortFilter::DataView,
                                         ::blink::mojom::SerialPortFilterPtr> {
  static bool IsNull(const ::blink::mojom::SerialPortFilterPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SerialPortFilterPtr* output) { output->reset(); }

  static decltype(::blink::mojom::SerialPortFilter::vendor_id) vendor_id(
      const ::blink::mojom::SerialPortFilterPtr& input) {
    return input->vendor_id;
  }

  static decltype(::blink::mojom::SerialPortFilter::has_vendor_id) has_vendor_id(
      const ::blink::mojom::SerialPortFilterPtr& input) {
    return input->has_vendor_id;
  }

  static decltype(::blink::mojom::SerialPortFilter::product_id) product_id(
      const ::blink::mojom::SerialPortFilterPtr& input) {
    return input->product_id;
  }

  static decltype(::blink::mojom::SerialPortFilter::has_product_id) has_product_id(
      const ::blink::mojom::SerialPortFilterPtr& input) {
    return input->has_product_id;
  }

  static const decltype(::blink::mojom::SerialPortFilter::bluetooth_service_class_id)& bluetooth_service_class_id(
      const ::blink::mojom::SerialPortFilterPtr& input) {
    return input->bluetooth_service_class_id;
  }

  static bool Read(::blink::mojom::SerialPortFilter::DataView input, ::blink::mojom::SerialPortFilterPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERIAL_SERIAL_MOJOM_H_