// third_party/blink/public/mojom/permissions/permission.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/permissions/permission.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class MidiPermissionDescriptorDataView;

class ClipboardPermissionDescriptorDataView;

class CameraDevicePermissionDescriptorDataView;

class TopLevelStorageAccessPermissionDescriptorDataView;

class FullscreenPermissionDescriptorDataView;

class PermissionDescriptorDataView;

class EmbeddedPermissionRequestDescriptorDataView;

class PermissionDescriptorExtensionDataView;


}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::MidiPermissionDescriptorDataView> {
  using Data = ::blink::mojom::internal::MidiPermissionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ClipboardPermissionDescriptorDataView> {
  using Data = ::blink::mojom::internal::ClipboardPermissionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CameraDevicePermissionDescriptorDataView> {
  using Data = ::blink::mojom::internal::CameraDevicePermissionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView> {
  using Data = ::blink::mojom::internal::TopLevelStorageAccessPermissionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FullscreenPermissionDescriptorDataView> {
  using Data = ::blink::mojom::internal::FullscreenPermissionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PermissionDescriptorDataView> {
  using Data = ::blink::mojom::internal::PermissionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::EmbeddedPermissionRequestDescriptorDataView> {
  using Data = ::blink::mojom::internal::EmbeddedPermissionRequestDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PermissionDescriptorExtensionDataView> {
  using Data = ::blink::mojom::internal::PermissionDescriptorExtension_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class PermissionName : int32_t {
  
  GEOLOCATION = 0,
  
  NOTIFICATIONS = 1,
  
  MIDI = 2,
  
  PROTECTED_MEDIA_IDENTIFIER = 3,
  
  DURABLE_STORAGE = 4,
  
  AUDIO_CAPTURE = 5,
  
  VIDEO_CAPTURE = 6,
  
  BACKGROUND_SYNC = 7,
  
  SENSORS = 8,
  
  CLIPBOARD_READ = 9,
  
  CLIPBOARD_WRITE = 10,
  
  PAYMENT_HANDLER = 11,
  
  BACKGROUND_FETCH = 12,
  
  IDLE_DETECTION = 13,
  
  PERIODIC_BACKGROUND_SYNC = 14,
  
  SCREEN_WAKE_LOCK = 15,
  
  SYSTEM_WAKE_LOCK = 16,
  
  NFC = 17,
  
  STORAGE_ACCESS = 18,
  
  WINDOW_MANAGEMENT = 19,
  
  LOCAL_FONTS = 20,
  
  DISPLAY_CAPTURE = 21,
  
  TOP_LEVEL_STORAGE_ACCESS = 22,
  
  CAPTURED_SURFACE_CONTROL = 23,
  
  SPEAKER_SELECTION = 24,
  
  KEYBOARD_LOCK = 25,
  
  POINTER_LOCK = 26,
  
  FULLSCREEN = 27,
  
  WEB_APP_INSTALLATION = 28,
  kMinValue = 0,
  kMaxValue = 28,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PermissionName value);
inline bool IsKnownEnumValue(PermissionName value) {
  return internal::PermissionName_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EmbeddedPermissionControlResult : int32_t {
  
  kDismissed = 0,
  
  kGranted = 1,
  
  kDenied = 2,
  
  kNotSupported = 3,
  
  kResolvedNoUserGesture = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, EmbeddedPermissionControlResult value);
inline bool IsKnownEnumValue(EmbeddedPermissionControlResult value) {
  return internal::EmbeddedPermissionControlResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PermissionObserverInterfaceBase {};

using PermissionObserverPtrDataView =
    mojo::InterfacePtrDataView<PermissionObserverInterfaceBase>;
using PermissionObserverRequestDataView =
    mojo::InterfaceRequestDataView<PermissionObserverInterfaceBase>;
using PermissionObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PermissionObserverInterfaceBase>;
using PermissionObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PermissionObserverInterfaceBase>;
class EmbeddedPermissionControlClientInterfaceBase {};

using EmbeddedPermissionControlClientPtrDataView =
    mojo::InterfacePtrDataView<EmbeddedPermissionControlClientInterfaceBase>;
using EmbeddedPermissionControlClientRequestDataView =
    mojo::InterfaceRequestDataView<EmbeddedPermissionControlClientInterfaceBase>;
using EmbeddedPermissionControlClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<EmbeddedPermissionControlClientInterfaceBase>;
using EmbeddedPermissionControlClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<EmbeddedPermissionControlClientInterfaceBase>;
class PermissionServiceInterfaceBase {};

using PermissionServicePtrDataView =
    mojo::InterfacePtrDataView<PermissionServiceInterfaceBase>;
using PermissionServiceRequestDataView =
    mojo::InterfaceRequestDataView<PermissionServiceInterfaceBase>;
using PermissionServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PermissionServiceInterfaceBase>;
using PermissionServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PermissionServiceInterfaceBase>;


class MidiPermissionDescriptorDataView {
 public:
  MidiPermissionDescriptorDataView() = default;

  MidiPermissionDescriptorDataView(
      internal::MidiPermissionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool sysex() const {
    return data_->sysex;
  }
 private:
  internal::MidiPermissionDescriptor_Data* data_ = nullptr;
};


class ClipboardPermissionDescriptorDataView {
 public:
  ClipboardPermissionDescriptorDataView() = default;

  ClipboardPermissionDescriptorDataView(
      internal::ClipboardPermissionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool has_user_gesture() const {
    return data_->has_user_gesture;
  }
  bool will_be_sanitized() const {
    return data_->will_be_sanitized;
  }
 private:
  internal::ClipboardPermissionDescriptor_Data* data_ = nullptr;
};


class CameraDevicePermissionDescriptorDataView {
 public:
  CameraDevicePermissionDescriptorDataView() = default;

  CameraDevicePermissionDescriptorDataView(
      internal::CameraDevicePermissionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool panTiltZoom() const {
    return data_->panTiltZoom;
  }
 private:
  internal::CameraDevicePermissionDescriptor_Data* data_ = nullptr;
};


class TopLevelStorageAccessPermissionDescriptorDataView {
 public:
  TopLevelStorageAccessPermissionDescriptorDataView() = default;

  TopLevelStorageAccessPermissionDescriptorDataView(
      internal::TopLevelStorageAccessPermissionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestedOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestedOrigin(UserType* output) {
    
    auto* pointer = data_->requestedOrigin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::TopLevelStorageAccessPermissionDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FullscreenPermissionDescriptorDataView {
 public:
  FullscreenPermissionDescriptorDataView() = default;

  FullscreenPermissionDescriptorDataView(
      internal::FullscreenPermissionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool allow_without_user_gesture() const {
    return data_->allow_without_user_gesture;
  }
 private:
  internal::FullscreenPermissionDescriptor_Data* data_ = nullptr;
};


class PermissionDescriptorDataView {
 public:
  PermissionDescriptorDataView() = default;

  PermissionDescriptorDataView(
      internal::PermissionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) const {
    auto data_value = data_->name;
    return mojo::internal::Deserialize<::blink::mojom::PermissionName>(
        data_value, output);
  }
  PermissionName name() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PermissionName>(data_->name));
  }
  inline void GetExtensionDataView(
      PermissionDescriptorExtensionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtension(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PermissionDescriptorExtensionDataView, UserType>(),
    "Attempting to read the optional `extension` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExtension` instead "
    "of `ReadExtension if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->extension.is_null() ? &data_->extension : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PermissionDescriptorExtensionDataView>(
        pointer, output, message_);
  }
 private:
  internal::PermissionDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EmbeddedPermissionRequestDescriptorDataView {
 public:
  EmbeddedPermissionRequestDescriptorDataView() = default;

  EmbeddedPermissionRequestDescriptorDataView(
      internal::EmbeddedPermissionRequestDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPermissionsDataView(
      mojo::ArrayDataView<PermissionDescriptorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermissions(UserType* output) {
    
    auto* pointer = data_->permissions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PermissionDescriptorDataView>>(
        pointer, output, message_);
  }
  inline void GetElementPositionDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementPosition(UserType* output) {
    
    auto* pointer = data_->element_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
 private:
  internal::EmbeddedPermissionRequestDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PermissionDescriptorExtensionDataView {
 public:
  using Tag = internal::PermissionDescriptorExtension_Data::PermissionDescriptorExtension_Tag;

  PermissionDescriptorExtensionDataView() = default;

  PermissionDescriptorExtensionDataView(
      internal::PermissionDescriptorExtension_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_midi() const { return data_->tag == Tag::kMidi; }
  inline void GetMidiDataView(
      MidiPermissionDescriptorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadMidi(UserType* output) const {
    
    CHECK(is_midi());
    return mojo::internal::Deserialize<::blink::mojom::MidiPermissionDescriptorDataView>(
        data_->data.f_midi.Get(), output, message_);
  }
  bool is_clipboard() const { return data_->tag == Tag::kClipboard; }
  inline void GetClipboardDataView(
      ClipboardPermissionDescriptorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadClipboard(UserType* output) const {
    
    CHECK(is_clipboard());
    return mojo::internal::Deserialize<::blink::mojom::ClipboardPermissionDescriptorDataView>(
        data_->data.f_clipboard.Get(), output, message_);
  }
  bool is_camera_device() const { return data_->tag == Tag::kCameraDevice; }
  inline void GetCameraDeviceDataView(
      CameraDevicePermissionDescriptorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCameraDevice(UserType* output) const {
    
    CHECK(is_camera_device());
    return mojo::internal::Deserialize<::blink::mojom::CameraDevicePermissionDescriptorDataView>(
        data_->data.f_camera_device.Get(), output, message_);
  }
  bool is_top_level_storage_access() const { return data_->tag == Tag::kTopLevelStorageAccess; }
  inline void GetTopLevelStorageAccessDataView(
      TopLevelStorageAccessPermissionDescriptorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTopLevelStorageAccess(UserType* output) const {
    
    CHECK(is_top_level_storage_access());
    return mojo::internal::Deserialize<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView>(
        data_->data.f_top_level_storage_access.Get(), output, message_);
  }
  bool is_fullscreen() const { return data_->tag == Tag::kFullscreen; }
  inline void GetFullscreenDataView(
      FullscreenPermissionDescriptorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFullscreen(UserType* output) const {
    
    CHECK(is_fullscreen());
    return mojo::internal::Deserialize<::blink::mojom::FullscreenPermissionDescriptorDataView>(
        data_->data.f_fullscreen.Get(), output, message_);
  }

 private:
  internal::PermissionDescriptorExtension_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::PermissionName>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PermissionName> {};

template <>
struct hash<::blink::mojom::EmbeddedPermissionControlResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::EmbeddedPermissionControlResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PermissionName, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PermissionName, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::PermissionName>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EmbeddedPermissionControlResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::EmbeddedPermissionControlResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::EmbeddedPermissionControlResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MidiPermissionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MidiPermissionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MidiPermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->sysex = Traits::sysex(input);
  }

  static bool Deserialize(::blink::mojom::internal::MidiPermissionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MidiPermissionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ClipboardPermissionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ClipboardPermissionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ClipboardPermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->has_user_gesture = Traits::has_user_gesture(input);
    fragment->will_be_sanitized = Traits::will_be_sanitized(input);
  }

  static bool Deserialize(::blink::mojom::internal::ClipboardPermissionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ClipboardPermissionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CameraDevicePermissionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CameraDevicePermissionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CameraDevicePermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->panTiltZoom = Traits::panTiltZoom(input);
  }

  static bool Deserialize(::blink::mojom::internal::CameraDevicePermissionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CameraDevicePermissionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TopLevelStorageAccessPermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::requestedOrigin(input)) in_requestedOrigin = Traits::requestedOrigin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->requestedOrigin)::BaseType> requestedOrigin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_requestedOrigin, requestedOrigin_fragment);
    fragment->requestedOrigin.Set(
        requestedOrigin_fragment.is_null() ? nullptr : requestedOrigin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->requestedOrigin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null requestedOrigin in TopLevelStorageAccessPermissionDescriptor struct");
  }

  static bool Deserialize(::blink::mojom::internal::TopLevelStorageAccessPermissionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FullscreenPermissionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FullscreenPermissionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FullscreenPermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->allow_without_user_gesture = Traits::allow_without_user_gesture(input);
  }

  static bool Deserialize(::blink::mojom::internal::FullscreenPermissionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FullscreenPermissionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PermissionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PermissionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::PermissionName>(
        Traits::name(input), &fragment->name);
    decltype(Traits::extension(input)) in_extension = Traits::extension(input);
    mojo::internal::MessageFragment<decltype(fragment->extension)>
        extension_fragment(fragment.message());
    extension_fragment.Claim(&fragment->extension);
    mojo::internal::Serialize<::blink::mojom::PermissionDescriptorExtensionDataView>(
        in_extension, extension_fragment, true);
  }

  static bool Deserialize(::blink::mojom::internal::PermissionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PermissionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EmbeddedPermissionRequestDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::EmbeddedPermissionRequestDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::EmbeddedPermissionRequestDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::permissions(input)) in_permissions = Traits::permissions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permissions)::BaseType>
        permissions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permissions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PermissionDescriptorDataView>>(
        in_permissions, permissions_fragment, &permissions_validate_params);
    fragment->permissions.Set(
        permissions_fragment.is_null() ? nullptr : permissions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->permissions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null permissions in EmbeddedPermissionRequestDescriptor struct");
    decltype(Traits::element_position(input)) in_element_position = Traits::element_position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->element_position)::BaseType> element_position_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_element_position, element_position_fragment);
    fragment->element_position.Set(
        element_position_fragment.is_null() ? nullptr : element_position_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->element_position.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null element_position in EmbeddedPermissionRequestDescriptor struct");
  }

  static bool Deserialize(::blink::mojom::internal::EmbeddedPermissionRequestDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::EmbeddedPermissionRequestDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PermissionDescriptorExtensionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PermissionDescriptorExtensionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PermissionDescriptorExtension_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kMidi: {
        decltype(Traits::midi(input))
            in_midi = Traits::midi(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_midi)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::MidiPermissionDescriptorDataView>(
            in_midi, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null midi in PermissionDescriptorExtension union");
        fragment->data.f_midi.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kClipboard: {
        decltype(Traits::clipboard(input))
            in_clipboard = Traits::clipboard(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_clipboard)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::ClipboardPermissionDescriptorDataView>(
            in_clipboard, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null clipboard in PermissionDescriptorExtension union");
        fragment->data.f_clipboard.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kCameraDevice: {
        decltype(Traits::camera_device(input))
            in_camera_device = Traits::camera_device(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_camera_device)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::CameraDevicePermissionDescriptorDataView>(
            in_camera_device, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null camera_device in PermissionDescriptorExtension union");
        fragment->data.f_camera_device.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kTopLevelStorageAccess: {
        decltype(Traits::top_level_storage_access(input))
            in_top_level_storage_access = Traits::top_level_storage_access(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_top_level_storage_access)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView>(
            in_top_level_storage_access, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null top_level_storage_access in PermissionDescriptorExtension union");
        fragment->data.f_top_level_storage_access.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kFullscreen: {
        decltype(Traits::fullscreen(input))
            in_fullscreen = Traits::fullscreen(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_fullscreen)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::FullscreenPermissionDescriptorDataView>(
            in_fullscreen, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null fullscreen in PermissionDescriptorExtension union");
        fragment->data.f_fullscreen.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::PermissionDescriptorExtension_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PermissionDescriptorExtensionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {







inline void TopLevelStorageAccessPermissionDescriptorDataView::GetRequestedOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->requestedOrigin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}




inline void PermissionDescriptorDataView::GetExtensionDataView(
    PermissionDescriptorExtensionDataView* output) {
  auto pointer = &data_->extension;
  *output = PermissionDescriptorExtensionDataView(pointer, message_);
}


inline void EmbeddedPermissionRequestDescriptorDataView::GetPermissionsDataView(
    mojo::ArrayDataView<PermissionDescriptorDataView>* output) {
  auto pointer = data_->permissions.Get();
  *output = mojo::ArrayDataView<PermissionDescriptorDataView>(pointer, message_);
}
inline void EmbeddedPermissionRequestDescriptorDataView::GetElementPositionDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->element_position.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}


inline void PermissionDescriptorExtensionDataView::GetMidiDataView(
    MidiPermissionDescriptorDataView* output) const {
  CHECK(is_midi());
  *output = MidiPermissionDescriptorDataView(data_->data.f_midi.Get(), message_);
}
inline void PermissionDescriptorExtensionDataView::GetClipboardDataView(
    ClipboardPermissionDescriptorDataView* output) const {
  CHECK(is_clipboard());
  *output = ClipboardPermissionDescriptorDataView(data_->data.f_clipboard.Get(), message_);
}
inline void PermissionDescriptorExtensionDataView::GetCameraDeviceDataView(
    CameraDevicePermissionDescriptorDataView* output) const {
  CHECK(is_camera_device());
  *output = CameraDevicePermissionDescriptorDataView(data_->data.f_camera_device.Get(), message_);
}
inline void PermissionDescriptorExtensionDataView::GetTopLevelStorageAccessDataView(
    TopLevelStorageAccessPermissionDescriptorDataView* output) const {
  CHECK(is_top_level_storage_access());
  *output = TopLevelStorageAccessPermissionDescriptorDataView(data_->data.f_top_level_storage_access.Get(), message_);
}
inline void PermissionDescriptorExtensionDataView::GetFullscreenDataView(
    FullscreenPermissionDescriptorDataView* output) const {
  CHECK(is_fullscreen());
  *output = FullscreenPermissionDescriptorDataView(data_->data.f_fullscreen.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::PermissionName> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::PermissionName value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::EmbeddedPermissionControlResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::EmbeddedPermissionControlResult value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_SHARED_H_