// third_party/blink/public/mojom/page/prerender_page_param.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PRERENDER_PAGE_PARAM_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PRERENDER_PAGE_PARAM_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/page/prerender_page_param.mojom-shared-internal.h"



#include "base/component_export.h"




namespace blink::mojom {
class PrerenderParamDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PrerenderParamDataView> {
  using Data = ::blink::mojom::internal::PrerenderParam_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class PrerenderParamDataView {
 public:
  PrerenderParamDataView() = default;

  PrerenderParamDataView(
      internal::PrerenderParam_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPageMetricSuffixDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageMetricSuffix(UserType* output) {
    
    auto* pointer = data_->page_metric_suffix.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool should_warm_up_compositor() const {
    return data_->should_warm_up_compositor;
  }
  bool should_prepare_paint_tree() const {
    return data_->should_prepare_paint_tree;
  }
 private:
  internal::PrerenderParam_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PrerenderParamDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PrerenderParamDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PrerenderParam_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::page_metric_suffix(input)) in_page_metric_suffix = Traits::page_metric_suffix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_metric_suffix)::BaseType> page_metric_suffix_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_page_metric_suffix, page_metric_suffix_fragment);
    fragment->page_metric_suffix.Set(
        page_metric_suffix_fragment.is_null() ? nullptr : page_metric_suffix_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->page_metric_suffix.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_metric_suffix in PrerenderParam struct");
    fragment->should_warm_up_compositor = Traits::should_warm_up_compositor(input);
    fragment->should_prepare_paint_tree = Traits::should_prepare_paint_tree(input);
  }

  static bool Deserialize(::blink::mojom::internal::PrerenderParam_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PrerenderParamDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void PrerenderParamDataView::GetPageMetricSuffixDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->page_metric_suffix.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PRERENDER_PAGE_PARAM_MOJOM_SHARED_H_