// third_party/blink/public/mojom/notifications/notification.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NOTIFICATIONS_NOTIFICATION_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NOTIFICATIONS_NOTIFICATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/notifications/notification.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class NotificationActionDataView;

class NotificationDataDataView;

class NotificationResourcesDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::NotificationActionDataView> {
  using Data = ::blink::mojom::internal::NotificationAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::NotificationDataDataView> {
  using Data = ::blink::mojom::internal::NotificationData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::NotificationResourcesDataView> {
  using Data = ::blink::mojom::internal::NotificationResources_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class NotificationDirection : int32_t {
  
  LEFT_TO_RIGHT = 0,
  
  RIGHT_TO_LEFT = 1,
  
  AUTO = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, NotificationDirection value);
inline bool IsKnownEnumValue(NotificationDirection value) {
  return internal::NotificationDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NotificationActionType : int32_t {
  
  BUTTON = 0,
  
  TEXT = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, NotificationActionType value);
inline bool IsKnownEnumValue(NotificationActionType value) {
  return internal::NotificationActionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NotificationScenario : int32_t {
  
  DEFAULT = 0,
  
  INCOMING_CALL = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, NotificationScenario value);
inline bool IsKnownEnumValue(NotificationScenario value) {
  return internal::NotificationScenario_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class NotificationActionDataView {
 public:
  NotificationActionDataView() = default;

  NotificationActionDataView(
      internal::NotificationAction_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::NotificationActionType>(
        data_value, output);
  }
  NotificationActionType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NotificationActionType>(data_->type));
  }
  inline void GetActionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) {
    
    auto* pointer = data_->action.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPlaceholderDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlaceholder(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `placeholder` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPlaceholder` instead "
    "of `ReadPlaceholder if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->placeholder.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::NotificationAction_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NotificationDataDataView {
 public:
  NotificationDataDataView() = default;

  NotificationDataDataView(
      internal::NotificationData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDirection(UserType* output) const {
    auto data_value = data_->direction;
    return mojo::internal::Deserialize<::blink::mojom::NotificationDirection>(
        data_value, output);
  }
  NotificationDirection direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NotificationDirection>(data_->direction));
  }
  inline void GetLangDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLang(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `lang` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLang` instead "
    "of `ReadLang if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->lang.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBodyDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBody(UserType* output) {
    
    auto* pointer = data_->body.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetTagDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTag(UserType* output) {
    
    auto* pointer = data_->tag.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetImageDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImage(UserType* output) {
    
    auto* pointer = data_->image.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetBadgeDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBadge(UserType* output) {
    
    auto* pointer = data_->badge.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetVibrationPatternDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVibrationPattern(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<int32_t>, UserType>(),
    "Attempting to read the optional `vibration_pattern` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVibrationPattern` instead "
    "of `ReadVibrationPattern if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->vibration_pattern.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  double timestamp() const {
    return data_->timestamp;
  }
  bool renotify() const {
    return data_->renotify;
  }
  bool silent() const {
    return data_->silent;
  }
  bool require_interaction() const {
    return data_->require_interaction;
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadData` instead "
    "of `ReadData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetActionsDataView(
      mojo::ArrayDataView<NotificationActionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::NotificationActionDataView>, UserType>(),
    "Attempting to read the optional `actions` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadActions` instead "
    "of `ReadActions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->actions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::NotificationActionDataView>>(
        pointer, output, message_);
  }
  inline void GetShowTriggerTimestampDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShowTriggerTimestamp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `show_trigger_timestamp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShowTriggerTimestamp` instead "
    "of `ReadShowTriggerTimestamp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->show_trigger_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScenario(UserType* output) const {
    auto data_value = data_->scenario;
    return mojo::internal::Deserialize<::blink::mojom::NotificationScenario>(
        data_value, output);
  }
  NotificationScenario scenario() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NotificationScenario>(data_->scenario));
  }
 private:
  internal::NotificationData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NotificationResourcesDataView {
 public:
  NotificationResourcesDataView() = default;

  NotificationResourcesDataView(
      internal::NotificationResources_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageDataView(
      ::skia::mojom::BitmapN32DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::BitmapN32DataView, UserType>(),
    "Attempting to read the optional `image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImage` instead "
    "of `ReadImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::skia::mojom::BitmapN32DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::BitmapN32DataView, UserType>(),
    "Attempting to read the optional `icon` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIcon` instead "
    "of `ReadIcon if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        pointer, output, message_);
  }
  inline void GetBadgeDataView(
      ::skia::mojom::BitmapN32DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBadge(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::BitmapN32DataView, UserType>(),
    "Attempting to read the optional `badge` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBadge` instead "
    "of `ReadBadge if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->badge.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        pointer, output, message_);
  }
  inline void GetActionIconsDataView(
      mojo::ArrayDataView<::skia::mojom::BitmapN32DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActionIcons(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::skia::mojom::BitmapN32DataView>, UserType>(),
    "Attempting to read the optional `action_icons` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadActionIcons` instead "
    "of `ReadActionIcons if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->action_icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::skia::mojom::BitmapN32DataView>>(
        pointer, output, message_);
  }
 private:
  internal::NotificationResources_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::NotificationDirection>
    : public mojo::internal::EnumHashImpl<::blink::mojom::NotificationDirection> {};

template <>
struct hash<::blink::mojom::NotificationActionType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::NotificationActionType> {};

template <>
struct hash<::blink::mojom::NotificationScenario>
    : public mojo::internal::EnumHashImpl<::blink::mojom::NotificationScenario> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NotificationDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::NotificationDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::NotificationDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NotificationActionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::NotificationActionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::NotificationActionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NotificationScenario, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::NotificationScenario, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::NotificationScenario>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NotificationActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::NotificationActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::NotificationAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::NotificationActionType>(
        Traits::type(input), &fragment->type);
    decltype(Traits::action(input)) in_action = Traits::action(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->action)::BaseType> action_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_action, action_fragment);
    fragment->action.Set(
        action_fragment.is_null() ? nullptr : action_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->action.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null action in NotificationAction struct");
    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_title, title_fragment);
    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in NotificationAction struct");
    decltype(Traits::icon(input)) in_icon = Traits::icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon)::BaseType> icon_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_icon, icon_fragment);
    fragment->icon.Set(
        icon_fragment.is_null() ? nullptr : icon_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->icon.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icon in NotificationAction struct");
    decltype(Traits::placeholder(input)) in_placeholder = Traits::placeholder(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->placeholder)::BaseType> placeholder_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_placeholder, placeholder_fragment);
    fragment->placeholder.Set(
        placeholder_fragment.is_null() ? nullptr : placeholder_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::NotificationAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::NotificationActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NotificationDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::NotificationDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::NotificationData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_title, title_fragment);
    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in NotificationData struct");
    mojo::internal::Serialize<::blink::mojom::NotificationDirection>(
        Traits::direction(input), &fragment->direction);
    decltype(Traits::lang(input)) in_lang = Traits::lang(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lang)::BaseType> lang_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_lang, lang_fragment);
    fragment->lang.Set(
        lang_fragment.is_null() ? nullptr : lang_fragment.data());
    decltype(Traits::body(input)) in_body = Traits::body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->body)::BaseType> body_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_body, body_fragment);
    fragment->body.Set(
        body_fragment.is_null() ? nullptr : body_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->body.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null body in NotificationData struct");
    decltype(Traits::tag(input)) in_tag = Traits::tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tag)::BaseType> tag_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_tag, tag_fragment);
    fragment->tag.Set(
        tag_fragment.is_null() ? nullptr : tag_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tag.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tag in NotificationData struct");
    decltype(Traits::image(input)) in_image = Traits::image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image)::BaseType> image_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_image, image_fragment);
    fragment->image.Set(
        image_fragment.is_null() ? nullptr : image_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->image.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image in NotificationData struct");
    decltype(Traits::icon(input)) in_icon = Traits::icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon)::BaseType> icon_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_icon, icon_fragment);
    fragment->icon.Set(
        icon_fragment.is_null() ? nullptr : icon_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->icon.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icon in NotificationData struct");
    decltype(Traits::badge(input)) in_badge = Traits::badge(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->badge)::BaseType> badge_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_badge, badge_fragment);
    fragment->badge.Set(
        badge_fragment.is_null() ? nullptr : badge_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->badge.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null badge in NotificationData struct");
    decltype(Traits::vibration_pattern(input)) in_vibration_pattern = Traits::vibration_pattern(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->vibration_pattern)::BaseType>
        vibration_pattern_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& vibration_pattern_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
        in_vibration_pattern, vibration_pattern_fragment, &vibration_pattern_validate_params);
    fragment->vibration_pattern.Set(
        vibration_pattern_fragment.is_null() ? nullptr : vibration_pattern_fragment.data());
    fragment->timestamp = Traits::timestamp(input);
    fragment->renotify = Traits::renotify(input);
    fragment->silent = Traits::silent(input);
    fragment->require_interaction = Traits::require_interaction(input);
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType>
        data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_data, data_fragment, &data_validate_params);
    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());
    decltype(Traits::actions(input)) in_actions = Traits::actions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->actions)::BaseType>
        actions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& actions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::NotificationActionDataView>>(
        in_actions, actions_fragment, &actions_validate_params);
    fragment->actions.Set(
        actions_fragment.is_null() ? nullptr : actions_fragment.data());
    decltype(Traits::show_trigger_timestamp(input)) in_show_trigger_timestamp = Traits::show_trigger_timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->show_trigger_timestamp)::BaseType> show_trigger_timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_show_trigger_timestamp, show_trigger_timestamp_fragment);
    fragment->show_trigger_timestamp.Set(
        show_trigger_timestamp_fragment.is_null() ? nullptr : show_trigger_timestamp_fragment.data());
    mojo::internal::Serialize<::blink::mojom::NotificationScenario>(
        Traits::scenario(input), &fragment->scenario);
  }

  static bool Deserialize(::blink::mojom::internal::NotificationData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::NotificationDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NotificationResourcesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::NotificationResourcesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::NotificationResources_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::image(input)) in_image = Traits::image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image)::BaseType> image_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
        in_image, image_fragment);
    fragment->image.Set(
        image_fragment.is_null() ? nullptr : image_fragment.data());
    decltype(Traits::icon(input)) in_icon = Traits::icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon)::BaseType> icon_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
        in_icon, icon_fragment);
    fragment->icon.Set(
        icon_fragment.is_null() ? nullptr : icon_fragment.data());
    decltype(Traits::badge(input)) in_badge = Traits::badge(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->badge)::BaseType> badge_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
        in_badge, badge_fragment);
    fragment->badge.Set(
        badge_fragment.is_null() ? nullptr : badge_fragment.data());
    decltype(Traits::action_icons(input)) in_action_icons = Traits::action_icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->action_icons)::BaseType>
        action_icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& action_icons_validate_params =
        mojo::internal::GetArrayValidator<0, true, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::skia::mojom::BitmapN32DataView>>(
        in_action_icons, action_icons_fragment, &action_icons_validate_params);
    fragment->action_icons.Set(
        action_icons_fragment.is_null() ? nullptr : action_icons_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::NotificationResources_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::NotificationResourcesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void NotificationActionDataView::GetActionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->action.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NotificationActionDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void NotificationActionDataView::GetIconDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->icon.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void NotificationActionDataView::GetPlaceholderDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->placeholder.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void NotificationDataDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void NotificationDataDataView::GetLangDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->lang.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NotificationDataDataView::GetBodyDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->body.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void NotificationDataDataView::GetTagDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->tag.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NotificationDataDataView::GetImageDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->image.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void NotificationDataDataView::GetIconDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->icon.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void NotificationDataDataView::GetBadgeDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->badge.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void NotificationDataDataView::GetVibrationPatternDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->vibration_pattern.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}
inline void NotificationDataDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void NotificationDataDataView::GetActionsDataView(
    mojo::ArrayDataView<NotificationActionDataView>* output) {
  auto pointer = data_->actions.Get();
  *output = mojo::ArrayDataView<NotificationActionDataView>(pointer, message_);
}
inline void NotificationDataDataView::GetShowTriggerTimestampDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->show_trigger_timestamp.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void NotificationResourcesDataView::GetImageDataView(
    ::skia::mojom::BitmapN32DataView* output) {
  auto pointer = data_->image.Get();
  *output = ::skia::mojom::BitmapN32DataView(pointer, message_);
}
inline void NotificationResourcesDataView::GetIconDataView(
    ::skia::mojom::BitmapN32DataView* output) {
  auto pointer = data_->icon.Get();
  *output = ::skia::mojom::BitmapN32DataView(pointer, message_);
}
inline void NotificationResourcesDataView::GetBadgeDataView(
    ::skia::mojom::BitmapN32DataView* output) {
  auto pointer = data_->badge.Get();
  *output = ::skia::mojom::BitmapN32DataView(pointer, message_);
}
inline void NotificationResourcesDataView::GetActionIconsDataView(
    mojo::ArrayDataView<::skia::mojom::BitmapN32DataView>* output) {
  auto pointer = data_->action_icons.Get();
  *output = mojo::ArrayDataView<::skia::mojom::BitmapN32DataView>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::NotificationDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::NotificationDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::NotificationActionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::NotificationActionType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::NotificationScenario> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::NotificationScenario value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NOTIFICATIONS_NOTIFICATION_MOJOM_SHARED_H_