// third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* WellKnownDirectoryToStringHelper(WellKnownDirectory value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WellKnownDirectory::kDirDesktop:
      return "kDirDesktop";
    case WellKnownDirectory::kDirDocuments:
      return "kDirDocuments";
    case WellKnownDirectory::kDirDownloads:
      return "kDirDownloads";
    case WellKnownDirectory::kDirMusic:
      return "kDirMusic";
    case WellKnownDirectory::kDirPictures:
      return "kDirPictures";
    case WellKnownDirectory::kDirVideos:
      return "kDirVideos";
    default:
      return nullptr;
  }
}

std::string WellKnownDirectoryToString(WellKnownDirectory value) {
  const char *str = WellKnownDirectoryToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WellKnownDirectory value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WellKnownDirectory value) {
  return os << WellKnownDirectoryToString(value);
}

namespace internal {
// static
bool TypeSpecificFilePickerOptionsUnion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TypeSpecificFilePickerOptionsUnion_Data* object = static_cast<const TypeSpecificFilePickerOptionsUnion_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TypeSpecificFilePickerOptionsUnion_Tag::kOpenFilePickerOptions: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_open_file_picker_options, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_open_file_picker_options, validation_context))
        return false;
      return true;
    }
    case TypeSpecificFilePickerOptionsUnion_Tag::kSaveFilePickerOptions: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_save_file_picker_options, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_save_file_picker_options, validation_context))
        return false;
      return true;
    }
    case TypeSpecificFilePickerOptionsUnion_Tag::kDirectoryPickerOptions: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_directory_picker_options, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_directory_picker_options, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TypeSpecificFilePickerOptionsUnion");
      return false;
    }
  }
}
// static
bool FilePickerStartInOptionsUnion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const FilePickerStartInOptionsUnion_Data* object = static_cast<const FilePickerStartInOptionsUnion_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case FilePickerStartInOptionsUnion_Tag::kWellKnownDirectory: {


      if (!::blink::mojom::internal::WellKnownDirectory_Data
            ::Validate(object->data.f_well_known_directory, validation_context))
        return false;
      return true;
    }
    case FilePickerStartInOptionsUnion_Tag::kDirectoryToken: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_directory_token, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_directory_token,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in FilePickerStartInOptionsUnion");
      return false;
    }
  }
}


// static
bool ChooseFileSystemEntryAcceptsOption_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChooseFileSystemEntryAcceptsOption_Data* object =
      static_cast<const ChooseFileSystemEntryAcceptsOption_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_types, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_types_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->mime_types, validation_context,
                                         &mime_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extensions, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extensions_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->extensions, validation_context,
                                         &extensions_validate_params)) {
    return false;
  }

  return true;
}

ChooseFileSystemEntryAcceptsOption_Data::ChooseFileSystemEntryAcceptsOption_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AcceptsTypesInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AcceptsTypesInfo_Data* object =
      static_cast<const AcceptsTypesInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accepts, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& accepts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->accepts, validation_context,
                                         &accepts_validate_params)) {
    return false;
  }

  return true;
}

AcceptsTypesInfo_Data::AcceptsTypesInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OpenFilePickerOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OpenFilePickerOptions_Data* object =
      static_cast<const OpenFilePickerOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accepts_types_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->accepts_types_info, validation_context))
    return false;

  return true;
}

OpenFilePickerOptions_Data::OpenFilePickerOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SaveFilePickerOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SaveFilePickerOptions_Data* object =
      static_cast<const SaveFilePickerOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accepts_types_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->accepts_types_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggested_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& suggested_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->suggested_name, validation_context,
                                         &suggested_name_validate_params)) {
    return false;
  }

  return true;
}

SaveFilePickerOptions_Data::SaveFilePickerOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectoryPickerOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectoryPickerOptions_Data* object =
      static_cast<const DirectoryPickerOptions_Data*>(data);

  return true;
}

DirectoryPickerOptions_Data::DirectoryPickerOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FilePickerOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FilePickerOptions_Data* object =
      static_cast<const FilePickerOptions_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->type_specific_options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->type_specific_options, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->starting_directory_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& starting_directory_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->starting_directory_id, validation_context,
                                         &starting_directory_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->start_in_options, validation_context))
    return false;

  return true;
}

FilePickerOptions_Data::FilePickerOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessManager_GetSandboxedFileSystem_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessManager_GetSandboxedFileSystem_Params_Data* object =
      static_cast<const FileSystemAccessManager_GetSandboxedFileSystem_Params_Data*>(data);

  return true;
}

FileSystemAccessManager_GetSandboxedFileSystem_Params_Data::FileSystemAccessManager_GetSandboxedFileSystem_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data* object =
      static_cast<const FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->directory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data::FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params_Data* object =
      static_cast<const FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->directory_path_components, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& directory_path_components_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->directory_path_components, validation_context,
                                         &directory_path_components_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params_Data::FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams_Data* object =
      static_cast<const FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->directory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams_Data::FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessManager_ChooseEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessManager_ChooseEntries_Params_Data* object =
      static_cast<const FileSystemAccessManager_ChooseEntries_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

FileSystemAccessManager_ChooseEntries_Params_Data::FileSystemAccessManager_ChooseEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessManager_ChooseEntries_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessManager_ChooseEntries_ResponseParams_Data* object =
      static_cast<const FileSystemAccessManager_ChooseEntries_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->entries, validation_context,
                                         &entries_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessManager_ChooseEntries_ResponseParams_Data::FileSystemAccessManager_ChooseEntries_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessManager_GetFileHandleFromToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessManager_GetFileHandleFromToken_Params_Data* object =
      static_cast<const FileSystemAccessManager_GetFileHandleFromToken_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->token,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->file_handle, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->file_handle,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessManager_GetFileHandleFromToken_Params_Data::FileSystemAccessManager_GetFileHandleFromToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data* object =
      static_cast<const FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->token,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->directory_handle, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->directory_handle,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data::FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data* object =
      static_cast<const FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->token,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data::FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data* object =
      static_cast<const FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->entry, validation_context))
    return false;

  return true;
}

FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data::FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessManager_BindObserverHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessManager_BindObserverHost_Params_Data* object =
      static_cast<const FileSystemAccessManager_BindObserverHost_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer_host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer_host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessManager_BindObserverHost_Params_Data::FileSystemAccessManager_BindObserverHost_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WellKnownDirectory>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WellKnownDirectory value) {
  return std::move(context).WriteString(::blink::mojom::WellKnownDirectoryToString(value));
}

} // namespace perfetto