// third_party/blink/public/mojom/file/file_utilities.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_FILE_UTILITIES_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_FILE_UTILITIES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/file/file_utilities.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file/file_utilities.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file/file_utilities.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_info.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class FileUtilitiesHostProxy;

template <typename ImplRefTraits>
class FileUtilitiesHostStub;

class FileUtilitiesHostRequestValidator;
class FileUtilitiesHostResponseValidator;


class BLINK_COMMON_EXPORT FileUtilitiesHost
    : public FileUtilitiesHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileUtilitiesHostInterfaceBase;
  using Proxy_ = FileUtilitiesHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileUtilitiesHostStub<ImplRefTraits>;

  using RequestValidator_ = FileUtilitiesHostRequestValidator;
  using ResponseValidator_ = FileUtilitiesHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetFileInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetFileInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileUtilitiesHost() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetFileInfo(const ::base::FilePath& path, std::optional<::base::File::Info>* out_result);

  using GetFileInfoCallback = base::OnceCallback<void(const std::optional<::base::File::Info>&)>;
  
  virtual void GetFileInfo(const ::base::FilePath& path, GetFileInfoCallback callback) = 0;
};



class BLINK_COMMON_EXPORT FileUtilitiesHostProxy
    : public FileUtilitiesHost {
 public:
  using InterfaceType = FileUtilitiesHost;

  explicit FileUtilitiesHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GetFileInfo(const ::base::FilePath& path, std::optional<::base::File::Info>* out_result) final;
  
  void GetFileInfo(const ::base::FilePath& path, GetFileInfoCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT FileUtilitiesHostStubDispatch {
 public:
  static bool Accept(FileUtilitiesHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileUtilitiesHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileUtilitiesHost>>
class FileUtilitiesHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileUtilitiesHostStub() = default;
  ~FileUtilitiesHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileUtilitiesHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileUtilitiesHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT FileUtilitiesHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT FileUtilitiesHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_FILE_UTILITIES_MOJOM_H_