// third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/url_request.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/request_context_frame_type.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class FetchAPIRequestHeadersDataView;

class FetchAPIRequestBodyDataView;

class FetchAPIRequestDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FetchAPIRequestHeadersDataView> {
  using Data = ::blink::mojom::internal::FetchAPIRequestHeaders_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FetchAPIRequestBodyDataView> {
  using Data = ::blink::mojom::internal::FetchAPIRequestBody_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FetchAPIRequestDataView> {
  using Data = ::blink::mojom::internal::FetchAPIRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class RequestContextType : int32_t {
  
  UNSPECIFIED = 0,
  
  ATTRIBUTION_SRC = 1,
  
  AUDIO = 2,
  
  BEACON = 3,
  
  CSP_REPORT = 4,
  
  DOWNLOAD = 5,
  
  EMBED = 6,
  
  EVENT_SOURCE = 7,
  
  FAVICON = 8,
  
  FETCH = 9,
  
  FONT = 10,
  
  FORM = 11,
  
  FRAME = 12,
  
  HYPERLINK = 13,
  
  IFRAME = 14,
  
  IMAGE = 15,
  
  IMAGE_SET = 16,
  
  INTERNAL = 17,
  
  JSON = 18,
  
  LOCATION = 19,
  
  MANIFEST = 20,
  
  OBJECT = 21,
  
  PING = 22,
  
  PLUGIN = 23,
  
  PREFETCH = 24,
  
  SCRIPT = 25,
  
  SERVICE_WORKER = 26,
  
  SHARED_WORKER = 27,
  
  SPECULATION_RULES = 28,
  
  SUBRESOURCE = 29,
  
  SUBRESOURCE_WEBBUNDLE = 30,
  
  STYLE = 31,
  
  TRACK = 32,
  
  VIDEO = 33,
  
  WORKER = 34,
  
  XML_HTTP_REQUEST = 35,
  
  XSLT = 36,
  kMinValue = 0,
  kMaxValue = 36,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, RequestContextType value);
inline bool IsKnownEnumValue(RequestContextType value) {
  return internal::RequestContextType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FetchCacheMode : int32_t {
  
  kDefault = 0,
  
  kNoStore = 1,
  
  kBypassCache = 2,
  
  kValidateCache = 3,
  
  kForceCache = 4,
  
  kOnlyIfCached = 5,
  
  kUnspecifiedOnlyIfCachedStrict = 6,
  
  kUnspecifiedForceCacheMiss = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FetchCacheMode value);
inline bool IsKnownEnumValue(FetchCacheMode value) {
  return internal::FetchCacheMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FetchPriorityHint : int32_t {
  
  kLow = 0,
  
  kAuto = 1,
  
  kHigh = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FetchPriorityHint value);
inline bool IsKnownEnumValue(FetchPriorityHint value) {
  return internal::FetchPriorityHint_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FetchAPIRequestHeadersDataView {
 public:
  FetchAPIRequestHeadersDataView() = default;

  FetchAPIRequestHeadersDataView(
      internal::FetchAPIRequestHeaders_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHeadersDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FetchAPIRequestHeaders_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FetchAPIRequestBodyDataView {
 public:
  FetchAPIRequestBodyDataView() = default;

  FetchAPIRequestBodyDataView(
      internal::FetchAPIRequestBody_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetElementsDataView(
      mojo::ArrayDataView<::network::mojom::DataElementDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElements(UserType* output) {
    
    auto* pointer = data_->elements.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::DataElementDataView>>(
        pointer, output, message_);
  }
  uint64_t identifier() const {
    return data_->identifier;
  }
  bool contains_sensitive_info() const {
    return data_->contains_sensitive_info;
  }
 private:
  internal::FetchAPIRequestBody_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FetchAPIRequestDataView {
 public:
  FetchAPIRequestDataView() = default;

  FetchAPIRequestDataView(
      internal::FetchAPIRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::network::mojom::RequestMode>(
        data_value, output);
  }
  ::network::mojom::RequestMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestMode>(data_->mode));
  }
  bool is_main_resource_load() const {
    return data_->is_main_resource_load;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDestination(UserType* output) const {
    auto data_value = data_->destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }
  ::network::mojom::RequestDestination destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestDestination>(data_->destination));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFrameType(UserType* output) const {
    auto data_value = data_->frame_type;
    return mojo::internal::Deserialize<::blink::mojom::RequestContextFrameType>(
        data_value, output);
  }
  ::blink::mojom::RequestContextFrameType frame_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::RequestContextFrameType>(data_->frame_type));
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      FetchAPIRequestHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIRequestHeadersDataView>(
        pointer, output, message_);
  }
  inline void GetBlobDataView(
      ::blink::mojom::SerializedBlobDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SerializedBlobDataView, UserType>(),
    "Attempting to read the optional `blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlob` instead "
    "of `ReadBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blob.Get();
    return mojo::internal::Deserialize<::blink::mojom::SerializedBlobDataView>(
        pointer, output, message_);
  }
  inline void GetBodyDataView(
      FetchAPIRequestBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBody(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FetchAPIRequestBodyDataView, UserType>(),
    "Attempting to read the optional `body` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBody` instead "
    "of `ReadBody if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->body.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIRequestBodyDataView>(
        pointer, output, message_);
  }
  inline void GetRequestInitiatorDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestInitiator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `request_initiator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestInitiator` instead "
    "of `ReadRequestInitiator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_initiator.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetNavigationRedirectChainDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationRedirectChain(UserType* output) {
    
    auto* pointer = data_->navigation_redirect_chain.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ReferrerDataView, UserType>(),
    "Attempting to read the optional `referrer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReferrer` instead "
    "of `ReadReferrer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCredentialsMode(UserType* output) const {
    auto data_value = data_->credentials_mode;
    return mojo::internal::Deserialize<::network::mojom::CredentialsMode>(
        data_value, output);
  }
  ::network::mojom::CredentialsMode credentials_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CredentialsMode>(data_->credentials_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCacheMode(UserType* output) const {
    auto data_value = data_->cache_mode;
    return mojo::internal::Deserialize<::blink::mojom::FetchCacheMode>(
        data_value, output);
  }
  FetchCacheMode cache_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FetchCacheMode>(data_->cache_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRedirectMode(UserType* output) const {
    auto data_value = data_->redirect_mode;
    return mojo::internal::Deserialize<::network::mojom::RedirectMode>(
        data_value, output);
  }
  ::network::mojom::RedirectMode redirect_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RedirectMode>(data_->redirect_mode));
  }
  inline void GetIntegrityDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntegrity(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `integrity` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIntegrity` instead "
    "of `ReadIntegrity if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->integrity.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPriority(UserType* output) const {
    auto data_value = data_->priority;
    return mojo::internal::Deserialize<::network::mojom::RequestPriority>(
        data_value, output);
  }
  ::network::mojom::RequestPriority priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestPriority>(data_->priority));
  }
  inline void GetFetchWindowIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFetchWindowId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `fetch_window_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFetchWindowId` instead "
    "of `ReadFetchWindowId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fetch_window_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  bool keepalive() const {
    return data_->keepalive;
  }
  bool is_reload() const {
    return data_->is_reload;
  }
  bool is_history_navigation() const {
    return data_->is_history_navigation;
  }
  inline void GetDevtoolsStackIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsStackId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `devtools_stack_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsStackId` instead "
    "of `ReadDevtoolsStackId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_stack_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTrustTokenParamsDataView(
      ::network::mojom::TrustTokenParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TrustTokenParamsDataView, UserType>(),
    "Attempting to read the optional `trust_token_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustTokenParams` instead "
    "of `ReadTrustTokenParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trust_token_params.Get();
    return mojo::internal::Deserialize<::network::mojom::TrustTokenParamsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTargetAddressSpace(UserType* output) const {
    auto data_value = data_->target_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace target_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->target_address_space));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttributionReportingEligibility(UserType* output) const {
    auto data_value = data_->attribution_reporting_eligibility;
    return mojo::internal::Deserialize<::network::mojom::AttributionReportingEligibility>(
        data_value, output);
  }
  ::network::mojom::AttributionReportingEligibility attribution_reporting_eligibility() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AttributionReportingEligibility>(data_->attribution_reporting_eligibility));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttributionReportingSupport(UserType* output) const {
    auto data_value = data_->attribution_reporting_support;
    return mojo::internal::Deserialize<::network::mojom::AttributionSupport>(
        data_value, output);
  }
  ::network::mojom::AttributionSupport attribution_reporting_support() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AttributionSupport>(data_->attribution_reporting_support));
  }
  inline void GetServiceWorkerRaceNetworkRequestTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerRaceNetworkRequestToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `service_worker_race_network_request_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServiceWorkerRaceNetworkRequestToken` instead "
    "of `ReadServiceWorkerRaceNetworkRequestToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->service_worker_race_network_request_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::FetchAPIRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::RequestContextType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::RequestContextType> {};

template <>
struct hash<::blink::mojom::FetchCacheMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FetchCacheMode> {};

template <>
struct hash<::blink::mojom::FetchPriorityHint>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FetchPriorityHint> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RequestContextType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::RequestContextType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::RequestContextType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchCacheMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FetchCacheMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FetchCacheMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchPriorityHint, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FetchPriorityHint, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FetchPriorityHint>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchAPIRequestHeadersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchAPIRequestHeadersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FetchAPIRequestHeaders_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType>
        headers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        in_headers, headers_fragment, &headers_validate_params);
    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in FetchAPIRequestHeaders struct");
  }

  static bool Deserialize(::blink::mojom::internal::FetchAPIRequestHeaders_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FetchAPIRequestHeadersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchAPIRequestBodyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchAPIRequestBodyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FetchAPIRequestBody_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::elements(input)) in_elements = Traits::elements(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->elements)::BaseType>
        elements_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DataElementDataView>>(
        in_elements, elements_fragment, &elements_validate_params);
    fragment->elements.Set(
        elements_fragment.is_null() ? nullptr : elements_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->elements.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null elements in FetchAPIRequestBody struct");
    fragment->identifier = Traits::identifier(input);
    fragment->contains_sensitive_info = Traits::contains_sensitive_info(input);
  }

  static bool Deserialize(::blink::mojom::internal::FetchAPIRequestBody_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FetchAPIRequestBodyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchAPIRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchAPIRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FetchAPIRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::network::mojom::RequestMode>(
        Traits::mode(input), &fragment->mode);
    fragment->is_main_resource_load = Traits::is_main_resource_load(input);
    mojo::internal::Serialize<::network::mojom::RequestDestination>(
        Traits::destination(input), &fragment->destination);
    mojo::internal::Serialize<::blink::mojom::RequestContextFrameType>(
        Traits::frame_type(input), &fragment->frame_type);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in FetchAPIRequest struct");
    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method)::BaseType> method_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_method, method_fragment);
    fragment->method.Set(
        method_fragment.is_null() ? nullptr : method_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->method.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in FetchAPIRequest struct");
    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType> headers_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FetchAPIRequestHeadersDataView>(
        in_headers, headers_fragment);
    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in FetchAPIRequest struct");
    decltype(Traits::blob(input)) in_blob = Traits::blob(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blob)::BaseType> blob_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
        in_blob, blob_fragment);
    fragment->blob.Set(
        blob_fragment.is_null() ? nullptr : blob_fragment.data());
    decltype(Traits::body(input)) in_body = Traits::body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->body)::BaseType> body_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FetchAPIRequestBodyDataView>(
        in_body, body_fragment);
    fragment->body.Set(
        body_fragment.is_null() ? nullptr : body_fragment.data());
    decltype(Traits::request_initiator(input)) in_request_initiator = Traits::request_initiator(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_initiator)::BaseType> request_initiator_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_request_initiator, request_initiator_fragment);
    fragment->request_initiator.Set(
        request_initiator_fragment.is_null() ? nullptr : request_initiator_fragment.data());
    decltype(Traits::navigation_redirect_chain(input)) in_navigation_redirect_chain = Traits::navigation_redirect_chain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_redirect_chain)::BaseType>
        navigation_redirect_chain_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& navigation_redirect_chain_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_navigation_redirect_chain, navigation_redirect_chain_fragment, &navigation_redirect_chain_validate_params);
    fragment->navigation_redirect_chain.Set(
        navigation_redirect_chain_fragment.is_null() ? nullptr : navigation_redirect_chain_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->navigation_redirect_chain.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_redirect_chain in FetchAPIRequest struct");
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referrer)::BaseType> referrer_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
        in_referrer, referrer_fragment);
    fragment->referrer.Set(
        referrer_fragment.is_null() ? nullptr : referrer_fragment.data());
    mojo::internal::Serialize<::network::mojom::CredentialsMode>(
        Traits::credentials_mode(input), &fragment->credentials_mode);
    mojo::internal::Serialize<::blink::mojom::FetchCacheMode>(
        Traits::cache_mode(input), &fragment->cache_mode);
    mojo::internal::Serialize<::network::mojom::RedirectMode>(
        Traits::redirect_mode(input), &fragment->redirect_mode);
    decltype(Traits::integrity(input)) in_integrity = Traits::integrity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->integrity)::BaseType> integrity_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_integrity, integrity_fragment);
    fragment->integrity.Set(
        integrity_fragment.is_null() ? nullptr : integrity_fragment.data());
    mojo::internal::Serialize<::network::mojom::RequestPriority>(
        Traits::priority(input), &fragment->priority);
    decltype(Traits::fetch_window_id(input)) in_fetch_window_id = Traits::fetch_window_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fetch_window_id)::BaseType> fetch_window_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_fetch_window_id, fetch_window_id_fragment);
    fragment->fetch_window_id.Set(
        fetch_window_id_fragment.is_null() ? nullptr : fetch_window_id_fragment.data());
    fragment->keepalive = Traits::keepalive(input);
    fragment->is_reload = Traits::is_reload(input);
    fragment->is_history_navigation = Traits::is_history_navigation(input);
    decltype(Traits::devtools_stack_id(input)) in_devtools_stack_id = Traits::devtools_stack_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_stack_id)::BaseType> devtools_stack_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_devtools_stack_id, devtools_stack_id_fragment);
    fragment->devtools_stack_id.Set(
        devtools_stack_id_fragment.is_null() ? nullptr : devtools_stack_id_fragment.data());
    decltype(Traits::trust_token_params(input)) in_trust_token_params = Traits::trust_token_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_token_params)::BaseType> trust_token_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::TrustTokenParamsDataView>(
        in_trust_token_params, trust_token_params_fragment);
    fragment->trust_token_params.Set(
        trust_token_params_fragment.is_null() ? nullptr : trust_token_params_fragment.data());
    mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::target_address_space(input), &fragment->target_address_space);
    mojo::internal::Serialize<::network::mojom::AttributionReportingEligibility>(
        Traits::attribution_reporting_eligibility(input), &fragment->attribution_reporting_eligibility);
    mojo::internal::Serialize<::network::mojom::AttributionSupport>(
        Traits::attribution_reporting_support(input), &fragment->attribution_reporting_support);
    decltype(Traits::service_worker_race_network_request_token(input)) in_service_worker_race_network_request_token = Traits::service_worker_race_network_request_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_worker_race_network_request_token)::BaseType> service_worker_race_network_request_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_service_worker_race_network_request_token, service_worker_race_network_request_token_fragment);
    fragment->service_worker_race_network_request_token.Set(
        service_worker_race_network_request_token_fragment.is_null() ? nullptr : service_worker_race_network_request_token_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::FetchAPIRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FetchAPIRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void FetchAPIRequestHeadersDataView::GetHeadersDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}


inline void FetchAPIRequestBodyDataView::GetElementsDataView(
    mojo::ArrayDataView<::network::mojom::DataElementDataView>* output) {
  auto pointer = data_->elements.Get();
  *output = mojo::ArrayDataView<::network::mojom::DataElementDataView>(pointer, message_);
}


inline void FetchAPIRequestDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void FetchAPIRequestDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FetchAPIRequestDataView::GetHeadersDataView(
    FetchAPIRequestHeadersDataView* output) {
  auto pointer = data_->headers.Get();
  *output = FetchAPIRequestHeadersDataView(pointer, message_);
}
inline void FetchAPIRequestDataView::GetBlobDataView(
    ::blink::mojom::SerializedBlobDataView* output) {
  auto pointer = data_->blob.Get();
  *output = ::blink::mojom::SerializedBlobDataView(pointer, message_);
}
inline void FetchAPIRequestDataView::GetBodyDataView(
    FetchAPIRequestBodyDataView* output) {
  auto pointer = data_->body.Get();
  *output = FetchAPIRequestBodyDataView(pointer, message_);
}
inline void FetchAPIRequestDataView::GetRequestInitiatorDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->request_initiator.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void FetchAPIRequestDataView::GetNavigationRedirectChainDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->navigation_redirect_chain.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}
inline void FetchAPIRequestDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, message_);
}
inline void FetchAPIRequestDataView::GetIntegrityDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->integrity.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FetchAPIRequestDataView::GetFetchWindowIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->fetch_window_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void FetchAPIRequestDataView::GetDevtoolsStackIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtools_stack_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FetchAPIRequestDataView::GetTrustTokenParamsDataView(
    ::network::mojom::TrustTokenParamsDataView* output) {
  auto pointer = data_->trust_token_params.Get();
  *output = ::network::mojom::TrustTokenParamsDataView(pointer, message_);
}
inline void FetchAPIRequestDataView::GetServiceWorkerRaceNetworkRequestTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->service_worker_race_network_request_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::RequestContextType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::RequestContextType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::FetchCacheMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::FetchCacheMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::FetchPriorityHint> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::FetchPriorityHint value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_SHARED_H_