// third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* ReportingDestinationToStringHelper(ReportingDestination value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ReportingDestination::kBuyer:
      return "kBuyer";
    case ReportingDestination::kSeller:
      return "kSeller";
    case ReportingDestination::kComponentSeller:
      return "kComponentSeller";
    case ReportingDestination::kSharedStorageSelectUrl:
      return "kSharedStorageSelectUrl";
    case ReportingDestination::kDirectSeller:
      return "kDirectSeller";
    default:
      return nullptr;
  }
}

std::string ReportingDestinationToString(ReportingDestination value) {
  const char *str = ReportingDestinationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ReportingDestination value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ReportingDestination value) {
  return os << ReportingDestinationToString(value);
}

NOINLINE static const char* DeprecatedFencedFrameModeToStringHelper(DeprecatedFencedFrameMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeprecatedFencedFrameMode::kDefault:
      return "kDefault";
    case DeprecatedFencedFrameMode::kOpaqueAds:
      return "kOpaqueAds";
    default:
      return nullptr;
  }
}

std::string DeprecatedFencedFrameModeToString(DeprecatedFencedFrameMode value) {
  const char *str = DeprecatedFencedFrameModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeprecatedFencedFrameMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeprecatedFencedFrameMode value) {
  return os << DeprecatedFencedFrameModeToString(value);
}

NOINLINE static const char* OpaqueToStringHelper(Opaque value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Opaque::kOpaque:
      return "kOpaque";
    default:
      return nullptr;
  }
}

std::string OpaqueToString(Opaque value) {
  const char *str = OpaqueToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Opaque value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Opaque value) {
  return os << OpaqueToString(value);
}

NOINLINE static const char* AutomaticBeaconTypeToStringHelper(AutomaticBeaconType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AutomaticBeaconType::kDeprecatedTopNavigation:
      return "kDeprecatedTopNavigation";
    case AutomaticBeaconType::kTopNavigationStart:
      return "kTopNavigationStart";
    case AutomaticBeaconType::kTopNavigationCommit:
      return "kTopNavigationCommit";
    default:
      return nullptr;
  }
}

std::string AutomaticBeaconTypeToString(AutomaticBeaconType value) {
  const char *str = AutomaticBeaconTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AutomaticBeaconType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AutomaticBeaconType value) {
  return os << AutomaticBeaconTypeToString(value);
}

namespace internal {
// static
bool PotentiallyOpaqueURL_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PotentiallyOpaqueURL_Data* object = static_cast<const PotentiallyOpaqueURL_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PotentiallyOpaqueURL_Tag::kTransparent: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_transparent, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_transparent, validation_context))
        return false;
      return true;
    }
    case PotentiallyOpaqueURL_Tag::kOpaque: {


      if (!::blink::mojom::internal::Opaque_Data
            ::Validate(object->data.f_opaque, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PotentiallyOpaqueURL");
      return false;
    }
  }
}
// static
bool PotentiallyOpaqueSize_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PotentiallyOpaqueSize_Data* object = static_cast<const PotentiallyOpaqueSize_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PotentiallyOpaqueSize_Tag::kTransparent: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_transparent, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_transparent, validation_context))
        return false;
      return true;
    }
    case PotentiallyOpaqueSize_Tag::kOpaque: {


      if (!::blink::mojom::internal::Opaque_Data
            ::Validate(object->data.f_opaque, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PotentiallyOpaqueSize");
      return false;
    }
  }
}
// static
bool PotentiallyOpaqueBool_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PotentiallyOpaqueBool_Data* object = static_cast<const PotentiallyOpaqueBool_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PotentiallyOpaqueBool_Tag::kTransparent: {

      return true;
    }
    case PotentiallyOpaqueBool_Tag::kOpaque: {


      if (!::blink::mojom::internal::Opaque_Data
            ::Validate(object->data.f_opaque, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PotentiallyOpaqueBool");
      return false;
    }
  }
}
// static
bool PotentiallyOpaqueAdAuctionData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PotentiallyOpaqueAdAuctionData_Data* object = static_cast<const PotentiallyOpaqueAdAuctionData_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PotentiallyOpaqueAdAuctionData_Tag::kTransparent: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_transparent, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_transparent, validation_context))
        return false;
      return true;
    }
    case PotentiallyOpaqueAdAuctionData_Tag::kOpaque: {


      if (!::blink::mojom::internal::Opaque_Data
            ::Validate(object->data.f_opaque, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PotentiallyOpaqueAdAuctionData");
      return false;
    }
  }
}
// static
bool PotentiallyOpaqueConfigVector_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PotentiallyOpaqueConfigVector_Data* object = static_cast<const PotentiallyOpaqueConfigVector_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PotentiallyOpaqueConfigVector_Tag::kTransparent: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_transparent, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& transparent_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_transparent, validation_context,
                                             &transparent_validate_params)) {
        return false;
      }
      return true;
    }
    case PotentiallyOpaqueConfigVector_Tag::kOpaque: {


      if (!::blink::mojom::internal::Opaque_Data
            ::Validate(object->data.f_opaque, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PotentiallyOpaqueConfigVector");
      return false;
    }
  }
}
// static
bool PotentiallyOpaqueURNConfigVector_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PotentiallyOpaqueURNConfigVector_Data* object = static_cast<const PotentiallyOpaqueURNConfigVector_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PotentiallyOpaqueURNConfigVector_Tag::kTransparent: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_transparent, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& transparent_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_transparent, validation_context,
                                             &transparent_validate_params)) {
        return false;
      }
      return true;
    }
    case PotentiallyOpaqueURNConfigVector_Tag::kOpaque: {


      if (!::blink::mojom::internal::Opaque_Data
            ::Validate(object->data.f_opaque, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PotentiallyOpaqueURNConfigVector");
      return false;
    }
  }
}
// static
bool PotentiallyOpaqueSharedStorageBudgetMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PotentiallyOpaqueSharedStorageBudgetMetadata_Data* object = static_cast<const PotentiallyOpaqueSharedStorageBudgetMetadata_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PotentiallyOpaqueSharedStorageBudgetMetadata_Tag::kTransparent: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_transparent, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_transparent, validation_context))
        return false;
      return true;
    }
    case PotentiallyOpaqueSharedStorageBudgetMetadata_Tag::kOpaque: {


      if (!::blink::mojom::internal::Opaque_Data
            ::Validate(object->data.f_opaque, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PotentiallyOpaqueSharedStorageBudgetMetadata");
      return false;
    }
  }
}


// static
bool AdAuctionData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdAuctionData_Data* object =
      static_cast<const AdAuctionData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interest_group_owner, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interest_group_owner, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interest_group_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& interest_group_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->interest_group_name, validation_context,
                                         &interest_group_name_validate_params)) {
    return false;
  }

  return true;
}

AdAuctionData_Data::AdAuctionData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URNConfigPair_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URNConfigPair_Data* object =
      static_cast<const URNConfigPair_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urn, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->urn, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

URNConfigPair_Data::URNConfigPair_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageBudgetMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageBudgetMetadata_Data* object =
      static_cast<const SharedStorageBudgetMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site, validation_context))
    return false;

  return true;
}

SharedStorageBudgetMetadata_Data::SharedStorageBudgetMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ParentPermissionsInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ParentPermissionsInfo_Data* object =
      static_cast<const ParentPermissionsInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parsed_permissions_policy, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& parsed_permissions_policy_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->parsed_permissions_policy, validation_context,
                                         &parsed_permissions_policy_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

ParentPermissionsInfo_Data::ParentPermissionsInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FencedFrameConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 152, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FencedFrameConfig_Data* object =
      static_cast<const FencedFrameConfig_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->mapped_url, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->container_size, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->content_size, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->deprecated_should_freeze_initial_size, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->ad_auction_data, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->nested_configs, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->shared_storage_budget_metadata, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urn_uuid, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->urn_uuid, validation_context))
    return false;


  if (!::blink::mojom::internal::DeprecatedFencedFrameMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->effective_enabled_permissions, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& effective_enabled_permissions_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::PermissionsPolicyFeature_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->effective_enabled_permissions, validation_context,
                                         &effective_enabled_permissions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->parent_permissions_info, validation_context))
    return false;

  return true;
}

FencedFrameConfig_Data::FencedFrameConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FencedFrameProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 144, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FencedFrameProperties_Data* object =
      static_cast<const FencedFrameProperties_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->mapped_url, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->container_size, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->content_size, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->deprecated_should_freeze_initial_size, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->ad_auction_data, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->nested_urn_config_pairs, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->shared_storage_budget_metadata, validation_context))
    return false;


  if (!::blink::mojom::internal::DeprecatedFencedFrameMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->effective_enabled_permissions, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& effective_enabled_permissions_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::PermissionsPolicyFeature_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->effective_enabled_permissions, validation_context,
                                         &effective_enabled_permissions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->parent_permissions_info, validation_context))
    return false;

  return true;
}

FencedFrameProperties_Data::FencedFrameProperties_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ReportingDestination>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ReportingDestination value) {
  return std::move(context).WriteString(::blink::mojom::ReportingDestinationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::DeprecatedFencedFrameMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::DeprecatedFencedFrameMode value) {
  return std::move(context).WriteString(::blink::mojom::DeprecatedFencedFrameModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::Opaque>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::Opaque value) {
  return std::move(context).WriteString(::blink::mojom::OpaqueToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AutomaticBeaconType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AutomaticBeaconType value) {
  return std::move(context).WriteString(::blink::mojom::AutomaticBeaconTypeToString(value));
}

} // namespace perfetto