// third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_FILE_BACKED_BLOB_FACTORY_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_FILE_BACKED_BLOB_FACTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/blob.mojom-forward.h"
#include "third_party/blink/public/mojom/blob/data_element.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class FileBackedBlobFactoryProxy;

template <typename ImplRefTraits>
class FileBackedBlobFactoryStub;

class FileBackedBlobFactoryRequestValidator;
class FileBackedBlobFactoryResponseValidator;


class BLINK_COMMON_EXPORT FileBackedBlobFactory
    : public FileBackedBlobFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    1
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileBackedBlobFactoryInterfaceBase;
  using Proxy_ = FileBackedBlobFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileBackedBlobFactoryStub<ImplRefTraits>;

  using RequestValidator_ = FileBackedBlobFactoryRequestValidator;
  using ResponseValidator_ = FileBackedBlobFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRegisterBlobMinVersion = 0,
    kRegisterBlobSyncMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RegisterBlob_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterBlobSync_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileBackedBlobFactory() = default;

  
  virtual void RegisterBlob(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, const std::string& content_type, ::blink::mojom::DataElementFilePtr file) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RegisterBlobSync(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, const std::string& content_type, ::blink::mojom::DataElementFilePtr file);

  using RegisterBlobSyncCallback = base::OnceCallback<void()>;
  
  virtual void RegisterBlobSync(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, const std::string& content_type, ::blink::mojom::DataElementFilePtr file, RegisterBlobSyncCallback callback) = 0;
};



class BLINK_COMMON_EXPORT FileBackedBlobFactoryProxy
    : public FileBackedBlobFactory {
 public:
  using InterfaceType = FileBackedBlobFactory;

  explicit FileBackedBlobFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterBlob(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, const std::string& content_type, ::blink::mojom::DataElementFilePtr file) final;
  
  bool RegisterBlobSync(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, const std::string& content_type, ::blink::mojom::DataElementFilePtr file) final;
  
  void RegisterBlobSync(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, const std::string& content_type, ::blink::mojom::DataElementFilePtr file, RegisterBlobSyncCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT FileBackedBlobFactoryStubDispatch {
 public:
  static bool Accept(FileBackedBlobFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileBackedBlobFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileBackedBlobFactory>>
class FileBackedBlobFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileBackedBlobFactoryStub() = default;
  ~FileBackedBlobFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileBackedBlobFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileBackedBlobFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT FileBackedBlobFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT FileBackedBlobFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_FILE_BACKED_BLOB_FACTORY_MOJOM_H_