// services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_AGGREGATED_HIT_TEST_REGION_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_AGGREGATED_HIT_TEST_REGION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"







namespace viz::mojom {
class AggregatedHitTestRegionDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::AggregatedHitTestRegionDataView> {
  using Data = ::viz::mojom::internal::AggregatedHitTestRegion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class AggregatedHitTestRegionDataView {
 public:
  AggregatedHitTestRegionDataView() = default;

  AggregatedHitTestRegionDataView(
      internal::AggregatedHitTestRegion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameSinkIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSinkId(UserType* output) {
    
    auto* pointer = data_->frame_sink_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, message_);
  }
  uint32_t flags() const {
    return data_->flags;
  }
  uint32_t async_hit_test_reasons() const {
    return data_->async_hit_test_reasons;
  }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  uint32_t child_count() const {
    return data_->child_count;
  }
  inline void GetTransformDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransform(UserType* output) {
    
    auto* pointer = data_->transform.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
 private:
  internal::AggregatedHitTestRegion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::AggregatedHitTestRegionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AggregatedHitTestRegionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::AggregatedHitTestRegion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_sink_id(input)) in_frame_sink_id = Traits::frame_sink_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_sink_id)::BaseType> frame_sink_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
        in_frame_sink_id, frame_sink_id_fragment);
    fragment->frame_sink_id.Set(
        frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_sink_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_sink_id in AggregatedHitTestRegion struct");
    fragment->flags = Traits::flags(input);
    fragment->async_hit_test_reasons = Traits::async_hit_test_reasons(input);
    decltype(Traits::rect(input)) in_rect = Traits::rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rect)::BaseType> rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_rect, rect_fragment);
    fragment->rect.Set(
        rect_fragment.is_null() ? nullptr : rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rect in AggregatedHitTestRegion struct");
    fragment->child_count = Traits::child_count(input);
    decltype(Traits::transform(input)) in_transform = Traits::transform(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transform)::BaseType> transform_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_transform, transform_fragment);
    fragment->transform.Set(
        transform_fragment.is_null() ? nullptr : transform_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->transform.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transform in AggregatedHitTestRegion struct");
  }

  static bool Deserialize(::viz::mojom::internal::AggregatedHitTestRegion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::AggregatedHitTestRegionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void AggregatedHitTestRegionDataView::GetFrameSinkIdDataView(
    ::viz::mojom::FrameSinkIdDataView* output) {
  auto pointer = data_->frame_sink_id.Get();
  *output = ::viz::mojom::FrameSinkIdDataView(pointer, message_);
}
inline void AggregatedHitTestRegionDataView::GetRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void AggregatedHitTestRegionDataView::GetTransformDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->transform.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_AGGREGATED_HIT_TEST_REGION_MOJOM_SHARED_H_