// services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SUBTREE_CAPTURE_ID_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SUBTREE_CAPTURE_ID_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared-internal.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"







namespace viz::mojom {
class SubtreeCaptureIdDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::SubtreeCaptureIdDataView> {
  using Data = ::viz::mojom::internal::SubtreeCaptureId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class SubtreeCaptureIdDataView {
 public:
  SubtreeCaptureIdDataView() = default;

  SubtreeCaptureIdDataView(
      internal::SubtreeCaptureId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSubtreeIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubtreeId(UserType* output) {
    
    auto* pointer = data_->subtree_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::SubtreeCaptureId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SubtreeCaptureIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SubtreeCaptureIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SubtreeCaptureId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::subtree_id(input)) in_subtree_id = Traits::subtree_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subtree_id)::BaseType> subtree_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
        in_subtree_id, subtree_id_fragment);
    fragment->subtree_id.Set(
        subtree_id_fragment.is_null() ? nullptr : subtree_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->subtree_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subtree_id in SubtreeCaptureId struct");
  }

  static bool Deserialize(::viz::mojom::internal::SubtreeCaptureId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SubtreeCaptureIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void SubtreeCaptureIdDataView::GetSubtreeIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->subtree_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SUBTREE_CAPTURE_ID_MOJOM_SHARED_H_