// services/video_effects/public/mojom/video_effects_processor.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_EFFECTS_PUBLIC_MOJOM_VIDEO_EFFECTS_PROCESSOR_MOJOM_H_
#define SERVICES_VIDEO_EFFECTS_PUBLIC_MOJOM_VIDEO_EFFECTS_PROCESSOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/video_effects/public/mojom/video_effects_processor.mojom-features.h"  // IWYU pragma: export
#include "services/video_effects/public/mojom/video_effects_processor.mojom-shared.h"  // IWYU pragma: export
#include "services/video_effects/public/mojom/video_effects_processor.mojom-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_buffer.mojom.h"
#include "media/capture/mojom/video_capture_types.mojom-forward.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace video_effects::mojom {

class VideoEffectsProcessorProxy;

template <typename ImplRefTraits>
class VideoEffectsProcessorStub;

class VideoEffectsProcessorRequestValidator;
class VideoEffectsProcessorResponseValidator;


class VideoEffectsProcessor
    : public VideoEffectsProcessorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoEffectsProcessorInterfaceBase;
  using Proxy_ = VideoEffectsProcessorProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoEffectsProcessorStub<ImplRefTraits>;

  using RequestValidator_ = VideoEffectsProcessorRequestValidator;
  using ResponseValidator_ = VideoEffectsProcessorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPostProcessMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PostProcess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoEffectsProcessor() = default;


  using PostProcessCallback = base::OnceCallback<void(PostProcessResultPtr)>;
  
  virtual void PostProcess(::media::mojom::VideoBufferHandlePtr input_frame_data, ::media::mojom::VideoFrameInfoPtr input_frame_info, ::media::mojom::VideoBufferHandlePtr result_frame_data, ::media::VideoPixelFormat result_pixel_format, PostProcessCallback callback) = 0;
};



class  VideoEffectsProcessorProxy
    : public VideoEffectsProcessor {
 public:
  using InterfaceType = VideoEffectsProcessor;

  explicit VideoEffectsProcessorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PostProcess(::media::mojom::VideoBufferHandlePtr input_frame_data, ::media::mojom::VideoFrameInfoPtr input_frame_info, ::media::mojom::VideoBufferHandlePtr result_frame_data, ::media::VideoPixelFormat result_pixel_format, PostProcessCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VideoEffectsProcessorStubDispatch {
 public:
  static bool Accept(VideoEffectsProcessor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoEffectsProcessor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoEffectsProcessor>>
class VideoEffectsProcessorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoEffectsProcessorStub() = default;
  ~VideoEffectsProcessorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEffectsProcessorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEffectsProcessorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoEffectsProcessorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoEffectsProcessorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  PostProcessResult {
 public:
  using DataView = PostProcessResultDataView;
  using Data_ = internal::PostProcessResult_Data;
  using Tag = Data_::PostProcessResult_Tag;

  template <typename... Args>
  static PostProcessResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |error|.
  static PostProcessResultPtr
  NewError(
      PostProcessError value) {
    auto result = PostProcessResultPtr(std::in_place);
    result->set_error(std::move(value));
    return result;
  }
  // Construct an instance holding |success|.
  static PostProcessResultPtr
  NewSuccess(
      PostProcessSuccessPtr value) {
    auto result = PostProcessResultPtr(std::in_place);
    result->set_success(std::move(value));
    return result;
  }

  template <typename U>
  static PostProcessResultPtr From(const U& u) {
    return mojo::TypeConverter<PostProcessResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PostProcessResult>::Convert(*this);
  }

  PostProcessResult();
  ~PostProcessResult();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PostProcessResult(const PostProcessResult& other) = delete;
  PostProcessResult& operator=(const PostProcessResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PostProcessResultPtr>
  PostProcessResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PostProcessResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PostProcessResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_error() const { return tag_ == Tag::kError; }

  
  PostProcessError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }

  
  void set_error(
      PostProcessError error);
  
  bool is_success() const { return tag_ == Tag::kSuccess; }

  
  PostProcessSuccessPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return *(data_.success);
  }

  
  void set_success(
      PostProcessSuccessPtr success);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PostProcessResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PostProcessResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    PostProcessError error;
    PostProcessSuccessPtr* success;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  PostProcessSuccess {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PostProcessSuccess, T>::value>;
  using DataView = PostProcessSuccessDataView;
  using Data_ = internal::PostProcessSuccess_Data;

  template <typename... Args>
  static PostProcessSuccessPtr New(Args&&... args) {
    return PostProcessSuccessPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PostProcessSuccessPtr From(const U& u) {
    return mojo::TypeConverter<PostProcessSuccessPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PostProcessSuccess>::Convert(*this);
  }


  PostProcessSuccess();

  explicit PostProcessSuccess(
      ::media::mojom::VideoFrameInfoPtr frame_info);

PostProcessSuccess(const PostProcessSuccess&) = delete;
PostProcessSuccess& operator=(const PostProcessSuccess&) = delete;

  ~PostProcessSuccess();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PostProcessSuccessPtr>
  PostProcessSuccessPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PostProcessSuccess::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PostProcessSuccess::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PostProcessSuccess::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PostProcessSuccess::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PostProcessSuccess::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PostProcessSuccess_UnserializedMessageContext<
            UserType, PostProcessSuccess::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PostProcessSuccess::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PostProcessSuccess::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PostProcessSuccess_UnserializedMessageContext<
            UserType, PostProcessSuccess::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PostProcessSuccess::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::mojom::VideoFrameInfoPtr frame_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PostProcessSuccess::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PostProcessSuccess::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PostProcessSuccess::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PostProcessSuccess::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
PostProcessResultPtr PostProcessResult::Clone() const {
  switch (tag_) {
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(*data_.success));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PostProcessResult>::value>::type*>
bool PostProcessResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
    case Tag::kSuccess:
      return mojo::Equals(*(data_.success), *(other.data_.success));
  }

  return false;
}
template <typename StructPtrType>
PostProcessSuccessPtr PostProcessSuccess::Clone() const {
  return New(
      mojo::Clone(frame_info)
  );
}

template <typename T, PostProcessSuccess::EnableIfSame<T>*>
bool PostProcessSuccess::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_info, other_struct.frame_info))
    return false;
  return true;
}

template <typename T, PostProcessSuccess::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_info < rhs.frame_info)
    return true;
  if (rhs.frame_info < lhs.frame_info)
    return false;
  return false;
}


}  // video_effects::mojom

namespace mojo {


template <>
struct  StructTraits<::video_effects::mojom::PostProcessSuccess::DataView,
                                         ::video_effects::mojom::PostProcessSuccessPtr> {
  static bool IsNull(const ::video_effects::mojom::PostProcessSuccessPtr& input) { return !input; }
  static void SetToNull(::video_effects::mojom::PostProcessSuccessPtr* output) { output->reset(); }

  static const decltype(::video_effects::mojom::PostProcessSuccess::frame_info)& frame_info(
      const ::video_effects::mojom::PostProcessSuccessPtr& input) {
    return input->frame_info;
  }

  static bool Read(::video_effects::mojom::PostProcessSuccess::DataView input, ::video_effects::mojom::PostProcessSuccessPtr* output);
};


template <>
struct  UnionTraits<::video_effects::mojom::PostProcessResult::DataView,
                                        ::video_effects::mojom::PostProcessResultPtr> {
  static bool IsNull(const ::video_effects::mojom::PostProcessResultPtr& input) { return !input; }
  static void SetToNull(::video_effects::mojom::PostProcessResultPtr* output) { output->reset(); }

  static ::video_effects::mojom::PostProcessResult::Tag GetTag(const ::video_effects::mojom::PostProcessResultPtr& input) {
    return input->which();
  }

  static  ::video_effects::mojom::PostProcessError error(const ::video_effects::mojom::PostProcessResultPtr& input) {
    return input->get_error();
  }

  static const ::video_effects::mojom::PostProcessSuccessPtr& success(const ::video_effects::mojom::PostProcessResultPtr& input) {
    return input->get_success();
  }

  static bool Read(::video_effects::mojom::PostProcessResult::DataView input, ::video_effects::mojom::PostProcessResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIDEO_EFFECTS_PUBLIC_MOJOM_VIDEO_EFFECTS_PROCESSOR_MOJOM_H_