// services/tracing/public/mojom/background_tracing_agent.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_PARAMS_DATA_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace tracing::mojom {
namespace internal {
class COMPONENT_EXPORT(TRACING_MOJOM_SHARED) BackgroundTracingAgentClient_OnInitialized_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<BackgroundTracingAgentClient_OnInitialized_Params_Data>;

  BackgroundTracingAgentClient_OnInitialized_Params_Data();
  ~BackgroundTracingAgentClient_OnInitialized_Params_Data() = delete;
};
static_assert(sizeof(BackgroundTracingAgentClient_OnInitialized_Params_Data) == 8,
              "Bad sizeof(BackgroundTracingAgentClient_OnInitialized_Params_Data)");
class COMPONENT_EXPORT(TRACING_MOJOM_SHARED) BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::BackgroundTracingRule_Data> rule;
  uint8_t histogram_value_$flag : 1;
  uint8_t pad1_[3];
  int32_t histogram_value_$value;

 private:
  friend class mojo::internal::MessageFragment<BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data>;

  BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data();
  ~BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data() = delete;
};
static_assert(sizeof(BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data) == 24,
              "Bad sizeof(BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data)");
class COMPONENT_EXPORT(TRACING_MOJOM_SHARED) BackgroundTracingAgent_SetUMACallback_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::BackgroundTracingRule_Data> rule;
  mojo::internal::Pointer<mojo::internal::String_Data> histogram_name;
  int32_t histogram_lower_value;
  int32_t histogram_upper_value;

 private:
  friend class mojo::internal::MessageFragment<BackgroundTracingAgent_SetUMACallback_Params_Data>;

  BackgroundTracingAgent_SetUMACallback_Params_Data();
  ~BackgroundTracingAgent_SetUMACallback_Params_Data() = delete;
};
static_assert(sizeof(BackgroundTracingAgent_SetUMACallback_Params_Data) == 32,
              "Bad sizeof(BackgroundTracingAgent_SetUMACallback_Params_Data)");
class COMPONENT_EXPORT(TRACING_MOJOM_SHARED) BackgroundTracingAgent_ClearUMACallback_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::BackgroundTracingRule_Data> rule;

 private:
  friend class mojo::internal::MessageFragment<BackgroundTracingAgent_ClearUMACallback_Params_Data>;

  BackgroundTracingAgent_ClearUMACallback_Params_Data();
  ~BackgroundTracingAgent_ClearUMACallback_Params_Data() = delete;
};
static_assert(sizeof(BackgroundTracingAgent_ClearUMACallback_Params_Data) == 16,
              "Bad sizeof(BackgroundTracingAgent_ClearUMACallback_Params_Data)");
class COMPONENT_EXPORT(TRACING_MOJOM_SHARED) BackgroundTracingAgentProvider_Create_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t tracing_process_id;
  mojo::internal::Interface_Data client;
  mojo::internal::Handle_Data agent;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<BackgroundTracingAgentProvider_Create_Params_Data>;

  BackgroundTracingAgentProvider_Create_Params_Data();
  ~BackgroundTracingAgentProvider_Create_Params_Data() = delete;
};
static_assert(sizeof(BackgroundTracingAgentProvider_Create_Params_Data) == 32,
              "Bad sizeof(BackgroundTracingAgentProvider_Create_Params_Data)");

}  // namespace internal


class BackgroundTracingAgentClient_OnInitialized_ParamsDataView {
 public:
  BackgroundTracingAgentClient_OnInitialized_ParamsDataView() = default;

  BackgroundTracingAgentClient_OnInitialized_ParamsDataView(
      internal::BackgroundTracingAgentClient_OnInitialized_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::BackgroundTracingAgentClient_OnInitialized_Params_Data* data_ = nullptr;
};


class BackgroundTracingAgentClient_OnTriggerBackgroundTrace_ParamsDataView {
 public:
  BackgroundTracingAgentClient_OnTriggerBackgroundTrace_ParamsDataView() = default;

  BackgroundTracingAgentClient_OnTriggerBackgroundTrace_ParamsDataView(
      internal::BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRuleDataView(
      BackgroundTracingRuleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRule(UserType* output) {
    
    auto* pointer = data_->rule.Get();
    return mojo::internal::Deserialize<::tracing::mojom::BackgroundTracingRuleDataView>(
        pointer, output, message_);
  }
  std::optional<int32_t> histogram_value() const {

    return data_->histogram_value_$flag
        ? std::make_optional(data_->histogram_value_$value)
        : std::nullopt;
  }
 private:
  internal::BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundTracingAgent_SetUMACallback_ParamsDataView {
 public:
  BackgroundTracingAgent_SetUMACallback_ParamsDataView() = default;

  BackgroundTracingAgent_SetUMACallback_ParamsDataView(
      internal::BackgroundTracingAgent_SetUMACallback_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRuleDataView(
      BackgroundTracingRuleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRule(UserType* output) {
    
    auto* pointer = data_->rule.Get();
    return mojo::internal::Deserialize<::tracing::mojom::BackgroundTracingRuleDataView>(
        pointer, output, message_);
  }
  inline void GetHistogramNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHistogramName(UserType* output) {
    
    auto* pointer = data_->histogram_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t histogram_lower_value() const {
    return data_->histogram_lower_value;
  }
  int32_t histogram_upper_value() const {
    return data_->histogram_upper_value;
  }
 private:
  internal::BackgroundTracingAgent_SetUMACallback_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundTracingAgent_ClearUMACallback_ParamsDataView {
 public:
  BackgroundTracingAgent_ClearUMACallback_ParamsDataView() = default;

  BackgroundTracingAgent_ClearUMACallback_ParamsDataView(
      internal::BackgroundTracingAgent_ClearUMACallback_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRuleDataView(
      BackgroundTracingRuleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRule(UserType* output) {
    
    auto* pointer = data_->rule.Get();
    return mojo::internal::Deserialize<::tracing::mojom::BackgroundTracingRuleDataView>(
        pointer, output, message_);
  }
 private:
  internal::BackgroundTracingAgent_ClearUMACallback_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundTracingAgentProvider_Create_ParamsDataView {
 public:
  BackgroundTracingAgentProvider_Create_ParamsDataView() = default;

  BackgroundTracingAgentProvider_Create_ParamsDataView(
      internal::BackgroundTracingAgentProvider_Create_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t tracing_process_id() const {
    return data_->tracing_process_id;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::tracing::mojom::BackgroundTracingAgentClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeAgent() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::tracing::mojom::BackgroundTracingAgentInterfaceBase>>(
            &data_->agent, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::BackgroundTracingAgentProvider_Create_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



inline void BackgroundTracingAgentClient_OnTriggerBackgroundTrace_ParamsDataView::GetRuleDataView(
    BackgroundTracingRuleDataView* output) {
  auto pointer = data_->rule.Get();
  *output = BackgroundTracingRuleDataView(pointer, message_);
}


inline void BackgroundTracingAgent_SetUMACallback_ParamsDataView::GetRuleDataView(
    BackgroundTracingRuleDataView* output) {
  auto pointer = data_->rule.Get();
  *output = BackgroundTracingRuleDataView(pointer, message_);
}
inline void BackgroundTracingAgent_SetUMACallback_ParamsDataView::GetHistogramNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->histogram_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BackgroundTracingAgent_ClearUMACallback_ParamsDataView::GetRuleDataView(
    BackgroundTracingRuleDataView* output) {
  auto pointer = data_->rule.Get();
  *output = BackgroundTracingRuleDataView(pointer, message_);
}





}  // tracing::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_PARAMS_DATA_H_