// services/shape_detection/public/mojom/barcodedetection.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/shape_detection/public/mojom/barcodedetection.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/shape_detection/public/mojom/barcodedetection.mojom-params-data.h"
#include "services/shape_detection/public/mojom/barcodedetection.mojom-shared-message-ids.h"

#include "services/shape_detection/public/mojom/barcodedetection.mojom-blink-import-headers.h"
#include "services/shape_detection/public/mojom/barcodedetection.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace shape_detection::mojom::blink {
BarcodeDetectionResult::BarcodeDetectionResult()
    : raw_value(),
      bounding_box(),
      format(),
      corner_points() {}

BarcodeDetectionResult::BarcodeDetectionResult(
    const WTF::String& raw_value_in,
    const ::gfx::RectF& bounding_box_in,
    BarcodeFormat format_in,
    WTF::Vector<::gfx::PointF> corner_points_in)
    : raw_value(std::move(raw_value_in)),
      bounding_box(std::move(bounding_box_in)),
      format(std::move(format_in)),
      corner_points(std::move(corner_points_in)) {}

BarcodeDetectionResult::~BarcodeDetectionResult() = default;

void BarcodeDetectionResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_value"), this->raw_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounding_box"), this->bounding_box,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BarcodeFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "corner_points"), this->corner_points,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<::gfx::PointF>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BarcodeDetectionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char BarcodeDetection::Name_[] = "shape_detection.mojom.BarcodeDetection";

BarcodeDetection::IPCStableHashFunction BarcodeDetection::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BarcodeDetection>(message.name())) {
    case messages::BarcodeDetection::kDetect: {
      return &BarcodeDetection::Detect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BarcodeDetection::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BarcodeDetection>(message.name())) {
      case messages::BarcodeDetection::kDetect:
            return "Receive shape_detection::mojom::BarcodeDetection::Detect";
    }
  } else {
    switch (static_cast<messages::BarcodeDetection>(message.name())) {
      case messages::BarcodeDetection::kDetect:
            return "Receive reply shape_detection::mojom::BarcodeDetection::Detect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BarcodeDetection::Detect_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)shape_detection::mojom::BarcodeDetection::Detect");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BarcodeDetection_Detect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BarcodeDetection_Detect_ForwardToCallback(
      BarcodeDetection::DetectCallback callback
      ) : callback_(std::move(callback)) {
  }

  BarcodeDetection_Detect_ForwardToCallback(const BarcodeDetection_Detect_ForwardToCallback&) = delete;
  BarcodeDetection_Detect_ForwardToCallback& operator=(const BarcodeDetection_Detect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BarcodeDetection::DetectCallback callback_;
};

BarcodeDetectionProxy::BarcodeDetectionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BarcodeDetectionProxy::Detect(
    const ::SkBitmap& in_bitmap_data, DetectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shape_detection::mojom::BarcodeDetection::Detect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitmap_data"), in_bitmap_data,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BarcodeDetection::kDetect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shape_detection::mojom::internal::BarcodeDetection_Detect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bitmap_data)::BaseType> bitmap_data_fragment(
          params.message());
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_bitmap_data, bitmap_data_fragment);
  params->bitmap_data.Set(
      bitmap_data_fragment.is_null() ? nullptr : bitmap_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bitmap_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bitmap_data in BarcodeDetection.Detect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BarcodeDetection::Name_);
  message.set_method_name("Detect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BarcodeDetection_Detect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BarcodeDetection_Detect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BarcodeDetection::DetectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BarcodeDetection_Detect_ProxyToResponder> proxy(
        new BarcodeDetection_Detect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BarcodeDetection_Detect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BarcodeDetection_Detect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BarcodeDetection_Detect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BarcodeDetection::DetectCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<BarcodeDetectionResultPtr> in_results);
};

bool BarcodeDetection_Detect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BarcodeDetection_Detect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BarcodeDetection_Detect_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for BarcodeDetection.0
  bool success = true;
  WTF::Vector<BarcodeDetectionResultPtr> p_results{};
  BarcodeDetection_Detect_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BarcodeDetection::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_results));
  return true;
}

void BarcodeDetection_Detect_ProxyToResponder::Run(
    WTF::Vector<BarcodeDetectionResultPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shape_detection::mojom::BarcodeDetection::Detect", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type WTF::Vector<BarcodeDetectionResultPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BarcodeDetection::kDetect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shape_detection::mojom::internal::BarcodeDetection_Detect_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::shape_detection::mojom::BarcodeDetectionResultDataView>>(
      in_results, results_fragment, &results_validate_params);
  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->results.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BarcodeDetection::Name_);
  message.set_method_name("Detect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BarcodeDetectionStubDispatch::Accept(
    BarcodeDetection* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BarcodeDetection>(message->header()->name)) {
    case messages::BarcodeDetection::kDetect: {
      break;
    }
  }
  return false;
}

// static
bool BarcodeDetectionStubDispatch::AcceptWithResponder(
    BarcodeDetection* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BarcodeDetection>(message->header()->name)) {
    case messages::BarcodeDetection::kDetect: {
      internal::BarcodeDetection_Detect_Params_Data* params =
          reinterpret_cast<
              internal::BarcodeDetection_Detect_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for BarcodeDetection.0
      bool success = true;
      ::SkBitmap p_bitmap_data{};
      BarcodeDetection_Detect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBitmapData(&p_bitmap_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BarcodeDetection::Name_, 0, false);
        return false;
      }
      BarcodeDetection::DetectCallback callback =
          BarcodeDetection_Detect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Detect(        
        std::move(p_bitmap_data), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBarcodeDetectionValidationInfo[] = {
    {base::to_underlying(messages::BarcodeDetection::kDetect),
     { &internal::BarcodeDetection_Detect_Params_Data::Validate,
      &internal::BarcodeDetection_Detect_ResponseParams_Data::Validate}},
};

bool BarcodeDetectionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::shape_detection::mojom::blink::BarcodeDetection::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBarcodeDetectionValidationInfo);
}

bool BarcodeDetectionResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::shape_detection::mojom::blink::BarcodeDetection::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kBarcodeDetectionValidationInfo);

}


}  // shape_detection::mojom::blink


namespace mojo {


// static
bool StructTraits<::shape_detection::mojom::blink::BarcodeDetectionResult::DataView, ::shape_detection::mojom::blink::BarcodeDetectionResultPtr>::Read(
    ::shape_detection::mojom::blink::BarcodeDetectionResult::DataView input,
    ::shape_detection::mojom::blink::BarcodeDetectionResultPtr* output) {
  bool success = true;
  ::shape_detection::mojom::blink::BarcodeDetectionResultPtr result(::shape_detection::mojom::blink::BarcodeDetectionResult::New());
  
      if (success && !input.ReadRawValue(&result->raw_value))
        success = false;
      if (success && !input.ReadBoundingBox(&result->bounding_box))
        success = false;
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadCornerPoints(&result->corner_points))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace shape_detection::mojom::blink {


void BarcodeDetectionInterceptorForTesting::Detect(const ::SkBitmap& bitmap_data, DetectCallback callback) {
  GetForwardingInterface()->Detect(
    std::move(bitmap_data)
    , std::move(callback));
}
BarcodeDetectionAsyncWaiter::BarcodeDetectionAsyncWaiter(
    BarcodeDetection* proxy) : proxy_(proxy) {}

BarcodeDetectionAsyncWaiter::~BarcodeDetectionAsyncWaiter() = default;

void BarcodeDetectionAsyncWaiter::Detect(
    const ::SkBitmap& bitmap_data, WTF::Vector<BarcodeDetectionResultPtr>* out_results) {
  base::RunLoop loop;
  proxy_->Detect(
      std::move(bitmap_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::Vector<BarcodeDetectionResultPtr>* out_results
,
             WTF::Vector<BarcodeDetectionResultPtr> results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

WTF::Vector<BarcodeDetectionResultPtr> BarcodeDetectionAsyncWaiter::Detect(
    const ::SkBitmap& bitmap_data) {
  WTF::Vector<BarcodeDetectionResultPtr> async_wait_result;
  Detect(std::move(bitmap_data),&async_wait_result);
  return async_wait_result;
}






}  // shape_detection::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif