// services/network/public/mojom/url_loader.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/url_loader.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_loader.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_loader.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "services/network/public/mojom/early_hints.mojom-blink-forward.h"
#include "services/network/public/mojom/http_request_headers.mojom-blink.h"
#include "services/network/public/mojom/request_priority.mojom-blink.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-blink.h"
#include "services/network/public/mojom/url_response_head.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class URLLoaderProxy;

template <typename ImplRefTraits>
class URLLoaderStub;

class URLLoaderRequestValidator;


class BLINK_PLATFORM_EXPORT URLLoader
    : public URLLoaderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = URLLoaderInterfaceBase;
  using Proxy_ = URLLoaderProxy;

  template <typename ImplRefTraits>
  using Stub_ = URLLoaderStub<ImplRefTraits>;

  using RequestValidator_ = URLLoaderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kFollowRedirectMinVersion = 0,
    kSetPriorityMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FollowRedirect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPriority_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  static constexpr uint32_t kClientDisconnectReason = 1U;
  virtual ~URLLoader() = default;

  
  virtual void FollowRedirect(const WTF::Vector<WTF::String>& removed_headers, const ::net::HttpRequestHeaders& modified_headers, const ::net::HttpRequestHeaders& modified_cors_exempt_headers, const std::optional<::blink::KURL>& new_url) = 0;

  
  virtual void SetPriority(::net::RequestPriority priority, int32_t intra_priority_value) = 0;
};

class URLLoaderClientProxy;

template <typename ImplRefTraits>
class URLLoaderClientStub;

class URLLoaderClientRequestValidator;
class URLLoaderClientResponseValidator;


class BLINK_PLATFORM_EXPORT URLLoaderClient
    : public URLLoaderClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = URLLoaderClientInterfaceBase;
  using Proxy_ = URLLoaderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = URLLoaderClientStub<ImplRefTraits>;

  using RequestValidator_ = URLLoaderClientRequestValidator;
  using ResponseValidator_ = URLLoaderClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnReceiveEarlyHintsMinVersion = 0,
    kOnReceiveResponseMinVersion = 0,
    kOnReceiveRedirectMinVersion = 0,
    kOnUploadProgressMinVersion = 0,
    kOnTransferSizeUpdatedMinVersion = 0,
    kOnCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnReceiveEarlyHints_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReceiveResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReceiveRedirect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnUploadProgress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTransferSizeUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~URLLoaderClient() = default;

  
  virtual void OnReceiveEarlyHints(::network::mojom::blink::EarlyHintsPtr early_hints) = 0;

  
  virtual void OnReceiveResponse(::network::mojom::blink::URLResponseHeadPtr head, ::mojo::ScopedDataPipeConsumerHandle body, std::optional<::mojo_base::BigBuffer> cached_metadata) = 0;

  
  virtual void OnReceiveRedirect(URLRequestRedirectInfoPtr redirect_info, ::network::mojom::blink::URLResponseHeadPtr head) = 0;


  using OnUploadProgressCallback = base::OnceCallback<void()>;
  
  virtual void OnUploadProgress(int64_t current_position, int64_t total_size, OnUploadProgressCallback callback) = 0;

  
  virtual void OnTransferSizeUpdated(int32_t transfer_size_diff) = 0;

  
  virtual void OnComplete(const ::network::URLLoaderCompletionStatus& status) = 0;
};



class BLINK_PLATFORM_EXPORT URLLoaderProxy
    : public URLLoader {
 public:
  using InterfaceType = URLLoader;

  explicit URLLoaderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FollowRedirect(const WTF::Vector<WTF::String>& removed_headers, const ::net::HttpRequestHeaders& modified_headers, const ::net::HttpRequestHeaders& modified_cors_exempt_headers, const std::optional<::blink::KURL>& new_url) final;
  
  void SetPriority(::net::RequestPriority priority, int32_t intra_priority_value) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT URLLoaderClientProxy
    : public URLLoaderClient {
 public:
  using InterfaceType = URLLoaderClient;

  explicit URLLoaderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnReceiveEarlyHints(::network::mojom::blink::EarlyHintsPtr early_hints) final;
  
  void OnReceiveResponse(::network::mojom::blink::URLResponseHeadPtr head, ::mojo::ScopedDataPipeConsumerHandle body, std::optional<::mojo_base::BigBuffer> cached_metadata) final;
  
  void OnReceiveRedirect(URLRequestRedirectInfoPtr redirect_info, ::network::mojom::blink::URLResponseHeadPtr head) final;
  
  void OnUploadProgress(int64_t current_position, int64_t total_size, OnUploadProgressCallback callback) final;
  
  void OnTransferSizeUpdated(int32_t transfer_size_diff) final;
  
  void OnComplete(const ::network::URLLoaderCompletionStatus& status) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT URLLoaderStubDispatch {
 public:
  static bool Accept(URLLoader* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      URLLoader* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<URLLoader>>
class URLLoaderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  URLLoaderStub() = default;
  ~URLLoaderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT URLLoaderClientStubDispatch {
 public:
  static bool Accept(URLLoaderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      URLLoaderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<URLLoaderClient>>
class URLLoaderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  URLLoaderClientStub() = default;
  ~URLLoaderClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT URLLoaderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT URLLoaderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT URLLoaderClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class BLINK_PLATFORM_EXPORT URLLoaderClientEndpoints {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLLoaderClientEndpoints, T>::value>;
  using DataView = URLLoaderClientEndpointsDataView;
  using Data_ = internal::URLLoaderClientEndpoints_Data;

  template <typename... Args>
  static URLLoaderClientEndpointsPtr New(Args&&... args) {
    return URLLoaderClientEndpointsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLLoaderClientEndpointsPtr From(const U& u) {
    return mojo::TypeConverter<URLLoaderClientEndpointsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLLoaderClientEndpoints>::Convert(*this);
  }


  URLLoaderClientEndpoints();

  URLLoaderClientEndpoints(
      ::mojo::PendingRemote<URLLoader> url_loader,
      ::mojo::PendingReceiver<URLLoaderClient> url_loader_client);

URLLoaderClientEndpoints(const URLLoaderClientEndpoints&) = delete;
URLLoaderClientEndpoints& operator=(const URLLoaderClientEndpoints&) = delete;

  ~URLLoaderClientEndpoints();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLLoaderClientEndpointsPtr>
  URLLoaderClientEndpointsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLLoaderClientEndpoints::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLLoaderClientEndpoints_UnserializedMessageContext<
            UserType, URLLoaderClientEndpoints::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLLoaderClientEndpoints::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLLoaderClientEndpoints::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLLoaderClientEndpoints_UnserializedMessageContext<
            UserType, URLLoaderClientEndpoints::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLLoaderClientEndpoints::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<URLLoader> url_loader;
  
  ::mojo::PendingReceiver<URLLoaderClient> url_loader_client;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
URLLoaderClientEndpointsPtr URLLoaderClientEndpoints::Clone() const {
  return New(
      mojo::Clone(url_loader),
      mojo::Clone(url_loader_client)
  );
}

template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>*>
bool URLLoaderClientEndpoints::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url_loader, other_struct.url_loader))
    return false;
  if (!mojo::Equals(this->url_loader_client, other_struct.url_loader_client))
    return false;
  return true;
}

template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url_loader < rhs.url_loader)
    return true;
  if (rhs.url_loader < lhs.url_loader)
    return false;
  if (lhs.url_loader_client < rhs.url_loader_client)
    return true;
  if (rhs.url_loader_client < lhs.url_loader_client)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::URLLoaderClientEndpoints::DataView,
                                         ::network::mojom::blink::URLLoaderClientEndpointsPtr> {
  static bool IsNull(const ::network::mojom::blink::URLLoaderClientEndpointsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::URLLoaderClientEndpointsPtr* output) { output->reset(); }

  static  decltype(::network::mojom::blink::URLLoaderClientEndpoints::url_loader)& url_loader(
       ::network::mojom::blink::URLLoaderClientEndpointsPtr& input) {
    return input->url_loader;
  }

  static  decltype(::network::mojom::blink::URLLoaderClientEndpoints::url_loader_client)& url_loader_client(
       ::network::mojom::blink::URLLoaderClientEndpointsPtr& input) {
    return input->url_loader_client;
  }

  static bool Read(::network::mojom::blink::URLLoaderClientEndpoints::DataView input, ::network::mojom::blink::URLLoaderClientEndpointsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_H_