// services/network/public/mojom/timing_allow_origin.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TIMING_ALLOW_ORIGIN_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TIMING_ALLOW_ORIGIN_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/timing_allow_origin.mojom-shared-internal.h"







namespace network::mojom {
class TimingAllowOriginDataView;


}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::TimingAllowOriginDataView> {
  using Data = ::network::mojom::internal::TimingAllowOrigin_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class TimingAllowOriginDataView {
 public:
  using Tag = internal::TimingAllowOrigin_Data::TimingAllowOrigin_Tag;

  TimingAllowOriginDataView() = default;

  TimingAllowOriginDataView(
      internal::TimingAllowOrigin_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_serialized_origins() const { return data_->tag == Tag::kSerializedOrigins; }
  inline void GetSerializedOriginsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSerializedOrigins(UserType* output) const {
    
    CHECK(is_serialized_origins());
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        data_->data.f_serialized_origins.Get(), output, message_);
  }
  bool is_all() const { return data_->tag == Tag::kAll; }
  uint8_t all() const {
    CHECK(is_all());
    return data_->data.f_all;
  }

 private:
  internal::TimingAllowOrigin_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TimingAllowOriginDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::TimingAllowOriginDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::TimingAllowOrigin_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::network::mojom::TimingAllowOriginDataView::Tag::kSerializedOrigins: {
        decltype(Traits::serialized_origins(input))
            in_serialized_origins = Traits::serialized_origins(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_serialized_origins)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& serialized_origins_validate_params =
            mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
        mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
            in_serialized_origins, value_fragment, &serialized_origins_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null serialized_origins in TimingAllowOrigin union");
        fragment->data.f_serialized_origins.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::network::mojom::TimingAllowOriginDataView::Tag::kAll: {
        decltype(Traits::all(input))
            in_all = Traits::all(input);
        fragment->data.f_all = in_all;
        break;
      }
    }
  }

  static bool Deserialize(::network::mojom::internal::TimingAllowOrigin_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TimingAllowOriginDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void TimingAllowOriginDataView::GetSerializedOriginsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) const {
  CHECK(is_serialized_origins());
  *output = mojo::ArrayDataView<mojo::StringDataView>(data_->data.f_serialized_origins.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TIMING_ALLOW_ORIGIN_MOJOM_SHARED_H_